/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import mondrian.util.UtilCompatible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilCompatibleJdk15
implements UtilCompatible {
    @Override
    public <E extends Enum<E>> Set<E> enumSetOf(E first, E ... rest) {
        return EnumSet.of(first, rest);
    }

    @Override
    public <E extends Enum<E>> Set<E> enumSetNoneOf(Class<E> elementType) {
        return EnumSet.noneOf(elementType);
    }

    @Override
    public <E extends Enum<E>> Set<E> enumSetAllOf(Class<E> elementType) {
        return EnumSet.allOf(elementType);
    }

    @Override
    public BigDecimal makeBigDecimalFromDouble(double d) {
        return new BigDecimal(d, MathContext.DECIMAL64);
    }

    @Override
    public String quotePattern(String s) {
        return Pattern.quote(s);
    }

    @Override
    public <T> T getAnnotation(Method method, String annotationClassName, T defaultValue) {
        try {
            Class<?> annotationClass = Class.forName(annotationClassName);
            if (method.isAnnotationPresent(annotationClass)) {
                Object annotation = method.getAnnotation(annotationClass);
                Method method1 = annotation.getClass().getMethod("value", new Class[0]);
                return (T)method1.invoke(annotation, new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (InvocationTargetException e) {
            return defaultValue;
        }
        catch (NoSuchMethodException e) {
            return defaultValue;
        }
        catch (ClassNotFoundException e) {
            return defaultValue;
        }
        return defaultValue;
    }
}

