/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.formatting;

import java.util.Arrays;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.structure.formatting.TagBasedLexerFormatter;

public class TransferData {
    public static final String TRANSFER_DATA_DOC_PROPERTY = "TagBasedFormatter.TransferData";
    public static final String ORG_CARET_OFFSET_DOCPROPERTY = "TagBasedFormatter.org_caret_offset";
    private boolean[] formattableLines;
    private int[] originalIndents;
    private int[] transformedOffsets;
    private boolean[] alreadyProcessedByNativeFormatter;
    private int numberOfLines;

    public void init(BaseDocument baseDocument) throws BadLocationException {
        this.numberOfLines = TagBasedLexerFormatter.getNumberOfLines(baseDocument);
        this.formattableLines = new boolean[this.numberOfLines];
        this.alreadyProcessedByNativeFormatter = new boolean[this.numberOfLines];
        Arrays.fill(this.formattableLines, true);
        this.originalIndents = new int[this.numberOfLines];
        this.transformedOffsets = new int[this.numberOfLines];
        for (int i = 0; i < this.numberOfLines; ++i) {
            this.originalIndents[i] = TagBasedLexerFormatter.getExistingIndent(baseDocument, i);
        }
        baseDocument.putProperty((Object)TRANSFER_DATA_DOC_PROPERTY, (Object)this);
    }

    public static TransferData readFromDocument(BaseDocument baseDocument) {
        return (TransferData)baseDocument.getProperty((Object)TRANSFER_DATA_DOC_PROPERTY);
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    public boolean isFormattable(int n) {
        return this.formattableLines[n];
    }

    public void setNonFormattable(int n) {
        this.formattableLines[n] = false;
    }

    public int[] getTransformedOffsets() {
        return this.transformedOffsets;
    }

    public void setTransformedOffsets(int[] nArray) {
        this.transformedOffsets = nArray;
    }

    public int getOriginalIndent(int n) {
        return this.originalIndents[n];
    }

    public boolean wasProcessedByNativeFormatter(int n) {
        return this.alreadyProcessedByNativeFormatter[n];
    }

    public void setProcessedByNativeFormatter(int n) {
        this.alreadyProcessedByNativeFormatter[n] = true;
    }
}

