/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnAction;
import com.jaspersoft.ireport.components.table.nodes.TableCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableNullCellNode;
import com.jaspersoft.ireport.components.table.undo.AddTableColumnUndoableEdit;
import com.jaspersoft.ireport.components.table.undo.DeleteTableColumnUndoableEdit;
import com.jaspersoft.ireport.designer.IReportManager;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class GroupColumnsAction
extends NodeAction {
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final int AT_THE_END = 2;
    public static final int AT_THE_START = 3;

    public String getName() {
        return NbBundle.getMessage(AddTableColumnAction.class, (String)"GroupColumnsAction.Name.CTL_GroupColumnsAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        StandardColumnGroup newColumn = new StandardColumnGroup();
        newColumn.setWidth(Integer.valueOf(0));
        StandardColumn fakeStdCol = new StandardColumn();
        fakeStdCol.setWidth(Integer.valueOf(0));
        DesignCell fakeDetail = new DesignCell();
        fakeDetail.setHeight(Integer.valueOf(0));
        fakeStdCol.setDetailCell((Cell)fakeDetail);
        newColumn.addColumn((BaseColumn)fakeStdCol);
        StandardTable table = null;
        JasperDesign jd = null;
        Object parent = null;
        List<BaseColumn> columns = null;
        int minIndex = -1;
        int maxIndex = -1;
        int count = 0;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Object node;
            Object thisParent = null;
            BaseColumn thisColumn = null;
            if (activatedNodes[i] instanceof TableCellNode) {
                node = (TableCellNode)activatedNodes[i];
                thisParent = TableModelUtils.getColumnParent(((TableCellNode)node).getTable(), ((TableCellNode)node).getColumn());
                thisColumn = ((TableCellNode)node).getColumn();
            }
            if (activatedNodes[i] instanceof TableNullCellNode) {
                node = (TableNullCellNode)activatedNodes[i];
                thisParent = TableModelUtils.getColumnParent(((TableNullCellNode)((Object)node)).getTable(), ((TableNullCellNode)((Object)node)).getColumn());
                thisColumn = ((TableNullCellNode)((Object)node)).getColumn();
            }
            if (parent == null) {
                parent = thisParent;
            }
            if (columns == null) {
                columns = TableModelUtils.getColumns(parent);
            }
            int index = columns.indexOf(thisColumn);
            if (minIndex < 0) {
                minIndex = index;
            }
            if (maxIndex < 0) {
                maxIndex = index;
            }
            if (maxIndex < index) {
                maxIndex = index;
            }
            if (minIndex > index) {
                maxIndex = index;
            }
            ++count;
        }
        TableModelUtils.addColumn(parent, (BaseColumn)newColumn, maxIndex + 1);
        AddTableColumnUndoableEdit edit = new AddTableColumnUndoableEdit(table, jd, (BaseColumn)newColumn, parent, maxIndex + 1);
        for (int i = maxIndex; i >= minIndex; --i) {
            BaseColumn col = columns.get(i);
            TableModelUtils.removeColumn(parent, col, i);
            edit.concatenate((UndoableEdit)((Object)new DeleteTableColumnUndoableEdit(table, jd, col, parent, i)));
            TableModelUtils.addColumn(newColumn, col, 0);
            edit.concatenate((UndoableEdit)((Object)new AddTableColumnUndoableEdit(table, jd, col, newColumn, 0)));
        }
        int colIndex = newColumn.getColumns().indexOf(fakeStdCol);
        TableModelUtils.removeColumn(newColumn, (BaseColumn)fakeStdCol, colIndex);
        edit.concatenate((UndoableEdit)((Object)new DeleteTableColumnUndoableEdit(table, jd, (BaseColumn)fakeStdCol, newColumn, colIndex)));
        edit.setPresentationName("Grouping Columns");
        IReportManager.getInstance().addUndoableEdit((UndoableEdit)((Object)edit));
        TableModelUtils.fixTableLayout(table, jd);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof TableCellNode || activatedNodes[i] instanceof TableNullCellNode) continue;
            return false;
        }
        Object parent = null;
        List<BaseColumn> columns = null;
        int minIndex = -1;
        int maxIndex = -1;
        int count = 0;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Object node;
            Object thisParent = null;
            BaseColumn thisColumn = null;
            if (activatedNodes[i] instanceof TableCellNode) {
                node = (TableCellNode)activatedNodes[i];
                thisParent = TableModelUtils.getColumnParent(((TableCellNode)node).getTable(), ((TableCellNode)node).getColumn());
                thisColumn = ((TableCellNode)node).getColumn();
            }
            if (activatedNodes[i] instanceof TableNullCellNode) {
                node = (TableNullCellNode)activatedNodes[i];
                thisParent = TableModelUtils.getColumnParent(((TableNullCellNode)((Object)node)).getTable(), ((TableNullCellNode)((Object)node)).getColumn());
                thisColumn = ((TableNullCellNode)((Object)node)).getColumn();
            }
            if (parent == null) {
                parent = thisParent;
            }
            if (columns == null) {
                columns = TableModelUtils.getColumns(parent);
            }
            if (thisParent != parent) {
                System.out.println(" Different parent for col " + i);
                System.out.flush();
                return false;
            }
            int index = columns.indexOf(thisColumn);
            if (minIndex < 0) {
                minIndex = index;
            }
            if (maxIndex < 0) {
                maxIndex = index;
            }
            if (maxIndex < index) {
                maxIndex = index;
            }
            if (minIndex > index) {
                maxIndex = index;
            }
            ++count;
        }
        if (maxIndex - minIndex + 1 != count) {
            System.out.println(" Count mismatch: " + maxIndex + "  " + minIndex + "  " + (maxIndex - minIndex) + "  " + count);
            System.out.flush();
            return false;
        }
        return true;
    }
}

