/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table;

import com.jaspersoft.ireport.components.table.TableCell;
import com.jaspersoft.ireport.components.table.TableMatrix;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModelUtils {
    public static DesignCell getCell(JRDesignElement element) {
        for (JRElementGroup g1 = element.getElementGroup(); g1 != null; g1 = g1.getElementGroup()) {
            if (!(g1 instanceof DesignCell)) continue;
            return (DesignCell)g1;
        }
        return null;
    }

    public static void addCell(BaseColumn column, DesignCell cell, byte section, String groupName) {
        if (cell == null || column == null) {
            return;
        }
        if (column instanceof StandardColumn) {
            TableModelUtils.addCellToStandardColumn((StandardColumn)column, cell, section, groupName);
        }
        if (column instanceof StandardColumnGroup) {
            TableModelUtils.addCellToStandardColumnGroup((StandardColumnGroup)column, cell, section, groupName);
        }
    }

    private static void addCellToStandardColumn(StandardColumn column, DesignCell cell, byte section, String groupName) {
        switch (section) {
            case 0: {
                column.setTableHeader((Cell)cell);
                break;
            }
            case 1: {
                column.setColumnHeader((Cell)cell);
                break;
            }
            case 2: {
                column.setGroupHeader(groupName, (Cell)cell);
                break;
            }
            case 3: {
                column.setDetailCell((Cell)cell);
                break;
            }
            case 4: {
                column.setGroupFooter(groupName, (Cell)cell);
                break;
            }
            case 5: {
                column.setColumnFooter((Cell)cell);
                break;
            }
            case 6: {
                column.setTableFooter((Cell)cell);
            }
        }
    }

    private static void addCellToStandardColumnGroup(StandardColumnGroup column, DesignCell cell, byte section, String groupName) {
        switch (section) {
            case 0: {
                column.setTableHeader((Cell)cell);
                break;
            }
            case 1: {
                column.setColumnHeader((Cell)cell);
                break;
            }
            case 2: {
                column.setGroupHeader(groupName, (Cell)cell);
                break;
            }
            case 4: {
                column.setGroupFooter(groupName, (Cell)cell);
                break;
            }
            case 5: {
                column.setColumnFooter((Cell)cell);
                break;
            }
            case 6: {
                column.setTableFooter((Cell)cell);
            }
        }
    }

    public static void removeCell(BaseColumn column, byte section, String groupName) {
        if (column == null) {
            return;
        }
        if (column instanceof StandardColumn) {
            TableModelUtils.removeCellFromStandardColumn((StandardColumn)column, section, groupName);
        }
        if (column instanceof StandardColumnGroup) {
            TableModelUtils.removeCellFromStandardColumnGroup((StandardColumnGroup)column, section, groupName);
        }
    }

    private static void removeCellFromStandardColumn(StandardColumn column, byte section, String groupName) {
        switch (section) {
            case 0: {
                column.setTableHeader(null);
                break;
            }
            case 1: {
                column.setColumnHeader(null);
                break;
            }
            case 2: {
                column.setGroupHeader(groupName, null);
                break;
            }
            case 3: {
                column.setDetailCell(null);
                break;
            }
            case 4: {
                column.setGroupFooter(groupName, null);
                break;
            }
            case 5: {
                column.setColumnFooter(null);
                break;
            }
            case 6: {
                column.setTableFooter(null);
            }
        }
    }

    private static void removeCellFromStandardColumnGroup(StandardColumnGroup column, byte section, String groupName) {
        switch (section) {
            case 0: {
                column.setTableHeader(null);
                break;
            }
            case 1: {
                column.setColumnHeader(null);
                break;
            }
            case 2: {
                column.setGroupHeader(groupName, null);
                break;
            }
            case 4: {
                column.setGroupFooter(groupName, null);
                break;
            }
            case 5: {
                column.setColumnFooter(null);
                break;
            }
            case 6: {
                column.setTableFooter(null);
            }
        }
    }

    public static void addColumn(Object parent, BaseColumn column, int index) {
        if (parent == null || column == null || index < 0) {
            return;
        }
        if (parent instanceof StandardTable) {
            ((StandardTable)parent).getColumns().add(index, column);
            ((StandardTable)parent).getEventSupport().firePropertyChange("columns", null, (Object)((StandardTable)parent).getColumns());
        } else if (parent instanceof StandardColumnGroup) {
            ((StandardColumnGroup)parent).getColumns().add(index, column);
            ((StandardColumnGroup)parent).getEventSupport().firePropertyChange("columns", null, (Object)((StandardColumnGroup)parent).getColumns());
        }
    }

    public static void removeColumn(Object parent, BaseColumn column, int index) {
        if (parent == null || column == null || index < 0) {
            return;
        }
        if (parent instanceof StandardTable) {
            ((StandardTable)parent).getColumns().remove(index);
            ((StandardTable)parent).getEventSupport().firePropertyChange("columns", null, (Object)((StandardTable)parent).getColumns());
        } else if (parent instanceof StandardColumnGroup) {
            ((StandardColumnGroup)parent).getColumns().remove(index);
            ((StandardColumnGroup)parent).getEventSupport().firePropertyChange("columns", null, (Object)((StandardColumnGroup)parent).getColumns());
        }
    }

    public static TableMatrix createTableMatrix(StandardTable table, JasperDesign jd) {
        TableMatrix matrix = new TableMatrix(jd, table);
        return matrix;
    }

    public static List<BaseColumn> getColumns(Object columnGroup) {
        if (columnGroup == null) {
            return null;
        }
        if (columnGroup instanceof StandardTable) {
            return ((StandardTable)columnGroup).getColumns();
        }
        if (columnGroup instanceof StandardColumnGroup) {
            return ((StandardColumnGroup)columnGroup).getColumns();
        }
        return null;
    }

    public static void fixTableLayout(StandardTable table, JasperDesign design) {
        TableMatrix matrix = TableModelUtils.createTableMatrix(table, design);
        for (TableCell cell : matrix.getCells()) {
            Rectangle bounds = matrix.getCellBounds(cell);
            if (cell.getCell() != null) {
                int finalRowSpan;
                if (cell.getCell().getHeight() == null || cell.getCell().getHeight() != bounds.height) {
                    cell.getCell().setHeight(Integer.valueOf(bounds.height));
                }
                if ((finalRowSpan = cell.getRowSpan()) > 1) {
                    for (int spanningRow = 0; spanningRow < cell.getRowSpan(); ++spanningRow) {
                        int spanningRowIndex = cell.getRow() + spanningRow;
                        boolean foundACell = false;
                        for (TableCell cellRow : matrix.getCells()) {
                            if (cellRow.getRow() != spanningRowIndex || cellRow.getRowSpan() != 1 || cellRow.getCell() == null) continue;
                            foundACell = true;
                            break;
                        }
                        if (foundACell) continue;
                        --finalRowSpan;
                    }
                }
                if (finalRowSpan < 1) {
                    finalRowSpan = 1;
                }
                if (cell.getCell().getRowSpan() == null || cell.getCell().getRowSpan() != finalRowSpan) {
                    cell.getCell().setRowSpan(Integer.valueOf(finalRowSpan));
                }
            }
            Rectangle columnBounds = matrix.getColumnBounds(cell.getColumn());
            if (cell.getColumn().getWidth() != null && cell.getColumn().getWidth() == columnBounds.width) continue;
            ((StandardBaseColumn)cell.getColumn()).setWidth(Integer.valueOf(columnBounds.width));
        }
    }

    public static int getColSpan(StandardColumnGroup column) {
        int span = 0;
        List columns = column.getColumns();
        for (BaseColumn c : columns) {
            if (c instanceof StandardColumn) {
                ++span;
                continue;
            }
            if (!(c instanceof StandardColumnGroup)) continue;
            span += TableModelUtils.getColSpan((StandardColumnGroup)c);
        }
        return span;
    }

    public static int getColumnIndex(StandardTable table, BaseColumn column) {
        HashMap<BaseColumn, Integer> mapColumnPositions = new HashMap<BaseColumn, Integer>();
        int currentIndex = 0;
        List columns = table.getColumns();
        for (BaseColumn c : columns) {
            mapColumnPositions.put(c, currentIndex);
            if (c instanceof StandardColumn) {
                ++currentIndex;
                continue;
            }
            if (!(c instanceof StandardColumnGroup)) continue;
            currentIndex = TableModelUtils.addColumnIndexes((StandardColumnGroup)c, currentIndex, c, mapColumnPositions);
        }
        if (mapColumnPositions.containsKey(column)) {
            return (Integer)mapColumnPositions.get(column);
        }
        return -1;
    }

    private static int addColumnIndexes(StandardColumnGroup parent, int currentIndex, BaseColumn column, Map<BaseColumn, Integer> mapColumnPositions) {
        List columns = parent.getColumns();
        for (BaseColumn c : columns) {
            mapColumnPositions.put(c, currentIndex);
            if (c instanceof StandardColumn) {
                ++currentIndex;
                continue;
            }
            if (!(c instanceof StandardColumnGroup)) continue;
            currentIndex = TableModelUtils.addColumnIndexes((StandardColumnGroup)c, currentIndex, c, mapColumnPositions);
        }
        return currentIndex;
    }

    public static int getStandardColumnsCount(List<BaseColumn> columns) {
        int count = 0;
        for (BaseColumn c : columns) {
            if (c instanceof StandardColumn) {
                ++count;
            }
            if (!(c instanceof StandardColumnGroup)) continue;
            count += TableModelUtils.getStandardColumnsCount(((StandardColumnGroup)c).getColumns());
        }
        return count;
    }

    public static Object getColumnParent(StandardTable table, BaseColumn column) {
        List columns = table.getColumns();
        for (BaseColumn c : columns) {
            Object parent;
            if (c == column) {
                return table;
            }
            if (!(c instanceof StandardColumnGroup) || (parent = TableModelUtils.getColumnParent((StandardColumnGroup)c, column)) == null) continue;
            return parent;
        }
        return null;
    }

    private static Object getColumnParent(StandardColumnGroup group, BaseColumn column) {
        List columns = group.getColumns();
        for (BaseColumn c : columns) {
            Object parent;
            if (c == column) {
                return group;
            }
            if (!(c instanceof StandardColumnGroup) || (parent = TableModelUtils.getColumnParent((StandardColumnGroup)c, column)) == null) continue;
            return parent;
        }
        return null;
    }
}

