/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEditSupport;
import javax.xml.namespace.QName;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xdm.XDMModelUndoableEdit;
import org.netbeans.modules.xml.xdm.diff.Add;
import org.netbeans.modules.xml.xdm.diff.Change;
import org.netbeans.modules.xml.xdm.diff.DefaultElementIdentity;
import org.netbeans.modules.xml.xdm.diff.Delete;
import org.netbeans.modules.xml.xdm.diff.DiffFinder;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.diff.MergeDiff;
import org.netbeans.modules.xml.xdm.diff.NodeIdDiffFinder;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.diff.SyncPreparation;
import org.netbeans.modules.xml.xdm.diff.XDMTreeDiff;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.XMLSyntaxParser;
import org.netbeans.modules.xml.xdm.visitor.FindVisitor;
import org.netbeans.modules.xml.xdm.visitor.FlushVisitor;
import org.netbeans.modules.xml.xdm.visitor.NamespaceRefactorVisitor;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.netbeans.modules.xml.xdm.visitor.Utils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XDMModel {
    private SyncPreparation preparation = null;
    private XMLSyntaxParser parser;
    private Document currentDocument;
    private PropertyChangeSupport pcs;
    private ModelSource source;
    private Status status;
    private boolean pretty = false;
    private UndoableEditSupport ues;
    private boolean fireUndoEvents = true;
    public static final String PROP_MODIFIED = "modified";
    public static final String PROP_DELETED = "deleted";
    public static final String PROP_ADDED = "added";
    public static final String DEFAULT_INDENT = "    ";
    private int nodeCount = 0;
    private ElementIdentity eID;
    private String currentIndent = "";
    private boolean indentInitialized = false;
    private Map<QName, List<QName>> qnameValuedAttributesByElementMap;

    public XDMModel(ModelSource modelSource) {
        this.source = modelSource;
        assert (this.getSwingDocument() != null);
        this.ues = new UndoableEditSupport(this);
        this.pcs = new PropertyChangeSupport(this);
        this.parser = new XMLSyntaxParser();
        this.setStatus(Status.UNPARSED);
        ElementIdentity elementIdentity = this.createElementIdentity();
        this.setElementIdentity(elementIdentity);
    }

    public String getIndentation() {
        return this.currentIndent;
    }

    public void setIndentation(String string) {
        this.currentIndent = string;
        this.indentInitialized = true;
    }

    private void setDefaultIndentation() {
        this.currentIndent = DEFAULT_INDENT;
    }

    private ElementIdentity createElementIdentity() {
        DefaultElementIdentity defaultElementIdentity = new DefaultElementIdentity();
        defaultElementIdentity.addIdentifier("id");
        defaultElementIdentity.addIdentifier("name");
        defaultElementIdentity.addIdentifier("ref");
        return defaultElementIdentity;
    }

    public synchronized void flush() {
        this.flushDocument(this.getDocument());
    }

    public synchronized void sync() throws IOException {
        if (this.preparation == null) {
            this.prepareSync();
        }
        this.finishSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareSync() {
        Status status = this.getStatus();
        try {
            this.setStatus(Status.PARSING);
            this.getSwingDocument().putProperty(Language.class, (Object)XMLTokenId.language());
            Document document = this.parser.parse(this.getSwingDocument());
            Document document2 = this.getCurrentDocument();
            if (document2 == null) {
                this.preparation = new SyncPreparation(document);
            } else {
                document.assignNodeIdRecursively();
                XDMTreeDiff xDMTreeDiff = new XDMTreeDiff(this.eID);
                List<Difference> list = xDMTreeDiff.performDiff(this, document);
                this.preparation = new SyncPreparation(document2, list);
            }
        }
        catch (BadLocationException badLocationException) {
            this.preparation = new SyncPreparation(badLocationException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.preparation = new SyncPreparation(illegalArgumentException);
        }
        catch (IOException iOException) {
            this.preparation = new SyncPreparation(iOException);
        }
        finally {
            this.setStatus(status);
        }
    }

    private void finishSync() throws IOException {
        if (this.preparation == null) {
            return;
        }
        if (this.preparation.hasErrors()) {
            IOException iOException = this.preparation.getError();
            this.preparation = null;
            this.setStatus(Status.BROKEN);
            throw iOException;
        }
        Status status = this.getStatus();
        this.setStatus(Status.PARSING);
        Document document = this.getCurrentDocument();
        try {
            if (this.preparation.getNewDocument() != null) {
                Document document2 = this.preparation.getNewDocument();
                document2.addedToTree(this);
                this.setDocument(document2);
            } else {
                assert (this.preparation.getOldDocument() != null) : "Invalid preparation oldDoc is null";
                if (document != this.preparation.getOldDocument()) {
                    this.setStatus(status);
                    return;
                }
                List<Difference> list = this.preparation.getDifferences();
                this.mergeDiff(list);
                this.fireDiffEvents(list);
                if (this.getCurrentDocument() != document) {
                    this.fireUndoableEditEvent(this.getCurrentDocument(), document);
                }
            }
            this.setStatus(Status.STABLE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.getStatus() != Status.STABLE) {
                IOException iOException = new IOException();
                iOException.initCause(illegalArgumentException);
                throw iOException;
            }
            if (illegalArgumentException.getCause() instanceof IOException) {
                this.setStatus(Status.BROKEN);
                throw (IOException)illegalArgumentException.getCause();
            }
            throw illegalArgumentException;
        }
        finally {
            if (this.getStatus() != Status.STABLE) {
                this.setStatus(Status.BROKEN);
                this.setDocument(document);
            }
            this.preparation = null;
        }
    }

    public void mergeDiff(List<Difference> list) {
        this.setStatus(Status.PARSING);
        new MergeDiff().merge(this, list);
        this.setStatus(Status.STABLE);
    }

    private void fireDiffEvents(List<Difference> list) {
        for (Difference difference : list) {
            NodeInfo nodeInfo;
            NodeInfo.NodeType nodeType = difference.getNodeType();
            if (difference instanceof Add) {
                nodeInfo = ((Add)difference).getNewNodeInfo();
                assert (nodeInfo != null);
                this.pcs.firePropertyChange(PROP_ADDED, null, nodeInfo);
                continue;
            }
            if (difference instanceof Delete) {
                nodeInfo = ((Delete)difference).getOldNodeInfo();
                assert (nodeInfo != null);
                this.pcs.firePropertyChange(PROP_DELETED, nodeInfo, null);
                continue;
            }
            if (!(difference instanceof Change)) continue;
            nodeInfo = ((Change)difference).getOldNodeInfo();
            assert (nodeInfo != null);
            NodeInfo nodeInfo2 = ((Change)difference).getNewNodeInfo();
            assert (nodeInfo2 != null);
            if (((Change)difference).isPositionChanged()) {
                this.pcs.firePropertyChange(PROP_DELETED, nodeInfo, null);
                this.pcs.firePropertyChange(PROP_ADDED, null, nodeInfo2);
                continue;
            }
            if (difference.getNodeType() == NodeInfo.NodeType.TEXT) {
                this.pcs.firePropertyChange(PROP_MODIFIED, nodeInfo, nodeInfo2);
                continue;
            }
            if (difference.getNodeType() != NodeInfo.NodeType.ELEMENT) continue;
            ArrayList<Node> arrayList = new ArrayList<Node>(nodeInfo.getOriginalAncestors());
            arrayList.add(0, nodeInfo.getNode());
            ArrayList<Node> arrayList2 = new ArrayList<Node>(nodeInfo2.getNewAncestors());
            arrayList2.add(0, nodeInfo2.getNode());
            List<Change.AttributeDiff> list2 = ((Change)difference).getAttrChanges();
            for (Change.AttributeDiff attributeDiff : list2) {
                Attribute attribute = attributeDiff.getOldAttribute();
                Attribute attribute2 = attributeDiff.getNewAttribute();
                if (attributeDiff instanceof Change.AttributeAdd) {
                    assert (attribute2 != null);
                    this.pcs.firePropertyChange(PROP_ADDED, null, new NodeInfo(attribute2, -1, arrayList, arrayList2));
                    continue;
                }
                if (attributeDiff instanceof Change.AttributeDelete) {
                    assert (attribute != null);
                    this.pcs.firePropertyChange(PROP_DELETED, new NodeInfo(attribute, -1, arrayList, arrayList2), null);
                    continue;
                }
                if (!(attributeDiff instanceof Change.AttributeChange)) continue;
                assert (attribute != null);
                assert (attribute2 != null);
                NodeInfo nodeInfo3 = new NodeInfo(attribute, -1, arrayList, arrayList2);
                NodeInfo nodeInfo4 = new NodeInfo(attribute2, -1, arrayList, arrayList2);
                this.pcs.firePropertyChange(PROP_MODIFIED, nodeInfo3, nodeInfo4);
            }
        }
    }

    private List<Node> getPathToRoot(Node node, Document document) {
        PathFromRootVisitor pathFromRootVisitor = new PathFromRootVisitor();
        List<Node> list = pathFromRootVisitor.findPath(document, node);
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("old node must be in the tree");
        }
        return list;
    }

    private static String classifyMutationType(Node node, Node node2) {
        if (node2 == null && node == null || node2 != null && node != null) {
            return PROP_MODIFIED;
        }
        if (node2 != null) {
            return PROP_ADDED;
        }
        return PROP_DELETED;
    }

    private List<Node> mutate(Node node, Node node2, Node node3, Updater updater) {
        return this.mutate(node, node2, node3, updater, null);
    }

    private List<Node> mutate(Node node, Node node2, Node node3, Updater updater, MutationType mutationType) {
        Node node4;
        List<Node> list;
        this.checkStableOrParsingState();
        if (node3 != null) {
            this.checkNodeInTree(node3);
        }
        Document document = this.getDocument();
        if (node == null) {
            assert (node2 != null);
            list = this.getPathToRoot(node2, document);
            node2 = list.remove(0);
        } else if (node2 != null) {
            assert (node.getIndexOfChild(node2) > -1);
            list = this.getPathToRoot(node2, document);
            assert (node2.getId() == list.get(0).getId());
            node2 = list.remove(0);
            assert (node.getId() == list.get(0).getId());
        } else {
            list = this.getPathToRoot(node, document);
        }
        Node node5 = list.remove(0);
        if (mutationType == null) {
            if (node2 instanceof Attribute || node3 instanceof Attribute || node2 == null && node3 == null) {
                mutationType = MutationType.ATTRIBUTE;
            } else if (list.size() == 1) {
                assert (node5 instanceof Element);
                mutationType = MutationType.BOTH;
            } else {
                mutationType = MutationType.CHILDREN;
            }
        }
        switch (mutationType) {
            case ATTRIBUTE: {
                node4 = node5.clone(true, true, false);
                break;
            }
            case CHILDREN: {
                node4 = node5.clone(true, false, true);
                break;
            }
            default: {
                node4 = node5.clone(true, true, true);
            }
        }
        if (node2 != null && node2.getNodeType() != 3 && node3 == null) {
            this.undoPrettyPrint(node4, node2, node5);
        }
        updater.update(node4, node2, node3);
        if (node2 == null && node3 != null && node3.getNodeType() != 3) {
            this.doPrettyPrint(node4, node3, node5);
        }
        List<Node> list2 = this.updateAncestors(list, node4, node5);
        if (this.getStatus() != Status.PARSING && node3 instanceof Element) {
            this.consolidateNamespaces(list2, node4, (Element)node3);
        }
        Document document2 = (Document)(!list2.isEmpty() ? list2.get(list2.size() - 1) : node4);
        document2.addedToTree(this);
        this.setDocument(document2);
        list.add(0, node5);
        list2.add(0, node4);
        if (this.getStatus() != Status.PARSING) {
            this.fireUndoableEditEvent(document2, document);
            String string = XDMModel.classifyMutationType(node2, node3);
            NodeInfo nodeInfo = new NodeInfo(node3, -1, list, list2);
            this.pcs.firePropertyChange(string, null, nodeInfo);
        }
        return list2;
    }

    private void consolidateNamespaces(List<Node> list, Node node, Element element) {
        Object object;
        if (node instanceof Document) {
            return;
        }
        assert (list.size() > 0);
        Element element2 = (Element)(list.size() == 1 ? node : list.get(list.size() - 2));
        ArrayList<Node> arrayList = new ArrayList<Node>(list);
        arrayList.add(0, node);
        this.consolidateAttributePrefix(arrayList, element);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            if (!(namedNodeMap.item(i) instanceof Attribute)) continue;
            object = (Attribute)namedNodeMap.item(i);
            this.consolidateNamespace(element2, arrayList, element, (Attribute)object);
        }
        String string = node.getPrefix();
        object = NodeImpl.lookupNamespace(node, list);
        if (object != null && !((String)object).equals("")) {
            new NamespaceRefactorVisitor(this).refactor(element, (String)object, string, arrayList);
        }
    }

    private void consolidateAttributePrefix(List<Node> list, Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string;
            Attribute attribute;
            String string2;
            if (!(namedNodeMap.item(i) instanceof Attribute) || (string2 = (attribute = (Attribute)namedNodeMap.item(i)).getPrefix()) == null || attribute.isXmlnsAttribute() || (string = element.lookupNamespaceURI(string2)) == null || (string2 = NodeImpl.lookupPrefix(string, list)) == null) continue;
            attribute.setPrefix(string2);
        }
    }

    private void consolidateNamespace(Element element, List<Node> list, Element element2, Attribute attribute) {
        if (attribute.isXmlnsAttribute()) {
            String string = attribute.getLocalName();
            if ("xmlns".equals(string)) {
                string = "";
            }
            String string2 = attribute.getValue();
            assert (string2 != null);
            Node node = list.get(0);
            String string3 = NodeImpl.lookupNamespace(node, list);
            String string4 = NodeImpl.lookupNamespace(string, list);
            String string5 = NodeImpl.lookupPrefix(string2, list);
            if (string4 == null && string5 == null) {
                element2.removeAttributeNode(attribute);
                element.appendAttribute(attribute);
            } else if (string2.equals(string4) && string.equals(string5)) {
                assert (string.equals(string5)) : "prefix='" + string + "' existingPrefix='" + string5 + "'";
                element2.removeAttributeNode(attribute);
            } else if (string5 != null && !string2.equals(string3)) {
                new NamespaceRefactorVisitor(this).refactor(element2, string2, string5, list);
            }
        }
    }

    public synchronized List<Node> modify(Node node, Node node2) {
        if (node.getId() != node2.getId()) {
            throw new IllegalArgumentException("newValue must be a clone of oldValue");
        }
        if (node instanceof Document) {
            assert (node2 instanceof Document);
            Document document = (Document)node;
            Document document2 = (Document)node2;
            document2.addedToTree(this);
            this.setDocument(document2);
            if (this.getStatus() != Status.PARSING) {
                this.fireUndoableEditEvent(document, this.currentDocument);
                String string = XDMModel.classifyMutationType(document, document2);
                ArrayList<Node> arrayList = new ArrayList<Node>();
                NodeInfo nodeInfo = new NodeInfo(document, -1, arrayList, arrayList);
                NodeInfo nodeInfo2 = new NodeInfo(document2, -1, arrayList, arrayList);
                this.pcs.firePropertyChange(string, nodeInfo, nodeInfo2);
            }
            return new ArrayList<Node>();
        }
        Updater updater = new Updater(){

            public void update(Node node, Node node2, Node node3) {
                if (node2 instanceof Attribute) {
                    ((Element)node).replaceAttribute((Attribute)node3, (Attribute)node2);
                } else {
                    node.replaceChild(node3, node2);
                }
            }
        };
        return this.mutate(null, node, node2, updater);
    }

    public synchronized List<Node> add(Node node, Node node2, final int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        Updater updater = new Updater(){

            public void update(Node node, Node node2, Node node3) {
                if (node instanceof Element && node3 instanceof Attribute) {
                    Element element = (Element)node;
                    if (n > element.getAttributes().getLength()) {
                        throw new IndexOutOfBoundsException();
                    }
                    element.addAttribute((Attribute)node3, n);
                } else {
                    if (node instanceof Document && node3 instanceof Element) {
                        XDMModel.this.resetIdMeter();
                    }
                    if (n > node.getChildNodes().getLength()) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (n < node.getChildNodes().getLength()) {
                        Node node4 = (Node)node.getChildNodes().item(n);
                        node.insertBefore(node3, node4);
                    } else {
                        node.appendChild(node3);
                    }
                }
            }
        };
        return this.mutate(node, null, node2, updater);
    }

    public synchronized List<Node> insertBefore(Node node, Node node2, Node node3) {
        final Node node4 = node3;
        Updater updater = new Updater(){

            public void update(Node node, Node node2, Node node3) {
                node.insertBefore(node3, node4);
            }
        };
        return this.mutate(node, null, node2, updater);
    }

    public synchronized List<Node> append(Node node, Node node2) {
        Updater updater = new Updater(){

            public void update(Node node, Node node2, Node node3) {
                if (node instanceof Document && node3 instanceof Element) {
                    XDMModel.this.resetIdMeter();
                }
                node.appendChild(node3);
            }
        };
        return this.mutate(node, null, node2, updater);
    }

    public synchronized List<Node> delete(Node node) {
        Updater updater = new Updater(){

            public void update(Node node, Node node2, Node node3) {
                node.removeChild(node2);
            }
        };
        return this.mutate(null, node, null, updater);
    }

    public synchronized List<Node> reorder(Node node, Node node2, final int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index=" + n);
        }
        Updater updater = new Updater(){

            public void update(Node node, Node node2, Node node3) {
                if (node instanceof Element && node3 instanceof Attribute) {
                    Element element = (Element)node;
                    int n2 = n;
                    if (n > element.getAttributes().getLength()) {
                        n2 = element.getAttributes().getLength();
                    }
                    element.reorderAttribute((Attribute)node2, n2);
                } else {
                    int n3 = n;
                    if (n > node.getChildNodes().getLength()) {
                        n3 = node.getChildNodes().getLength();
                    }
                    ((NodeImpl)node).reorderChild(node2, n3);
                }
            }
        };
        return this.mutate(node, node2, null, updater);
    }

    public synchronized List<Node> reorderChildren(Node node, final int[] nArray) {
        Updater updater = new Updater(){

            public void update(Node node, Node node2, Node node3) {
                ((NodeImpl)node).reorderChildren(nArray);
            }
        };
        return this.mutate(node, null, null, updater, MutationType.CHILDREN);
    }

    public synchronized List<Node> remove(final Node node, Node node2) {
        Updater updater = new Updater(){

            public void update(Node node4, Node node2, Node node3) {
                assert (node.isEquivalentNode(node4));
                node4.removeChild(node2);
            }
        };
        return this.mutate(node, node2, null, updater);
    }

    public synchronized List<Node> removeChildNodes(final Node node, final Collection<Node> collection) {
        Updater updater = new Updater(){

            public void update(Node node5, Node node2, Node node3) {
                assert (node.isEquivalentNode(node5));
                for (Node node4 : collection) {
                    node5.removeChild(node4);
                }
            }
        };
        return this.mutate(node, null, null, updater, MutationType.CHILDREN);
    }

    public synchronized List<Node> replaceChild(final Node node, Node node2, Node node3) {
        Updater updater = new Updater(){

            public void update(Node node4, Node node2, Node node3) {
                assert (node4.isEquivalentNode(node));
                node4.replaceChild(node3, node2);
            }
        };
        return this.mutate(null, node2, node3, updater);
    }

    public synchronized List<Node> setAttribute(Element element, final String string, final String string2) {
        Updater updater = new Updater(){

            public void update(Node node, Node node2, Node node3) {
                ((Element)node).setAttribute(string, string2);
            }
        };
        return this.mutate(element, null, null, updater);
    }

    public synchronized List<Node> removeAttribute(Element element, final String string) {
        Updater updater = new Updater(){

            public void update(Node node, Node node2, Node node3) {
                ((Element)node).removeAttribute(string);
            }
        };
        return this.mutate(element, null, null, updater);
    }

    public synchronized List<Node> setXmlFragmentText(Element element, final String string) throws IOException {
        CheckIOExceptionUpdater checkIOExceptionUpdater = new CheckIOExceptionUpdater(){
            private IOException error;

            public void update(Node node, Node node2, Node node3) {
                try {
                    ((Element)node).setXmlFragmentText(string);
                }
                catch (IOException iOException) {
                    this.error = iOException;
                }
            }

            public IOException getError() {
                return this.error;
            }
        };
        List<Node> list = this.mutate(element, null, null, checkIOExceptionUpdater, MutationType.CHILDREN);
        if (checkIOExceptionUpdater.getError() != null) {
            throw checkIOExceptionUpdater.getError();
        }
        return list;
    }

    public synchronized List<Node> setTextValue(Node node, String string) {
        Node node2 = (Node)((Object)this.currentDocument.createTextNode(string));
        Updater updater = new Updater(){

            public void update(Node node, Node node2, Node node3) {
                while (node.hasChildNodes()) {
                    node.removeChild(node.getLastChild());
                }
                node.appendChild(node3);
            }
        };
        return this.mutate(node, null, node2, updater);
    }

    private List<Node> updateAncestors(List<Node> list, Node node, Node node2) {
        assert (list != null && node != null && node2 != null);
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
        Node node3 = node;
        Node node4 = node2;
        for (Node node5 : list) {
            Node node6 = node5.clone(false, true, true);
            node6.replaceChild(node3, node4);
            arrayList.add(node6);
            node4 = node5;
            node3 = node6;
        }
        return arrayList;
    }

    public synchronized Document getDocument() {
        this.checkStableOrParsingState();
        return this.currentDocument;
    }

    public synchronized Document getCurrentDocument() {
        return this.currentDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetDocument(Document document) {
        try {
            this.fireUndoEvents = false;
            List<Difference> list = new NodeIdDiffFinder().findDiff(this.getCurrentDocument(), document);
            List<Difference> list2 = DiffFinder.filterWhitespace(list);
            this.setDocument(document);
            if (list2 != null && !list2.isEmpty()) {
                this.fireDiffEvents(list2);
            }
        }
        finally {
            this.fireUndoEvents = true;
        }
    }

    private void flushDocument(Document document) {
        CompoundEdit compoundEdit;
        block7: {
            this.checkStableState();
            UndoableEditListener undoableEditListener = null;
            BaseDocument baseDocument = this.getSwingDocument();
            compoundEdit = new CompoundEdit();
            try {
                UndoableEditListener[] undoableEditListenerArray = new FlushVisitor();
                String string = undoableEditListenerArray.flushModel(document);
                undoableEditListener = new UndoableEditListener(){

                    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                        compoundEdit.addEdit(undoableEditEvent.getEdit());
                    }
                };
                baseDocument.addUndoableEditListener(undoableEditListener);
                Utils.replaceDocument((javax.swing.text.Document)baseDocument, string);
                if (undoableEditListener == null) break block7;
            }
            catch (BadLocationException badLocationException) {
                try {
                    throw new IllegalStateException("It is possible that model source file is locked", badLocationException);
                }
                catch (Throwable throwable) {
                    if (undoableEditListener != null) {
                        baseDocument.removeUndoableEditListener(undoableEditListener);
                    }
                    compoundEdit.end();
                    for (UndoableEditListener undoableEditListener2 : this.ues.getUndoableEditListeners()) {
                        undoableEditListener2.undoableEditHappened(new UndoableEditEvent(this, compoundEdit));
                    }
                    throw throwable;
                }
            }
            baseDocument.removeUndoableEditListener(undoableEditListener);
        }
        compoundEdit.end();
        for (UndoableEditListener undoableEditListener : this.ues.getUndoableEditListeners()) {
            undoableEditListener.undoableEditHappened(new UndoableEditEvent(this, compoundEdit));
        }
    }

    public synchronized String getCurrentDocumentText() {
        return new FlushVisitor().flushModel(this.getCurrentDocument());
    }

    private BaseDocument getSwingDocument() {
        BaseDocument baseDocument = (BaseDocument)this.source.getLookup().lookup(BaseDocument.class);
        return baseDocument;
    }

    public synchronized void setDocument(Document document) {
        this.currentDocument = document;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public synchronized void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.ues.addUndoableEditListener(undoableEditListener);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.ues.addUndoableEditListener(undoableEditListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private synchronized Node findNode(int n) {
        FindVisitor findVisitor = new FindVisitor();
        return findVisitor.find(this.getDocument(), n);
    }

    private void fireUndoableEditEvent(Document document, Document document2) {
        if (this.fireUndoEvents) {
            assert (document != document2);
            XDMModelUndoableEdit xDMModelUndoableEdit = new XDMModelUndoableEdit(document2, document, this);
            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, xDMModelUndoableEdit);
            for (UndoableEditListener undoableEditListener : this.ues.getUndoableEditListeners()) {
                undoableEditListener.undoableEditHappened(undoableEditEvent);
            }
        }
    }

    private void checkNodeInTree(Node node) {
        if (node.isInTree()) {
            throw new IllegalArgumentException("newValue must not have been added to model");
        }
    }

    private void checkStableState() {
        if (this.getStatus() != Status.STABLE) {
            throw new IllegalStateException("flush can only be called from STABLE STATE");
        }
    }

    private void checkStableOrParsingState() {
        if (this.getStatus() != Status.STABLE && this.getStatus() != Status.PARSING) {
            throw new IllegalStateException("The model is not initialized or is broken.");
        }
    }

    private void setStatus(Status status) {
        this.status = status;
    }

    public int getNextNodeId() {
        int n = this.nodeCount++;
        return n;
    }

    private void resetIdMeter() {
        this.nodeCount = 1;
    }

    private boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean bl) {
        this.pretty = bl;
    }

    private void doPrettyPrint(Node node, Node node2, Node node3) {
        if (this.getStatus() != Status.PARSING && this.isPretty()) {
            if (this.isSimpleContent(node)) {
                return;
            }
            if (!this.indentInitialized) {
                this.initializeIndent(node3);
            }
            String string = this.calculateNodeIndent(node3);
            if (!this.isPretty(node, node2)) {
                Node node4;
                int n;
                int n2 = 1;
                if (node3.getChildNodes().getLength() == 0) {
                    node.insertBefore(this.createPrettyText(string + this.getIndentation()), node2);
                    ++n2;
                }
                if ((n = ((NodeImpl)node).getIndexOfChild(node2)) > 0) {
                    node4 = (Node)node.getChildNodes().item(n - 1);
                    if (this.checkPrettyText(node4)) {
                        Text text = this.createPrettyText(string + this.getIndentation());
                        node.replaceChild(text, node4);
                    } else {
                        node.insertBefore(this.createPrettyText(string + this.getIndentation()), node2);
                        ++n2;
                    }
                }
                node4 = null;
                if (n + n2 < node.getChildNodes().getLength()) {
                    node4 = (Node)node.getChildNodes().item(n + n2);
                }
                if (node4 != null) {
                    if (!this.checkPrettyText(node4)) {
                        node.insertBefore(this.createPrettyText(string + this.getIndentation()), node4);
                    }
                } else {
                    node.appendChild(this.createPrettyText(string));
                }
            }
            this.doPrettyPrintRecursive(node2, string, node);
        }
    }

    private void initializeIndent(Node node) {
        String string = this.calculateNodeIndent(node);
        List<Node> list = new PathFromRootVisitor().findPath(this.getDocument(), node);
        if (string.length() > 0 && list.size() - 2 > 0) {
            double d = Math.floor((double)string.length() / (double)(list.size() - 2));
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while ((double)n < d) {
                stringBuffer.append(" ");
                ++n;
            }
            String string2 = stringBuffer.toString();
            if (string2.length() > 0) {
                this.setIndentation(string2);
            } else {
                this.setDefaultIndentation();
            }
        } else {
            this.setDefaultIndentation();
        }
    }

    private String calculateNodeIndent(Node node) {
        String string;
        int n;
        Node node2;
        int n2;
        String string2 = "";
        Node node3 = (Node)node.getParentNode();
        if (node3 != null && (n2 = node3.getIndexOfChild(node)) > 0 && this.checkPrettyText(node2 = (Node)node3.getChildNodes().item(n2 - 1)) && (n = (string = ((NodeImpl)node2).getTokens().get(0).getValue()).lastIndexOf("\n")) != -1 && n + 1 < string.length()) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private void doPrettyPrintRecursive(Node node, String string, Node node2) {
        if (this.getStatus() != Status.PARSING && this.isPretty()) {
            if (this.isSimpleContent(node)) {
                return;
            }
            if (node instanceof Element && this.isPretty(node)) {
                this.fixPrettyForCopiedNode(node, string, node2);
            } else {
                int n;
                ArrayList<Node> arrayList = new ArrayList<Node>();
                ArrayList<Node> arrayList2 = new ArrayList<Node>();
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    arrayList.add((Node)nodeList.item(i));
                    if (!(nodeList.item(i) instanceof Element)) continue;
                    arrayList2.add((Node)nodeList.item(i));
                }
                String string2 = string + this.getIndentation();
                if (arrayList.size() > 0) {
                    node.appendChild(this.createPrettyText(string2));
                }
                String string3 = string2 + this.getIndentation();
                for (n = arrayList.size() - 1; n >= 0; --n) {
                    Node node3 = (Node)arrayList.get(n);
                    Text text = this.createPrettyText(string3);
                    node.insertBefore(text, node3);
                }
                arrayList.clear();
                for (n = 0; n < arrayList2.size(); ++n) {
                    this.doPrettyPrintRecursive((Node)arrayList2.get(n), string2, node);
                }
                arrayList2.clear();
            }
        }
    }

    private void fixPrettyForCopiedNode(Node node, String string, Node node2) {
        int n;
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return;
        }
        Text text = (Text)nodeList.item(nodeList.getLength() - 1);
        String string2 = text.getTokens().get(0).getValue();
        NodeImpl nodeImpl = (NodeImpl)node2.getChildNodes().item(0);
        String string3 = nodeImpl.getTokens().get(0).getValue();
        if (string3.length() == string2.length()) {
            return;
        }
        String string4 = string + this.getIndentation();
        String string5 = string4 + this.getIndentation();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (n = 0; n < nodeList.getLength(); ++n) {
            arrayList.add((Node)nodeList.item(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Node node3 = (Node)node.getChildNodes().item(n);
            if (!this.checkPrettyText(node3)) continue;
            String string6 = string5 + this.getIndentation();
            if (n == 0) {
                string6 = string5;
            } else if (n == arrayList.size() - 1) {
                string6 = string4;
            }
            node.replaceChild(this.createPrettyText(string6), node3);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.fixPrettyForCopiedNode((Node)node.getChildNodes().item(n), string5, node);
        }
        arrayList.clear();
    }

    private Text createPrettyText(String string) {
        String string2 = "\n" + string;
        Text text = (Text)this.getDocument().createTextNode(string2);
        return text;
    }

    private void undoPrettyPrint(Node node, Node node2, Node node3) {
        if (this.getStatus() != Status.PARSING && this.isPretty()) {
            Node node4;
            String string = this.calculateNodeIndent(node3);
            int n = string != null ? string.length() : 0;
            int n2 = ((NodeImpl)node3).getIndexOfChild(node2);
            Node node5 = null;
            if (n2 > 0 && this.checkPrettyText(node5 = (Node)node3.getChildNodes().item(n2 - 1)) && n <= this.getLength((Text)node5)) {
                node.removeChild(node5);
            }
            if (node.getChildNodes().getLength() == 2 && n2 + 1 < node3.getChildNodes().getLength() && this.checkPrettyText(node4 = (Node)node3.getChildNodes().item(n2 + 1)) && n <= this.getLength((Text)node4)) {
                node.removeChild(node4);
            }
        }
    }

    private int getLength(Text text) {
        int n = 0;
        for (Token token : text.getTokens()) {
            n += token.getValue().length();
        }
        return n;
    }

    private boolean checkPrettyText(Node node) {
        return node instanceof Text && ((NodeImpl)node).getTokens().size() == 1 && this.isWhitespaceOnly(((NodeImpl)node).getTokens().get(0).getValue());
    }

    private boolean isPossibleWhiteSpace(String string) {
        return string.length() > 0 && Character.isWhitespace(string.charAt(0)) && Character.isWhitespace(string.charAt(string.length() - 1));
    }

    private boolean isWhitespaceOnly(String string) {
        return this.isPossibleWhiteSpace(string) && string.trim().length() == 0;
    }

    public ElementIdentity getElementIdentity() {
        return this.eID;
    }

    public void setElementIdentity(ElementIdentity elementIdentity) {
        this.eID = elementIdentity;
    }

    private boolean isSimpleContent(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) instanceof Text) continue;
            return false;
        }
        return true;
    }

    private boolean isPretty(Node node) {
        return this.isPretty(node, null);
    }

    private boolean isPretty(Node node, Node node2) {
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            bl = true;
        } else if (n == 1 && nodeList.item(0) instanceof Text) {
            bl = true;
        } else if (n > 2 && this.checkPrettyText((Node)nodeList.item(0)) && this.checkPrettyText((Node)nodeList.item(n - 1))) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        if (node2 != null) {
            Node node3 = null;
            Node node4 = null;
            int n2 = ((NodeImpl)node).getIndexOfChild(node2);
            if (n2 > 0) {
                node3 = (Node)node.getChildNodes().item(n2 - 1);
            }
            if (n2 + 1 < node.getChildNodes().getLength()) {
                node4 = (Node)node.getChildNodes().item(n2 + 1);
            }
            return this.checkPrettyText(node3) && this.checkPrettyText(node4);
        }
        return bl;
    }

    public void setQNameValuedAttributes(Map<QName, List<QName>> map) {
        this.qnameValuedAttributesByElementMap = map;
    }

    public Map<QName, List<QName>> getQNameValuedAttributes() {
        return this.qnameValuedAttributesByElementMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        BROKEN,
        STABLE,
        UNPARSED,
        PARSING;

    }

    private static interface CheckIOExceptionUpdater
    extends Updater {
        public IOException getError();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MutationType {
        CHILDREN,
        ATTRIBUTE,
        BOTH;

    }

    private static interface Updater {
        public void update(Node var1, Node var2, Node var3);
    }
}

