/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.ui.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.server.ServerRegistry;
import org.netbeans.modules.server.ui.node.AddServerInstanceAction;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public final class RootNode
extends AbstractNode {
    private static final String SERVERS_ICON = "org/netbeans/modules/server/ui/resources/servers.png";
    private static RootNode node;

    private RootNode(ChildFactory childFactory) {
        super(Children.create((org.openide.nodes.ChildFactory)childFactory, (boolean)true));
        this.setName("");
        this.setDisplayName(NbBundle.getMessage(RootNode.class, (String)"Server_Registry_Node_Name"));
        this.setShortDescription(NbBundle.getMessage(RootNode.class, (String)"Server_Registry_Node_Short_Description"));
        this.setIconBaseWithExtension(SERVERS_ICON);
    }

    public static synchronized RootNode getInstance() {
        if (node == null) {
            ChildFactory childFactory = new ChildFactory();
            childFactory.init();
            node = new RootNode(childFactory);
        }
        return node;
    }

    public Action[] getActions(boolean bl) {
        return new SystemAction[]{SystemAction.get(AddServerInstanceAction.class)};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceComparator
    implements Comparator<ServerInstance>,
    Serializable {
        private InstanceComparator() {
        }

        @Override
        public int compare(ServerInstance serverInstance, ServerInstance serverInstance2) {
            return serverInstance.getDisplayName().compareTo(serverInstance2.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildFactory
    extends org.openide.nodes.ChildFactory<ServerInstance>
    implements ChangeListener {
        private static final Comparator<ServerInstance> COMPARATOR = new InstanceComparator();
        private final List<ServerInstanceProvider> types = new ArrayList<ServerInstanceProvider>();

        public synchronized void init() {
            ServerRegistry serverRegistry = ServerRegistry.getInstance();
            serverRegistry.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this, (Object)serverRegistry));
            this.stateChanged(new ChangeEvent(serverRegistry));
        }

        @Override
        public synchronized void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof ServerRegistry) {
                for (ServerInstanceProvider serverInstanceProvider : this.types) {
                    serverInstanceProvider.removeChangeListener(this);
                }
                this.types.clear();
                this.types.addAll(((ServerRegistry)changeEvent.getSource()).getProviders());
                for (ServerInstanceProvider serverInstanceProvider : this.types) {
                    serverInstanceProvider.addChangeListener(this);
                }
            }
            this.refresh();
        }

        protected final void refresh() {
            this.refresh(false);
        }

        protected Node createNodeForKey(ServerInstance serverInstance) {
            return serverInstance.getFullNode();
        }

        protected boolean createKeys(List<ServerInstance> list) {
            ArrayList<ServerInstance> arrayList = new ArrayList<ServerInstance>();
            ServerRegistry serverRegistry = ServerRegistry.getInstance();
            for (ServerInstanceProvider serverInstanceProvider : serverRegistry.getProviders()) {
                arrayList.addAll(serverInstanceProvider.getInstances());
            }
            Collections.sort(arrayList, COMPARATOR);
            list.addAll(arrayList);
            return true;
        }
    }
}

