/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.util.BitSet;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class LazyListModel
implements ListModel,
Runnable,
ListDataListener {
    private static int NOT_TESTED = -32769;
    private static int EMPTY_VALUE = -32770;
    private static final boolean skipExpensiveAsserts = Boolean.getBoolean("org.openide.explorer.view.LazyListModel.skipExpensiveAsserts");
    private boolean log;
    private ListModel listModel;
    private Filter filter;
    private Object defaultValue;
    private EventListenerList list = new EventListenerList();
    private int originalSize;
    private int size;
    private int[] external;
    private BitSet checked;
    private int refused;
    private BitSet tested;
    private boolean markDirty;
    static Boolean CREATE;

    private LazyListModel(ListModel listModel, Filter filter, double d, Object object) {
        this.listModel = listModel;
        this.filter = filter;
        this.defaultValue = object;
        listModel.addListDataListener(this);
    }

    final Filter getFilter() {
        return this.filter;
    }

    final boolean isComputed(int n) {
        return this.tested != null && this.tested.get(n);
    }

    private void markDirty() {
        this.markDirty = true;
        this.getFilter().scheduleUpdate(this);
    }

    public void run() {
        if (!this.markDirty) {
            return;
        }
        this.markDirty = false;
        if (this.log) {
            System.err.println("updateYourAssumeptions ();");
        }
        this.updateYourAssumeptions();
    }

    private void notifyRemoval(int n, int n2) {
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, n, n2 - 1);
        LazyListModel.removeInterval(this.external, n, n2);
        int n3 = n2 - n;
        this.size -= n3;
        this.regenerateCheckedBitSet();
        this.fireChange(listDataEvent);
    }

    private void regenerateCheckedBitSet() {
        this.checked = new BitSet(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (this.external[i] < 0) continue;
            this.checked.set(i);
        }
    }

    private int getExternal(int n) {
        if (n == this.size) {
            return this.originalSize;
        }
        if (n < 0) {
            return -1;
        }
        return this.external[n];
    }

    final void updateYourAssumeptions() {
        if (this.external == null) {
            return;
        }
        int n = this.size;
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.size) {
            int n3;
            while (this.getExternal(n2) >= 0 && n2 < this.size) {
                ++n2;
            }
            if (n2 == this.size) break;
            if (this.getExternal(n2) == NOT_TESTED) {
                n3 = n2 - 1;
                while (n2 < this.size && this.getExternal(n2) == NOT_TESTED) {
                    ++n2;
                }
                int n4 = n2 - n3 - 1;
                int n5 = this.getExternal(n3) + 1;
                int n6 = this.getExternal(n2);
                assert (n5 >= 0) : "Value at " + n3 + "(" + n5 + ") must be greater than minus one";
                assert (n6 >= 0) : "Value at " + n2 + "must be greater than minus one but was: " + n6;
                assert (n6 >= n5) : "Must be true: " + n6 + " >= " + n5;
                int n7 = n4 - (n6 - n5);
                if (n7 <= 0) continue;
                this.notifyRemoval(n2 - n7, n2);
                n2 -= n7;
                continue;
            }
            n3 = n2;
            while (n2 < this.size && this.getExternal(n2) == EMPTY_VALUE) {
                ++n2;
            }
            this.notifyRemoval(n3, n2);
            n2 = n3;
        }
        assert (this.externalContraints()) : "Constraints failed";
    }

    private boolean externalContraints() {
        assert (this.external != null) : "Not null";
        assert (this.external.length >= this.size) : "Length " + this.external.length + " >= " + this.size;
        if (!skipExpensiveAsserts) {
            for (int i = 1; i < this.size; ++i) {
                assert (this.external[i - 1] != NOT_TESTED || this.external[i] != EMPTY_VALUE) : "There cannot be empty value after not tested value";
                assert (this.external[i - 1] != EMPTY_VALUE || this.external[i] != NOT_TESTED) : "Not tested cannot immediatelly follow empty value";
                assert (this.external[i] < 0 || this.external[i] > this.external[i - 1]) : "If valid index it has to be greater: " + i;
                assert (this.external[i] < 0 == !this.checked.get(i)) : "external and checked must be consistent: " + i;
            }
        }
        return true;
    }

    private static void removeInterval(int[] nArray, int n, int n2) {
        assert (n < n2) : "Index1 must be bigger than index0: " + n2 + " > " + n;
        System.arraycopy(nArray, n2, nArray, n, nArray.length - n2);
    }

    public static LazyListModel create(ListModel listModel, Filter filter, double d, Object object) {
        return LazyListModel.create(listModel, filter, d, object, false);
    }

    static LazyListModel create(ListModel listModel, Filter filter, double d, Object object, boolean bl) {
        LazyListModel lazyListModel = new LazyListModel(listModel, filter, d, object);
        lazyListModel.log = bl;
        return lazyListModel;
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.list.add(ListDataListener.class, listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.list.remove(ListDataListener.class, listDataListener);
    }

    private void fireChange(ListDataEvent listDataEvent) {
        if (this.list.getListenerCount() == 0) {
            return;
        }
        Object[] objectArray = this.list.getListenerList();
        block5: for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ListDataListener listDataListener = (ListDataListener)objectArray[i];
            switch (listDataEvent.getType()) {
                case 0: {
                    listDataListener.contentsChanged(listDataEvent);
                    continue block5;
                }
                case 1: {
                    listDataListener.intervalAdded(listDataEvent);
                    continue block5;
                }
                case 2: {
                    listDataListener.intervalRemoved(listDataEvent);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + listDataEvent.getType());
                }
            }
        }
    }

    private boolean accepted(int n, Object[] objectArray) {
        Object e = this.listModel.getElementAt(n);
        this.tested.set(n);
        if (this.filter.accept(e)) {
            objectArray[0] = e;
            return true;
        }
        this.markDirty();
        return false;
    }

    private void initialize() {
        if (this.tested == null) {
            this.originalSize = this.listModel.getSize();
            this.size = this.listModel.getSize();
            this.tested = new BitSet(this.size);
            this.external = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.external[i] = NOT_TESTED;
            }
            this.checked = new BitSet(this.size);
        }
        assert (this.externalContraints()) : "Constraints failed";
    }

    public Object getElementAt(int n) {
        int n2;
        int n3;
        int n4;
        this.initialize();
        if (this.log) {
            System.err.println("model.getElementAt (" + n + ");");
        }
        if (this.external[n] >= 0) {
            return this.listModel.getElementAt(this.external[n]);
        }
        if (this.external[n] == EMPTY_VALUE) {
            return this.defaultValue;
        }
        if (CREATE != null && !CREATE.booleanValue()) {
            assert (Thread.holdsLock(CREATE)) : "Only one thread (from tests) can access this";
            return this.defaultValue;
        }
        for (n4 = n; n4 >= 0 && this.getExternal(n4) < 0; --n4) {
        }
        if (this.checked.get(n)) {
            n3 = n;
        } else {
            n3 = this.checked.nextSetBit(n);
            if (n3 == -1 || n3 > this.size) {
                n3 = this.size;
            }
        }
        int n5 = this.getExternal(n4) + 1;
        int n6 = this.getExternal(n3);
        assert (n6 >= n6) : "Must be greater";
        if (n6 != n5) {
            Object[] objectArray;
            n2 = n5 + (n - n4) - 1;
            if (n2 >= n6) {
                n2 = n6 - 1;
            }
            if (this.accepted(n2, objectArray = new Object[1])) {
                assert (this.external[n] == NOT_TESTED) : "External index " + n + " still needs to be unset: " + this.external[n];
                this.external[n] = n2;
                this.checked.set(n);
                return objectArray[0];
            }
            boolean bl = true;
            boolean bl2 = true;
            int n7 = 1;
            while (bl2 || bl) {
                if (bl) {
                    boolean bl3 = bl = n - n7 >= n4 && n2 - n7 >= n5 && this.getExternal(n - n7) == NOT_TESTED;
                    if (bl && this.accepted(n2 - n7, objectArray)) {
                        this.external[n] = n2 - n7;
                        this.checked.set(n);
                        return objectArray[0];
                    }
                }
                if (bl2) {
                    boolean bl4 = bl2 = n + n7 < n3 && n2 + n7 < n6 && this.getExternal(n + n7) == NOT_TESTED;
                    if (bl2 && this.accepted(n2 + n7, objectArray)) {
                        this.external[n] = n2 + n7;
                        this.checked.set(n);
                        return objectArray[0];
                    }
                }
                ++n7;
            }
        }
        this.markDirty();
        for (n2 = n4 + 1; n2 < n3; ++n2) {
            assert (this.external[n2] == NOT_TESTED) : n2 + " should not be set: " + this.external[n2];
            this.external[n2] = EMPTY_VALUE;
        }
        this.checked.clear(n4 + 1, n3);
        assert (this.external[n] == EMPTY_VALUE) : "Should be asigned in the cycle above";
        return this.defaultValue;
    }

    public int getSize() {
        this.initialize();
        return this.size;
    }

    private static BitSet insertAt(BitSet bitSet, int n, int n2, int n3) {
        BitSet bitSet2 = bitSet.get(0, n);
        BitSet bitSet3 = new BitSet(n3);
        bitSet3.or(bitSet2);
        int n4 = bitSet.length();
        while (n < n4) {
            bitSet3.set(n + n2, bitSet.get(n));
            ++n;
        }
        return bitSet3;
    }

    private static BitSet removeAt(BitSet bitSet, int n, int n2, int n3) {
        BitSet bitSet2 = (BitSet)bitSet.clone();
        int n4 = bitSet.length();
        while (n < n4) {
            bitSet2.set(n, bitSet.get(n + n2));
            ++n;
        }
        bitSet2.set(n3, bitSet.size(), false);
        return bitSet2;
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        int n;
        if (this.external == null) {
            return;
        }
        this.updateYourAssumeptions();
        int n2 = listDataEvent.getIndex0();
        int n3 = listDataEvent.getIndex1() + 1;
        int n4 = n3 - n2;
        int n5 = this.originalSize + n4;
        int n6 = this.size + n4;
        this.tested = LazyListModel.insertAt(this.tested, n2, n4, n5);
        int n7 = this.findExternalIndex(n2);
        int[] nArray = new int[n6];
        System.arraycopy(this.external, 0, nArray, 0, n7);
        for (n = 0; n < n4; ++n) {
            nArray[n7 + n] = NOT_TESTED;
        }
        for (n = n7 + n4; n < nArray.length; ++n) {
            int n8 = this.external[n - n4];
            nArray[n] = n8 < 0 ? n8 : n8 + n4;
        }
        this.external = nArray;
        this.size = n6;
        this.originalSize = n5;
        this.regenerateCheckedBitSet();
        this.fireChange(new ListDataEvent(this, 1, n7, n7 + n4 - 1));
        assert (this.externalContraints()) : "Constraints failed";
    }

    private int findExternalIndex(int n) {
        int n2 = 0;
        for (int i = -1; i < this.size; ++i) {
            n2 = this.getExternal(i) == NOT_TESTED ? ++n2 : this.getExternal(i);
            if (n2 < n) continue;
            return i;
        }
        return this.size;
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.external == null) {
            return;
        }
        this.updateYourAssumeptions();
        int n = listDataEvent.getIndex0();
        int n2 = listDataEvent.getIndex1() + 1;
        int n3 = n2 - n;
        int n4 = this.originalSize - n3;
        int n5 = this.findExternalIndex(n);
        int n6 = this.findExternalIndex(n2);
        assert (n5 >= 0) : "First index must be above zero: " + n5;
        assert (n6 >= n5) : "End index must be above first: " + n5 + " <= " + n6;
        int n7 = n6 - n5;
        int[] nArray = (int[])this.external.clone();
        for (int i = n6; i < this.size; ++i) {
            int n8 = this.external[i];
            nArray[i - n7] = n8 < 0 ? n8 : n8 - n3;
            this.checked.set(i - n7, n8 >= 0);
        }
        this.external = nArray;
        this.size -= n7;
        this.originalSize = n4;
        if (n7 != 0) {
            this.fireChange(new ListDataEvent(this, 2, n5, n6 - 1));
        }
        assert (this.externalContraints()) : "Constraints failed";
    }

    public static interface Filter {
        public boolean accept(Object var1);

        public void scheduleUpdate(Runnable var1);
    }
}

