/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;

public class NodeMemberEvent
extends NodeEvent {
    static final long serialVersionUID = -3973509253579305102L;
    private boolean add;
    private Node[] delta;
    private Node[] from;
    private int[] indices;

    NodeMemberEvent(Node node, boolean bl, Node[] nodeArray, Node[] nodeArray2) {
        super(node);
        this.add = bl;
        this.delta = nodeArray;
        this.from = nodeArray2;
    }

    public final boolean isAddEvent() {
        return this.add;
    }

    public final Node[] getDelta() {
        return this.delta;
    }

    public synchronized int[] getDeltaIndices() {
        int n;
        if (this.indices != null) {
            return this.indices;
        }
        if (this.from == null) {
            this.from = this.getNode().getChildren().getNodes();
        }
        List<Node> list = Arrays.asList(this.delta);
        HashSet<Node> hashSet = new HashSet<Node>(list);
        this.indices = new int[this.delta.length];
        int n2 = 0;
        for (n = 0; n < this.from.length && n2 < this.indices.length; ++n) {
            if (!hashSet.contains(this.from[n])) continue;
            this.indices[n2++] = n;
        }
        if (n2 != this.delta.length) {
            StringBuilder stringBuilder = new StringBuilder(1000);
            stringBuilder.append("Some of a set of deleted nodes are not present in the original ones.\n");
            stringBuilder.append("See #15478; you may need to check that your Children.Keys keys are safely comparable.");
            stringBuilder.append("\ni: ").append(n);
            stringBuilder.append("\nj: ").append(n2);
            stringBuilder.append("\nThis: ").append(this);
            stringBuilder.append("\nCurrent state:\n");
            stringBuilder.append(Arrays.asList(this.from));
            stringBuilder.append("\nDelta:\n");
            stringBuilder.append(list);
            throw new IllegalStateException(stringBuilder.toString());
        }
        return this.indices;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[node=");
        stringBuilder.append(this.getSource());
        stringBuilder.append(", add=");
        stringBuilder.append(this.isAddEvent());
        Node[] nodeArray = this.getDelta();
        int[] nArray = this.getDeltaIndices();
        for (int i = 0; i < nodeArray.length; ++i) {
            stringBuilder.append("\n  ");
            stringBuilder.append(i);
            stringBuilder.append(" at ");
            stringBuilder.append(nArray[i]);
            stringBuilder.append(" = ");
            stringBuilder.append(nodeArray[i]);
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }
}

