/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.features.DatabaseContext;
import org.netbeans.modules.languages.features.DatabaseDefinition;
import org.netbeans.modules.languages.features.DatabaseItem;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.DatabaseUsage;
import org.netbeans.modules.languages.features.MarkOccurrencesSupport;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantRenameAction
extends BaseAction
implements KeyListener,
DocumentListener {
    private List<Element> elements;
    private List<Highlighting.Highlight> highlights;
    private JTextComponent editor;
    private NbEditorDocument document;
    private String text;
    private static final AttributeSet defaultSyncedTextBlocksHighlight = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, new Color(138, 191, 236)});
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task task;

    public InstantRenameAction() {
        super("in-place-refactoring", 14);
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        int n = jTextComponent.getCaretPosition();
        ParserManager parserManager = ParserManager.get(jTextComponent.getDocument());
        if (parserManager.getState() == ParserManager.State.PARSING) {
            return;
        }
        try {
            InstantRenameAction.removeHighlights(this.highlights);
            this.highlights = null;
            ASTNode aSTNode = parserManager.getAST();
            DatabaseContext databaseContext = DatabaseManager.getRoot(aSTNode);
            if (databaseContext == null) {
                return;
            }
            DatabaseItem databaseItem = databaseContext.getDatabaseItem(n);
            if (databaseItem == null) {
                databaseItem = databaseContext.getDatabaseItem(n - 1);
            }
            if (databaseItem == null) {
                return;
            }
            this.editor = jTextComponent;
            this.document = (NbEditorDocument)jTextComponent.getDocument();
            this.elements = this.getUssages(databaseItem, aSTNode);
            this.addHighlights(this.elements);
            this.document.addDocumentListener((DocumentListener)this);
            jTextComponent.addKeyListener(this);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    protected Class getShortDescriptionBundleClass() {
        return InstantRenameAction.class;
    }

    private static AttributeSet getHighlightAS() {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings.getFontColors("synchronized-text-blocks");
        return attributeSet == null ? defaultSyncedTextBlocksHighlight : attributeSet;
    }

    private static void removeHighlights(final List<Highlighting.Highlight> list) {
        if (list == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ((Highlighting.Highlight)iterator.next()).remove();
                }
            }
        });
    }

    private void addHighlights(final List<Element> list) {
        if (list.isEmpty()) {
            return;
        }
        MarkOccurrencesSupport.removeHighlights(this.editor);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstantRenameAction.this.highlights = new ArrayList();
                Highlighting highlighting = Highlighting.getHighlighting((Document)InstantRenameAction.this.document);
                for (Element element : list) {
                    ASTItem aSTItem = element.getItem();
                    InstantRenameAction.this.highlights.add(highlighting.highlight(aSTItem.getOffset(), aSTItem.getEndOffset(), InstantRenameAction.getHighlightAS()));
                }
            }
        });
    }

    List<Element> getUssages(DatabaseItem databaseItem, ASTNode aSTNode) throws BadLocationException {
        ASTItem aSTItem;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        DatabaseDefinition databaseDefinition = null;
        if (databaseItem instanceof DatabaseDefinition) {
            databaseDefinition = (DatabaseDefinition)databaseItem;
        } else {
            databaseDefinition = ((DatabaseUsage)databaseItem).getDefinition();
            aSTItem = aSTNode.findPath(databaseItem.getOffset()).getLeaf();
            arrayList.add(new Element(aSTItem, this.document.createPosition(aSTItem.getOffset()), this.document.createPosition(aSTItem.getEndOffset()), (Document)this.document));
        }
        aSTItem = aSTNode.findPath(databaseDefinition.getOffset()).getLeaf();
        Element element = new Element(aSTItem, this.document.createPosition(aSTItem.getOffset()), this.document.createPosition(aSTItem.getEndOffset()), (Document)this.document);
        arrayList.add(element);
        this.text = element.getText();
        for (DatabaseUsage databaseUsage : databaseDefinition.getUsages()) {
            aSTItem = aSTNode.findPath(databaseUsage.getOffset()).getLeaf();
            if (aSTItem == ((Element)arrayList.get(0)).getItem()) continue;
            arrayList.add(new Element(aSTItem, this.document.createPosition(aSTItem.getOffset()), this.document.createPosition(aSTItem.getEndOffset()), (Document)this.document));
        }
        return arrayList;
    }

    private void update() {
        int n = this.editor.getCaretPosition();
        if (!this.elements.get(0).contains(n)) {
            return;
        }
        try {
            String string = this.elements.get(0).getText();
            if (this.text.equals(string)) {
                return;
            }
            this.text = string;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        if (this.requestProcessor == null) {
            this.requestProcessor = new RequestProcessor("InstantRename");
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = this.requestProcessor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                InstantRenameAction.this.document.removeDocumentListener((DocumentListener)InstantRenameAction.this);
                InstantRenameAction.this.document.atomicLock();
                try {
                    Iterator iterator = InstantRenameAction.this.elements.iterator();
                    try {
                        String string = ((Element)iterator.next()).getText();
                        while (iterator.hasNext()) {
                            ((Element)iterator.next()).setText(string);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                finally {
                    InstantRenameAction.this.document.atomicUnlock();
                    InstantRenameAction.this.document.addDocumentListener((DocumentListener)InstantRenameAction.this);
                }
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && keyEvent.getModifiers() == 0 || keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0) {
            InstantRenameAction.removeHighlights(this.highlights);
            this.editor.removeKeyListener(this);
            this.document.removeDocumentListener((DocumentListener)this);
            this.highlights = null;
            this.elements = null;
            this.editor = null;
            this.document = null;
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    private static class Element {
        private Position start;
        private Position end;
        private ASTItem item;
        private Document doc;

        Element(ASTItem aSTItem, Position position, Position position2, Document document) {
            this.item = aSTItem;
            this.start = position;
            this.end = position2;
            this.doc = document;
        }

        boolean contains(int n) {
            return this.start.getOffset() <= n && n <= this.end.getOffset();
        }

        void setText(String string) {
            try {
                if (string.equals(this.getText())) {
                    return;
                }
                this.doc.insertString(this.end.getOffset(), string, null);
                this.doc.remove(this.start.getOffset(), this.end.getOffset() - this.start.getOffset() - string.length());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        ASTItem getItem() {
            return this.item;
        }

        String getText() throws BadLocationException {
            return this.doc.getText(this.start.getOffset(), this.end.getOffset() - this.start.getOffset());
        }
    }
}

