/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.languages.features.DatabaseItem;
import org.netbeans.modules.languages.features.DatabaseUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseDefinition
extends DatabaseItem {
    private String name;
    private String type;
    private List<DatabaseUsage> usages;

    DatabaseDefinition(String string, String string2, int n, int n2) {
        super(n, n2);
        this.name = string;
        this.type = string2;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    void addUsage(DatabaseUsage databaseUsage) {
        if (this.usages == null) {
            this.usages = new ArrayList<DatabaseUsage>();
        }
        this.usages.add(databaseUsage);
    }

    public List<DatabaseUsage> getUsages() {
        if (this.usages == null) {
            return Collections.emptyList();
        }
        return this.usages;
    }

    public String toString() {
        return "Definition " + this.getName() + " (" + this.getType() + ")";
    }

    static DatabaseDefinition load(DataInputStream dataInputStream) throws IOException {
        return new DatabaseDefinition(dataInputStream.readUTF(), dataInputStream.readUTF(), dataInputStream.readInt(), dataInputStream.readInt());
    }

    void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeUTF(this.type);
        dataOutputStream.writeInt(this.getOffset());
        dataOutputStream.writeInt(this.getEndOffset());
    }
}

