/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.olap4j.OlapException;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Member;
import org.olap4j.query.Query;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDimension {
    protected QueryAxis axis;
    protected final List<Selection> selections = new SelectionList();
    private final Query query;
    protected Dimension dimension;

    public QueryDimension(Query query, Dimension dimension) {
        this.query = query;
        this.dimension = dimension;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setAxis(QueryAxis axis) {
        this.axis = axis;
    }

    public QueryAxis getAxis() {
        return this.axis;
    }

    public String getName() {
        return this.dimension.getName();
    }

    public Selection createSelection(Member member) {
        return this.createSelection(member, Selection.Operator.MEMBER);
    }

    public Selection createSelection(Member member, Selection.Operator operator) {
        return this.query.getSelectionFactory().createMemberSelection(member, operator);
    }

    public static String[] getNameParts(String sel) {
        List<IdentifierNode.Segment> list = IdentifierNode.parseIdentifier(sel);
        String[] nameParts = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nameParts[i] = list.get(i).getName();
        }
        return nameParts;
    }

    public List<Member> resolve(Selection selection) throws OlapException {
        Member.TreeOp op;
        assert (selection != null);
        Member.TreeOp secondOp = null;
        switch (selection.getOperator()) {
            case CHILDREN: {
                op = Member.TreeOp.CHILDREN;
                break;
            }
            case SIBLINGS: {
                op = Member.TreeOp.SIBLINGS;
                break;
            }
            case INCLUDE_CHILDREN: {
                op = Member.TreeOp.SELF;
                secondOp = Member.TreeOp.CHILDREN;
                break;
            }
            case MEMBER: {
                op = Member.TreeOp.SELF;
                break;
            }
            default: {
                throw new OlapException("Operation not supported: " + (Object)((Object)selection.getOperator()));
            }
        }
        TreeSet<Member.TreeOp> set = new TreeSet<Member.TreeOp>();
        set.add(op);
        if (secondOp != null) {
            set.add(secondOp);
        }
        try {
            return this.query.getCube().lookupMembers(set, QueryDimension.getNameParts(selection.getName()));
        }
        catch (Exception e) {
            throw new OlapException("Error while resolving selection " + selection.toString(), e);
        }
    }

    public List<Selection> getSelections() {
        return this.selections;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionList
    extends AbstractList<Selection> {
        private final List<Selection> list = new ArrayList<Selection>();

        private SelectionList() {
        }

        @Override
        public Selection get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Selection set(int index, Selection selection) {
            return this.list.set(index, selection);
        }

        @Override
        public void add(int index, Selection selection) {
            if (this.contains(selection)) {
                throw new IllegalStateException("dimension already contains selection");
            }
            this.list.add(index, selection);
        }

        @Override
        public Selection remove(int index) {
            return this.list.remove(index);
        }
    }
}

