/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.olap4j.CellSet;
import org.olap4j.OlapException;
import org.olap4j.OlapExceptionHelper;
import org.olap4j.OlapStatement;
import org.olap4j.driver.xmla.XmlaOlap4jCellSet;
import org.olap4j.driver.xmla.XmlaOlap4jConnection;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlaOlap4jStatement
implements OlapStatement {
    final XmlaOlap4jConnection olap4jConnection;
    private boolean closed;
    XmlaOlap4jCellSet openCellSet;
    private boolean canceled;
    int timeoutSeconds;
    Future<byte[]> future;

    XmlaOlap4jStatement(XmlaOlap4jConnection olap4jConnection) {
        assert (olap4jConnection != null);
        this.olap4jConnection = olap4jConnection;
        this.closed = false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    private void checkOpen() throws SQLException {
        if (this.closed) {
            throw OlapExceptionHelper.createException("closed");
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            if (this.openCellSet != null) {
                XmlaOlap4jCellSet c = this.openCellSet;
                this.openCellSet = null;
                c.close();
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.timeoutSeconds;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw OlapExceptionHelper.createException("illegal timeout value " + seconds);
        }
        this.timeoutSeconds = seconds;
    }

    @Override
    public synchronized void cancel() {
        if (!this.canceled) {
            this.canceled = true;
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw OlapExceptionHelper.createException("does not implement '" + iface + "'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CellSet executeOlapQuery(String mdx) throws OlapException {
        String catalog = this.olap4jConnection.getCatalog();
        String dataSourceInfo = this.olap4jConnection.getDataSourceInfo();
        StringBuilder buf = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope\n    xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"\n    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n    <soapenv:Body>\n        <Execute xmlns=\"urn:schemas-microsoft-com:xml-analysis\">\n        <Command>\n        <Statement>\n           <![CDATA[\n" + mdx + "]]>\n" + "         </Statement>\n" + "        </Command>\n" + "        <Properties>\n" + "          <PropertyList>\n");
        if (catalog != null) {
            buf.append("            <Catalog>");
            buf.append(catalog);
            buf.append("</Catalog>\n");
        }
        if (dataSourceInfo != null) {
            buf.append("            <DataSourceInfo>");
            buf.append(dataSourceInfo);
            buf.append("</DataSourceInfo>\n");
        }
        buf.append("            <Format>Multidimensional</Format>\n            <AxisFormat>TupleFormat</AxisFormat>\n          </PropertyList>\n        </Properties>\n</Execute>\n</soapenv:Body>\n</soapenv:Envelope>");
        String request = buf.toString();
        XmlaOlap4jStatement xmlaOlap4jStatement = this;
        synchronized (xmlaOlap4jStatement) {
            if (this.openCellSet != null) {
                XmlaOlap4jCellSet cs = this.openCellSet;
                this.openCellSet = null;
                try {
                    cs.close();
                }
                catch (SQLException e) {
                    throw OlapExceptionHelper.createException("Error while closing previous CellSet", e);
                }
            }
            this.future = this.olap4jConnection.proxy.submit(this.olap4jConnection.serverUrl, request);
            this.openCellSet = this.olap4jConnection.factory.newCellSet(this);
        }
        this.openCellSet.populate();
        return this.openCellSet;
    }

    @Override
    public CellSet executeOlapQuery(SelectNode selectNode) throws OlapException {
        String mdx = XmlaOlap4jStatement.toString(selectNode);
        return this.executeOlapQuery(mdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes() throws OlapException {
        Object object = this;
        synchronized (object) {
            if (this.future == null) {
                throw new IllegalArgumentException();
            }
        }
        try {
            if (this.timeoutSeconds > 0) {
                object = this.future.get(this.timeoutSeconds, TimeUnit.SECONDS);
                return object;
            }
            object = this.future.get();
            return object;
        }
        catch (InterruptedException e) {
            throw OlapExceptionHelper.createException(null, e);
        }
        catch (ExecutionException e) {
            throw OlapExceptionHelper.createException(null, e.getCause());
        }
        catch (TimeoutException e) {
            throw OlapExceptionHelper.createException("Query timeout of " + this.timeoutSeconds + " seconds exceeded");
        }
        catch (CancellationException e) {
            throw OlapExceptionHelper.createException("Query canceled");
        }
        finally {
            XmlaOlap4jStatement xmlaOlap4jStatement = this;
            synchronized (xmlaOlap4jStatement) {
                if (this.future == null) {
                    throw new IllegalArgumentException();
                }
                this.future = null;
            }
        }
    }

    private static String toString(ParseTreeNode node) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ParseTreeWriter parseTreeWriter = new ParseTreeWriter(pw);
        node.unparse(parseTreeWriter);
        pw.flush();
        return sw.toString();
    }
}

