/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.lang.ref.WeakReference;
import javax.swing.text.Position;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;

public class MarkFactory {
    private MarkFactory() {
    }

    public static class ChainDrawMark
    extends DrawMark {
        protected ChainDrawMark next;
        protected ChainDrawMark prev;

        public ChainDrawMark(String string, EditorUI editorUI) {
            this(string, editorUI, Position.Bias.Forward);
        }

        public ChainDrawMark(String string, EditorUI editorUI, Position.Bias bias) {
            super(string, editorUI, bias);
        }

        public final ChainDrawMark getNext() {
            return this.next;
        }

        public final void setNext(ChainDrawMark chainDrawMark) {
            this.next = chainDrawMark;
        }

        public void setNextChain(ChainDrawMark chainDrawMark) {
            this.next = chainDrawMark;
            if (chainDrawMark != null) {
                chainDrawMark.prev = this;
            }
        }

        public final ChainDrawMark getPrev() {
            return this.prev;
        }

        public final void setPrev(ChainDrawMark chainDrawMark) {
            this.prev = chainDrawMark;
        }

        public void setPrevChain(ChainDrawMark chainDrawMark) {
            this.prev = chainDrawMark;
            if (chainDrawMark != null) {
                chainDrawMark.next = this;
            }
        }

        public ChainDrawMark insertChain(ChainDrawMark chainDrawMark) {
            ChainDrawMark chainDrawMark2;
            chainDrawMark.prev = chainDrawMark2 = this.prev;
            chainDrawMark.next = this;
            if (chainDrawMark2 != null) {
                chainDrawMark2.next = chainDrawMark;
            }
            this.prev = chainDrawMark;
            return chainDrawMark;
        }

        public ChainDrawMark removeChain() {
            ChainDrawMark chainDrawMark = this.next;
            ChainDrawMark chainDrawMark2 = this.prev;
            if (chainDrawMark2 != null) {
                chainDrawMark2.next = chainDrawMark;
                this.prev = null;
            }
            if (chainDrawMark != null) {
                chainDrawMark.prev = chainDrawMark2;
                this.next = null;
            }
            try {
                this.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
            return chainDrawMark;
        }

        public String toStringChain() {
            return this.toString() + (this.next != null ? "\n" + this.next.toStringChain() : "");
        }

        public String toString() {
            return super.toString() + ", " + (this.prev != null ? (this.next != null ? "chain member" : "last member") : (this.next != null ? "first member" : "standalone member"));
        }
    }

    public static class DrawMark
    extends ContextMark {
        protected boolean activateLayer;
        String layerName;
        WeakReference editorUIRef;

        public DrawMark(String string, EditorUI editorUI) {
            this(string, editorUI, Position.Bias.Forward);
        }

        public DrawMark(String string, EditorUI editorUI, Position.Bias bias) {
            super(bias, false);
            this.layerName = string;
            this.setEditorUI(editorUI);
        }

        public boolean isDocumentMark() {
            return this.editorUIRef == null;
        }

        public EditorUI getEditorUI() {
            if (this.editorUIRef != null) {
                return (EditorUI)this.editorUIRef.get();
            }
            return null;
        }

        public void setEditorUI(EditorUI editorUI) {
            this.editorUIRef = editorUI != null ? new WeakReference<EditorUI>(editorUI) : null;
        }

        public boolean isValidUI() {
            return this.editorUIRef == null || this.editorUIRef.get() != null;
        }

        public void setActivateLayer(boolean bl) {
            this.activateLayer = bl;
        }

        public boolean getActivateLayer() {
            return this.activateLayer;
        }

        public boolean removeInvalid() {
            if (!this.isValidUI() && this.isValid()) {
                try {
                    this.remove();
                }
                catch (InvalidMarkException invalidMarkException) {
                    throw new IllegalStateException(invalidMarkException.toString());
                }
                return true;
            }
            return false;
        }

        public String toString() {
            try {
                return "pos=" + this.getOffset() + ", line=" + this.getLine();
            }
            catch (InvalidMarkException invalidMarkException) {
                return "mark not valid";
            }
        }
    }

    public static class ContextMark
    extends Mark {
        public ContextMark(boolean bl) {
            this(false, bl);
        }

        public ContextMark(boolean bl, boolean bl2) {
            this(bl ? Position.Bias.Backward : Position.Bias.Forward, bl2);
        }

        public ContextMark(Position.Bias bias, boolean bl) {
            super(bias);
        }
    }

    public static class SyntaxMark
    extends Mark {
        private Syntax.StateInfo stateInfo;
        private TokenItem tokenItem;

        public Syntax.StateInfo getStateInfo() {
            return this.stateInfo;
        }

        public void updateStateInfo(Syntax syntax) {
            if (this.stateInfo == null) {
                this.stateInfo = syntax.createStateInfo();
            }
            syntax.storeState(this.stateInfo);
        }

        void setStateInfo(Syntax.StateInfo stateInfo) {
            this.stateInfo = stateInfo;
        }

        public TokenItem getTokenItem() {
            return this.tokenItem;
        }

        void setTokenItem(TokenItem tokenItem) {
            this.tokenItem = tokenItem;
        }

        protected void removeUpdateAction(int n, int n2) {
            try {
                this.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
    }
}

