/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.Dimension;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.diff.Difference;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.diff.builtin.visualizer.editable.DecoratedEditorPane;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel;
import org.netbeans.modules.diff.builtin.visualizer.editable.EditableDiffView;
import org.netbeans.spi.diff.DiffProvider;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiffViewManager
implements ChangeListener {
    private final EditableDiffView master;
    private final DiffContentPanel leftContentPanel;
    private final DiffContentPanel rightContentPanel;
    private boolean myScrollEvent;
    private int cachedDiffSerial;
    private DecoratedDifference[] decorationsCached = new DecoratedDifference[0];
    private HighLight[] secondHilitesCached = new HighLight[0];
    private HighLight[] firstHilitesCached = new HighLight[0];
    private final ScrollMapCached scrollMap = new ScrollMapCached();

    public DiffViewManager(EditableDiffView editableDiffView) {
        this.master = editableDiffView;
        this.leftContentPanel = editableDiffView.getEditorPane1();
        this.rightContentPanel = editableDiffView.getEditorPane2();
    }

    void init() {
        this.initScrolling();
    }

    private void initScrolling() {
        this.leftContentPanel.getScrollPane().getVerticalScrollBar().getModel().addChangeListener(this);
        this.rightContentPanel.getScrollPane().getVerticalScrollBar().getModel().addChangeListener(this);
        this.leftContentPanel.getScrollPane().getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JScrollBar jScrollBar = this.leftContentPanel.getScrollPane().getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.rightContentPanel.getScrollPane().getVerticalScrollBar();
        if (changeEvent.getSource() == this.leftContentPanel.getScrollPane().getVerticalScrollBar().getModel()) {
            int n = jScrollBar.getValue();
            this.leftContentPanel.getActionsScrollPane().getVerticalScrollBar().setValue(n);
            if (this.myScrollEvent) {
                return;
            }
            this.myScrollEvent = true;
        } else {
            int n = jScrollBar2.getValue();
            this.rightContentPanel.getActionsScrollPane().getVerticalScrollBar().setValue(n);
            if (this.myScrollEvent) {
                return;
            }
            this.myScrollEvent = true;
            this.smartScroll();
        }
        this.master.getMyDivider().repaint();
        this.master.updateCurrentDifference();
        this.myScrollEvent = false;
    }

    public void scroll() {
        this.myScrollEvent = true;
        this.smartScroll();
        this.master.getMyDivider().repaint();
        this.myScrollEvent = false;
    }

    EditableDiffView getMaster() {
        return this.master;
    }

    private void updateDifferences() {
        assert (Thread.holdsLock(this));
        int n = this.master.getDiffSerial();
        if (n <= this.cachedDiffSerial) {
            return;
        }
        this.cachedDiffSerial = n;
        this.computeDecorations();
        this.computeSecondHighlights();
        this.computeFirstHighlights();
    }

    public synchronized DecoratedDifference[] getDecorations() {
        this.updateDifferences();
        return this.decorationsCached;
    }

    public synchronized HighLight[] getSecondHighlights() {
        this.updateDifferences();
        return this.secondHilitesCached;
    }

    public synchronized HighLight[] getFirstHighlights() {
        this.updateDifferences();
        return this.firstHilitesCached;
    }

    private void computeFirstHighlights() {
        ArrayList<HighLight> arrayList = new ArrayList<HighLight>();
        Document document = this.leftContentPanel.getEditorPane().getDocument();
        for (DecoratedDifference decoratedDifference : this.decorationsCached) {
            Object object;
            Difference difference = decoratedDifference.getDiff();
            if (decoratedDifference.getBottomLeft() == -1) continue;
            int n = DiffViewManager.getRowStartFromLineOffset(document, difference.getFirstStart() - 1);
            if (this.isOneLineChange(difference)) {
                CorrectRowTokenizer correctRowTokenizer = new CorrectRowTokenizer(difference.getFirstText());
                object = new CorrectRowTokenizer(difference.getSecondText());
                for (int i = difference.getSecondStart(); i <= difference.getSecondEnd(); ++i) {
                    String string = correctRowTokenizer.nextToken();
                    String string2 = ((CorrectRowTokenizer)object).nextToken();
                    List<HighLight> list = this.computeFirstRowHilites(n, string, string2);
                    arrayList.addAll(list);
                    n += string.length() + 1;
                }
                continue;
            }
            int n2 = DiffViewManager.getRowStartFromLineOffset(document, difference.getFirstEnd());
            if (n2 == -1) {
                n2 = document.getLength();
            }
            object = new SimpleAttributeSet();
            StyleConstants.setBackground((MutableAttributeSet)object, this.master.getColor(difference));
            ((SimpleAttributeSet)object).addAttribute(HighlightsContainer.ATTR_EXTENDS_EOL, Boolean.TRUE);
            arrayList.add(new HighLight(n, n2, (AttributeSet)object));
        }
        this.firstHilitesCached = arrayList.toArray(new HighLight[arrayList.size()]);
    }

    static int getRowStartFromLineOffset(Document document, int n) {
        if (document instanceof BaseDocument) {
            return Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)n);
        }
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n);
        return element2.getStartOffset();
    }

    private void computeSecondHighlights() {
        ArrayList<HighLight> arrayList = new ArrayList<HighLight>();
        Document document = this.rightContentPanel.getEditorPane().getDocument();
        for (DecoratedDifference decoratedDifference : this.decorationsCached) {
            Object object;
            Difference difference = decoratedDifference.getDiff();
            if (decoratedDifference.getBottomRight() == -1) continue;
            int n = DiffViewManager.getRowStartFromLineOffset(document, difference.getSecondStart() - 1);
            if (this.isOneLineChange(difference)) {
                CorrectRowTokenizer correctRowTokenizer = new CorrectRowTokenizer(difference.getFirstText());
                object = new CorrectRowTokenizer(difference.getSecondText());
                for (int i = difference.getSecondStart(); i <= difference.getSecondEnd(); ++i) {
                    try {
                        String string = correctRowTokenizer.nextToken();
                        String string2 = ((CorrectRowTokenizer)object).nextToken();
                        List<HighLight> list = this.computeSecondRowHilites(n, string, string2);
                        arrayList.addAll(list);
                        n += string2.length() + 1;
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                continue;
            }
            int n2 = DiffViewManager.getRowStartFromLineOffset(document, difference.getSecondEnd());
            if (n2 == -1) {
                n2 = document.getLength();
            }
            object = new SimpleAttributeSet();
            StyleConstants.setBackground((MutableAttributeSet)object, this.master.getColor(difference));
            ((SimpleAttributeSet)object).addAttribute(HighlightsContainer.ATTR_EXTENDS_EOL, Boolean.TRUE);
            arrayList.add(new HighLight(n, n2, (AttributeSet)object));
        }
        this.secondHilitesCached = arrayList.toArray(new HighLight[arrayList.size()]);
    }

    private List<HighLight> computeFirstRowHilites(int n, String string, String string2) {
        Difference[] differenceArray;
        ArrayList<HighLight> arrayList = new ArrayList<HighLight>(4);
        String string3 = this.wordsToRows(string);
        String string4 = this.wordsToRows(string2);
        DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diffProvider == null) {
            return arrayList;
        }
        try {
            differenceArray = diffProvider.computeDiff(new StringReader(string3), new StringReader(string4));
        }
        catch (IOException iOException) {
            return arrayList;
        }
        for (Difference difference : differenceArray) {
            if (difference.getType() == 1) continue;
            int n2 = this.rowOffset(string3, difference.getFirstStart());
            int n3 = this.rowOffset(string3, difference.getFirstEnd() + 1);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setBackground(simpleAttributeSet, this.master.getColor(difference));
            arrayList.add(new HighLight(n + n2, n + n3, simpleAttributeSet));
        }
        return arrayList;
    }

    private List<HighLight> computeSecondRowHilites(int n, String string, String string2) {
        Difference[] differenceArray;
        ArrayList<HighLight> arrayList = new ArrayList<HighLight>(4);
        String string3 = this.wordsToRows(string);
        String string4 = this.wordsToRows(string2);
        DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diffProvider == null) {
            return arrayList;
        }
        try {
            differenceArray = diffProvider.computeDiff(new StringReader(string3), new StringReader(string4));
        }
        catch (IOException iOException) {
            return arrayList;
        }
        for (Difference difference : differenceArray) {
            if (difference.getType() == 0) continue;
            int n2 = this.rowOffset(string4, difference.getSecondStart());
            int n3 = this.rowOffset(string4, difference.getSecondEnd() + 1);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setBackground(simpleAttributeSet, this.master.getColor(difference));
            arrayList.add(new HighLight(n + n2, n + n3, simpleAttributeSet));
        }
        return arrayList;
    }

    private int rowOffset(String string, int n) {
        if (n == 1) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\n') continue;
            ++n2;
            if (--n != 1) continue;
            return i + 1 - n2;
        }
        return string.length();
    }

    private String wordsToRows(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n[]{};:'\",.<>/?-=_+\\|~!@#$%^&*()", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0) continue;
            stringBuilder.append(string2);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private boolean isOneLineChange(Difference difference) {
        return difference.getType() == 2 && difference.getFirstEnd() - difference.getFirstStart() == difference.getSecondEnd() - difference.getSecondStart();
    }

    private void computeDecorations() {
        Document document = this.master.getEditorPane2().getEditorPane().getDocument();
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.rightContentPanel.getEditorPane());
        if (editorUI == null) {
            return;
        }
        int n = editorUI.getLineHeight();
        Difference[] differenceArray = this.master.getDifferences();
        this.decorationsCached = new DecoratedDifference[differenceArray.length];
        for (int i = 0; i < differenceArray.length; ++i) {
            Difference difference = differenceArray[i];
            DecoratedDifference decoratedDifference = new DecoratedDifference(difference, this.canRollback(document, difference));
            if (difference.getType() == 1) {
                decoratedDifference.topRight = (difference.getSecondStart() - 1) * n;
                decoratedDifference.bottomRight = difference.getSecondEnd() * n;
                decoratedDifference.topLeft = difference.getFirstStart() * n;
                decoratedDifference.floodFill = true;
            } else if (difference.getType() == 0) {
                decoratedDifference.topLeft = (difference.getFirstStart() - 1) * n;
                decoratedDifference.bottomLeft = difference.getFirstEnd() * n;
                decoratedDifference.topRight = difference.getSecondStart() * n;
                decoratedDifference.floodFill = true;
            } else {
                decoratedDifference.topRight = (difference.getSecondStart() - 1) * n;
                decoratedDifference.bottomRight = difference.getSecondEnd() * n;
                decoratedDifference.topLeft = (difference.getFirstStart() - 1) * n;
                decoratedDifference.bottomLeft = difference.getFirstEnd() * n;
                decoratedDifference.floodFill = true;
            }
            this.decorationsCached[i] = decoratedDifference;
        }
    }

    private boolean canRollback(Document document, Difference difference) {
        int n;
        int n2;
        if (!(document instanceof GuardedDocument)) {
            return true;
        }
        GuardedDocument guardedDocument = (GuardedDocument)document;
        if (difference.getType() == 0) {
            n = n2 = Utilities.getRowStartFromLineOffset((BaseDocument)guardedDocument, (int)difference.getSecondStart());
        } else {
            n = Utilities.getRowStartFromLineOffset((BaseDocument)guardedDocument, (int)(difference.getSecondStart() - 1));
            n2 = Utilities.getRowStartFromLineOffset((BaseDocument)guardedDocument, (int)difference.getSecondEnd());
        }
        MarkBlockChain markBlockChain = guardedDocument.getGuardedBlockChain();
        return (markBlockChain.compareBlock(n, n2) & 1) == 0;
    }

    private void smartScroll() {
        DiffContentPanel diffContentPanel = this.master.getEditorPane2();
        DiffContentPanel diffContentPanel2 = this.master.getEditorPane1();
        int[] nArray = this.scrollMap.getScrollMap(diffContentPanel.getEditorPane().getSize().height, this.master.getDiffSerial());
        int n = diffContentPanel.getScrollPane().getVerticalScrollBar().getValue();
        if (n >= nArray.length) {
            return;
        }
        diffContentPanel2.getScrollPane().getVerticalScrollBar().setValue(nArray[n]);
    }

    private int computeLeftOffsetToMatchDifference(DifferencePosition differencePosition, int n, int n2) {
        int n3;
        int n4;
        Difference difference = differencePosition.getDiff();
        boolean bl = differencePosition.isStart();
        if (bl) {
            n4 = difference.getFirstStart() * n;
            n3 = difference.getSecondStart() * n;
        } else if (difference.getType() == 1) {
            n4 = difference.getFirstStart() * n;
            n4 -= n;
            n3 = difference.getSecondEnd() * n;
        } else {
            n4 = difference.getFirstEnd() * n;
            if (difference.getType() == 0) {
                n4 += n;
                n3 = difference.getSecondStart() * n;
            } else {
                n3 = difference.getSecondEnd() * n;
            }
        }
        int n5 = n2 - n3;
        n4 += n5;
        if (difference.getType() == 1) {
            n4 += n;
        }
        if (difference.getType() == 0) {
            n4 -= n;
        }
        return n4;
    }

    private DifferencePosition findDifferenceToMatch(int n, int n2) {
        boolean bl;
        DecoratedDifference[] decoratedDifferenceArray;
        DecoratedDifference decoratedDifference = null;
        for (DecoratedDifference decoratedDifference2 : decoratedDifferenceArray = this.getDecorations()) {
            if (decoratedDifference2.getTopRight() > n + n2) break;
            if (decoratedDifference2.getBottomRight() == -1 ? decoratedDifference2.getTopRight() <= n : decoratedDifference2.getBottomRight() <= n) continue;
            if (decoratedDifference != null) {
                if (decoratedDifference.getDiff().getType() == 0) {
                    decoratedDifference = decoratedDifference2;
                    continue;
                }
                if (decoratedDifference.getTopRight() < n) {
                    decoratedDifference = decoratedDifference2;
                    continue;
                }
                if (decoratedDifference2.getTopRight() > n + n2 / 2) continue;
                decoratedDifference = decoratedDifference2;
                continue;
            }
            decoratedDifference = decoratedDifference2;
        }
        if (decoratedDifference == null) {
            return null;
        }
        boolean bl2 = bl = decoratedDifference.getTopRight() > n + n2 / 2;
        if (decoratedDifference.getDiff().getType() == 0 && decoratedDifference.getTopRight() < n + n2 * 4 / 5) {
            bl = false;
        }
        if (decoratedDifference.getDiff().getType() == 0 && decoratedDifference == decoratedDifferenceArray[decoratedDifferenceArray.length - 1]) {
            bl = false;
        }
        return new DifferencePosition(decoratedDifference.getDiff(), bl);
    }

    double getScrollFactor() {
        BoundedRangeModel boundedRangeModel = this.leftContentPanel.getScrollPane().getVerticalScrollBar().getModel();
        BoundedRangeModel boundedRangeModel2 = this.rightContentPanel.getScrollPane().getVerticalScrollBar().getModel();
        return ((double)boundedRangeModel.getMaximum() - (double)boundedRangeModel.getExtent()) / (double)(boundedRangeModel2.getMaximum() - boundedRangeModel2.getExtent());
    }

    void editorPainting(DecoratedEditorPane decoratedEditorPane) {
        if (!decoratedEditorPane.isFirst()) {
            JComponent jComponent = this.master.getMyDivider();
            jComponent.paint(jComponent.getGraphics());
        }
    }

    private class ScrollMapCached {
        private int rightPanelHeightCached;
        private int[] scrollMapCached;
        private int diffSerialCached;

        private ScrollMapCached() {
        }

        public synchronized int[] getScrollMap(int n, int n2) {
            if (n != this.rightPanelHeightCached || this.diffSerialCached != n2 || this.scrollMapCached == null) {
                this.diffSerialCached = n2;
                this.rightPanelHeightCached = n;
                this.scrollMapCached = this.compute();
            }
            return this.scrollMapCached;
        }

        private int[] compute() {
            DiffContentPanel diffContentPanel = DiffViewManager.this.master.getEditorPane2();
            int n = diffContentPanel.getScrollPane().getViewport().getViewRect().height;
            int[] nArray = new int[this.rightPanelHeightCached];
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)DiffViewManager.this.leftContentPanel.getEditorPane());
            if (editorUI == null) {
                return nArray;
            }
            int n2 = editorUI.getLineHeight();
            int n3 = 0;
            for (int i = 0; i < this.rightPanelHeightCached; ++i) {
                int n4;
                DifferencePosition differencePosition = DiffViewManager.this.findDifferenceToMatch(i, n);
                if (differencePosition == null) {
                    n4 = n3 + i;
                } else {
                    n4 = DiffViewManager.this.computeLeftOffsetToMatchDifference(differencePosition, n2, i);
                    n3 = n4 - i;
                }
                nArray[i] = n4;
            }
            nArray = this.smooth(nArray);
            return nArray;
        }

        private int[] smooth(int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            int n = 0;
            float f = 0.0f;
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                int n3 = n2 - i;
                if (n3 > n) {
                    if (f > (float)(n3 - n)) {
                        f = n3 - n;
                    }
                    n = (int)((float)n + f);
                    f += 0.02f;
                } else if (n3 < n) {
                    --n;
                } else {
                    f = 1.0f;
                }
                nArray2[i] = i + n;
            }
            return nArray2;
        }
    }

    private static class CorrectRowTokenizer {
        private final String s;
        private int idx;

        public CorrectRowTokenizer(String string) {
            this.s = string;
        }

        public String nextToken() {
            String string = null;
            for (int i = this.idx; i < this.s.length(); ++i) {
                if (this.s.charAt(i) != '\n') continue;
                string = this.s.substring(this.idx, i);
                this.idx = i + 1;
                break;
            }
            return string;
        }
    }

    public static class HighLight {
        private final int startOffset;
        private final int endOffset;
        private final AttributeSet attrs;

        public HighLight(int n, int n2, AttributeSet attributeSet) {
            this.startOffset = n;
            this.endOffset = n2;
            this.attrs = attributeSet;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public AttributeSet getAttrs() {
            return this.attrs;
        }
    }

    public static class DecoratedDifference {
        private final Difference diff;
        private final boolean canRollback;
        private int topLeft;
        private int bottomLeft = -1;
        private int topRight;
        private int bottomRight = -1;
        private boolean floodFill;

        public DecoratedDifference(Difference difference, boolean bl) {
            this.diff = difference;
            this.canRollback = bl;
        }

        public boolean canRollback() {
            return this.canRollback;
        }

        public Difference getDiff() {
            return this.diff;
        }

        public int getTopLeft() {
            return this.topLeft;
        }

        public int getBottomLeft() {
            return this.bottomLeft;
        }

        public int getTopRight() {
            return this.topRight;
        }

        public int getBottomRight() {
            return this.bottomRight;
        }

        public boolean isFloodFill() {
            return this.floodFill;
        }
    }

    public static class DifferencePosition {
        private Difference diff;
        private boolean isStart;

        public DifferencePosition(Difference difference, boolean bl) {
            this.diff = difference;
            this.isStart = bl;
        }

        public Difference getDiff() {
            return this.diff;
        }

        public boolean isStart() {
            return this.isStart;
        }
    }
}

