/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import java.util.prefs.Preferences;
import org.netbeans.modules.diff.builtin.provider.BuiltInDiffProvider;
import org.netbeans.modules.diff.cmdline.CmdlineDiffProvider;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class DiffModuleConfig {
    public static final String PREF_EXTERNAL_DIFF_COMMAND = "externalDiffCommand";
    private static final String PREF_IGNORE_WHITESPACE = "ignoreWhitespace";
    private static final String PREF_USE_INTERNAL_DIFF = "useInternalDiff";
    private static final String PREF_ADDED_COLOR = "addedColor";
    private static final String PREF_CHANGED_COLOR = "changedColor";
    private static final String PREF_DELETED_COLOR = "deletedColor";
    private static final DiffModuleConfig INSTANCE = new DiffModuleConfig();
    private final Color defaultAddedColor = new Color(180, 255, 180);
    private final Color defaultChangedColor = new Color(160, 200, 255);
    private final Color defaultDeletedColor = new Color(255, 160, 180);

    public static DiffModuleConfig getDefault() {
        return INSTANCE;
    }

    private DiffModuleConfig() {
    }

    public Color getAddedColor() {
        return this.getColor(PREF_ADDED_COLOR, this.defaultAddedColor);
    }

    public Color getChangedColor() {
        return this.getColor(PREF_CHANGED_COLOR, this.defaultChangedColor);
    }

    public Color getDeletedColor() {
        return this.getColor(PREF_DELETED_COLOR, this.defaultDeletedColor);
    }

    public void setChangedColor(Color color) {
        this.putColor(PREF_CHANGED_COLOR, color);
    }

    public void setAddedColor(Color color) {
        this.putColor(PREF_ADDED_COLOR, color);
    }

    public void setDeletedColor(Color color) {
        this.putColor(PREF_DELETED_COLOR, color);
    }

    private void putColor(String string, Color color) {
        this.getPreferences().putInt(string, color.getRGB());
    }

    private Color getColor(String string, Color color) {
        int n = this.getPreferences().getInt(string, color.getRGB());
        return new Color(n);
    }

    public DiffProvider getDefaultDiffProvider() {
        DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diffProvider instanceof BuiltInDiffProvider) {
            ((BuiltInDiffProvider)diffProvider).setTrimLines(this.isIgnoreWhitespace());
        } else if (diffProvider instanceof CmdlineDiffProvider) {
            ((CmdlineDiffProvider)diffProvider).setDiffCommand(this.getDiffCommand());
        }
        return diffProvider;
    }

    private String getDiffCommand() {
        return this.getPreferences().get(PREF_EXTERNAL_DIFF_COMMAND, "diff {0} {1}");
    }

    public void setIgnoreWhitespace(boolean bl) {
        this.getPreferences().putBoolean(PREF_IGNORE_WHITESPACE, bl);
        this.getBuiltinProvider().setTrimLines(bl);
    }

    private BuiltInDiffProvider getBuiltinProvider() {
        Collection collection = Lookup.getDefault().lookupAll(DiffProvider.class);
        for (DiffProvider diffProvider : collection) {
            if (!(diffProvider instanceof BuiltInDiffProvider)) continue;
            return (BuiltInDiffProvider)diffProvider;
        }
        throw new IllegalStateException("No builtin diff provider");
    }

    public boolean isIgnoreWhitespace() {
        return this.getPreferences().getBoolean(PREF_IGNORE_WHITESPACE, true);
    }

    public void setUseInteralDiff(boolean bl) {
        this.getPreferences().putBoolean(PREF_USE_INTERNAL_DIFF, bl);
        Collection collection = Lookup.getDefault().lookupAll(DiffProvider.class);
        if (bl) {
            this.setDefaultProvider(this.getBuiltinProvider());
        } else {
            for (DiffProvider diffProvider : collection) {
                if (!(diffProvider instanceof CmdlineDiffProvider)) continue;
                this.setDefaultProvider(diffProvider);
                break;
            }
        }
    }

    public boolean isUseInteralDiff() {
        return this.getPreferences().getBoolean(PREF_USE_INTERNAL_DIFF, true);
    }

    private void setDefaultProvider(DiffProvider diffProvider) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Services/DiffProviders");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            InstanceDataObject instanceDataObject;
            if (!(dataObjectArray[i] instanceof InstanceDataObject) || !(instanceDataObject = (InstanceDataObject)dataObjectArray[i]).instanceOf(diffProvider.getClass())) continue;
            try {
                if (!diffProvider.equals(instanceDataObject.instanceCreate())) continue;
                dataFolder.setOrder(new DataObject[]{instanceDataObject});
                break;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(DiffModuleConfig.class);
    }
}

