/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.netbeans.modules.db.util.DatabaseExplorerInternalUIs;
import org.netbeans.modules.db.util.DriverListUtil;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NewConnectionPanel
extends ConnectionDialog.FocusablePanel
implements DocumentListener,
ListDataListener {
    private ConnectionDialogMediator mediator;
    private DatabaseConnection connection;
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private static final String BUNDLE = "org.netbeans.modules.db.resources.Bundle";
    private JPanel connectProgressPanel;
    private JLabel driverLabel;
    private JTextField driverTextField;
    private JPanel jPanel1;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JPanel progressContainerPanel;
    private JLabel progressMessageLabel;
    private JComboBox templateComboBox;
    private JLabel templateLabel;
    private JComboBox urlComboBox;
    private JLabel urlLabel;
    private JLabel userLabel;
    private JTextField userTextField;

    public NewConnectionPanel(ConnectionDialogMediator connectionDialogMediator, String string, DatabaseConnection databaseConnection) {
        this.mediator = connectionDialogMediator;
        this.connection = databaseConnection;
        this.initComponents();
        this.initAccessibility();
        DatabaseExplorerInternalUIs.connect(this.templateComboBox, JDBCDriverManager.getDefault(), string);
        ConnectionProgressListener connectionProgressListener = new ConnectionProgressListener(){

            public void connectionStarted() {
                NewConnectionPanel.this.startProgress();
            }

            public void connectionStep(String string) {
                NewConnectionPanel.this.setProgressMessage(string);
            }

            public void connectionFinished() {
                NewConnectionPanel.this.stopProgress(true);
            }

            public void connectionFailed() {
                NewConnectionPanel.this.stopProgress(false);
            }
        };
        connectionDialogMediator.addConnectionProgressListener(connectionProgressListener);
        this.driverTextField.setText(databaseConnection.getDriver());
        this.urlComboBox.setSelectedItem(databaseConnection.getDatabase());
        this.userTextField.setText(databaseConnection.getUser());
        this.passwordField.setText(databaseConnection.getPassword());
        String string2 = databaseConnection.getDriver();
        String string3 = databaseConnection.getDriverName();
        if (string2 != null && string3 != null) {
            for (int i = 0; i < this.templateComboBox.getItemCount(); ++i) {
                JDBCDriver jDBCDriver;
                Object e = this.templateComboBox.getItemAt(i);
                if (!(e instanceof JDBCDriver) || !(jDBCDriver = (JDBCDriver)e).getClassName().equals(string2) || !jDBCDriver.getName().equals(string3)) continue;
                this.templateComboBox.setSelectedIndex(i);
                break;
            }
        }
        this.driverTextField.getDocument().addDocumentListener(this);
        this.userTextField.getDocument().addDocumentListener(this);
        this.passwordField.getDocument().addDocumentListener(this);
        this.templateComboBox.getModel().addListDataListener(this);
        this.urlComboBox.getModel().addListDataListener(this);
        this.checkValid();
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)BUNDLE);
        this.templateLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionDriverNameA11yDesc"));
        this.templateComboBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionDriverNameComboBoxA11yName"));
        this.driverLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionDriverClassA11yDesc"));
        this.driverTextField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionDriverClassComboBoxA11yName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionDatabaseURLA11yDesc"));
        this.urlComboBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionDatabaseURLTextFieldA11yName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionUserNameA11yDesc"));
        this.userTextField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionUserNameTextFieldA11yName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionPasswordA11yDesc"));
        this.passwordField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionPasswordTextFieldA11yName"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_ConnectionProgressBarA11yName"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_ConnectionProgressBarA11yDesc"));
    }

    public void initializeFocus() {
        this.getInitiallyFocusedComponent().requestFocusInWindow();
    }

    private JComponent getInitiallyFocusedComponent() {
        if (this.templateComboBox.getItemCount() <= 1) {
            return this.templateComboBox;
        }
        if (this.connection.getDatabase().length() == 0) {
            return this.urlComboBox;
        }
        if (this.userTextField.getText().length() == 0) {
            return this.userTextField;
        }
        if (this.passwordField.getPassword().length == 0) {
            return this.passwordField;
        }
        return this.urlComboBox;
    }

    private void initComponents() {
        this.templateLabel = new JLabel();
        this.templateComboBox = new JComboBox();
        this.driverLabel = new JLabel();
        this.driverTextField = new JTextField();
        this.urlLabel = new JLabel();
        this.urlComboBox = new JComboBox();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.passwordCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.connectProgressPanel = new JPanel();
        this.progressMessageLabel = new JLabel();
        this.progressContainerPanel = new JPanel();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.templateLabel.setLabelFor(this.templateComboBox);
        Mnemonics.setLocalizedText((JLabel)this.templateLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDriverName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.templateLabel, gridBagConstraints);
        this.templateComboBox.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionDriverNameComboBoxA11yDesc"));
        this.templateComboBox.addItemListener(formListener);
        this.templateComboBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 5, 0, 11);
        this.add((Component)this.templateComboBox, gridBagConstraints);
        this.driverLabel.setLabelFor(this.driverTextField);
        Mnemonics.setLocalizedText((JLabel)this.driverLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDriverClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.driverLabel, gridBagConstraints);
        this.driverTextField.setColumns(50);
        this.driverTextField.setEditable(false);
        this.driverTextField.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionDriverClassComboBoxA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.driverTextField, gridBagConstraints);
        this.urlLabel.setLabelFor(this.urlComboBox);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDatabaseURL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.urlLabel, gridBagConstraints);
        this.urlComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.urlComboBox, gridBagConstraints);
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionUserName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.userLabel, gridBagConstraints);
        this.userTextField.setColumns(50);
        this.userTextField.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionUserNameTextFieldA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.userTextField, gridBagConstraints);
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.passwordLabel, gridBagConstraints);
        this.passwordField.setColumns(50);
        this.passwordField.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionPasswordTextFieldA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.passwordField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.passwordCheckBox, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionRememberPassword"));
        this.passwordCheckBox.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionRememberPasswordA11yDesc"));
        this.passwordCheckBox.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.passwordCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.connectProgressPanel.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_ConnectionProgressBarA11yDesc"));
        this.connectProgressPanel.setLayout(new BorderLayout(0, 5));
        Mnemonics.setLocalizedText((JLabel)this.progressMessageLabel, (String)" ");
        this.connectProgressPanel.add((Component)this.progressMessageLabel, "North");
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        this.progressContainerPanel.setLayout(new BorderLayout());
        this.connectProgressPanel.add((Component)this.progressContainerPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.connectProgressPanel, gridBagConstraints);
    }

    private void templateComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.checkValid();
    }

    private void templateComboBoxActionPerformed(ActionEvent actionEvent) {
        Object object = this.templateComboBox.getSelectedItem();
        if (!(object instanceof JDBCDriver)) {
            return;
        }
        JDBCDriver jDBCDriver = (JDBCDriver)object;
        List list = null;
        String string = null;
        if (jDBCDriver != null) {
            string = jDBCDriver.getClassName();
            list = DriverListUtil.getURLs(string);
        }
        this.urlComboBox.removeAllItems();
        if (!this.connection.getDatabase().equals("")) {
            this.urlComboBox.addItem(this.connection.getDatabase());
        } else if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.urlComboBox.addItem((String)list.get(i));
            }
        }
        if (string != null) {
            this.driverTextField.setText(string);
        }
    }

    private JDBCDriver getSelectedDriver() {
        Object object = this.templateComboBox.getSelectedItem();
        if (object instanceof JDBCDriver) {
            return (JDBCDriver)object;
        }
        return null;
    }

    public void setConnectionInfo() {
        JDBCDriver jDBCDriver = this.getSelectedDriver();
        if (jDBCDriver != null) {
            this.connection.setDriverName(jDBCDriver.getName());
            this.connection.setDriver(jDBCDriver.getClassName());
        }
        this.connection.setDatabase(this.urlComboBox.getEditor().getItem().toString());
        this.connection.setUser(this.userTextField.getText());
        this.connection.setPassword(this.getPassword());
        this.connection.setRememberPassword(this.passwordCheckBox.isSelected());
    }

    private String getPassword() {
        String string = new String(this.passwordField.getPassword());
        String string2 = string.length() > 0 ? string : null;
        return string2;
    }

    public String getTitle() {
        return NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDialogTitle");
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewConnectionPanel.this.progressHandle = ProgressHandleFactory.createHandle(null);
                NewConnectionPanel.this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)NewConnectionPanel.this.progressHandle);
                NewConnectionPanel.this.progressContainerPanel.add((Component)NewConnectionPanel.this.progressComponent, "Center");
                NewConnectionPanel.this.progressHandle.start();
                NewConnectionPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)NewConnectionPanel.BUNDLE).getString("ConnectionProgress_Connecting"));
            }
        });
    }

    private void setProgressMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewConnectionPanel.this.progressMessageLabel.setText(string);
            }
        });
    }

    private void stopProgress(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewConnectionPanel.this.progressHandle.finish();
                NewConnectionPanel.this.progressContainerPanel.remove(NewConnectionPanel.this.progressComponent);
                NewConnectionPanel.this.progressContainerPanel.repaint();
                if (bl) {
                    NewConnectionPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)NewConnectionPanel.BUNDLE).getString("ConnectionProgress_Established"));
                } else {
                    NewConnectionPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)NewConnectionPanel.BUNDLE).getString("ConnectionProgress_Failed"));
                }
            }
        });
    }

    private void resetProgress() {
        this.progressMessageLabel.setText("");
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireChange();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireChange();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireChange();
    }

    private void fireChange() {
        this.firePropertyChange("argumentChanged", null, null);
        this.resetProgress();
    }

    private void checkValid() {
        this.mediator.setValid(this.getSelectedDriver() != null);
    }

    private class FormListener
    implements ActionListener,
    ItemListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == NewConnectionPanel.this.templateComboBox) {
                NewConnectionPanel.this.templateComboBoxActionPerformed(actionEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == NewConnectionPanel.this.templateComboBox) {
                NewConnectionPanel.this.templateComboBoxItemStateChanged(itemEvent);
            }
        }
    }
}

