/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.MacroDialogSupport;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorSettingsInitializer;
import org.netbeans.modules.editor.NbEditorUI;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.NbToolTip;
import org.netbeans.modules.editor.impl.ActionsList;
import org.netbeans.modules.editor.impl.PopupMenuActionsProvider;
import org.netbeans.modules.editor.impl.SearchBar;
import org.netbeans.modules.editor.impl.actions.NavigationHistoryBackAction;
import org.netbeans.modules.editor.impl.actions.NavigationHistoryForwardAction;
import org.netbeans.modules.editor.impl.actions.NavigationHistoryLastEditAction;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MacrosEditorPanel;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FindAction;
import org.openide.actions.GotoAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PopupAction;
import org.openide.actions.RedoAction;
import org.openide.actions.ReplaceAction;
import org.openide.actions.UndoAction;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class NbEditorKit
extends ExtKit {
    public static final String SYSTEM_ACTION_CLASS_NAME_PROPERTY = "systemActionClassName";
    static final long serialVersionUID = 4482122073483644089L;
    private static final Map contentTypeTable;
    public static final String generateGoToPopupAction = "generate-goto-popup";
    public static final String generateFoldPopupAction = "generate-fold-popup";
    private static final NbUndoAction nbUndoActionDef;
    private static final NbRedoAction nbRedoActionDef;
    private Map systemAction2editorAction = new HashMap();

    public NbEditorKit() {
        NbEditorSettingsInitializer.init();
    }

    public Document createDefaultDocument() {
        NbEditorDocument nbEditorDocument = new NbEditorDocument(((Object)((Object)this)).getClass());
        Object object = nbEditorDocument.getProperty("mimeType");
        if (object == null) {
            nbEditorDocument.putProperty("mimeType", this.getContentType());
        }
        return nbEditorDocument;
    }

    protected void toolTipAnnotationsLock(Document document) {
    }

    protected void toolTipAnnotationsUnlock(Document document) {
    }

    protected EditorUI createEditorUI() {
        return new NbEditorUI();
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new NbBuildPopupMenuAction(), new NbStopMacroRecordingAction(), nbUndoActionDef, nbRedoActionDef, new NbBuildToolTipAction(), new NbToggleLineNumbersAction(), new ToggleToolbarAction(), new NbGenerateGoToPopupAction(), new GenerateFoldPopupAction(), new NavigationHistoryLastEditAction(), new NavigationHistoryBackAction(), new NavigationHistoryForwardAction(), new SearchBar.IncrementalSearchForwardAction(), new SearchBar.IncrementalSearchBackwardAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    protected void addSystemActionMapping(String string, Class clazz) {
        Action action = this.getActionByName(string);
        if (action != null) {
            action.putValue(SYSTEM_ACTION_CLASS_NAME_PROPERTY, clazz.getName());
        }
        this.systemAction2editorAction.put(clazz.getName(), string);
    }

    protected void updateActions() {
        this.addSystemActionMapping("cut-to-clipboard", CutAction.class);
        this.addSystemActionMapping("copy-to-clipboard", CopyAction.class);
        this.addSystemActionMapping("paste-from-clipboard", PasteAction.class);
        this.addSystemActionMapping("delete-next", DeleteAction.class);
        this.addSystemActionMapping("show-popup-menu", PopupAction.class);
        this.addSystemActionMapping("incremental-search-forward", FindAction.class);
        this.addSystemActionMapping("replace", ReplaceAction.class);
        this.addSystemActionMapping("goto", GotoAction.class);
        this.addSystemActionMapping("undo", UndoAction.class);
        this.addSystemActionMapping("redo", RedoAction.class);
    }

    private boolean isInheritorOfNbEditorKit() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        while (clazz.getSuperclass() != null) {
            if (NbEditorKit.class != (clazz = clazz.getSuperclass())) continue;
            return true;
        }
        return false;
    }

    public String getContentType() {
        if (this.isInheritorOfNbEditorKit()) {
            ErrorManager.getDefault().log(16, "Warning: KitClass " + ((Object)((Object)this)).getClass().getName() + " doesn't override the method getContentType.");
        }
        return contentTypeTable.containsKey(((Object)((Object)this)).getClass().getName()) ? (String)contentTypeTable.get(((Object)((Object)this)).getClass().getName()) : "text/" + ((Object)((Object)this)).getClass().getName().replace('.', '_');
    }

    private static ResourceBundle getBundleFromName(String string) {
        ResourceBundle resourceBundle = null;
        if (string != null) {
            try {
                resourceBundle = NbBundle.getBundle((String)string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return resourceBundle;
    }

    static {
        nbUndoActionDef = new NbUndoAction();
        nbRedoActionDef = new NbRedoAction();
        contentTypeTable = new HashMap();
        contentTypeTable.put("org.netbeans.modules.properties.syntax.PropertiesKit", "text/x-properties");
        contentTypeTable.put("org.netbeans.modules.web.core.syntax.JSPKit", "text/x-jsp");
        contentTypeTable.put("org.netbeans.modules.css.text.syntax.CSSEditorKit", "text/css");
        contentTypeTable.put("org.netbeans.modules.xml.css.editor.CSSEditorKit", "text/css");
        contentTypeTable.put("org.netbeans.modules.xml.text.syntax.DTDKit", "text/x-dtd");
        contentTypeTable.put("org.netbeans.modules.xml.text.syntax.XMLKit", "text/xml");
        contentTypeTable.put("org.netbeans.modules.corba.idl.editor.coloring.IDLKit", "text/x-idl");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LayerSubFolderMenu
    extends JMenu {
        private static String getLocalizedName(FileObject fileObject) {
            try {
                return fileObject.getFileSystem().getStatus().annotateName(fileObject.getNameExt(), Collections.singleton(fileObject));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return fileObject.getNameExt();
            }
        }

        public LayerSubFolderMenu(JTextComponent jTextComponent, FileObject fileObject) {
            this(jTextComponent, LayerSubFolderMenu.getLocalizedName(fileObject), ActionsList.convert(LayerSubFolderMenu.sort(fileObject.getChildren())));
        }

        private static List<FileObject> sort(FileObject[] fileObjectArray) {
            List list = Arrays.asList(fileObjectArray);
            list = FileUtil.getOrder(list, (boolean)true);
            return list;
        }

        private LayerSubFolderMenu(JTextComponent jTextComponent, String string, List list) {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)string);
            for (Object e : list) {
                if (e == null || e instanceof JSeparator) {
                    this.addSeparator();
                    continue;
                }
                if (e instanceof String) {
                    LayerSubFolderMenu.addAction(jTextComponent, (JMenu)this, (String)e);
                    continue;
                }
                if (e instanceof Action) {
                    LayerSubFolderMenu.addAction(jTextComponent, (JMenu)this, (Action)e);
                    continue;
                }
                if (!(e instanceof DataFolder)) continue;
                this.add(new LayerSubFolderMenu(jTextComponent, ((DataFolder)e).getPrimaryFile()));
            }
        }

        private static void addAcceleretors(Action action, JMenuItem jMenuItem, JTextComponent jTextComponent) {
            Keymap keymap;
            Keymap keymap2 = keymap = jTextComponent == null ? BaseKit.getKit(BaseKit.class).getKeymap() : jTextComponent.getKeymap();
            if (keymap != null) {
                KeyStroke keyStroke;
                KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
                if (keyStrokeArray != null && keyStrokeArray.length > 0) {
                    boolean bl = false;
                    for (int i = 0; i < keyStrokeArray.length; ++i) {
                        if (keyStrokeArray[i].getKeyCode() != 106 && keyStrokeArray[i].getKeyCode() != 107) continue;
                        jMenuItem.setAccelerator(keyStrokeArray[i]);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        jMenuItem.setAccelerator(keyStrokeArray[0]);
                    }
                } else if (action != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
                    jMenuItem.setAccelerator(keyStroke);
                }
            }
        }

        private static String getItemText(JTextComponent jTextComponent, String string, Action action) {
            Object object;
            String string2 = action instanceof BaseAction ? ((BaseAction)action).getPopupMenuText(jTextComponent) : ((object = action.getValue("PopupMenuText")) instanceof String ? (String)object : string);
            return string2;
        }

        private static void addAction(JTextComponent jTextComponent, JMenu jMenu, String string) {
            assert (jTextComponent != null) : "The parameter target must not be null";
            assert (jMenu != null) : "The parameter menu must not be null";
            assert (string != null) : "The parameter actionName must not be null";
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            if (baseKit == null) {
                return;
            }
            Action action = baseKit.getActionByName(string);
            if (action != null) {
                LayerSubFolderMenu.addAction(jTextComponent, jMenu, action);
            }
        }

        private static void addAction(JTextComponent jTextComponent, JMenu jMenu, Action action) {
            String string;
            String string2;
            assert (jTextComponent != null) : "The parameter target must not be null";
            assert (jMenu != null) : "The parameter menu must not be null";
            assert (action != null) : "The parameter action must not be null";
            JMenuItem jMenuItem = null;
            if (action instanceof BaseAction) {
                jMenuItem = ((BaseAction)action).getPopupMenuItem(jTextComponent);
            }
            if (jMenuItem == null && (string2 = LayerSubFolderMenu.getItemText(jTextComponent, string = (String)action.getValue("Name"), action)) != null) {
                jMenuItem = new JMenuItem(string2);
                jMenuItem.addActionListener(action);
                Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)string2);
                LayerSubFolderMenu.addAcceleretors(action, jMenuItem, jTextComponent);
                jMenuItem.setEnabled(action.isEnabled());
                Object object = action.getValue("helpID");
                if (object != null && object instanceof String) {
                    jMenuItem.putClientProperty("HelpID", object);
                }
            }
            if (jMenuItem != null) {
                jMenu.add(jMenuItem);
            }
        }
    }

    public static class GenerateFoldPopupAction
    extends BaseAction {
        private boolean addSeparatorBeforeNextAction;

        public GenerateFoldPopupAction() {
            super(NbEditorKit.generateFoldPopupAction);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        protected Class getShortDescriptionBundleClass() {
            return NbEditorKit.class;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }

        private void addAcceleretors(Action action, JMenuItem jMenuItem, JTextComponent jTextComponent) {
            KeyStroke[] keyStrokeArray;
            Keymap keymap;
            Keymap keymap2 = keymap = jTextComponent == null ? BaseKit.getKit(BaseKit.class).getKeymap() : jTextComponent.getKeymap();
            if (keymap != null && (keyStrokeArray = keymap.getKeyStrokesForAction(action)) != null && keyStrokeArray.length > 0) {
                boolean bl = false;
                for (int i = 0; i < keyStrokeArray.length; ++i) {
                    if (keyStrokeArray[i].getKeyCode() != 106 && keyStrokeArray[i].getKeyCode() != 107) continue;
                    jMenuItem.setAccelerator(keyStrokeArray[i]);
                    bl = true;
                    break;
                }
                if (!bl) {
                    jMenuItem.setAccelerator(keyStrokeArray[0]);
                }
            }
        }

        protected String getItemText(JTextComponent jTextComponent, String string, Action action) {
            String string2 = action instanceof BaseAction ? ((BaseAction)action).getPopupMenuText(jTextComponent) : string;
            return string2;
        }

        protected void addAction(JTextComponent jTextComponent, JMenu jMenu, String string) {
            BaseKit baseKit;
            if (this.addSeparatorBeforeNextAction) {
                this.addSeparatorBeforeNextAction = false;
                jMenu.addSeparator();
            }
            BaseKit baseKit2 = baseKit = jTextComponent == null ? BaseKit.getKit(BaseKit.class) : Utilities.getKit((JTextComponent)jTextComponent);
            if (!(baseKit instanceof BaseKit)) {
                baseKit = BaseKit.getKit(BaseKit.class);
                jTextComponent = null;
            }
            if (baseKit == null) {
                return;
            }
            boolean bl = jTextComponent == null ? false : (Boolean)Settings.getValue((Class)Utilities.getKitClass((JTextComponent)jTextComponent), (String)"code-folding-enable");
            Action action = baseKit.getActionByName(string);
            if (action != null) {
                String string2;
                JMenuItem jMenuItem = null;
                if (action instanceof BaseAction) {
                    jMenuItem = ((BaseAction)action).getPopupMenuItem(jTextComponent);
                }
                if (jMenuItem == null && (string2 = this.getItemText(jTextComponent, string, action)) != null) {
                    jMenuItem = new JMenuItem(string2);
                    jMenuItem.addActionListener(action);
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)string2);
                    this.addAcceleretors(action, jMenuItem, jTextComponent);
                    jMenuItem.setEnabled(action.isEnabled() && bl);
                    Object object = action.getValue("helpID");
                    if (object != null && object instanceof String) {
                        jMenuItem.putClientProperty("HelpID", object);
                    }
                }
                if (jMenuItem != null) {
                    jMenu.add(jMenuItem);
                }
            } else {
                jMenu.addSeparator();
            }
        }

        protected void setAddSeparatorBeforeNextAction(boolean bl) {
            this.addSeparatorBeforeNextAction = bl;
        }

        protected void addAdditionalItems(JTextComponent jTextComponent, JMenu jMenu) {
            this.setAddSeparatorBeforeNextAction(false);
        }

        public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
            String string = NbBundle.getBundle(NbEditorKit.class).getString("Menu/View/CodeFolds");
            JMenu jMenu = new JMenu(string);
            Mnemonics.setLocalizedText((AbstractButton)jMenu, (String)string);
            this.setAddSeparatorBeforeNextAction(false);
            this.addAction(jTextComponent, jMenu, "collapse-fold");
            this.addAction(jTextComponent, jMenu, "expand-fold");
            this.setAddSeparatorBeforeNextAction(true);
            this.addAction(jTextComponent, jMenu, "collapse-all-folds");
            this.addAction(jTextComponent, jMenu, "expand-all-folds");
            this.setAddSeparatorBeforeNextAction(true);
            if (jTextComponent != null) {
                this.addAdditionalItems(jTextComponent, jMenu);
            }
            return jMenu;
        }
    }

    public static class NbBuildToolTipAction
    extends ExtKit.BuildToolTipAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                NbToolTip.buildToolTip(jTextComponent);
            }
        }
    }

    public static class NbGenerateGoToPopupAction
    extends BaseAction {
        public NbGenerateGoToPopupAction() {
            super(NbEditorKit.generateGoToPopupAction);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }

        protected Class getShortDescriptionBundleClass() {
            return NbEditorKit.class;
        }
    }

    public static class NbToggleLineNumbersAction
    extends ActionFactory.ToggleLineNumbersAction {
        protected boolean isLineNumbersVisible() {
            return AllOptionsFolder.getDefault().getLineNumberVisible();
        }

        protected void toggleLineNumbers() {
            boolean bl = AllOptionsFolder.getDefault().getLineNumberVisible();
            AllOptionsFolder.getDefault().setLineNumberVisible(!bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            this.toggleLineNumbers();
        }
    }

    public static class NbRedoAction
    extends ActionFactory.RedoAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            RedoAction redoAction = (RedoAction)SystemAction.get(RedoAction.class);
            if (redoAction != null && redoAction.isEnabled()) {
                redoAction.actionPerformed(actionEvent);
            }
        }
    }

    public static class NbUndoAction
    extends ActionFactory.UndoAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            UndoAction undoAction = (UndoAction)SystemAction.get(UndoAction.class);
            if (undoAction != null && undoAction.isEnabled()) {
                undoAction.actionPerformed(actionEvent);
            }
        }
    }

    public class NbStopMacroRecordingAction
    extends ActionFactory.StopMacroRecordingAction {
        private BaseOptions bo;

        private Map getKBMap() {
            List list = this.bo.getKeyBindingList();
            if (list.size() > 0 && (list.get(0) instanceof Class || list.get(0) instanceof String)) {
                list.remove(0);
            }
            Map<String, MultiKeyBinding> map = OptionUtilities.makeKeyBindingsMap(list);
            return map;
        }

        protected MacroDialogSupport getMacroDialogSupport(Class clazz) {
            return new NbMacroDialogSupport(clazz);
        }

        private class NbMacroDialogSupport
        extends MacroDialogSupport {
            public NbMacroDialogSupport(Class clazz) {
                super(clazz);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                NbStopMacroRecordingAction.this.bo = BaseOptions.getOptions(((Object)((Object)NbEditorKit.this)).getClass());
                Map map = null;
                Map map2 = null;
                if (NbStopMacroRecordingAction.this.bo != null) {
                    map = NbStopMacroRecordingAction.this.bo.getMacroMap();
                    map2 = NbStopMacroRecordingAction.this.getKBMap();
                }
                super.actionPerformed(actionEvent);
                if (NbStopMacroRecordingAction.this.bo != null) {
                    Map map3 = NbStopMacroRecordingAction.this.bo.getMacroMap();
                    NbStopMacroRecordingAction.this.bo.setMacroDiffMap(OptionUtilities.getMapDiff(map, map3, true));
                    NbStopMacroRecordingAction.this.bo.setKeyBindingsDiffMap(OptionUtilities.getMapDiff(map2, NbStopMacroRecordingAction.this.getKBMap(), true));
                    NbStopMacroRecordingAction.this.bo.setMacroMap(map3, false);
                    NbStopMacroRecordingAction.this.bo.setKeyBindingList(NbStopMacroRecordingAction.this.bo.getKeyBindingList(), false);
                }
            }

            protected int showConfirmDialog(String string) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MacrosEditorPanel.class, (String)"MEP_Overwrite", (Object)string), 1, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                return (Integer)confirmation.getValue();
            }
        }
    }

    public class NbBuildPopupMenuAction
    extends ExtKit.BuildPopupMenuAction {
        static final long serialVersionUID = -8623762627678464181L;

        protected JPopupMenu createPopupMenu(JTextComponent jTextComponent) {
            return new JPopupMenuPlus();
        }

        protected JPopupMenu buildPopupMenu(JTextComponent jTextComponent) {
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
            if (!editorUI.hasExtComponent()) {
                return null;
            }
            JPopupMenu jPopupMenu = this.createPopupMenu(jTextComponent);
            String string = NbEditorUtilities.getMimeType(jTextComponent);
            List list = PopupMenuActionsProvider.getPopupMenuItems(string);
            if (list.isEmpty()) {
                list = (List)Settings.getValue((Class)Utilities.getKitClass((JTextComponent)jTextComponent), (String)(editorUI == null || editorUI.hasExtComponent() ? "popup-menu-action-name-list" : "dialog-popup-menu-action-name-list"));
            }
            if (list != null) {
                for (Object e : list) {
                    if (e == null || e instanceof JSeparator) {
                        this.addAction(jTextComponent, jPopupMenu, (String)null);
                        continue;
                    }
                    if (e instanceof String) {
                        this.addAction(jTextComponent, jPopupMenu, (String)e);
                        continue;
                    }
                    if (e instanceof Action) {
                        this.addAction(jTextComponent, jPopupMenu, (Action)e);
                        continue;
                    }
                    if (!(e instanceof DataFolder)) continue;
                    jPopupMenu.add(new LayerSubFolderMenu(jTextComponent, ((DataFolder)e).getPrimaryFile()));
                }
            }
            return jPopupMenu;
        }

        private Lookup getContextLookup(Component component) {
            Lookup lookup = null;
            for (Component component2 = component; !(component2 == null || component2 instanceof Lookup.Provider && (lookup = ((Lookup.Provider)component2).getLookup()) != null); component2 = component2.getParent()) {
            }
            return lookup;
        }

        private Action translateContextLookupAction(Lookup lookup, Action action) {
            if (action instanceof ContextAwareAction && lookup != null) {
                action = ((ContextAwareAction)action).createContextAwareInstance(lookup);
            }
            return action;
        }

        private JMenuItem createLocalizedMenuItem(Action action) {
            JMenuItem jMenuItem;
            if (action instanceof Presenter.Popup) {
                jMenuItem = ((Presenter.Popup)action).getPopupPresenter();
            } else {
                jMenuItem = new JMenuItem(action);
                Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
                if (jMenuItem.getIcon() != null) {
                    jMenuItem.setIcon(null);
                }
            }
            return jMenuItem;
        }

        private void assignAccelerator(Keymap keymap, Action action, JMenuItem jMenuItem) {
            if (jMenuItem.getAccelerator() == null) {
                KeyStroke[] keyStrokeArray;
                KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                if (keyStroke != null) {
                    jMenuItem.setAccelerator(keyStroke);
                } else if (keymap != null && (keyStrokeArray = keymap.getKeyStrokesForAction(action)) != null && keyStrokeArray.length > 0) {
                    jMenuItem.setAccelerator(keyStrokeArray[0]);
                }
            }
        }

        protected void addAction(JTextComponent jTextComponent, JPopupMenu jPopupMenu, Action action) {
            Lookup lookup = this.getContextLookup(jTextComponent);
            if (lookup == null && NbEditorKit.this.systemAction2editorAction.containsKey(action.getClass().getName())) {
                this.addAction(jTextComponent, jPopupMenu, (String)NbEditorKit.this.systemAction2editorAction.get(action.getClass().getName()));
                return;
            }
            if ((action = this.translateContextLookupAction(lookup, action)) != null) {
                JMenuItem jMenuItem = this.createLocalizedMenuItem(action);
                if (jMenuItem instanceof DynamicMenuContent) {
                    JComponent[] jComponentArray = ((DynamicMenuContent)jMenuItem).getMenuPresenters();
                    for (int i = 0; i < jComponentArray.length; ++i) {
                        jPopupMenu.add(jComponentArray[i]);
                    }
                } else {
                    jMenuItem.setEnabled(action.isEnabled());
                    Object object = action.getValue("helpID");
                    if (object != null && object instanceof String) {
                        jMenuItem.putClientProperty("HelpID", object);
                    }
                    this.assignAccelerator(jTextComponent.getKeymap(), action, jMenuItem);
                    this.debugPopupMenuItem(jMenuItem, action);
                    jPopupMenu.add(jMenuItem);
                }
            }
        }

        private void addTopComponentActions(JTextComponent jTextComponent, JPopupMenu jPopupMenu) {
            Lookup lookup = this.getContextLookup(jTextComponent);
            TopComponent topComponent = NbEditorUtilities.getOuterTopComponent(jTextComponent);
            if (topComponent != null) {
                Action[] actionArray = topComponent.getActions();
                Component[] componentArray = org.openide.util.Utilities.actionsToPopup((Action[])actionArray, (Lookup)lookup).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    jPopupMenu.add(componentArray[i]);
                }
            }
        }

        protected void addAction(JTextComponent jTextComponent, JPopupMenu jPopupMenu, String string) {
            if (string != null) {
                ClassLoader classLoader;
                if (TopComponent.class.getName().equals(string)) {
                    this.addTopComponentActions(jTextComponent, jPopupMenu);
                    return;
                }
                Class<?> clazz = null;
                try {
                    classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    clazz = Class.forName(string, false, classLoader);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (clazz != null && SystemAction.class.isAssignableFrom(clazz)) {
                    classLoader = this.getContextLookup(jTextComponent);
                    Object object = SystemAction.get(clazz);
                    JMenuItem jMenuItem = this.createLocalizedMenuItem((Action)(object = this.translateContextLookupAction((Lookup)classLoader, (Action)object)));
                    if (jMenuItem != null) {
                        if (jMenuItem instanceof DynamicMenuContent) {
                            JComponent[] jComponentArray = ((DynamicMenuContent)jMenuItem).getMenuPresenters();
                            for (int i = 0; i < jComponentArray.length; ++i) {
                                jPopupMenu.add(jComponentArray[i]);
                            }
                        } else {
                            if (!(jMenuItem instanceof JMenu)) {
                                this.assignAccelerator((Keymap)Lookup.getDefault().lookup(Keymap.class), (Action)object, jMenuItem);
                            }
                            this.debugPopupMenuItem(jMenuItem, (Action)object);
                            jPopupMenu.add(jMenuItem);
                        }
                    }
                    return;
                }
            }
            super.addAction(jTextComponent, jPopupMenu, string);
        }
    }

    public static class ToggleToolbarAction
    extends BaseAction {
        public ToggleToolbarAction() {
            super("toggle-toolbar");
            this.putValue("helpID", ToggleToolbarAction.class.getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            boolean bl = AllOptionsFolder.getDefault().isToolbarVisible();
            AllOptionsFolder.getDefault().setToolbarVisible(!bl);
        }

        public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getBundle(BaseOptions.class).getString("PROP_base_toolbarVisible"), AllOptionsFolder.getDefault().isToolbarVisible());
            jCheckBoxMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ToggleToolbarAction.this.actionPerformed(null, null);
                }
            });
            return jCheckBoxMenuItem;
        }

        protected Class getShortDescriptionBundleClass() {
            return BaseKit.class;
        }
    }
}

