/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.actions.SystemAction;

public final class FileBasedFileSystem
extends FileSystem {
    private static Map allInstances;
    private final FileObjectFactory factory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void reinitForTests() {
        allInstances = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileBasedFileSystem getInstance(File file) {
        FileBasedFileSystem fileBasedFileSystem;
        FileInfo fileInfo = new FileInfo(file);
        FileInfo fileInfo2 = fileInfo.getRoot();
        Map map = allInstances;
        synchronized (map) {
            File file2 = fileInfo2.getFile();
            fileBasedFileSystem = (FileBasedFileSystem)((Object)allInstances.get(file2));
            if (fileBasedFileSystem == null && fileInfo2.isConvertibleToFileObject()) {
                fileBasedFileSystem = new FileBasedFileSystem(file2);
                allInstances.put(file2, fileBasedFileSystem);
            }
        }
        return fileBasedFileSystem;
    }

    public static final FileObject getFileObject(File file) {
        FileBasedFileSystem fileBasedFileSystem = FileBasedFileSystem.getInstance(file);
        return fileBasedFileSystem != null ? fileBasedFileSystem.findFileObject(file) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection getInstances() {
        Map map = allInstances;
        synchronized (map) {
            return new ArrayList(allInstances.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getSize() {
        Map map = allInstances;
        synchronized (map) {
            return allInstances.size();
        }
    }

    private FileBasedFileSystem(File file) {
        this.factory = FileObjectFactory.getInstance(new FileInfo(file));
    }

    public final FileObject findResource(String string) {
        File file = new File(string);
        if (!$assertionsDisabled && !file.getAbsolutePath().replace('\\', '/').equals(string.replace('\\', '/'))) {
            throw new AssertionError((Object)(string + " versus " + file.getAbsolutePath()));
        }
        return this.findFileObject(file);
    }

    public final FileObject findFileObject(File file) {
        return this.findFileObject(new FileInfo(file));
    }

    public final FileObject findFileObject(FileInfo fileInfo) {
        File file;
        boolean bl;
        File file2 = fileInfo.getFile();
        boolean bl2 = bl = fileInfo.isWindows() && file2.getName().endsWith(".");
        if (bl) {
            file = FileUtil.normalizeFile((File)file2);
            boolean bl3 = bl = !file.getName().endsWith(".");
            if (bl) {
                return null;
            }
        }
        return (file = this.getFactory().findFileObject(fileInfo)) != null && file.isValid() ? file : null;
    }

    public final FileObject getRoot() {
        return this.getFactory().getRoot();
    }

    public final String getDisplayName() {
        return this.getFactory().getRoot().getRealRoot().getPath();
    }

    public final SystemAction[] getActions() {
        return new SystemAction[0];
    }

    public final SystemAction[] getActions(Set set) {
        return new SystemAction[0];
    }

    public final void refresh(final boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FS);
        stopWatch.start();
        try {
            this.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileBasedFileSystem.this.getFactory().refreshAll(bl);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stopWatch.stop();
        Logger.getLogger("org.netbeans.modules.masterfs.REFRESH").fine("FS.refresh statistics (" + Statistics.fileObjects() + "FileObjects):\n  " + Statistics.REFRESH_FS.toString() + "\n  " + Statistics.LISTENERS_CALLS.toString() + "\n  " + Statistics.REFRESH_FOLDER.toString() + "\n  " + Statistics.REFRESH_FILE.toString() + "\n");
        Statistics.REFRESH_FS.reset();
        Statistics.LISTENERS_CALLS.reset();
        Statistics.REFRESH_FOLDER.reset();
        Statistics.REFRESH_FILE.reset();
    }

    public final boolean isReadOnly() {
        return false;
    }

    public final String toString() {
        return this.getDisplayName();
    }

    public final FileObjectFactory getFactory() {
        return this.factory;
    }

    static {
        $assertionsDisabled = !FileBasedFileSystem.class.desiredAssertionStatus();
        allInstances = new HashMap();
    }
}

