/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.guards;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.netbeans.modules.editor.guards.GuardedSectionsImpl;
import org.netbeans.modules.editor.guards.NewLine;
import org.netbeans.spi.editor.guards.support.AbstractGuardedSectionsProvider;

final class GuardedReader
extends Reader {
    Reader reader;
    private NewLineInputStream newLineStream;
    char[] charBuff;
    int howmany;
    boolean justFilter;
    int position;
    private final GuardedSectionsImpl callback;
    private final AbstractGuardedSectionsProvider gr;
    private boolean isClosed = false;
    private AbstractGuardedSectionsProvider.Result result;

    GuardedReader(AbstractGuardedSectionsProvider abstractGuardedSectionsProvider, InputStream inputStream, boolean bl, Charset charset, GuardedSectionsImpl guardedSectionsImpl) {
        this.newLineStream = new NewLineInputStream(inputStream);
        this.reader = charset == null ? new InputStreamReader(this.newLineStream) : new InputStreamReader((InputStream)this.newLineStream, charset);
        this.justFilter = bl;
        this.callback = guardedSectionsImpl;
        this.gr = abstractGuardedSectionsProvider;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.charBuff == null) {
            char[] cArray2 = this.readCharBuff();
            this.result = this.gr.readSections(cArray2);
            this.charBuff = this.result.getContent();
            this.howmany = this.charBuff.length;
        }
        if (this.howmany <= 0) {
            return -1;
        }
        int n3 = Math.min(n2, this.howmany);
        System.arraycopy(this.charBuff, this.position, cArray, n, n3);
        this.howmany -= n3;
        this.position += n3;
        return n3;
    }

    final char[] readCharBuff() throws IOException {
        int n;
        char[] cArray = new char[2048];
        ArrayList<char[]> arrayList = new ArrayList<char[]>(20);
        while (true) {
            n = this.readFully(cArray);
            arrayList.add(cArray);
            if (n < 2048) break;
            cArray = new char[2048];
        }
        int n2 = arrayList.size() - 1;
        int n3 = n2 * 2048 + n;
        char[] cArray2 = new char[n3];
        this.charBuff = new char[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            char[] cArray3 = (char[])arrayList.get(i);
            System.arraycopy(cArray3, 0, cArray2, n4, 2048);
            n4 += 2048;
        }
        System.arraycopy(cArray, 0, cArray2, n4, n);
        return cArray2;
    }

    final int readFully(char[] cArray) throws IOException {
        int n = 0;
        int n2 = 0;
        while ((n2 += (n = this.reader.read(cArray, n2, cArray.length - n2))) < cArray.length && n > 0) {
        }
        return n2 + 1;
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.reader.close();
            this.callback.fillSections(this.result.getGuardedSections(), this.newLineStream.getNewLineType());
        }
    }

    private final class NewLineInputStream
    extends InputStream {
        private final InputStream stream;
        private int b;
        private int lookahead;
        private boolean isLookahead = false;
        final int[] newLineTypes;

        public NewLineInputStream(InputStream inputStream) {
            this.stream = inputStream;
            this.newLineTypes = new int[]{0, 0, 0};
        }

        public NewLine getNewLineType() {
            if (this.newLineTypes[NewLine.N.ordinal()] == this.newLineTypes[NewLine.R.ordinal()] && this.newLineTypes[NewLine.R.ordinal()] == this.newLineTypes[NewLine.RN.ordinal()]) {
                String string = System.getProperty("line.separator");
                return NewLine.resolve(string);
            }
            if (this.newLineTypes[NewLine.N.ordinal()] > this.newLineTypes[NewLine.R.ordinal()]) {
                return this.newLineTypes[NewLine.N.ordinal()] > this.newLineTypes[NewLine.RN.ordinal()] ? NewLine.N : NewLine.RN;
            }
            return this.newLineTypes[NewLine.R.ordinal()] > this.newLineTypes[NewLine.RN.ordinal()] ? NewLine.R : NewLine.RN;
        }

        public int read() throws IOException {
            this.b = this.isLookahead ? this.lookahead : this.stream.read();
            this.isLookahead = false;
            switch (this.b) {
                case 10: {
                    int n = NewLine.N.ordinal();
                    this.newLineTypes[n] = this.newLineTypes[n] + 1;
                    return this.b;
                }
                case 13: {
                    this.lookahead = this.stream.read();
                    if (this.lookahead != 10) {
                        int n = NewLine.R.ordinal();
                        this.newLineTypes[n] = this.newLineTypes[n] + 1;
                        this.isLookahead = true;
                    } else {
                        int n = NewLine.RN.ordinal();
                        this.newLineTypes[n] = this.newLineTypes[n] + 1;
                    }
                    return 10;
                }
            }
            return this.b;
        }

        public void close() throws IOException {
            super.close();
            this.stream.close();
        }
    }
}

