/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.jasperreports.engine.export.oasis.zip.EmptyOasisZipEntry;
import net.sf.jasperreports.engine.export.oasis.zip.OasisZipEntry;

public abstract class OasisZip {
    private List oasisZipEntries = new ArrayList();
    private OasisZipEntry contentEntry = this.createEntry("content.xml");
    private OasisZipEntry stylesEntry = null;

    public OasisZip() throws IOException {
        this(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OasisZip(byte openDocumentNature) throws IOException {
        String mimetype;
        this.oasisZipEntries.add(this.contentEntry);
        this.oasisZipEntries.add(new EmptyOasisZipEntry("meta.xml"));
        this.oasisZipEntries.add(new EmptyOasisZipEntry("settings.xml"));
        this.stylesEntry = this.createEntry("styles.xml");
        this.oasisZipEntries.add(this.stylesEntry);
        switch (openDocumentNature) {
            case 2: {
                mimetype = "spreadsheet";
                break;
            }
            default: {
                mimetype = "text";
            }
        }
        OasisZipEntry mimeEntry = this.createEntry("mimetype");
        Writer mimeWriter = null;
        try {
            mimeWriter = mimeEntry.getWriter();
            mimeWriter.write("application/vnd.oasis.opendocument." + mimetype);
            mimeWriter.flush();
            this.oasisZipEntries.add(mimeEntry);
        }
        finally {
            if (mimeWriter != null) {
                try {
                    mimeWriter.close();
                }
                catch (IOException e) {}
            }
        }
        OasisZipEntry manifestEntry = this.createEntry("META-INF/manifest.xml");
        Writer manifestWriter = null;
        try {
            manifestWriter = manifestEntry.getWriter();
            manifestWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \r\n");
            manifestWriter.write("<!DOCTYPE manifest:manifest PUBLIC \"-//OpenOffice.org//DTD Manifest 1.0//EN\" \"Manifest.dtd\"> \r\n");
            manifestWriter.write("<manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\"> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"application/vnd.oasis.opendocument." + mimetype + "\" manifest:full-path=\"/\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"application/vnd.sun.xml.ui.configuration\" manifest:full-path=\"Configurations2/\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Pictures/\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"content.xml\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"styles.xml\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"meta.xml\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Thumbnails/thumbnail.png\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Thumbnails/\"/> \r\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"settings.xml\"/> \r\n");
            manifestWriter.write("</manifest:manifest> \r\n");
            manifestWriter.flush();
            this.oasisZipEntries.add(manifestEntry);
        }
        finally {
            if (mimeWriter != null) {
                try {
                    mimeWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public abstract OasisZipEntry createEntry(String var1);

    public OasisZipEntry getContentEntry() {
        return this.contentEntry;
    }

    public OasisZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    public void addEntry(OasisZipEntry entry) {
        this.oasisZipEntries.add(entry);
    }

    public void zipEntries(OutputStream os) throws IOException {
        ZipOutputStream zipos = new ZipOutputStream(os);
        zipos.setMethod(8);
        for (int i = 0; i < this.oasisZipEntries.size(); ++i) {
            OasisZipEntry oasisZipEntry = (OasisZipEntry)this.oasisZipEntries.get(i);
            ZipEntry zipEntry = new ZipEntry(oasisZipEntry.getName());
            zipos.putNextEntry(zipEntry);
            oasisZipEntry.writeData(zipos);
        }
        zipos.flush();
        zipos.finish();
    }

    public void dispose() {
        for (int i = 0; i < this.oasisZipEntries.size(); ++i) {
            OasisZipEntry oasisZipEntry = (OasisZipEntry)this.oasisZipEntries.get(i);
            oasisZipEntry.dispose();
        }
    }
}

