/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.NbPreferences;

public class AutoupdateSettings {
    private static String tempIdeIdentity = null;
    private static final Logger err = Logger.getLogger(AutoupdateSettings.class.getName());
    private static final String PROP_IDE_IDENTITY = "ideIdentity";
    private static final String PROP_PERIOD = "period";
    private static final String PROP_LAST_CHECK = "lastCheckTime";
    public static final int EVERY_STARTUP = 0;
    public static final int EVERY_DAY = 1;
    public static final int EVERY_WEEK = 2;
    public static final int EVERY_2WEEKS = 3;
    public static final int EVERY_MONTH = 4;
    public static final int EVERY_NEVER = 5;

    private AutoupdateSettings() {
    }

    public static String getIdeIdentity() {
        if (tempIdeIdentity instanceof String) {
            return tempIdeIdentity;
        }
        String string = AutoupdateSettings.getPreferences().get(PROP_IDE_IDENTITY, null);
        String string2 = null;
        string2 = string == null ? AutoupdateSettings.modifyIdeIdentityIfNeeded(AutoupdateSettings.generateNewId()) : AutoupdateSettings.modifyIdeIdentityIfNeeded(string);
        tempIdeIdentity = string2;
        if (!string2.equals(string)) {
            err.log(Level.FINE, "Put new value of PROP_IDE_IDENTITY to " + string2);
            AutoupdateSettings.getPreferences().put(PROP_IDE_IDENTITY, string2);
        }
        return tempIdeIdentity;
    }

    public static int getPeriod() {
        return AutoupdateSettings.getPreferences().getInt(PROP_PERIOD, 2);
    }

    public static void setPeriod(int n) {
        AutoupdateSettings.getPreferences().putInt(PROP_PERIOD, n);
    }

    public static Date getLastCheck() {
        long l = AutoupdateSettings.getPreferences().getLong(PROP_LAST_CHECK, -1L);
        return l > 0L ? new Date(l) : null;
    }

    public static void setLastCheck(Date date) {
        err.log(Level.FINER, "Set the last check to " + date);
        if (date != null) {
            AutoupdateSettings.getPreferences().putLong(PROP_LAST_CHECK, date.getTime());
        } else {
            AutoupdateSettings.getPreferences().remove(PROP_LAST_CHECK);
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String modifyIdeIdentityIfNeeded(String string) {
        String string2;
        String string3;
        String string4;
        block11: {
            int n = string.indexOf(48);
            String[] stringArray = string.split("\\d");
            string4 = null;
            string3 = null;
            if (stringArray.length == 0 || n == 0) {
                string4 = string;
                string3 = "";
            } else if (n != -1 && string.substring(stringArray[0].length()).startsWith("0")) {
                string3 = string.substring(0, n);
                string4 = string.substring(string3.length());
            } else {
                string3 = stringArray[0];
                string4 = string.substring(string3.length());
            }
            err.log(Level.FINER, "Old IDE Identity Prefix: " + string3);
            err.log(Level.FINER, "Old IDE Identity ID: " + string4);
            string2 = "";
            try {
                FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("/productid");
                if (fileObject == null) break block11;
                InputStream inputStream = fileObject.getInputStream();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    string2 = bufferedReader.readLine().trim();
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                err.log(Level.FINER, iOException.getMessage(), iOException);
            }
        }
        if (!string2.equals(string3)) {
            err.log(Level.FINER, "New IDE Identity Prefix: " + string2);
        } else {
            err.log(Level.FINER, "No new prefix.");
        }
        return string2 + string4;
    }

    private static String generateNewId() {
        return "0" + UUID.randomUUID().toString();
    }
}

