/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.templates.DefaultReportGenerator;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.ConnectionSelectionWizardPanel;
import com.jaspersoft.ireport.designer.wizards.CustomChooserWizardPanel;
import com.jaspersoft.ireport.designer.wizards.FieldsSelectionWizardPanel;
import com.jaspersoft.ireport.designer.wizards.GroupingWizardPanel;
import com.jaspersoft.ireport.designer.wizards.NewJrxmlWizardPanel6;
import com.jaspersoft.ireport.designer.wizards.TemplateListWizardPanel;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;

public final class NewJrxmlWizardIterator
implements TemplateWizard.Iterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private DataObject createdDataObject = null;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            WizardDescriptor.Panel targetChooserPanel = null;
            boolean useCustomChooserPanel = false;
            if (this.wizard.getProperty("useCustomChooserPanel") != null && this.wizard.getProperty("useCustomChooserPanel").equals("true")) {
                targetChooserPanel = new CustomChooserWizardPanel(this.wizard);
            } else {
                targetChooserPanel = ((TemplateWizard)this.wizard).targetChooser();
                try {
                    File f;
                    DataFolder folder = ((TemplateWizard)this.wizard).getTargetFolder();
                    String dir = Misc.getDataFolderPath(folder);
                    String fname = "report1.jrxml";
                    for (int i = 1; i < 1000 && (f = new File(dir, fname = "report" + i + ".jrxml")).exists(); ++i) {
                    }
                    ((TemplateWizard)this.wizard).setTargetName(fname);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            ArrayList<Object> panelsList = new ArrayList<Object>();
            if (this.wizard.getProperty("reportTemplate") == null) {
                panelsList.add(new TemplateListWizardPanel(this.wizard));
            }
            panelsList.add(targetChooserPanel);
            if (this.wizard.getProperty("noFields") == null || !this.wizard.getProperty("noFields").equals("true")) {
                panelsList.add(new ConnectionSelectionWizardPanel(this.wizard));
                panelsList.add(new FieldsSelectionWizardPanel(this.wizard));
                panelsList.add(new GroupingWizardPanel(this.wizard));
            }
            panelsList.add(new NewJrxmlWizardPanel6(this.wizard));
            this.panels = panelsList.toArray(new WizardDescriptor.Panel[panelsList.size()]);
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public void setCreatedDataObject(DataObject obj) {
        this.createdDataObject = obj;
    }

    public DataObject getCreatedDataObject() {
        return this.createdDataObject;
    }

    public Set instantiate(TemplateWizard wizard) throws IOException {
        this.setCreatedDataObject(null);
        final Thread t = Thread.currentThread();
        Runnable r = new Runnable(){

            public void run() {
                try {
                    if (NewJrxmlWizardIterator.this.getCreatedDataObject() == null) {
                        StackTraceElement[] ees = t.getStackTrace();
                        for (int i = 0; i < ees.length; ++i) {
                            Misc.msg("" + ees[i]);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t2 = new Thread(r);
        t2.start();
        Logger.global.log(Level.INFO, "Instancing the report generator");
        DefaultReportGenerator reportGenerator = new DefaultReportGenerator();
        Logger.global.log(Level.INFO, "Report generator instanced");
        FileObject createdFile = reportGenerator.generateReport((WizardDescriptor)wizard);
        Logger.global.log(Level.INFO, "Report generated");
        if (createdFile == null) {
            throw new IOException("Unable to create the report.");
        }
        try {
            this.setCreatedDataObject(DataObject.find((FileObject)createdFile));
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        if (this.getCreatedDataObject() != null) {
            return Collections.singleton(this.getCreatedDataObject());
        }
        throw new IOException("Unable to create the report.");
    }

    public void initialize(TemplateWizard wizard) {
        this.wizard = wizard;
        this.index = 0;
        this.setCreatedDataObject(null);
        this.getPanels();
    }

    public void uninitialize(TemplateWizard wizard) {
        if (this.getCreatedDataObject() != null) {
            Runnable r = new Runnable(){

                public void run() {
                    OpenCookie cookie;
                    Logger.global.log(Level.INFO, "Opening report");
                    if (NewJrxmlWizardIterator.this.getCreatedDataObject() != null && (cookie = (OpenCookie)NewJrxmlWizardIterator.this.getCreatedDataObject().getCookie(OpenCookie.class)) != null) {
                        cookie.open();
                    }
                    Logger.global.log(Level.INFO, "Report opened...");
                }
            };
            SwingUtilities.invokeLater(r);
        }
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.getPanels()[this.index].getComponent().getName();
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        this.updateStepsList();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
        this.updateStepsList();
    }

    void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        if (component == null) {
            return;
        }
        String[] list = this.createSteps();
        component.putClientProperty("WizardPanel_contentData", list);
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.index));
        component.firePropertyChange("WizardPanel_contentSelectedIndex", new Integer(this.index - 1), new Integer(this.index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public String[] createSteps() {
        WizardDescriptor.Panel[] pans = this.getPanels();
        String[] steps = new String[pans.length];
        for (int i = 0; i < pans.length; ++i) {
            Component c = pans[i].getComponent();
            steps[i] = c.getName();
        }
        return steps;
    }
}

