/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.crosstab.widgets;

import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.ThreadUtils;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import com.jaspersoft.ireport.designer.utils.Java2DUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;

public class CellSeparatorWidget
extends SeparatorWidget
implements PropertyChangeListener {
    private final Stroke stroke = new BasicStroke(1.0f);
    private int index = 0;

    public CellSeparatorWidget(CrosstabObjectScene scene, int index, SeparatorWidget.Orientation orientation) {
        super((Scene)scene, orientation);
        this.index = index;
        if (SeparatorWidget.Orientation.HORIZONTAL.equals((Object)orientation)) {
            this.setBorder(BorderFactory.createEmptyBorder((int)0, (int)3));
            this.setCursor(Cursor.getPredefinedCursor(9));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder((int)3, (int)0));
            this.setCursor(Cursor.getPredefinedCursor(10));
        }
        this.setForeground(new Color(0, 0, 0, 0));
        this.updateBounds();
    }

    public void updateBounds() {
        if (this.getOrientation() == SeparatorWidget.Orientation.HORIZONTAL) {
            this.setPreferredLocation(new Point(0, ((CrosstabObjectScene)this.getScene()).getHorizontalSeparators().get(this.getIndex())));
            this.setPreferredBounds(new Rectangle(-10, -3, ((CrosstabObjectScene)this.getScene()).getCrosstabWidget().getCrosstabDesignWidth() + 10, 7));
        } else {
            this.setPreferredLocation(new Point(((CrosstabObjectScene)this.getScene()).getVerticalSeparators().get(this.getIndex()), 0));
            this.setPreferredBounds(new Rectangle(-3, -10, 7, ((CrosstabObjectScene)this.getScene()).getCrosstabWidget().getCrosstabDesignHeight() + 10));
        }
    }

    protected void paintWidget() {
        Graphics2D gr = this.getGraphics();
        gr.setColor(this.getForeground());
        Rectangle bounds = this.getBounds();
        Insets insets = this.getBorder().getInsets();
        gr.setStroke(Java2DUtils.getInvertedZoomedStroke(this.stroke, this.getScene().getZoomFactor()));
        if (this.getOrientation() == SeparatorWidget.Orientation.HORIZONTAL) {
            Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, bounds.width - insets.left - insets.right, 0.0);
            gr.draw(r);
        } else {
            Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 0.0, bounds.height - insets.top - insets.bottom);
            gr.draw(r);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Runnable r = null;
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("height")) {
            r = new Runnable(){

                public void run() {
                    ((ReportObjectScene)CellSeparatorWidget.this.getScene()).refreshDocument();
                }
            };
        } else if (evt.getPropertyName().equals("children")) {
            r = new Runnable(){

                public void run() {
                }
            };
        }
        if (r != null) {
            ThreadUtils.invokeInAWTThread(r);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

