/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.features.DatabaseContext;
import org.netbeans.modules.languages.features.DatabaseDefinition;
import org.netbeans.modules.languages.features.DatabaseItem;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.DatabaseUsage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorsManager {
    public static final String COLOR = "COLOR";
    private static AttributeSet unusedParameterAttributeSet;
    private static AttributeSet parameterAttributeSet;
    private static AttributeSet unusedLocalVariableAttributeSet;
    private static AttributeSet localVariableAttributeSet;
    private static AttributeSet unusedFieldAttributeSet;
    private static AttributeSet fieldAttributeSet;
    private static Map<String, Color> colors;

    static List<AttributeSet> getColors(Language language, ASTPath aSTPath, Document document) {
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        SyntaxContext syntaxContext = SyntaxContext.create(document, aSTPath);
        List<Feature> list = language.getFeatures(COLOR, aSTPath);
        for (Feature object2 : list) {
            if (!object2.getBoolean("condition", syntaxContext, true)) continue;
            arrayList.add(ColorsManager.createColoring(object2, null));
        }
        ASTNode aSTNode = (ASTNode)aSTPath.getRoot();
        DatabaseContext databaseContext = DatabaseManager.getRoot(aSTNode);
        if (databaseContext == null) {
            return arrayList;
        }
        ASTItem aSTItem = aSTPath.getLeaf();
        DatabaseItem databaseItem = databaseContext.getDatabaseItem(aSTItem.getOffset());
        if (databaseItem == null || databaseItem.getEndOffset() != aSTItem.getEndOffset()) {
            return arrayList;
        }
        AttributeSet attributeSet = ColorsManager.getAttributes(databaseItem);
        if (attributeSet != null) {
            arrayList.add(attributeSet);
        }
        return arrayList;
    }

    private static AttributeSet getAttributes(DatabaseItem databaseItem) {
        DatabaseItem databaseItem2;
        if (databaseItem instanceof DatabaseDefinition) {
            databaseItem2 = (DatabaseDefinition)databaseItem;
            if ("global_variable".equals(((DatabaseDefinition)databaseItem2).getName())) {
                System.out.println("");
            }
            if (((DatabaseDefinition)databaseItem2).getUsages().isEmpty()) {
                if ("parameter".equals(((DatabaseDefinition)databaseItem2).getType())) {
                    return ColorsManager.getUnusedParameterAttributes();
                }
                if ("variable".equals(((DatabaseDefinition)databaseItem2).getType())) {
                    return ColorsManager.getUnusedLocalVariableAttributes();
                }
                if ("field".equals(((DatabaseDefinition)databaseItem2).getType())) {
                    return ColorsManager.getUnusedFieldAttributes();
                }
            } else {
                if ("parameter".equals(((DatabaseDefinition)databaseItem2).getType())) {
                    return ColorsManager.getParameterAttributes();
                }
                if ("variable".equals(((DatabaseDefinition)databaseItem2).getType())) {
                    return ColorsManager.getLocalVariableAttributes();
                }
                if ("field".equals(((DatabaseDefinition)databaseItem2).getType())) {
                    return ColorsManager.getFieldAttributes();
                }
            }
        }
        if (databaseItem instanceof DatabaseUsage) {
            databaseItem2 = (DatabaseUsage)databaseItem;
            DatabaseDefinition databaseDefinition = ((DatabaseUsage)databaseItem2).getDefinition();
            if ("parameter".equals(databaseDefinition.getType())) {
                return ColorsManager.getParameterAttributes();
            }
            if ("local".equals(databaseDefinition.getType())) {
                return ColorsManager.getLocalVariableAttributes();
            }
            if ("field".equals(databaseDefinition.getType())) {
                return ColorsManager.getFieldAttributes();
            }
        }
        return null;
    }

    private static AttributeSet getUnusedParameterAttributes() {
        if (unusedParameterAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, new Color(115, 115, 115));
            unusedParameterAttributeSet = simpleAttributeSet;
        }
        return unusedParameterAttributeSet;
    }

    private static AttributeSet getParameterAttributes() {
        if (parameterAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, new Color(160, 96, 1));
            parameterAttributeSet = simpleAttributeSet;
        }
        return parameterAttributeSet;
    }

    private static AttributeSet getUnusedLocalVariableAttributes() {
        if (unusedLocalVariableAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, new Color(115, 115, 115));
            unusedLocalVariableAttributeSet = simpleAttributeSet;
        }
        return unusedLocalVariableAttributeSet;
    }

    private static AttributeSet getLocalVariableAttributes() {
        if (localVariableAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            localVariableAttributeSet = simpleAttributeSet;
        }
        return localVariableAttributeSet;
    }

    private static AttributeSet getUnusedFieldAttributes() {
        if (unusedFieldAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, new Color(115, 115, 115));
            StyleConstants.setBold(simpleAttributeSet, true);
            unusedFieldAttributeSet = simpleAttributeSet;
        }
        return unusedFieldAttributeSet;
    }

    private static AttributeSet getFieldAttributes() {
        if (fieldAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, new Color(9, 134, 24));
            StyleConstants.setBold(simpleAttributeSet, true);
            fieldAttributeSet = simpleAttributeSet;
        }
        return fieldAttributeSet;
    }

    public static void initColorings(Language language) {
        FontColorSettingsFactory fontColorSettingsFactory = EditorSettings.getDefault().getFontColorSettings(new String[]{language.getMimeType()});
        if (!fontColorSettingsFactory.getAllFontColors("NetBeans").isEmpty()) {
            return;
        }
        String string = ColorsManager.getBundleName(language);
        ResourceBundle resourceBundle = string != null ? NbBundle.getBundle((String)string) : null;
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        Iterator<Language> iterator = language.getImportedLanguages().iterator();
        while (iterator.hasNext()) {
            ColorsManager.addColors(hashMap, iterator.next(), resourceBundle);
        }
        ColorsManager.addColors(hashMap, language, resourceBundle);
        fontColorSettingsFactory.setAllFontColorsDefaults("NetBeans", hashMap.values());
        fontColorSettingsFactory.setAllFontColors("NetBeans", hashMap.values());
        if (string != null) {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource("Editors/" + language.getMimeType() + "/FontsColors/NetBeans/org-netbeans-modules-editor-settings-CustomFontsColors.xml");
            try {
                if (fileObject != null) {
                    fileObject.setAttribute("SystemFileSystem.localizingBundle", (Object)string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fileObject = fileSystem.findResource("Editors/" + language.getMimeType() + "/FontsColors/NetBeans/Defaults/org-netbeans-modules-editor-settings-CustomFontsColors.xml");
            try {
                if (fileObject != null) {
                    fileObject.setAttribute("SystemFileSystem.localizingBundle", (Object)string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void addColors(Map<String, AttributeSet> map, Language language, ResourceBundle resourceBundle) {
        if (language.getParser() == null) {
            return;
        }
        Map<String, AttributeSet> map2 = ColorsManager.getDefaultColors();
        List<Feature> list = language.getFeatures(COLOR);
        for (Feature object : list) {
            SimpleAttributeSet simpleAttributeSet = ColorsManager.createColoring(object, resourceBundle);
            map.put((String)simpleAttributeSet.getAttribute(StyleConstants.NameAttribute), simpleAttributeSet);
        }
        for (TokenType tokenType : language.getParser().getTokenTypes()) {
            String string = tokenType.getType();
            if (map.containsKey(string)) continue;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, string);
            String string2 = string;
            if (resourceBundle != null) {
                try {
                    string2 = resourceBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, string2);
            String string3 = string;
            int n = string3.lastIndexOf(95);
            if (n > 0) {
                string3 = string3.substring(n + 1);
            }
            if (map2.containsKey(string3)) {
                simpleAttributeSet.addAttribute(EditorStyleConstants.Default, string3);
            }
            map.put(string, simpleAttributeSet);
        }
    }

    private static List<AttributeSet> getColors(Language language, ResourceBundle resourceBundle) {
        List<Feature> list = language.getFeatures("COLORS");
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        for (Feature feature : list) {
            arrayList.add(ColorsManager.createColoring(feature, resourceBundle));
        }
        return arrayList;
    }

    static SimpleAttributeSet createColoring(Feature feature, ResourceBundle resourceBundle) {
        String string = (String)feature.getValue("color_name");
        String string2 = null;
        if (string == null) {
            string = feature.getSelector().getAsString();
        }
        if (resourceBundle != null) {
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return ColorsManager.createColoring(string, string2, (String)feature.getValue("default_coloring"), (String)feature.getValue("foreground_color"), (String)feature.getValue("background_color"), (String)feature.getValue("underline_color"), (String)feature.getValue("wave_underline_color"), (String)feature.getValue("strike_through_color"), (String)feature.getValue("font_name"), (String)feature.getValue("font_type"));
    }

    private static SimpleAttributeSet createColoring(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, string);
        simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, string2);
        if (string3 != null) {
            simpleAttributeSet.addAttribute(EditorStyleConstants.Default, string3);
        }
        if (string4 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Foreground, ColorsManager.readColor(string4));
        }
        if (string5 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Background, ColorsManager.readColor(string5));
        }
        if (string8 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.StrikeThrough, ColorsManager.readColor(string8));
        }
        if (string6 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Underline, ColorsManager.readColor(string6));
        }
        if (string7 != null) {
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, ColorsManager.readColor(string7));
        }
        if (string9 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.FontFamily, string9);
        }
        if (string10 != null) {
            if (string10.toLowerCase().indexOf("bold") >= 0) {
                simpleAttributeSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
            }
            if (string10.toLowerCase().indexOf("italic") >= 0) {
                simpleAttributeSet.addAttribute(StyleConstants.Italic, Boolean.TRUE);
            }
        }
        return simpleAttributeSet;
    }

    static Color readColor(String string) {
        if (string == null) {
            return null;
        }
        Color color = colors.get(string);
        if (color == null) {
            color = Color.decode(string);
        }
        return color;
    }

    private static void addColor(String string, SimpleAttributeSet simpleAttributeSet, Map<String, AttributeSet> map, Map<String, AttributeSet> map2) {
        String string2 = (String)(simpleAttributeSet = simpleAttributeSet == null ? new SimpleAttributeSet() : new SimpleAttributeSet(simpleAttributeSet)).getAttribute(StyleConstants.NameAttribute);
        if (string2 == null) {
            string2 = string;
        }
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, string2);
        simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, string2);
        if (!simpleAttributeSet.isDefined(EditorStyleConstants.Default)) {
            String string3 = string2;
            int n = string3.lastIndexOf(95);
            if (n > 0) {
                string3 = string3.substring(n + 1);
            }
            if (map2.containsKey(string3)) {
                simpleAttributeSet.addAttribute(EditorStyleConstants.Default, string3);
            }
        }
        map.put(string2, simpleAttributeSet);
    }

    private static Map<String, AttributeSet> getDefaultColors() {
        Collection collection = EditorSettings.getDefault().getDefaultFontColorDefaults("NetBeans");
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        for (AttributeSet attributeSet : collection) {
            hashMap.put((String)attributeSet.getAttribute(StyleConstants.NameAttribute), attributeSet);
        }
        return hashMap;
    }

    private static Map getCurrentColors(Language language) {
        FontColorSettingsFactory fontColorSettingsFactory = EditorSettings.getDefault().getFontColorSettings(new String[]{language.getMimeType()});
        Collection collection = fontColorSettingsFactory.getAllFontColors("NetBeans");
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        for (AttributeSet attributeSet : collection) {
            hashMap.put((String)attributeSet.getAttribute(StyleConstants.NameAttribute), attributeSet);
        }
        return hashMap;
    }

    private static String getBundleName(Language language) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Editors/" + language.getMimeType());
        Object object = fileObject.getAttribute("SystemFileSystem.localizingBundle");
        return (String)object;
    }

    static {
        colors = new HashMap<String, Color>();
        colors.put("black", Color.black);
        colors.put("blue", Color.blue);
        colors.put("cyan", Color.cyan);
        colors.put("darkGray", Color.darkGray);
        colors.put("gray", Color.gray);
        colors.put("green", Color.green);
        colors.put("lightGray", Color.lightGray);
        colors.put("magenta", Color.magenta);
        colors.put("orange", Color.orange);
        colors.put("pink", Color.pink);
        colors.put("red", Color.red);
        colors.put("white", Color.white);
        colors.put("yellow", Color.yellow);
    }
}

