/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultFontProvider;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class JRBaseFont
implements JRFont,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_BOLD = "bold";
    public static final String PROPERTY_FONT_NAME = "fontName";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_ITALIC = "italic";
    public static final String PROPERTY_PDF_EMBEDDED = "pdfEmbedded";
    public static final String PROPERTY_PDF_ENCODING = "pdfEncoding";
    public static final String PROPERTY_PDF_FONT_NAME = "pdfFontName";
    public static final String PROPERTY_REPORT_FONT = "reportFont";
    public static final String PROPERTY_STRIKE_THROUGH = "strikeThrough";
    public static final String PROPERTY_UNDERLINE = "underline";
    protected JRDefaultFontProvider defaultFontProvider = null;
    protected JRReportFont reportFont = null;
    protected JRStyleContainer styleContainer = null;
    protected String fontName = null;
    protected Boolean isBold = null;
    protected Boolean isItalic = null;
    protected Boolean isUnderline = null;
    protected Boolean isStrikeThrough = null;
    protected Integer fontSize = null;
    protected String pdfFontName = null;
    protected String pdfEncoding = null;
    protected Boolean isPdfEmbedded = null;
    private transient JRPropertyChangeSupport eventSupport;

    public JRBaseFont() {
    }

    public JRBaseFont(Map attributes) {
        Boolean isPdfEmbeddedAttr;
        String pdfEncodingAttr;
        String pdfFontNameAttr;
        Object strikeThrough;
        Object underline;
        Float sizeAttr;
        Object italic;
        Object bold;
        String fontNameAttr = (String)attributes.get(TextAttribute.FAMILY);
        if (fontNameAttr != null) {
            this.setFontName(fontNameAttr);
        }
        if ((bold = attributes.get(TextAttribute.WEIGHT)) != null) {
            this.setBold(TextAttribute.WEIGHT_BOLD.equals(bold));
        }
        if ((italic = attributes.get(TextAttribute.POSTURE)) != null) {
            this.setItalic(TextAttribute.POSTURE_OBLIQUE.equals(italic));
        }
        if ((sizeAttr = (Float)attributes.get(TextAttribute.SIZE)) != null) {
            this.setFontSize(sizeAttr.intValue());
        }
        if ((underline = attributes.get(TextAttribute.UNDERLINE)) != null) {
            this.setUnderline(TextAttribute.UNDERLINE_ON.equals(underline));
        }
        if ((strikeThrough = attributes.get(TextAttribute.STRIKETHROUGH)) != null) {
            this.setStrikeThrough(TextAttribute.STRIKETHROUGH_ON.equals(strikeThrough));
        }
        if ((pdfFontNameAttr = (String)attributes.get(JRTextAttribute.PDF_FONT_NAME)) != null) {
            this.setPdfFontName(pdfFontNameAttr);
        }
        if ((pdfEncodingAttr = (String)attributes.get(JRTextAttribute.PDF_ENCODING)) != null) {
            this.setPdfEncoding(pdfEncodingAttr);
        }
        if ((isPdfEmbeddedAttr = (Boolean)attributes.get(JRTextAttribute.IS_PDF_EMBEDDED)) != null) {
            this.setPdfEmbedded(isPdfEmbeddedAttr);
        }
    }

    protected JRBaseFont(JRDefaultFontProvider defaultFontProvider) {
        this.defaultFontProvider = defaultFontProvider;
    }

    public JRBaseFont(JRDefaultFontProvider defaultFontProvider, JRReportFont reportFont, JRFont font) {
        this(defaultFontProvider, reportFont, null, font);
    }

    public JRBaseFont(JRStyleContainer styleContainer, JRFont font) {
        this(null, null, styleContainer, font);
    }

    public JRBaseFont(JRDefaultFontProvider defaultFontProvider, JRReportFont reportFont, JRStyleContainer styleContainer, JRFont font) {
        this.defaultFontProvider = defaultFontProvider;
        this.reportFont = reportFont;
        this.styleContainer = styleContainer;
        if (font != null) {
            this.fontName = font.getOwnFontName();
            this.isBold = font.isOwnBold();
            this.isItalic = font.isOwnItalic();
            this.isUnderline = font.isOwnUnderline();
            this.isStrikeThrough = font.isOwnStrikeThrough();
            this.fontSize = font.getOwnFontSize();
            this.pdfFontName = font.getOwnPdfFontName();
            this.pdfEncoding = font.getOwnPdfEncoding();
            this.isPdfEmbedded = font.isOwnPdfEmbedded();
        }
    }

    public JRDefaultFontProvider getDefaultFontProvider() {
        return this.defaultFontProvider;
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.styleContainer == null ? null : this.styleContainer.getDefaultStyleProvider();
    }

    public JRStyle getStyle() {
        return this.styleContainer == null ? null : this.styleContainer.getStyle();
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont reportFont) {
        JRReportFont old = this.reportFont;
        this.reportFont = reportFont;
        this.getEventSupport().firePropertyChange(PROPERTY_REPORT_FONT, old, this.reportFont);
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        String old = this.fontName;
        this.fontName = fontName;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_NAME, old, this.fontName);
    }

    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBold(Boolean isBold) {
        Boolean old = this.isBold;
        this.isBold = isBold;
        this.getEventSupport().firePropertyChange(PROPERTY_BOLD, old, this.isBold);
    }

    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setItalic(Boolean isItalic) {
        Boolean old = this.isItalic;
        this.isItalic = isItalic;
        this.getEventSupport().firePropertyChange(PROPERTY_ITALIC, old, this.isItalic);
    }

    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUnderline(Boolean isUnderline) {
        Boolean old = this.isUnderline;
        this.isUnderline = isUnderline;
        this.getEventSupport().firePropertyChange(PROPERTY_UNDERLINE, old, this.isUnderline);
    }

    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStrikeThrough(Boolean isStrikeThrough) {
        Boolean old = this.isStrikeThrough;
        this.isStrikeThrough = isStrikeThrough;
        this.getEventSupport().firePropertyChange(PROPERTY_STRIKE_THROUGH, old, this.isStrikeThrough);
    }

    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.setFontSize(new Integer(fontSize));
    }

    public void setFontSize(Integer fontSize) {
        Integer old = this.fontSize;
        this.fontSize = fontSize;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_SIZE, old, this.fontSize);
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int size) {
        this.setFontSize(size);
    }

    public void setSize(Integer size) {
        this.setFontSize(size);
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    public void setPdfFontName(String pdfFontName) {
        String old = this.pdfFontName;
        this.pdfFontName = pdfFontName;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_FONT_NAME, old, this.pdfFontName);
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String pdfEncoding) {
        String old = this.pdfEncoding;
        this.pdfEncoding = pdfEncoding;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_ENCODING, old, this.pdfEncoding);
    }

    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        Boolean old = this.isPdfEmbedded;
        this.isPdfEmbedded = isPdfEmbedded;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_EMBEDDED, old, this.isPdfEmbedded);
    }

    public String getStyleNameReference() {
        return this.styleContainer == null ? null : this.styleContainer.getStyleNameReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseFont jRBaseFont = this;
        synchronized (jRBaseFont) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

