/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.url;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.url.URLPresenter;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class URLDataObject
extends MultiDataObject
implements OpenCookie,
InstanceCookie {
    static final String PROP_URL = "url";
    static final long serialVersionUID = 6829522922370124627L;

    public URLDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.getCookieSet().add((Node.Cookie)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getURLString() {
        FileObject fileObject = this.getPrimaryFile();
        if (!fileObject.isValid()) {
            return null;
        }
        String string = null;
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
            string = new BufferedReader(new InputStreamReader(inputStream)).readLine();
        }
        catch (FileNotFoundException fileNotFoundException) {
            ErrorManager.getDefault().notify(16, (Throwable)fileNotFoundException);
            String string2 = null;
            return string2;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
            String string3 = null;
            return string3;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setURLString(String string) {
        FileObject fileObject = this.getPrimaryFile();
        if (!fileObject.isValid()) {
            return;
        }
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            outputStream.write(string.getBytes());
            outputStream.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(URLDataObject.class);
    }

    public void open() {
        String string = this.getURLString();
        if (string == null) {
            return;
        }
        URL uRL = URLDataObject.getURLFromString(string);
        if (uRL == null) {
            return;
        }
        HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
    }

    private static URL getURLFromString(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL("http://" + string);
            }
            catch (MalformedURLException malformedURLException2) {
                String string2 = string.length() > 50 ? NbBundle.getMessage(URLDataObject.class, (String)"MSG_MalformedURLError") : NbBundle.getMessage(URLDataObject.class, (String)"MSG_FMT_MalformedURLError", (Object)string);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
                return null;
            }
        }
    }

    public String instanceName() {
        return this.getName();
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return URLPresenter.class;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        return new URLPresenter(this);
    }
}

