/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.actions.PaddingAndBordersAction;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.nodes.ElementContainerChildren;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementPasteType;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.outline.nodes.properties.CrosstabCellPropertiesFactory;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.PasteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class CellNode
extends IRIndexedNode
implements PropertyChangeListener {
    private final JasperDesign jd;
    private final JRDesignCellContents cellContents;
    private final JRDesignCrosstab crosstab;

    public CellNode(JasperDesign jd, JRDesignCrosstab crosstab, JRDesignCellContents cellContents, Lookup doLkp) {
        this(new ElementContainerChildren(jd, (JRDesignElementGroup)cellContents, doLkp), jd, crosstab, cellContents, doLkp);
    }

    public CellNode(ElementContainerChildren pc, JasperDesign jd, JRDesignCrosstab crosstab, JRDesignCellContents cellContents, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{jd, crosstab, cellContents}), doLkp}));
        this.jd = jd;
        this.crosstab = crosstab;
        this.cellContents = cellContents;
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/cell-16.png");
        this.cellContents.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.setDisplayName(ModelUtils.nameOf(cellContents));
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                int i;
                List elements = CellNode.this.getCellContents().getChildren();
                int[] permutations = ev.getPermutation();
                Object[] elementsArray = new Object[elements.size()];
                for (i = 0; i < elementsArray.length; ++i) {
                    elementsArray[permutations[i]] = elements.get(i);
                }
                elements.clear();
                for (i = 0; i < elementsArray.length; ++i) {
                    elements.add(elementsArray[i]);
                }
                CellNode.this.getCellContents().getEventSupport().firePropertyChange("children", null, (Object)CellNode.this.getCellContents().getChildren());
            }
        });
    }

    public String getDisplayName() {
        if (this.getCellContents() == null) {
            return super.getDisplayName();
        }
        return ModelUtils.nameOf(this.cellContents);
    }

    public String getHtmlDisplayName() {
        return this.getDisplayName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        List<Sheet.Set> cellPropertiesSets = CrosstabCellPropertiesFactory.getCrosstabCellPropertySets(this.cellContents, this.jd);
        for (Sheet.Set s : cellPropertiesSets) {
            sheet.put(s);
        }
        return sheet;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (ModelUtils.containsProperty(this.getPropertySets(), evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("name") || evt.getPropertyName().equals("columnTotalGroup") || evt.getPropertyName().equals("rowTotalGroup")) {
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
        if (evt.getPropertyName().equals("children")) {
            ((ElementContainerChildren)this.getChildren()).recalculateKeys();
        }
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean popup) {
        ArrayList<SystemAction> list = new ArrayList<SystemAction>();
        list.add(SystemAction.get(PaddingAndBordersAction.class));
        list.add(SystemAction.get(PasteAction.class));
        return list.toArray(new Action[list.size()]);
    }

    public JRDesignCellContents getCellContents() {
        return this.cellContents;
    }

    public JRDesignCrosstab getCrosstab() {
        return this.crosstab;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction(t);
        if (null != dropNode) {
            JRDesignElement element = (JRDesignElement)dropNode.getLookup().lookup(JRDesignElement.class);
            if (element instanceof JRCrosstab) {
                return null;
            }
            if (null != element) {
                return new ElementPasteType(element.getElementGroup(), (JRElementGroup)this.getCellContents(), element, dropAction, (Node)this);
            }
            if (dropNode instanceof ElementGroupNode) {
                JRDesignElementGroup g = ((ElementGroupNode)dropNode).getElementGroup();
                return new ElementPasteType(g.getElementGroup(), (JRElementGroup)this.getCellContents(), g, dropAction, (Node)this);
            }
        }
        return null;
    }
}

