/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import junit.framework.Assert;
import mondrian.calc.ResultStyle;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.Evaluator;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.spi.Dialect;
import mondrian.spi.UserDefinedFunction;
import mondrian.test.ChooseRunnable;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestCaseForker;
import mondrian.test.TestContext;
import mondrian.util.Bug;

public class BasicQueryTest
extends FoodMartTestCase {
    static final String EmptyResult = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\nAxis #2:\n");
    private MondrianProperties props = MondrianProperties.instance();
    private static final FoodMartTestCase.QueryAndResult[] sampleQueries = new FoodMartTestCase.QueryAndResult[]{new FoodMartTestCase.QueryAndResult("select {[Measures].[Unit Sales]} on columns\n from Sales", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nRow #0: 266,773\n"), new FoodMartTestCase.QueryAndResult("select\n    {[Measures].[Unit Sales]} on columns,\n    order(except([Promotion Media].[Media Type].members,{[Promotion Media].[Media Type].[No Media]}),[Measures].[Unit Sales],DESC) on rows\nfrom Sales ", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Promotion Media].[All Media].[Daily Paper, Radio, TV]}\n{[Promotion Media].[All Media].[Daily Paper]}\n{[Promotion Media].[All Media].[Product Attachment]}\n{[Promotion Media].[All Media].[Daily Paper, Radio]}\n{[Promotion Media].[All Media].[Cash Register Handout]}\n{[Promotion Media].[All Media].[Sunday Paper, Radio]}\n{[Promotion Media].[All Media].[Street Handout]}\n{[Promotion Media].[All Media].[Sunday Paper]}\n{[Promotion Media].[All Media].[Bulk Mail]}\n{[Promotion Media].[All Media].[In-Store Coupon]}\n{[Promotion Media].[All Media].[TV]}\n{[Promotion Media].[All Media].[Sunday Paper, Radio, TV]}\n{[Promotion Media].[All Media].[Radio]}\nRow #0: 9,513\nRow #1: 7,738\nRow #2: 7,544\nRow #3: 6,891\nRow #4: 6,697\nRow #5: 5,945\nRow #6: 5,753\nRow #7: 4,339\nRow #8: 4,320\nRow #9: 3,798\nRow #10: 3,607\nRow #11: 2,726\nRow #12: 2,454\n"), new FoodMartTestCase.QueryAndResult("select\n    { [Measures].[Units Shipped], [Measures].[Units Ordered] } on columns,\n    NON EMPTY [Store].[Store Name].members on rows\nfrom Warehouse", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Units Shipped]}\n{[Measures].[Units Ordered]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nRow #0: 10759.0\nRow #0: 11699.0\nRow #1: 24587.0\nRow #1: 26463.0\nRow #2: 23835.0\nRow #2: 26270.0\nRow #3: 1696.0\nRow #3: 1875.0\nRow #4: 8515.0\nRow #4: 9109.0\nRow #5: 32393.0\nRow #5: 35797.0\nRow #6: 2348.0\nRow #6: 2454.0\nRow #7: 22734.0\nRow #7: 24610.0\nRow #8: 24110.0\nRow #8: 26703.0\nRow #9: 11889.0\nRow #9: 12828.0\nRow #10: 32411.0\nRow #10: 35930.0\nRow #11: 1860.0\nRow #11: 2074.0\nRow #12: 10589.0\nRow #12: 11426.0\n"), new FoodMartTestCase.QueryAndResult("with member [Measures].[Store Sales Last Period] as     '([Measures].[Store Sales], Time.PrevMember)',\n    format='#,###.00'\nselect\n    {[Measures].[Store Sales Last Period]} on columns,\n    {TopCount([Product].[Product Department].members,5, [Measures].[Store Sales Last Period])} on rows\nfrom Sales\nwhere ([Time].[1998])", "Axis #0:\n{[Time].[1998]}\nAxis #1:\n{[Measures].[Store Sales Last Period]}\nAxis #2:\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Snack Foods]}\n{[Product].[All Products].[Non-Consumable].[Household]}\n{[Product].[All Products].[Food].[Frozen Foods]}\n{[Product].[All Products].[Food].[Canned Foods]}\nRow #0: 82,248.42\nRow #1: 67,609.82\nRow #2: 60,469.89\nRow #3: 55,207.50\nRow #4: 39,774.34\n"), new FoodMartTestCase.QueryAndResult("with member [Measures].[Total Store Sales] as 'Sum(YTD(),[Measures].[Store Sales])', format_string='#.00'\nselect\n    {[Measures].[Total Store Sales]} on columns,\n    {TopCount([Product].[Product Department].members,5, [Measures].[Total Store Sales])} on rows\nfrom Sales\nwhere ([Time].[1997].[Q2].[4])", "Axis #0:\n{[Time].[1997].[Q2].[4]}\nAxis #1:\n{[Measures].[Total Store Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Snack Foods]}\n{[Product].[All Products].[Non-Consumable].[Household]}\n{[Product].[All Products].[Food].[Frozen Foods]}\n{[Product].[All Products].[Food].[Canned Foods]}\nRow #0: 26526.67\nRow #1: 21897.10\nRow #2: 19980.90\nRow #3: 17882.63\nRow #4: 12963.23\n"), new FoodMartTestCase.QueryAndResult("with member [Measures].[Store Profit Rate] as '([Measures].[Store Sales]-[Measures].[Store Cost])/[Measures].[Store Cost]', format = '#.00%'\nselect\n    {[Measures].[Store Cost],[Measures].[Store Sales],[Measures].[Store Profit Rate]} on columns,\n    Order([Product].[Product Department].members, [Measures].[Store Profit Rate], BDESC) on rows\nfrom Sales\nwhere ([Time].[1997])", "Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\n{[Measures].[Store Profit Rate]}\nAxis #2:\n{[Product].[All Products].[Food].[Breakfast Foods]}\n{[Product].[All Products].[Non-Consumable].[Carousel]}\n{[Product].[All Products].[Food].[Canned Products]}\n{[Product].[All Products].[Food].[Baking Goods]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Product].[All Products].[Non-Consumable].[Health and Hygiene]}\n{[Product].[All Products].[Food].[Snack Foods]}\n{[Product].[All Products].[Food].[Baked Goods]}\n{[Product].[All Products].[Drink].[Beverages]}\n{[Product].[All Products].[Food].[Frozen Foods]}\n{[Product].[All Products].[Non-Consumable].[Periodicals]}\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Seafood]}\n{[Product].[All Products].[Food].[Deli]}\n{[Product].[All Products].[Food].[Meat]}\n{[Product].[All Products].[Food].[Canned Foods]}\n{[Product].[All Products].[Non-Consumable].[Household]}\n{[Product].[All Products].[Food].[Starchy Foods]}\n{[Product].[All Products].[Food].[Eggs]}\n{[Product].[All Products].[Food].[Snacks]}\n{[Product].[All Products].[Food].[Dairy]}\n{[Product].[All Products].[Drink].[Dairy]}\n{[Product].[All Products].[Non-Consumable].[Checkout]}\nRow #0: 2,756.80\nRow #0: 6,941.46\nRow #0: 151.79%\nRow #1: 595.97\nRow #1: 1,500.11\nRow #1: 151.71%\nRow #2: 1,317.13\nRow #2: 3,314.52\nRow #2: 151.65%\nRow #3: 15,370.61\nRow #3: 38,670.41\nRow #3: 151.59%\nRow #4: 5,576.79\nRow #4: 14,029.08\nRow #4: 151.56%\nRow #5: 12,972.99\nRow #5: 32,571.86\nRow #5: 151.07%\nRow #6: 26,963.34\nRow #6: 67,609.82\nRow #6: 150.75%\nRow #7: 6,564.09\nRow #7: 16,455.43\nRow #7: 150.69%\nRow #8: 11,069.53\nRow #8: 27,748.53\nRow #8: 150.67%\nRow #9: 22,030.66\nRow #9: 55,207.50\nRow #9: 150.59%\nRow #10: 3,614.55\nRow #10: 9,056.76\nRow #10: 150.56%\nRow #11: 32,831.33\nRow #11: 82,248.42\nRow #11: 150.52%\nRow #12: 1,520.70\nRow #12: 3,809.14\nRow #12: 150.49%\nRow #13: 10,108.87\nRow #13: 25,318.93\nRow #13: 150.46%\nRow #14: 1,465.42\nRow #14: 3,669.89\nRow #14: 150.43%\nRow #15: 15,894.53\nRow #15: 39,774.34\nRow #15: 150.24%\nRow #16: 24,170.73\nRow #16: 60,469.89\nRow #16: 150.18%\nRow #17: 4,705.91\nRow #17: 11,756.07\nRow #17: 149.82%\nRow #18: 3,684.90\nRow #18: 9,200.76\nRow #18: 149.69%\nRow #19: 5,827.58\nRow #19: 14,550.05\nRow #19: 149.68%\nRow #20: 12,228.85\nRow #20: 30,508.85\nRow #20: 149.48%\nRow #21: 2,830.92\nRow #21: 7,058.60\nRow #21: 149.34%\nRow #22: 1,525.04\nRow #22: 3,767.71\nRow #22: 147.06%\n"), new FoodMartTestCase.QueryAndResult("with\n   member [Product].[All Products].[Drink].[Percent of Alcoholic Drinks] as '[Product].[All Products].[Drink].[Alcoholic Beverages]/[Product].[All Products].[Drink]',\n       format_string = '#.00%'\nselect\n   { [Product].[All Products].[Drink].[Percent of Alcoholic Drinks] } on columns,\n   order([Customers].[All Customers].[USA].[WA].Children, [Product].[All Products].[Drink].[Percent of Alcoholic Drinks],BDESC) on rows\nfrom Sales\nwhere ([Measures].[Unit Sales])", "Axis #0:\n{[Measures].[Unit Sales]}\nAxis #1:\n{[Product].[All Products].[Drink].[Percent of Alcoholic Drinks]}\nAxis #2:\n{[Customers].[All Customers].[USA].[WA].[Seattle]}\n{[Customers].[All Customers].[USA].[WA].[Kirkland]}\n{[Customers].[All Customers].[USA].[WA].[Marysville]}\n{[Customers].[All Customers].[USA].[WA].[Anacortes]}\n{[Customers].[All Customers].[USA].[WA].[Olympia]}\n{[Customers].[All Customers].[USA].[WA].[Ballard]}\n{[Customers].[All Customers].[USA].[WA].[Bremerton]}\n{[Customers].[All Customers].[USA].[WA].[Puyallup]}\n{[Customers].[All Customers].[USA].[WA].[Yakima]}\n{[Customers].[All Customers].[USA].[WA].[Tacoma]}\n{[Customers].[All Customers].[USA].[WA].[Everett]}\n{[Customers].[All Customers].[USA].[WA].[Renton]}\n{[Customers].[All Customers].[USA].[WA].[Issaquah]}\n{[Customers].[All Customers].[USA].[WA].[Bellingham]}\n{[Customers].[All Customers].[USA].[WA].[Port Orchard]}\n{[Customers].[All Customers].[USA].[WA].[Redmond]}\n{[Customers].[All Customers].[USA].[WA].[Spokane]}\n{[Customers].[All Customers].[USA].[WA].[Burien]}\n{[Customers].[All Customers].[USA].[WA].[Lynnwood]}\n{[Customers].[All Customers].[USA].[WA].[Walla Walla]}\n{[Customers].[All Customers].[USA].[WA].[Edmonds]}\n{[Customers].[All Customers].[USA].[WA].[Sedro Woolley]}\nRow #0: 44.05%\nRow #1: 34.41%\nRow #2: 34.20%\nRow #3: 32.93%\nRow #4: 31.05%\nRow #5: 30.84%\nRow #6: 30.69%\nRow #7: 29.81%\nRow #8: 28.82%\nRow #9: 28.70%\nRow #10: 28.37%\nRow #11: 26.67%\nRow #12: 26.60%\nRow #13: 26.47%\nRow #14: 26.42%\nRow #15: 26.28%\nRow #16: 25.96%\nRow #17: 24.70%\nRow #18: 21.89%\nRow #19: 21.47%\nRow #20: 17.47%\nRow #21: 13.79%\n"), new FoodMartTestCase.QueryAndResult("with member [Measures].[Accumulated Sales] as 'Sum(YTD(),[Measures].[Store Sales])'\nselect\n    {[Measures].[Store Sales],[Measures].[Accumulated Sales]} on columns,\n    {Descendants([Time].[1997],[Time].[Month])} on rows\nfrom Sales", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\n{[Measures].[Accumulated Sales]}\nAxis #2:\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[5]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3].[8]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4].[11]}\n{[Time].[1997].[Q4].[12]}\nRow #0: 45,539.69\nRow #0: 45,539.69\nRow #1: 44,058.79\nRow #1: 89,598.48\nRow #2: 50,029.87\nRow #2: 139,628.35\nRow #3: 42,878.25\nRow #3: 182,506.60\nRow #4: 44,456.29\nRow #4: 226,962.89\nRow #5: 45,331.73\nRow #5: 272,294.62\nRow #6: 50,246.88\nRow #6: 322,541.50\nRow #7: 46,199.04\nRow #7: 368,740.54\nRow #8: 43,825.97\nRow #8: 412,566.51\nRow #9: 42,342.27\nRow #9: 454,908.78\nRow #10: 53,363.71\nRow #10: 508,272.49\nRow #11: 56,965.64\nRow #11: 565,238.13\n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Promotion Sales]} on columns\n from Sales", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Promotion Sales]}\nRow #0: 151,211.21\n")};
    private static final List<FoodMartTestCase.QueryAndResult> taglibQueries = Arrays.asList(new FoodMartTestCase.QueryAndResult("select\n  {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} on columns,\n  CrossJoin(\n    { [Promotion Media].[All Media].[Radio],\n      [Promotion Media].[All Media].[TV],\n      [Promotion Media].[All Media].[Sunday Paper],\n      [Promotion Media].[All Media].[Street Handout] },\n    [Product].[All Products].[Drink].children) on rows\nfrom Sales\nwhere ([Time].[1997])", "Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Promotion Media].[All Media].[Radio], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Promotion Media].[All Media].[Radio], [Product].[All Products].[Drink].[Beverages]}\n{[Promotion Media].[All Media].[Radio], [Product].[All Products].[Drink].[Dairy]}\n{[Promotion Media].[All Media].[TV], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Promotion Media].[All Media].[TV], [Product].[All Products].[Drink].[Beverages]}\n{[Promotion Media].[All Media].[TV], [Product].[All Products].[Drink].[Dairy]}\n{[Promotion Media].[All Media].[Sunday Paper], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Promotion Media].[All Media].[Sunday Paper], [Product].[All Products].[Drink].[Beverages]}\n{[Promotion Media].[All Media].[Sunday Paper], [Product].[All Products].[Drink].[Dairy]}\n{[Promotion Media].[All Media].[Street Handout], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Promotion Media].[All Media].[Street Handout], [Product].[All Products].[Drink].[Beverages]}\n{[Promotion Media].[All Media].[Street Handout], [Product].[All Products].[Drink].[Dairy]}\nRow #0: 75\nRow #0: 70.40\nRow #0: 168.62\nRow #1: 97\nRow #1: 75.70\nRow #1: 186.03\nRow #2: 54\nRow #2: 36.75\nRow #2: 89.03\nRow #3: 76\nRow #3: 70.99\nRow #3: 182.38\nRow #4: 188\nRow #4: 167.00\nRow #4: 419.14\nRow #5: 68\nRow #5: 45.19\nRow #5: 119.55\nRow #6: 148\nRow #6: 128.97\nRow #6: 316.88\nRow #7: 197\nRow #7: 161.81\nRow #7: 399.58\nRow #8: 85\nRow #8: 54.75\nRow #8: 140.27\nRow #9: 158\nRow #9: 121.14\nRow #9: 294.55\nRow #10: 270\nRow #10: 201.28\nRow #10: 520.55\nRow #11: 84\nRow #11: 50.26\nRow #11: 128.32\n"), new FoodMartTestCase.QueryAndResult("select\n  [Product].[All Products].[Drink].children on rows,\n  CrossJoin(\n    {[Measures].[Unit Sales], [Measures].[Store Sales]},\n    { [Promotion Media].[All Media].[Radio],\n      [Promotion Media].[All Media].[TV],\n      [Promotion Media].[All Media].[Sunday Paper],\n      [Promotion Media].[All Media].[Street Handout] }\n   ) on columns\nfrom Sales\nwhere ([Time].[1997])", "Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales], [Promotion Media].[All Media].[Radio]}\n{[Measures].[Unit Sales], [Promotion Media].[All Media].[TV]}\n{[Measures].[Unit Sales], [Promotion Media].[All Media].[Sunday Paper]}\n{[Measures].[Unit Sales], [Promotion Media].[All Media].[Street Handout]}\n{[Measures].[Store Sales], [Promotion Media].[All Media].[Radio]}\n{[Measures].[Store Sales], [Promotion Media].[All Media].[TV]}\n{[Measures].[Store Sales], [Promotion Media].[All Media].[Sunday Paper]}\n{[Measures].[Store Sales], [Promotion Media].[All Media].[Street Handout]}\nAxis #2:\n{[Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Product].[All Products].[Drink].[Beverages]}\n{[Product].[All Products].[Drink].[Dairy]}\nRow #0: 75\nRow #0: 76\nRow #0: 148\nRow #0: 158\nRow #0: 168.62\nRow #0: 182.38\nRow #0: 316.88\nRow #0: 294.55\nRow #1: 97\nRow #1: 188\nRow #1: 197\nRow #1: 270\nRow #1: 186.03\nRow #1: 419.14\nRow #1: 399.58\nRow #1: 520.55\nRow #2: 54\nRow #2: 68\nRow #2: 85\nRow #2: 84\nRow #2: 89.03\nRow #2: 119.55\nRow #2: 140.27\nRow #2: 128.32\n"), new FoodMartTestCase.QueryAndResult("select\n  {[Measures].[Unit Sales], [Measures].[Store Sales]} on columns,\n  Order([Product].[Product Department].members, [Measures].[Store Sales], DESC) on rows\nfrom Sales", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Snack Foods]}\n{[Product].[All Products].[Food].[Frozen Foods]}\n{[Product].[All Products].[Food].[Canned Foods]}\n{[Product].[All Products].[Food].[Baking Goods]}\n{[Product].[All Products].[Food].[Dairy]}\n{[Product].[All Products].[Food].[Deli]}\n{[Product].[All Products].[Food].[Baked Goods]}\n{[Product].[All Products].[Food].[Snacks]}\n{[Product].[All Products].[Food].[Starchy Foods]}\n{[Product].[All Products].[Food].[Eggs]}\n{[Product].[All Products].[Food].[Breakfast Foods]}\n{[Product].[All Products].[Food].[Seafood]}\n{[Product].[All Products].[Food].[Meat]}\n{[Product].[All Products].[Food].[Canned Products]}\n{[Product].[All Products].[Non-Consumable].[Household]}\n{[Product].[All Products].[Non-Consumable].[Health and Hygiene]}\n{[Product].[All Products].[Non-Consumable].[Periodicals]}\n{[Product].[All Products].[Non-Consumable].[Checkout]}\n{[Product].[All Products].[Non-Consumable].[Carousel]}\n{[Product].[All Products].[Drink].[Beverages]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Product].[All Products].[Drink].[Dairy]}\nRow #0: 37,792\nRow #0: 82,248.42\nRow #1: 30,545\nRow #1: 67,609.82\nRow #2: 26,655\nRow #2: 55,207.50\nRow #3: 19,026\nRow #3: 39,774.34\nRow #4: 20,245\nRow #4: 38,670.41\nRow #5: 12,885\nRow #5: 30,508.85\nRow #6: 12,037\nRow #6: 25,318.93\nRow #7: 7,870\nRow #7: 16,455.43\nRow #8: 6,884\nRow #8: 14,550.05\nRow #9: 5,262\nRow #9: 11,756.07\nRow #10: 4,132\nRow #10: 9,200.76\nRow #11: 3,317\nRow #11: 6,941.46\nRow #12: 1,764\nRow #12: 3,809.14\nRow #13: 1,714\nRow #13: 3,669.89\nRow #14: 1,812\nRow #14: 3,314.52\nRow #15: 27,038\nRow #15: 60,469.89\nRow #16: 16,284\nRow #16: 32,571.86\nRow #17: 4,294\nRow #17: 9,056.76\nRow #18: 1,779\nRow #18: 3,767.71\nRow #19: 841\nRow #19: 1,500.11\nRow #20: 13,573\nRow #20: 27,748.53\nRow #21: 6,838\nRow #21: 14,029.08\nRow #22: 4,186\nRow #22: 7,058.60\n"), new FoodMartTestCase.QueryAndResult("select\n  [Product].[All Products].[Drink].children on columns\nfrom Sales\nwhere ([Measures].[Unit Sales], [Promotion Media].[All Media].[Street Handout], [Time].[1997])", "Axis #0:\n{[Measures].[Unit Sales], [Promotion Media].[All Media].[Street Handout], [Time].[1997]}\nAxis #1:\n{[Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Product].[All Products].[Drink].[Beverages]}\n{[Product].[All Products].[Drink].[Dairy]}\nRow #0: 158\nRow #0: 270\nRow #0: 84\n"), new FoodMartTestCase.QueryAndResult("select\n  NON EMPTY CrossJoin([Product].[All Products].[Drink].children, [Customers].[All Customers].[USA].[WA].Children) on rows,\n  CrossJoin(\n    {[Measures].[Unit Sales], [Measures].[Store Sales]},\n    { [Promotion Media].[All Media].[Radio],\n      [Promotion Media].[All Media].[TV],\n      [Promotion Media].[All Media].[Sunday Paper],\n      [Promotion Media].[All Media].[Street Handout] }\n   ) on columns\nfrom Sales\nwhere ([Time].[1997])", "Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales], [Promotion Media].[All Media].[Radio]}\n{[Measures].[Unit Sales], [Promotion Media].[All Media].[TV]}\n{[Measures].[Unit Sales], [Promotion Media].[All Media].[Sunday Paper]}\n{[Measures].[Unit Sales], [Promotion Media].[All Media].[Street Handout]}\n{[Measures].[Store Sales], [Promotion Media].[All Media].[Radio]}\n{[Measures].[Store Sales], [Promotion Media].[All Media].[TV]}\n{[Measures].[Store Sales], [Promotion Media].[All Media].[Sunday Paper]}\n{[Measures].[Store Sales], [Promotion Media].[All Media].[Street Handout]}\nAxis #2:\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Anacortes]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Ballard]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Bellingham]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Bremerton]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Burien]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Everett]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Issaquah]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Kirkland]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Lynnwood]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Marysville]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Olympia]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Port Orchard]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Puyallup]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Redmond]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Renton]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Seattle]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Spokane]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Tacoma]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Customers].[All Customers].[USA].[WA].[Yakima]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Anacortes]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Ballard]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Bremerton]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Burien]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Edmonds]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Everett]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Issaquah]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Kirkland]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Lynnwood]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Marysville]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Olympia]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Port Orchard]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Puyallup]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Redmond]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Seattle]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Sedro Woolley]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Spokane]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Tacoma]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Walla Walla]}\n{[Product].[All Products].[Drink].[Beverages], [Customers].[All Customers].[USA].[WA].[Yakima]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Ballard]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Bellingham]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Bremerton]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Burien]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Everett]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Issaquah]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Kirkland]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Lynnwood]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Marysville]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Olympia]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Port Orchard]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Puyallup]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Redmond]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Renton]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Seattle]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Spokane]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Tacoma]}\n{[Product].[All Products].[Drink].[Dairy], [Customers].[All Customers].[USA].[WA].[Yakima]}\nRow #0: \nRow #0: 2\nRow #0: \nRow #0: \nRow #0: \nRow #0: 1.14\nRow #0: \nRow #0: \nRow #1: 4\nRow #1: \nRow #1: \nRow #1: 4\nRow #1: 10.40\nRow #1: \nRow #1: \nRow #1: 2.16\nRow #2: \nRow #2: 1\nRow #2: \nRow #2: \nRow #2: \nRow #2: 2.37\nRow #2: \nRow #2: \nRow #3: \nRow #3: \nRow #3: 24\nRow #3: \nRow #3: \nRow #3: \nRow #3: 46.09\nRow #3: \nRow #4: 3\nRow #4: \nRow #4: \nRow #4: 8\nRow #4: 2.10\nRow #4: \nRow #4: \nRow #4: 9.63\nRow #5: 6\nRow #5: \nRow #5: \nRow #5: 5\nRow #5: 8.06\nRow #5: \nRow #5: \nRow #5: 6.21\nRow #6: 3\nRow #6: \nRow #6: \nRow #6: 7\nRow #6: 7.80\nRow #6: \nRow #6: \nRow #6: 15.00\nRow #7: 14\nRow #7: \nRow #7: \nRow #7: \nRow #7: 36.10\nRow #7: \nRow #7: \nRow #7: \nRow #8: 3\nRow #8: \nRow #8: \nRow #8: 16\nRow #8: 10.29\nRow #8: \nRow #8: \nRow #8: 32.20\nRow #9: 3\nRow #9: \nRow #9: \nRow #9: \nRow #9: 10.56\nRow #9: \nRow #9: \nRow #9: \nRow #10: \nRow #10: \nRow #10: 15\nRow #10: 11\nRow #10: \nRow #10: \nRow #10: 34.79\nRow #10: 15.67\nRow #11: \nRow #11: \nRow #11: 7\nRow #11: \nRow #11: \nRow #11: \nRow #11: 17.44\nRow #11: \nRow #12: \nRow #12: \nRow #12: 22\nRow #12: 9\nRow #12: \nRow #12: \nRow #12: 32.35\nRow #12: 17.43\nRow #13: 7\nRow #13: \nRow #13: \nRow #13: 4\nRow #13: 4.77\nRow #13: \nRow #13: \nRow #13: 15.16\nRow #14: 4\nRow #14: \nRow #14: \nRow #14: 4\nRow #14: 3.64\nRow #14: \nRow #14: \nRow #14: 9.64\nRow #15: 2\nRow #15: \nRow #15: \nRow #15: 7\nRow #15: 6.86\nRow #15: \nRow #15: \nRow #15: 8.38\nRow #16: \nRow #16: \nRow #16: \nRow #16: 28\nRow #16: \nRow #16: \nRow #16: \nRow #16: 61.98\nRow #17: \nRow #17: \nRow #17: 3\nRow #17: 4\nRow #17: \nRow #17: \nRow #17: 10.56\nRow #17: 8.96\nRow #18: 6\nRow #18: \nRow #18: \nRow #18: 3\nRow #18: 7.16\nRow #18: \nRow #18: \nRow #18: 8.10\nRow #19: 7\nRow #19: \nRow #19: \nRow #19: \nRow #19: 15.63\nRow #19: \nRow #19: \nRow #19: \nRow #20: 3\nRow #20: \nRow #20: \nRow #20: 13\nRow #20: 6.96\nRow #20: \nRow #20: \nRow #20: 12.22\nRow #21: \nRow #21: \nRow #21: 16\nRow #21: \nRow #21: \nRow #21: \nRow #21: 45.08\nRow #21: \nRow #22: 3\nRow #22: \nRow #22: \nRow #22: 18\nRow #22: 6.39\nRow #22: \nRow #22: \nRow #22: 21.08\nRow #23: \nRow #23: \nRow #23: \nRow #23: 21\nRow #23: \nRow #23: \nRow #23: \nRow #23: 33.22\nRow #24: \nRow #24: \nRow #24: \nRow #24: 9\nRow #24: \nRow #24: \nRow #24: \nRow #24: 22.65\nRow #25: 2\nRow #25: \nRow #25: \nRow #25: 9\nRow #25: 6.80\nRow #25: \nRow #25: \nRow #25: 18.90\nRow #26: 3\nRow #26: \nRow #26: \nRow #26: 9\nRow #26: 1.50\nRow #26: \nRow #26: \nRow #26: 23.01\nRow #27: \nRow #27: \nRow #27: \nRow #27: 22\nRow #27: \nRow #27: \nRow #27: \nRow #27: 50.71\nRow #28: 4\nRow #28: \nRow #28: \nRow #28: \nRow #28: 5.16\nRow #28: \nRow #28: \nRow #28: \nRow #29: \nRow #29: \nRow #29: 20\nRow #29: 14\nRow #29: \nRow #29: \nRow #29: 48.02\nRow #29: 28.80\nRow #30: \nRow #30: \nRow #30: 14\nRow #30: \nRow #30: \nRow #30: \nRow #30: 19.96\nRow #30: \nRow #31: \nRow #31: \nRow #31: 10\nRow #31: 40\nRow #31: \nRow #31: \nRow #31: 26.36\nRow #31: 74.49\nRow #32: 6\nRow #32: \nRow #32: \nRow #32: \nRow #32: 17.01\nRow #32: \nRow #32: \nRow #32: \nRow #33: 4\nRow #33: \nRow #33: \nRow #33: \nRow #33: 2.80\nRow #33: \nRow #33: \nRow #33: \nRow #34: 4\nRow #34: \nRow #34: \nRow #34: \nRow #34: 7.98\nRow #34: \nRow #34: \nRow #34: \nRow #35: \nRow #35: \nRow #35: \nRow #35: 46\nRow #35: \nRow #35: \nRow #35: \nRow #35: 81.71\nRow #36: \nRow #36: \nRow #36: 21\nRow #36: 6\nRow #36: \nRow #36: \nRow #36: 37.93\nRow #36: 14.73\nRow #37: \nRow #37: \nRow #37: 3\nRow #37: \nRow #37: \nRow #37: \nRow #37: 7.92\nRow #37: \nRow #38: 25\nRow #38: \nRow #38: \nRow #38: 3\nRow #38: 51.65\nRow #38: \nRow #38: \nRow #38: 2.34\nRow #39: 3\nRow #39: \nRow #39: \nRow #39: 4\nRow #39: 4.47\nRow #39: \nRow #39: \nRow #39: 9.20\nRow #40: \nRow #40: 1\nRow #40: \nRow #40: \nRow #40: \nRow #40: 1.47\nRow #40: \nRow #40: \nRow #41: \nRow #41: \nRow #41: 15\nRow #41: \nRow #41: \nRow #41: \nRow #41: 18.88\nRow #41: \nRow #42: \nRow #42: \nRow #42: \nRow #42: 3\nRow #42: \nRow #42: \nRow #42: \nRow #42: 3.75\nRow #43: 9\nRow #43: \nRow #43: \nRow #43: 10\nRow #43: 31.41\nRow #43: \nRow #43: \nRow #43: 15.12\nRow #44: 3\nRow #44: \nRow #44: \nRow #44: 3\nRow #44: 7.41\nRow #44: \nRow #44: \nRow #44: 2.55\nRow #45: 3\nRow #45: \nRow #45: \nRow #45: \nRow #45: 1.71\nRow #45: \nRow #45: \nRow #45: \nRow #46: \nRow #46: \nRow #46: \nRow #46: 7\nRow #46: \nRow #46: \nRow #46: \nRow #46: 11.86\nRow #47: \nRow #47: \nRow #47: \nRow #47: 3\nRow #47: \nRow #47: \nRow #47: \nRow #47: 2.76\nRow #48: \nRow #48: \nRow #48: 4\nRow #48: 5\nRow #48: \nRow #48: \nRow #48: 4.50\nRow #48: 7.27\nRow #49: \nRow #49: \nRow #49: 7\nRow #49: \nRow #49: \nRow #49: \nRow #49: 10.01\nRow #49: \nRow #50: \nRow #50: \nRow #50: 5\nRow #50: 4\nRow #50: \nRow #50: \nRow #50: 12.88\nRow #50: 5.28\nRow #51: 2\nRow #51: \nRow #51: \nRow #51: \nRow #51: 2.64\nRow #51: \nRow #51: \nRow #51: \nRow #52: \nRow #52: \nRow #52: \nRow #52: 5\nRow #52: \nRow #52: \nRow #52: \nRow #52: 12.34\nRow #53: \nRow #53: \nRow #53: \nRow #53: 5\nRow #53: \nRow #53: \nRow #53: \nRow #53: 3.41\nRow #54: \nRow #54: \nRow #54: \nRow #54: 4\nRow #54: \nRow #54: \nRow #54: \nRow #54: 2.44\nRow #55: \nRow #55: \nRow #55: 2\nRow #55: \nRow #55: \nRow #55: \nRow #55: 6.92\nRow #55: \nRow #56: 13\nRow #56: \nRow #56: \nRow #56: 7\nRow #56: 23.69\nRow #56: \nRow #56: \nRow #56: 7.07\n"), new FoodMartTestCase.QueryAndResult("select from Sales\nwhere ([Measures].[Store Sales], [Time].[1997], [Promotion Media].[All Media].[TV])", "Axis #0:\n{[Measures].[Store Sales], [Time].[1997], [Promotion Media].[All Media].[TV]}\n7,786.21"));

    public BasicQueryTest() {
    }

    public BasicQueryTest(String name) {
        super(name);
    }

    public void testSample0() {
        this.assertQueryReturns(BasicQueryTest.sampleQueries[0].query, BasicQueryTest.sampleQueries[0].result);
    }

    public void testSample1() {
        this.assertQueryReturns(BasicQueryTest.sampleQueries[1].query, BasicQueryTest.sampleQueries[1].result);
    }

    public void testSample2() {
        this.assertQueryReturns(BasicQueryTest.sampleQueries[2].query, BasicQueryTest.sampleQueries[2].result);
    }

    public void testSample3() {
        this.assertQueryReturns(BasicQueryTest.sampleQueries[3].query, BasicQueryTest.sampleQueries[3].result);
    }

    public void testSample4() {
        this.assertQueryReturns(BasicQueryTest.sampleQueries[4].query, BasicQueryTest.sampleQueries[4].result);
    }

    public void testSample5() {
        this.assertQueryReturns(BasicQueryTest.sampleQueries[5].query, BasicQueryTest.sampleQueries[5].result);
    }

    public void testSample6() {
        this.assertQueryReturns(BasicQueryTest.sampleQueries[6].query, BasicQueryTest.sampleQueries[6].result);
    }

    public void testSample7() {
        this.assertQueryReturns(BasicQueryTest.sampleQueries[7].query, BasicQueryTest.sampleQueries[7].result);
    }

    public void testSample8() {
        if (TestContext.instance().getDialect().getDatabaseProduct() == Dialect.DatabaseProduct.INFOBRIGHT) {
            return;
        }
        this.assertQueryReturns(BasicQueryTest.sampleQueries[8].query, BasicQueryTest.sampleQueries[8].result);
    }

    public void testGoodComments() {
        this.assertQueryReturns("SELECT {} ON ROWS, {} ON COLUMNS FROM [Sales]/* trailing comment*/", EmptyResult);
        String[] comments = new String[]{"-- a basic comment\n", "// another basic comment\n", "/* yet another basic comment */", "-- a more complicated comment test\n", "-- to make it more intesting, -- we'll nest this comment\n", "-- also, \"we can put a string in the comment\"\n", "-- also, 'even a single quote string'\n", "---- and, the comment delimiter is looong\n", "/*\n * next, how about a comment block?\n * with several lines.\n * also, \"we can put a string in the comment\"\n * also, 'even a single quote string'\n * also, -- another style comment is happy\n */\n", "/* a simple /* nested */ comment */", "/*\n * a multiline /* nested */ comment\n*/", "/*\n * a multiline\n * /* multiline\n *  * nested comment\n *  */\n*/", "/*\n * a multiline\n * /* multiline\n * /* deeply\n * /* really /* deeply */\n *  * nested comment\n *  */\n *  */\n *  */\n*/", "-- single-line comment containing /* multiline */ comment\n", "/* multi-line comment containing -- single-line comment */"};
        ArrayList<String> allCommentList = new ArrayList<String>();
        for (String comment : comments) {
            allCommentList.add(comment);
            if (comment.indexOf("\n") < 0) continue;
            allCommentList.add(comment.replaceAll("\n", "\r\n"));
            allCommentList.add(comment.replaceAll("\n", "\n\r"));
            allCommentList.add(comment.replaceAll("\n", " \n \n "));
        }
        allCommentList.add("");
        String[] allComments = allCommentList.toArray(new String[allCommentList.size()]);
        StringBuilder buf = new StringBuilder();
        for (String allComment : allComments) {
            buf.append(allComment);
        }
        allComments[allComments.length - 1] = buf.toString();
        for (String comment : allComments) {
            this.assertQueryReturns(comment + "SELECT {} ON ROWS, {} ON COLUMNS FROM [Sales]", EmptyResult);
        }
        for (String comment : allComments) {
            this.assertQueryReturns("SELECT" + comment + "{} ON ROWS, {} ON COLUMNS FROM [Sales]", EmptyResult);
        }
        for (String comment : allComments) {
            this.assertQueryReturns("SELECT {" + comment + "} ON ROWS, {} ON COLUMNS FROM [Sales]", EmptyResult);
        }
        for (String comment : allComments) {
            this.assertQueryReturns("SELECT {} ON ROWS" + comment + ", {} ON COLUMNS FROM [Sales]", EmptyResult);
        }
        for (String comment : allComments) {
            this.assertQueryReturns("SELECT {} ON ROWS, {} ON COLUMNS FROM [Sales] WHERE" + comment + "([Gender].[F])", BasicQueryTest.fold("Axis #0:\n{[Gender].[All Gender].[F]}\nAxis #1:\nAxis #2:\n"));
        }
        for (String comment : allComments) {
            this.assertQueryReturns("SELECT {} ON ROWS, {} ON COLUMNS FROM [Sales]" + comment, EmptyResult);
        }
        this.assertQueryReturns("-- a comment test with carriage returns at the end of the lines\r\n-- first, more than one single-line comment in a row\r\n-- and, to make it more intesting, -- we'll nest this comment\r\n-- also, \"we can put a string in the comment\"\r\n-- also, 'even a single quote string'\r\n---- and, the comment delimiter is looong\r\n/*\r\n * next, now about a comment block?\r\n * with several lines.\r\n * also, \"we can put a string in the comment\"\r\n * also, 'even a single quote comment'\r\n * also, -- another style comment is heppy\r\n * also, // another style comment is heppy\r\n */\r\nSELECT {} ON ROWS, {} ON COLUMNS FROM [Sales]\r", EmptyResult);
        this.assertQueryReturns("/* a simple /* nested */ comment */\n/*\n * a multiline /* nested */ comment\n*/\n/*\n * a multiline\n * /* multiline\n *  * nested comment\n *  */\n*/\n/*\n * a multiline\n * /* multiline\n * /* deeply\n * /* really /* deeply */\n *  * nested comment\n *  */\n *  */\n *  */\n*/\nSELECT {} ON ROWS, {} ON COLUMNS FROM [Sales]", EmptyResult);
        this.assertQueryReturns("-- an entire select statement commented out\n-- SELECT {} ON ROWS, {} ON COLUMNS FROM [Sales];\n/*SELECT {} ON ROWS, {} ON COLUMNS FROM [Sales];*/\n// SELECT {} ON ROWS, {} ON COLUMNS FROM [Sales];\nSELECT {} ON ROWS, {} ON COLUMNS FROM [Sales]", EmptyResult);
        this.assertQueryReturns("// now for some comments in a larger command\nwith // create calculate measure [Product].[All Products].[Drink].[Percent of Alcoholic Drinks]\n   member [Product].[All Products].[Drink].[Percent of Alcoholic Drinks]/*the measure name*/as '                        // begin the definition of the measure next\n       [Product]./****this is crazy****/[All Products].[Drink].[Alcoholic Beverages]/[Product].[All Products].[Drink]',  // divide number of alcoholic drinks by total # of drinks\n       format_string = '#.00%'  // a custom format for our measure\nselect\n   { [Product]/**** still crazy ****/.[All Products].[Drink].[Percent of Alcoholic Drinks] } on columns,\n   order(/****do not put a comment inside square brackets****/[Customers].[All Customers].[USA].[WA].Children, [Product].[All Products].[Drink].[Percent of Alcoholic Drinks],BDESC) on rows\nfrom Sales\nwhere ([Measures].[Unit Sales] /****,[Time].[1997]****/) -- a comment at the end of the command", BasicQueryTest.fold("Axis #0:\n{[Measures].[Unit Sales]}\nAxis #1:\n{[Product].[All Products].[Drink].[Percent of Alcoholic Drinks]}\nAxis #2:\n{[Customers].[All Customers].[USA].[WA].[Seattle]}\n{[Customers].[All Customers].[USA].[WA].[Kirkland]}\n{[Customers].[All Customers].[USA].[WA].[Marysville]}\n{[Customers].[All Customers].[USA].[WA].[Anacortes]}\n{[Customers].[All Customers].[USA].[WA].[Olympia]}\n{[Customers].[All Customers].[USA].[WA].[Ballard]}\n{[Customers].[All Customers].[USA].[WA].[Bremerton]}\n{[Customers].[All Customers].[USA].[WA].[Puyallup]}\n{[Customers].[All Customers].[USA].[WA].[Yakima]}\n{[Customers].[All Customers].[USA].[WA].[Tacoma]}\n{[Customers].[All Customers].[USA].[WA].[Everett]}\n{[Customers].[All Customers].[USA].[WA].[Renton]}\n{[Customers].[All Customers].[USA].[WA].[Issaquah]}\n{[Customers].[All Customers].[USA].[WA].[Bellingham]}\n{[Customers].[All Customers].[USA].[WA].[Port Orchard]}\n{[Customers].[All Customers].[USA].[WA].[Redmond]}\n{[Customers].[All Customers].[USA].[WA].[Spokane]}\n{[Customers].[All Customers].[USA].[WA].[Burien]}\n{[Customers].[All Customers].[USA].[WA].[Lynnwood]}\n{[Customers].[All Customers].[USA].[WA].[Walla Walla]}\n{[Customers].[All Customers].[USA].[WA].[Edmonds]}\n{[Customers].[All Customers].[USA].[WA].[Sedro Woolley]}\nRow #0: 44.05%\nRow #1: 34.41%\nRow #2: 34.20%\nRow #3: 32.93%\nRow #4: 31.05%\nRow #5: 30.84%\nRow #6: 30.69%\nRow #7: 29.81%\nRow #8: 28.82%\nRow #9: 28.70%\nRow #10: 28.37%\nRow #11: 26.67%\nRow #12: 26.60%\nRow #13: 26.47%\nRow #14: 26.42%\nRow #15: 26.28%\nRow #16: 25.96%\nRow #17: 24.70%\nRow #18: 21.89%\nRow #19: 21.47%\nRow #20: 17.47%\nRow #21: 13.79%\n"));
    }

    public void testBadComments() {
        this.assertThrows("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]\nWHERE {[/***an illegal comment****/Marital Status].[S]}", "Failed to parse query");
        this.assertThrows("/* a simple /* nested * comment */\nSELECT {} ON ROWS, {} ON COLUMNS FROM [Sales]", "Failed to parse query");
        this.assertThrows("SELECT {} ON COLUMNS -- comment terminated by CR only\r, {} ON ROWS FROM [Sales]", "Failed to parse query");
    }

    public void testBothAxesEmpty() {
        this.assertQueryReturns("SELECT {} ON ROWS, {} ON COLUMNS FROM [Sales]", EmptyResult);
        this.assertQueryReturns("SELECT Filter({[Gender].MEMBERS}, 1 = 0) ON COLUMNS, \n{} ON ROWS\nFROM [Sales]", EmptyResult);
        this.assertQueryReturns("SELECT {} ON ROWS, {} ON COLUMNS \nFROM [Sales] WHERE ([Gender].[F])", BasicQueryTest.fold("Axis #0:\n{[Gender].[All Gender].[F]}\nAxis #1:\nAxis #2:\n"));
    }

    public void testCompoundSlicerFails() {
        this.assertThrows("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]\nWHERE {([Marital Status].[S]),\n       ([Marital Status].[M])}", "WHERE clause expression returned set with more than one element.");
        this.assertThrows("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]\nWHERE {[Marital Status].[S],\n       [Product]}", "All arguments to function '{}' must have same hierarchy.");
        this.assertThrows("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]\nWHERE Filter({[Marital Status].MEMBERS}, 1 = 0)", "WHERE clause expression returned NULL or empty set.");
        this.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]\nWHERE ({Filter({[Marital Status].MEMBERS}, [Measures].[Unit Sales] = 266773)}.Item(0))", BasicQueryTest.fold("Axis #0:\n{[Marital Status].[All Marital Status]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 266,773\nRow #1: 131,558\nRow #2: 135,215\n"));
        this.assertThrows("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]\nWHERE [Marital Status].Parent", "WHERE clause expression returned NULL or empty set.");
        this.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]\nWHERE Filter({[Marital Status].MEMBERS}, [Measures].[Unit Sales] = 266773)", BasicQueryTest.fold("Axis #0:\n{[Marital Status].[All Marital Status]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 266,773\nRow #1: 131,558\nRow #2: 135,215\n"));
        this.assertThrows("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]\nWHERE Filter({[Marital Status].MEMBERS}, [Measures].[Unit Sales] <= 266773)", "WHERE clause expression returned set with more than one element.");
        this.assertThrows("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]\nWHERE {[Marital Status].[S],\n       [Product]}", "All arguments to function '{}' must have same hierarchy.");
        this.assertThrows("SELECT CrossJoin(\n  {[Measures].[Unit Sales]},\n  {[Gender].[M]}) ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]", "Dimension '[Gender]' appears in more than one independent axis.");
        this.assertThrows("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]WHERE ([Marital Status].[S], [Gender].[F])", "Dimension '[Gender]' appears in more than one independent axis.");
        this.assertThrows("SELECT {[Measures].[Unit Sales]} ON COLUMNS,\n {[Gender].MEMBERS} ON ROWS\nFROM [Sales]WHERE ([Marital Status].[S], [Marital Status].[M])", "Tuple contains more than one member of dimension '[Marital Status]'.");
        this.assertThrows("select\n{[Measures].[Unit Sales]} on columns,\n{([Product].[All Products], [Time].[1997])} ON rows\nfrom Sales\nwhere ([Time].[1997])", "Dimension '[Time]' appears in more than one independent axis.");
    }

    public void testBigQuery() {
        Result result = this.executeQuery("SELECT {[Measures].[Unit Sales]} on columns,\n {[Product].members} on rows\nfrom Sales");
        int rowCount = result.getAxes()[1].getPositions().size();
        BasicQueryTest.assertEquals((int)2256, (int)rowCount);
        BasicQueryTest.assertEquals((String)"152", (String)result.getCell(new int[]{0, rowCount - 1}).getFormattedValue());
    }

    public void testNonEmpty1() {
        this.assertSize("select\n  NON EMPTY CrossJoin({[Product].[All Products].[Drink].Children},\n    {[Customers].[All Customers].[USA].[WA].[Bellingham]}) on rows,\n  CrossJoin(\n    {[Measures].[Unit Sales], [Measures].[Store Sales]},\n    { [Promotion Media].[All Media].[Radio],\n      [Promotion Media].[All Media].[TV],\n      [Promotion Media].[All Media].[Sunday Paper],\n      [Promotion Media].[All Media].[Street Handout] }\n   ) on columns\nfrom Sales\nwhere ([Time].[1997])", 8, 2);
    }

    public void testNonEmpty2() {
        this.assertSize("select\n  NON EMPTY CrossJoin(\n    {[Product].[All Products].Children},\n    {[Customers].[All Customers].[USA].[WA].[Bellingham]}) on rows,\n  NON EMPTY CrossJoin(\n    {[Measures].[Unit Sales]},\n    { [Promotion Media].[All Media].[Cash Register Handout],\n      [Promotion Media].[All Media].[Sunday Paper],\n      [Promotion Media].[All Media].[Street Handout] }\n   ) on columns\nfrom Sales\nwhere ([Time].[1997])", 2, 2);
    }

    public void testOneDimensionalQueryWithCompoundSlicer() {
        Result result = this.executeQuery("select\n  [Product].[All Products].[Drink].children on columns\nfrom Sales\nwhere ([Measures].[Unit Sales], [Promotion Media].[All Media].[Street Handout], [Time].[1997])");
        BasicQueryTest.assertTrue((result.getAxes().length == 1 ? 1 : 0) != 0);
        BasicQueryTest.assertTrue((result.getAxes()[0].getPositions().size() == 3 ? 1 : 0) != 0);
        BasicQueryTest.assertTrue((result.getSlicerAxis().getPositions().size() == 1 ? 1 : 0) != 0);
        BasicQueryTest.assertTrue((result.getSlicerAxis().getPositions().get(0).size() == 3 ? 1 : 0) != 0);
    }

    public void testSlicerIsEvaluatedBeforeAxes() {
        this.assertSize("SELECT {[Measures].[Unit Sales]} on columns,\n filter({[Product].members}, [Measures].[Unit Sales] > 20000) on rows\nFROM Sales\nWHERE [Time].[1997].[Q1]", 1, 2);
    }

    public void testSlicerWithCalculatedMembers() {
        this.assertSize("WITH MEMBER [Time].[1997].[H1] as ' Aggregate({[Time].[1997].[Q1], [Time].[1997].[Q2]})' \n  MEMBER [Measures].[Store Margin] as '[Measures].[Store Sales] - [Measures].[Store Cost]'\nSELECT {[Gender].children} on columns,\n filter({[Product].members}, [Gender].[F] > 10000) on rows\nFROM Sales\nWHERE ([Time].[1997].[H1], [Measures].[Store Margin])", 2, 6);
    }

    public void _testEver() {
        this.assertQueryReturns("select\n {[Measures].[Unit Sales], [Measures].[Ever]} on columns,\n [Gender].members on rows\nfrom Sales", "xxx");
    }

    public void _testDairy() {
        this.assertQueryReturns("with\n  member [Product].[Non dairy] as '[Product].[All Products] - [Product].[Food].[Dairy]'\n  member [Measures].[Dairy ever] as 'sum([Time].members, ([Measures].[Unit Sales],[Product].[Food].[Dairy]))'\n  set [Customers who never bought dairy] as 'filter([Customers].members, [Measures].[Dairy ever] = 0)'\nselect\n {[Measures].[Unit Sales], [Measures].[Dairy ever]}  on columns,\n  [Customers who never bought dairy] on rows\nfrom Sales", "xxx");
    }

    public void testSolveOrder() {
        this.assertQueryReturns("WITH\n   MEMBER [Measures].[StoreType] AS \n   '[Store].CurrentMember.Properties(\"Store Type\")',\n   SOLVE_ORDER = 2\n   MEMBER [Measures].[ProfitPct] AS \n   '(Measures.[Store Sales] - Measures.[Store Cost]) / Measures.[Store Sales]',\n   SOLVE_ORDER = 1, FORMAT_STRING = '##.00%'\nSELECT\n   { Descendants([Store].[USA], [Store].[Store Name])} ON COLUMNS,\n   { [Measures].[Store Sales], [Measures].[Store Cost], [Measures].[StoreType],\n   [Measures].[ProfitPct] } ON ROWS\nFROM Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[CA].[Alameda].[HQ]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nAxis #2:\n{[Measures].[Store Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[StoreType]}\n{[Measures].[ProfitPct]}\nRow #0: \nRow #0: 45,750.24\nRow #0: 54,545.28\nRow #0: 54,431.14\nRow #0: 4,441.18\nRow #0: 55,058.79\nRow #0: 87,218.28\nRow #0: 4,739.23\nRow #0: 52,896.30\nRow #0: 52,644.07\nRow #0: 49,634.46\nRow #0: 74,843.96\nRow #0: 4,705.97\nRow #0: 24,329.23\nRow #1: \nRow #1: 18,266.44\nRow #1: 21,771.54\nRow #1: 21,713.53\nRow #1: 1,778.92\nRow #1: 21,948.94\nRow #1: 34,823.56\nRow #1: 1,896.62\nRow #1: 21,121.96\nRow #1: 20,956.80\nRow #1: 19,795.49\nRow #1: 29,959.28\nRow #1: 1,880.34\nRow #1: 9,713.81\nRow #2: HeadQuarters\nRow #2: Gourmet Supermarket\nRow #2: Supermarket\nRow #2: Supermarket\nRow #2: Small Grocery\nRow #2: Supermarket\nRow #2: Deluxe Supermarket\nRow #2: Small Grocery\nRow #2: Supermarket\nRow #2: Supermarket\nRow #2: Supermarket\nRow #2: Deluxe Supermarket\nRow #2: Small Grocery\nRow #2: Mid-Size Grocery\nRow #3: \nRow #3: 60.07%\nRow #3: 60.09%\nRow #3: 60.11%\nRow #3: 59.94%\nRow #3: 60.14%\nRow #3: 60.07%\nRow #3: 59.98%\nRow #3: 60.07%\nRow #3: 60.19%\nRow #3: 60.12%\nRow #3: 59.97%\nRow #3: 60.04%\nRow #3: 60.07%\n"));
    }

    public void testSolveOrderNonMeasure() {
        this.assertQueryReturns("WITH\n   MEMBER [Product].[ProdCalc] as '1', SOLVE_ORDER=1\n   MEMBER [Measures].[MeasuresCalc] as '2', SOLVE_ORDER=2\n   MEMBER [Time].[TimeCalc] as '3', SOLVE_ORDER=3\nSELECT\n   { [Product].[ProdCalc] } ON columns,\n   {([Time].[TimeCalc], [Measures].[MeasuresCalc])} ON rows\nFROM Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[ProdCalc]}\nAxis #2:\n{[Time].[TimeCalc], [Measures].[MeasuresCalc]}\nRow #0: 3\n"));
    }

    public void testSolveOrderNonMeasure2() {
        this.assertQueryReturns("WITH\n   MEMBER [Store].[StoreCalc] as '0', SOLVE_ORDER=0\n   MEMBER [Product].[ProdCalc] as '1', SOLVE_ORDER=1\nSELECT\n   { [Product].[ProdCalc] } ON columns,\n   { [Store].[StoreCalc] } ON rows\nFROM Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[ProdCalc]}\nAxis #2:\n{[Store].[StoreCalc]}\nRow #0: 1\n"));
    }

    public void testSolveOrderAmbiguous1() {
        this.assertQueryReturns("WITH\n   MEMBER [Promotions].[Calc] AS '1'\n   MEMBER [Customers].[Calc] AS '2'\nSELECT\n   { [Promotions].[Calc] } ON COLUMNS,\n   {  [Customers].[Calc] } ON ROWS\nFROM Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Promotions].[Calc]}\nAxis #2:\n{[Customers].[Calc]}\nRow #0: 1\n"));
    }

    public void testSolveOrderAmbiguous2() {
        this.assertQueryReturns("WITH\n   MEMBER [Promotions].[Calc] AS '1'\n   MEMBER [Product].[Calc] AS '2'\nSELECT\n   { [Promotions].[Calc] } ON COLUMNS,\n   { [Product].[Calc] } ON ROWS\nFROM Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Promotions].[Calc]}\nAxis #2:\n{[Product].[Calc]}\nRow #0: 2\n"));
    }

    public void testCalculatedMemberWhichIsNotAMeasure() {
        String query = "WITH MEMBER [Product].[BigSeller] AS\n  'IIf([Product].[Drink].[Alcoholic Beverages].[Beer and Wine] > 100, \"Yes\",\"No\")'\nSELECT {[Product].[BigSeller],[Product].children} ON COLUMNS,\n   {[Store].[All Stores].[USA].[CA].children} ON ROWS\nFROM Sales";
        String desiredResult = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[BigSeller]}\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Alameda]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\nRow #0: No\nRow #0: \nRow #0: \nRow #0: \nRow #1: Yes\nRow #1: 1,945\nRow #1: 15,438\nRow #1: 3,950\nRow #2: Yes\nRow #2: 2,422\nRow #2: 18,294\nRow #2: 4,947\nRow #3: Yes\nRow #3: 2,560\nRow #3: 18,369\nRow #3: 4,706\nRow #4: No\nRow #4: 175\nRow #4: 1,555\nRow #4: 387\n");
        this.assertQueryReturns(query, desiredResult);
    }

    public void testMultipleCalculatedMembersWhichAreNotMeasures() {
        String query = "WITH\n  MEMBER [Store].[x] AS '1'\n  MEMBER [Product].[x] AS '1'\nSELECT {[Store].[x]} ON COLUMNS\nFROM Sales";
        String desiredResult = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[x]}\nRow #0: 1\n");
        this.assertQueryReturns(query, desiredResult);
    }

    public void testMultipleCalculatedMembersWhichAreNotMeasures2() {
        String query = "WITH\n  MEMBER [Product].[x] AS '1'\n  MEMBER [Store].[x] AS '1'\nSELECT {[Store].[x]} ON COLUMNS\nFROM Sales";
        String desiredResult = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[x]}\nRow #0: 1\n");
        this.assertQueryReturns(query, desiredResult);
    }

    public void testMultipleCalculatedMembersWhichAreNotMeasures3() {
        String query = "WITH\n  MEMBER [Product].[All Products].[x] AS '1'\n  MEMBER [Store].[All Stores].[x] AS '1'\nSELECT {[Store].[All Stores].[x]} ON COLUMNS\nFROM Sales";
        String desiredResult = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[x]}\nRow #0: 1\n");
        this.assertQueryReturns(query, desiredResult);
    }

    public void testConstantString() {
        String s = this.executeExpr(" \"a string\" ");
        BasicQueryTest.assertEquals((String)"a string", (String)s);
    }

    public void testConstantNumber() {
        String s = this.executeExpr(" 1234 ");
        BasicQueryTest.assertEquals((String)"1,234", (String)s);
    }

    public void testCyclicalCalculatedMembers() {
        Util.discard((Object)this.executeQuery("WITH\n   MEMBER [Product].[X] AS '[Product].[Y]'\n   MEMBER [Product].[Y] AS '[Product].[X]'\nSELECT\n   {[Product].[X]} ON COLUMNS,\n   {Store.[Store Name].Members} ON ROWS\nFROM Sales"));
    }

    public void testCycle() {
        String s = this.executeExpr("[Time].[1997].[Q4]");
        BasicQueryTest.assertEquals((String)"72,024", (String)s);
    }

    public void testHalfYears() {
        Util.discard((Object)this.executeQuery("WITH MEMBER [Measures].[ProfitPercent] AS\n     '([Measures].[Store Sales]-[Measures].[Store Cost])/([Measures].[Store Cost])',\n FORMAT_STRING = '#.00%', SOLVE_ORDER = 1\n MEMBER [Time].[First Half 97] AS  '[Time].[1997].[Q1] + [Time].[1997].[Q2]'\n MEMBER [Time].[Second Half 97] AS '[Time].[1997].[Q3] + [Time].[1997].[Q4]'\n SELECT {[Time].[First Half 97],\n     [Time].[Second Half 97],\n     [Time].[1997].CHILDREN} ON COLUMNS,\n {[Store].[Store Country].[USA].CHILDREN} ON ROWS\n FROM [Sales]\n WHERE ([Measures].[ProfitPercent])"));
    }

    public void _testHalfYearsTrickyCase() {
        Util.discard((Object)this.executeQuery("WITH MEMBER MEASURES.ProfitPercent AS\n     '([Measures].[Store Sales]-[Measures].[Store Cost])/([Measures].[Store Cost])',\n FORMAT_STRING = '#.00%', SOLVE_ORDER = 1\n MEMBER [Time].[First Half 97] AS  '[Time].[1997].[Q1] + [Time].[1997].[Q2]'\n MEMBER [Time].[Second Half 97] AS '[Time].[1997].[Q3] + [Time].[1997].[Q4]'\n SELECT {[Time].[First Half 97],\n     [Time].[Second Half 97],\n     [Time].[1997].CHILDREN} ON COLUMNS,\n {[Store].[Store Country].[USA].CHILDREN} ON ROWS\n FROM [Sales]\n WHERE (MEASURES.ProfitPercent)"));
    }

    public void testAsSample7ButUsingVirtualCube() {
        Util.discard((Object)this.executeQuery("with member [Measures].[Accumulated Sales] as 'Sum(YTD(),[Measures].[Store Sales])'\nselect\n    {[Measures].[Store Sales],[Measures].[Accumulated Sales]} on columns,\n    {Descendants([Time].[1997],[Time].[Month])} on rows\nfrom [Warehouse and Sales]"));
    }

    public void testVirtualCube() {
        this.assertQueryReturns("select CrossJoin(\n  {[Warehouse].DefaultMember, [Warehouse].[USA].children},\n  {[Measures].[Unit Sales], [Measures].[Store Sales], [Measures].[Units Shipped]}) on columns,\n [Time].children on rows\nfrom [Warehouse and Sales]", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Warehouse].[All Warehouses], [Measures].[Unit Sales]}\n{[Warehouse].[All Warehouses], [Measures].[Store Sales]}\n{[Warehouse].[All Warehouses], [Measures].[Units Shipped]}\n{[Warehouse].[All Warehouses].[USA].[CA], [Measures].[Unit Sales]}\n{[Warehouse].[All Warehouses].[USA].[CA], [Measures].[Store Sales]}\n{[Warehouse].[All Warehouses].[USA].[CA], [Measures].[Units Shipped]}\n{[Warehouse].[All Warehouses].[USA].[OR], [Measures].[Unit Sales]}\n{[Warehouse].[All Warehouses].[USA].[OR], [Measures].[Store Sales]}\n{[Warehouse].[All Warehouses].[USA].[OR], [Measures].[Units Shipped]}\n{[Warehouse].[All Warehouses].[USA].[WA], [Measures].[Unit Sales]}\n{[Warehouse].[All Warehouses].[USA].[WA], [Measures].[Store Sales]}\n{[Warehouse].[All Warehouses].[USA].[WA], [Measures].[Units Shipped]}\nAxis #2:\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q4]}\nRow #0: 66,291\nRow #0: 139,628.35\nRow #0: 50951.0\nRow #0: \nRow #0: \nRow #0: 8539.0\nRow #0: \nRow #0: \nRow #0: 7994.0\nRow #0: \nRow #0: \nRow #0: 34418.0\nRow #1: 62,610\nRow #1: 132,666.27\nRow #1: 49187.0\nRow #1: \nRow #1: \nRow #1: 15726.0\nRow #1: \nRow #1: \nRow #1: 7575.0\nRow #1: \nRow #1: \nRow #1: 25886.0\nRow #2: 65,848\nRow #2: 140,271.89\nRow #2: 57789.0\nRow #2: \nRow #2: \nRow #2: 20821.0\nRow #2: \nRow #2: \nRow #2: 8673.0\nRow #2: \nRow #2: \nRow #2: 28295.0\nRow #3: 72,024\nRow #3: 152,671.62\nRow #3: 49799.0\nRow #3: \nRow #3: \nRow #3: 15791.0\nRow #3: \nRow #3: \nRow #3: 16666.0\nRow #3: \nRow #3: \nRow #3: 17342.0\n"));
    }

    public void testUseDimensionAsShorthandForMember() {
        Util.discard((Object)this.executeQuery("select {[Measures].[Unit Sales]} on columns,\n {[Store], [Store].children} on rows\nfrom [Sales]"));
    }

    public void _testMembersFunction() {
        Util.discard((Object)this.executeQuery("select {[Measures].[Unit Sales]} on columns,\n {[Customers].members(0)} on rows\nfrom [Sales]"));
    }

    public void _testProduct2() {
        Axis axis = this.getTestContext().executeAxis("{[Product2].members}");
        System.out.println(TestContext.toString(axis.getPositions()));
    }

    public void testTaglib0() {
        this.assertQueryReturns(BasicQueryTest.taglibQueries.get((int)0).query, BasicQueryTest.taglibQueries.get((int)0).result);
    }

    public void testTaglib1() {
        this.assertQueryReturns(BasicQueryTest.taglibQueries.get((int)1).query, BasicQueryTest.taglibQueries.get((int)1).result);
    }

    public void testTaglib2() {
        this.assertQueryReturns(BasicQueryTest.taglibQueries.get((int)2).query, BasicQueryTest.taglibQueries.get((int)2).result);
    }

    public void testTaglib3() {
        this.assertQueryReturns(BasicQueryTest.taglibQueries.get((int)3).query, BasicQueryTest.taglibQueries.get((int)3).result);
    }

    public void testTaglib4() {
        this.assertQueryReturns(BasicQueryTest.taglibQueries.get((int)4).query, BasicQueryTest.taglibQueries.get((int)4).result);
    }

    public void testTaglib5() {
        this.assertQueryReturns(BasicQueryTest.taglibQueries.get((int)5).query, BasicQueryTest.taglibQueries.get((int)5).result);
    }

    public void testCellValue() {
        Result result = this.executeQuery("select {[Measures].[Unit Sales],[Measures].[Store Sales]} on columns,\n {[Gender].[M]} on rows\nfrom Sales");
        Cell cell = result.getCell(new int[]{0, 0});
        Object value = cell.getValue();
        BasicQueryTest.assertTrue((boolean)(value instanceof Number));
        BasicQueryTest.assertEquals((int)135215, (int)((Number)value).intValue());
        cell = result.getCell(new int[]{1, 0});
        value = cell.getValue();
        BasicQueryTest.assertTrue((boolean)(value instanceof Number));
        BasicQueryTest.assertEquals((int)285011, (int)((Number)value).intValue());
    }

    public void testDynamicFormat() {
        this.assertQueryReturns("with member [Measures].[USales] as [Measures].[Unit Sales],\n  format_string = iif([Measures].[Unit Sales] > 50000, \"\\<b\\>#.00\\<\\/b\\>\", \"\\<i\\>#.00\\<\\/i\\>\")\nselect \n  {[Measures].[USales]} on columns,\n  {[Store Type].members} on rows\nfrom Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[USales]}\nAxis #2:\n{[Store Type].[All Store Types]}\n{[Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Store Type].[All Store Types].[HeadQuarters]}\n{[Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Store Type].[All Store Types].[Small Grocery]}\n{[Store Type].[All Store Types].[Supermarket]}\nRow #0: <b>266773.00</b>\nRow #1: <b>76837.00</b>\nRow #2: <i>21333.00</i>\nRow #3: \nRow #4: <i>11491.00</i>\nRow #5: <i>6557.00</i>\nRow #6: <b>150555.00</b>\n"));
    }

    public void testFormatOfNulls() {
        this.assertQueryReturns("with member [Measures].[Foo] as '([Measures].[Store Sales])',\n format_string = '$#,##0.00;($#,##0.00);ZERO;NULL;Nil'\nselect\n {[Measures].[Foo]} on columns,\n {[Customers].[Country].members} on rows\nfrom Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nAxis #2:\n{[Customers].[All Customers].[Canada]}\n{[Customers].[All Customers].[Mexico]}\n{[Customers].[All Customers].[USA]}\nRow #0: NULL\nRow #1: NULL\nRow #2: $565,238.13\n"));
    }

    public void testBug684593(FoodMartTestCase test) {
        test.assertQueryReturns("with member [Measures].[USales] as '[Measures].[Unit Sales]',\n format_string = iif([Measures].[Sales Count] > 30, \"#.00 good\",\"#.00 bad\")\nselect {[Measures].[USales], [Measures].[Store Cost], [Measures].[Store Sales]} ON columns,\n Crossjoin({[Promotion Media].[All Media].[Radio], [Promotion Media].[All Media].[TV], [Promotion Media]. [All Media].[Sunday Paper], [Promotion Media].[All Media].[Street Handout]}, [Product].[All Products].[Drink].Children) ON rows\nfrom [Sales] where ([Time].[1997])", BasicQueryTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[USales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Promotion Media].[All Media].[Radio], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Promotion Media].[All Media].[Radio], [Product].[All Products].[Drink].[Beverages]}\n{[Promotion Media].[All Media].[Radio], [Product].[All Products].[Drink].[Dairy]}\n{[Promotion Media].[All Media].[TV], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Promotion Media].[All Media].[TV], [Product].[All Products].[Drink].[Beverages]}\n{[Promotion Media].[All Media].[TV], [Product].[All Products].[Drink].[Dairy]}\n{[Promotion Media].[All Media].[Sunday Paper], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Promotion Media].[All Media].[Sunday Paper], [Product].[All Products].[Drink].[Beverages]}\n{[Promotion Media].[All Media].[Sunday Paper], [Product].[All Products].[Drink].[Dairy]}\n{[Promotion Media].[All Media].[Street Handout], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Promotion Media].[All Media].[Street Handout], [Product].[All Products].[Drink].[Beverages]}\n{[Promotion Media].[All Media].[Street Handout], [Product].[All Products].[Drink].[Dairy]}\nRow #0: 75.00 bad\nRow #0: 70.40\nRow #0: 168.62\nRow #1: 97.00 good\nRow #1: 75.70\nRow #1: 186.03\nRow #2: 54.00 bad\nRow #2: 36.75\nRow #2: 89.03\nRow #3: 76.00 bad\nRow #3: 70.99\nRow #3: 182.38\nRow #4: 188.00 good\nRow #4: 167.00\nRow #4: 419.14\nRow #5: 68.00 bad\nRow #5: 45.19\nRow #5: 119.55\nRow #6: 148.00 good\nRow #6: 128.97\nRow #6: 316.88\nRow #7: 197.00 good\nRow #7: 161.81\nRow #7: 399.58\nRow #8: 85.00 bad\nRow #8: 54.75\nRow #8: 140.27\nRow #9: 158.00 good\nRow #9: 121.14\nRow #9: 294.55\nRow #10: 270.00 good\nRow #10: 201.28\nRow #10: 520.55\nRow #11: 84.00 bad\nRow #11: 50.26\nRow #11: 128.32\n"));
    }

    public void testBug761196() {
        this.assertQueryReturns("with member [Measures].[xxx] as '[Measures].[Store Sales]',\n format_string = IIf([Measures].[Unit Sales] > 100000, \"AAA######.00\",\"BBB###.00\")\nselect {[Measures].[xxx]} ON columns,\n {[Product].[All Products].children} ON rows\nfrom [Sales] where [Time].[1997]", BasicQueryTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[xxx]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: BBB48836.21\nRow #1: AAA409035.59\nRow #2: BBB107366.33\n"));
    }

    public void testBug761952() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} ON columns,\n {[Gender].Children} ON rows\nfrom [Sales]\nwhere ([Time].[1997], [Customers])", BasicQueryTest.fold("Axis #0:\n{[Time].[1997], [Customers].[All Customers]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 131,558\nRow #1: 135,215\n"));
    }

    public void testBug804903() {
        this.getConnection().getCacheControl(null).flushSchemaCache();
        this.assertQueryReturns("select {[Measures].[Customer Count]} ON columns,\n  {([Promotion Media].[All Media], [Product].[All Products])} ON rows\nfrom [Sales]\nwhere [Time].[1997]", BasicQueryTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Promotion Media].[All Media], [Product].[All Products]}\nRow #0: 5,581\n"));
    }

    public void testStoreCube() {
        this.assertQueryReturns("select {[Measures].members} on columns,\n {[Store Type].members} on rows\nfrom [Store]where [Store].[USA].[CA]", BasicQueryTest.fold("Axis #0:\n{[Store].[All Stores].[USA].[CA]}\nAxis #1:\n{[Measures].[Store Sqft]}\n{[Measures].[Grocery Sqft]}\nAxis #2:\n{[Store Type].[All Store Types]}\n{[Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Store Type].[All Store Types].[HeadQuarters]}\n{[Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Store Type].[All Store Types].[Small Grocery]}\n{[Store Type].[All Store Types].[Supermarket]}\nRow #0: 69,764\nRow #0: 44,868\nRow #1: \nRow #1: \nRow #2: 23,688\nRow #2: 15,337\nRow #3: \nRow #3: \nRow #4: \nRow #4: \nRow #5: 22,478\nRow #5: 15,321\nRow #6: 23,598\nRow #6: 14,210\n"));
    }

    public void testSchemaLevelTableIsBad() {
    }

    public void testSchemaLevelTableInAnotherHierarchy() {
    }

    public void testSchemaLevelWithViewSpecifiesTable() {
    }

    public void testSchemaLevelOrdinalInOtherTable() {
    }

    public void testSchemaTopLevelNotUnique() {
    }

    public void testBug645744() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} ON columns,\n{[Product].[All Products].[Drink].[Beverages].[Drinks].[Flavored Drinks].children} ON rows\nfrom [Sales]", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Drink].[Beverages].[Drinks].[Flavored Drinks].[Excellent]}\n{[Product].[All Products].[Drink].[Beverages].[Drinks].[Flavored Drinks].[Fabulous]}\n{[Product].[All Products].[Drink].[Beverages].[Drinks].[Flavored Drinks].[Skinner]}\n{[Product].[All Products].[Drink].[Beverages].[Drinks].[Flavored Drinks].[Token]}\n{[Product].[All Products].[Drink].[Beverages].[Drinks].[Flavored Drinks].[Washington]}\nRow #0: 468\nRow #1: 469\nRow #2: 506\nRow #3: 466\nRow #4: 560\n"));
        this.executeQuery("select {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} ON columns,ToggleDrillState({([Promotion Media].[All Media].[Radio], [Product].[All Products].[Drink].[Beverages].[Drinks].[Flavored Drinks])}, {[Product].[All Products].[Drink].[Beverages].[Drinks].[Flavored Drinks]}) ON rows from [Sales] where ([Time].[1997])");
    }

    public void testBug636687() {
        this.executeQuery("select {[Measures].[Unit Sales], [Measures].[Store Cost],[Measures].[Store Sales]} ON columns, Order({([Store].[All Stores].[USA].[CA], [Product].[All Products].[Drink].[Alcoholic Beverages]), ([Store].[All Stores].[USA].[CA], [Product].[All Products].[Drink].[Beverages]), Crossjoin({[Store].[All Stores].[USA].[CA].Children}, {[Product].[All Products].[Drink].[Beverages]}), ([Store].[All Stores].[USA].[CA], [Product].[All Products].[Drink].[Dairy]), ([Store].[All Stores].[USA].[OR], [Product].[All Products].[Drink].[Alcoholic Beverages]), ([Store].[All Stores].[USA].[OR], [Product].[All Products].[Drink].[Beverages]), ([Store].[All Stores].[USA].[OR], [Product].[All Products].[Drink].[Dairy]), ([Store].[All Stores].[USA].[WA], [Product].[All Products].[Drink].[Alcoholic Beverages]), ([Store].[All Stores].[USA].[WA], [Product].[All Products].[Drink].[Beverages]), ([Store].[All Stores].[USA].[WA], [Product].[All Products].[Drink].[Dairy])}, [Measures].[Store Cost], BDESC) ON rows from [Sales] where ([Time].[1997])");
        this.executeQuery("select {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} ON columns, Order({([Store].[All Stores].[USA].[WA], [Product].[All Products].[Drink].[Beverages]), ([Store].[All Stores].[USA].[CA], [Product].[All Products].[Drink].[Beverages]), ([Store].[All Stores].[USA].[OR], [Product].[All Products].[Drink].[Beverages]), ([Store].[All Stores].[USA].[WA], [Product].[All Products].[Drink].[Alcoholic Beverages]), ([Store].[All Stores].[USA].[CA], [Product].[All Products].[Drink].[Alcoholic Beverages]), ([Store].[All Stores].[USA].[OR], [Product].[All Products].[Drink].[Alcoholic Beverages]), ([Store].[All Stores].[USA].[WA], [Product].[All Products].[Drink].[Dairy]), ([Store].[All Stores].[USA].[CA].[San Diego], [Product].[All Products].[Drink].[Beverages]), ([Store].[All Stores].[USA].[CA].[Los Angeles], [Product].[All Products].[Drink].[Beverages]), Crossjoin({[Store].[All Stores].[USA].[CA].[Los Angeles]}, {[Product].[All Products].[Drink].[Beverages].Children}), ([Store].[All Stores].[USA].[CA].[Beverly Hills], [Product].[All Products].[Drink].[Beverages]), ([Store].[All Stores].[USA].[CA], [Product].[All Products].[Drink].[Dairy]), ([Store].[All Stores].[USA].[OR], [Product].[All Products].[Drink].[Dairy]), ([Store].[All Stores].[USA].[CA].[San Francisco], [Product].[All Products].[Drink].[Beverages])}, [Measures].[Store Cost], BDESC) ON rows from [Sales] where ([Time].[1997])");
    }

    public void testBug769114() {
        this.assertQueryReturns("select {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} ON columns,\n Order(TopCount({[Product].[Product Category].Members}, 10.0, [Measures].[Unit Sales]), [Measures].[Store Sales], ASC) ON rows\nfrom [Sales]\nwhere [Time].[1997]", BasicQueryTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baked Goods].[Bread]}\n{[Product].[All Products].[Food].[Deli].[Meat]}\n{[Product].[All Products].[Food].[Dairy].[Dairy]}\n{[Product].[All Products].[Food].[Baking Goods].[Baking Goods]}\n{[Product].[All Products].[Food].[Baking Goods].[Jams and Jellies]}\n{[Product].[All Products].[Food].[Canned Foods].[Canned Soup]}\n{[Product].[All Products].[Food].[Frozen Foods].[Vegetables]}\n{[Product].[All Products].[Food].[Snack Foods].[Snack Foods]}\n{[Product].[All Products].[Food].[Produce].[Fruit]}\n{[Product].[All Products].[Food].[Produce].[Vegetables]}\nRow #0: 7,870\nRow #0: 6,564.09\nRow #0: 16,455.43\nRow #1: 9,433\nRow #1: 8,215.81\nRow #1: 20,616.29\nRow #2: 12,885\nRow #2: 12,228.85\nRow #2: 30,508.85\nRow #3: 8,357\nRow #3: 6,123.32\nRow #3: 15,446.69\nRow #4: 11,888\nRow #4: 9,247.29\nRow #4: 23,223.72\nRow #5: 8,006\nRow #5: 6,408.29\nRow #5: 15,966.10\nRow #6: 6,984\nRow #6: 5,885.05\nRow #6: 14,769.82\nRow #7: 30,545\nRow #7: 26,963.34\nRow #7: 67,609.82\nRow #8: 11,767\nRow #8: 10,312.77\nRow #8: 25,816.13\nRow #9: 20,739\nRow #9: 18,048.81\nRow #9: 45,185.41\n"));
    }

    public void _testBug793616() {
        if (this.props.TestExpDependencies.get() > 0) {
            return;
        }
        long start = System.currentTimeMillis();
        Connection connection = this.getTestContext().getFoodMartConnection();
        String queryString = "select {[Measures].[Unit Sales],\n [Measures].[Store Cost],\n [Measures].[Store Sales]} ON columns,\nHierarchize(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union\n({([Gender].[All Gender],\n [Marital Status].[All Marital Status],\n [Customers].[All Customers],\n [Product].[All Products])},\n Crossjoin ([Gender].[All Gender].Children,\n {([Marital Status].[All Marital Status],\n [Customers].[All Customers],\n [Product].[All Products])})),\n Crossjoin(Crossjoin({[Gender].[All Gender].[F]},\n [Marital Status].[All Marital Status].Children),\n {([Customers].[All Customers],\n [Product].[All Products])})),\n Crossjoin(Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[M])},\n [Customers].[All Customers].Children),\n {[Product].[All Products]})),\n Crossjoin(Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[M])},\n [Customers].[All Customers].[USA].Children),\n {[Product].[All Products]})),\n Crossjoin ({([Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Customers].[All Customers].[USA].[CA])},\n   [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Customers].[All Customers].[USA].[OR])},\n   [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Customers].[All Customers].[USA].[WA])},\n   [Product].[All Products].Children)),\n Crossjoin ({([Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Customers].[All Customers].[USA])},\n   [Product].[All Products].Children)),\n Crossjoin(\n   Crossjoin({([Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S])}, [Customers].[All Customers].Children),\n   {[Product].[All Products]})),\n Crossjoin(Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[S])},\n [Customers].[All Customers].[USA].Children),\n {[Product].[All Products]})),\n Crossjoin ({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[S],\n [Customers].[All Customers].[USA].[CA])},\n [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[S],\n [Customers].[All Customers].[USA].[OR])},\n [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[S],\n [Customers].[All Customers].[USA].[WA])},\n [Product].[All Products].Children)),\n Crossjoin ({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[S],\n [Customers].[All Customers].[USA])},\n [Product].[All Products].Children)),\n Crossjoin(Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status])},\n [Customers].[All Customers].Children),\n {[Product].[All Products]})),\n Crossjoin(Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status])},\n [Customers].[All Customers].[USA].Children),\n {[Product].[All Products]})),\n Crossjoin ({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status],\n [Customers].[All Customers].[USA].[CA])},\n [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status],\n [Customers].[All Customers].[USA].[OR])},\n [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status],\n [Customers].[All Customers].[USA].[WA])},\n [Product].[All Products].Children)),\n Crossjoin ({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status],\n [Customers].[All Customers].[USA])},\n [Product].[All Products].Children))) ON rows  from [Sales]  where [Time].[1997]";
        Query query = connection.parseQuery("select {[Measures].[Unit Sales],\n [Measures].[Store Cost],\n [Measures].[Store Sales]} ON columns,\nHierarchize(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union(Union\n({([Gender].[All Gender],\n [Marital Status].[All Marital Status],\n [Customers].[All Customers],\n [Product].[All Products])},\n Crossjoin ([Gender].[All Gender].Children,\n {([Marital Status].[All Marital Status],\n [Customers].[All Customers],\n [Product].[All Products])})),\n Crossjoin(Crossjoin({[Gender].[All Gender].[F]},\n [Marital Status].[All Marital Status].Children),\n {([Customers].[All Customers],\n [Product].[All Products])})),\n Crossjoin(Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[M])},\n [Customers].[All Customers].Children),\n {[Product].[All Products]})),\n Crossjoin(Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[M])},\n [Customers].[All Customers].[USA].Children),\n {[Product].[All Products]})),\n Crossjoin ({([Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Customers].[All Customers].[USA].[CA])},\n   [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Customers].[All Customers].[USA].[OR])},\n   [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Customers].[All Customers].[USA].[WA])},\n   [Product].[All Products].Children)),\n Crossjoin ({([Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Customers].[All Customers].[USA])},\n   [Product].[All Products].Children)),\n Crossjoin(\n   Crossjoin({([Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S])}, [Customers].[All Customers].Children),\n   {[Product].[All Products]})),\n Crossjoin(Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[S])},\n [Customers].[All Customers].[USA].Children),\n {[Product].[All Products]})),\n Crossjoin ({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[S],\n [Customers].[All Customers].[USA].[CA])},\n [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[S],\n [Customers].[All Customers].[USA].[OR])},\n [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[S],\n [Customers].[All Customers].[USA].[WA])},\n [Product].[All Products].Children)),\n Crossjoin ({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status].[S],\n [Customers].[All Customers].[USA])},\n [Product].[All Products].Children)),\n Crossjoin(Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status])},\n [Customers].[All Customers].Children),\n {[Product].[All Products]})),\n Crossjoin(Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status])},\n [Customers].[All Customers].[USA].Children),\n {[Product].[All Products]})),\n Crossjoin ({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status],\n [Customers].[All Customers].[USA].[CA])},\n [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status],\n [Customers].[All Customers].[USA].[OR])},\n [Product].[All Products].Children)),\n Crossjoin({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status],\n [Customers].[All Customers].[USA].[WA])},\n [Product].[All Products].Children)),\n Crossjoin ({([Gender].[All Gender].[F],\n [Marital Status].[All Marital Status],\n [Customers].[All Customers].[USA])},\n [Product].[All Products].Children))) ON rows  from [Sales]  where [Time].[1997]");
        long afterParseMillis = System.currentTimeMillis();
        long afterParseNonDbMillis = afterParseMillis - Util.dbTimeMillis();
        long parseMillis = afterParseMillis - start;
        BasicQueryTest.assertTrue((String)("performance problem: parse took " + parseMillis + " milliseconds"), (parseMillis <= 10000L ? 1 : 0) != 0);
        Result result = connection.execute(query);
        BasicQueryTest.assertEquals((int)59, (int)result.getAxes()[1].getPositions().size());
        long afterExecMillis = System.currentTimeMillis();
        long afterExecNonDbMillis = afterExecMillis - Util.dbTimeMillis();
        long execNonDbMillis = afterExecNonDbMillis - afterParseNonDbMillis;
        long execMillis = afterExecMillis - afterParseMillis;
        BasicQueryTest.assertTrue((String)("performance problem: execute took " + execMillis + " milliseconds, " + execNonDbMillis + " milliseconds excluding db"), (execNonDbMillis <= 2000L && execMillis <= 30000L ? 1 : 0) != 0);
    }

    public void testCatalogHierarchyBasedOnView() {
        if (this.props.ReadAggregates.get()) {
            return;
        }
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Gender2\" foreignKey=\"customer_id\">\n  <Hierarchy hasAll=\"true\" allMemberName=\"All Gender\" primaryKey=\"customer_id\">\n    <View alias=\"gender2\">\n      <SQL dialect=\"generic\">\n        <![CDATA[SELECT * FROM customer]]>\n      </SQL>\n      <SQL dialect=\"oracle\">\n        <![CDATA[SELECT * FROM \"customer\"]]>\n      </SQL>\n      <SQL dialect=\"derby\">\n        <![CDATA[SELECT * FROM \"customer\"]]>\n      </SQL>\n      <SQL dialect=\"luciddb\">\n        <![CDATA[SELECT * FROM \"customer\"]]>\n      </SQL>\n      <SQL dialect=\"db2\">\n        <![CDATA[SELECT * FROM \"customer\"]]>\n      </SQL>\n      <SQL dialect=\"netezza\">\n        <![CDATA[SELECT * FROM \"customer\"]]>\n      </SQL>\n    </View>\n    <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>", null);
        if (!testContext.getDialect().allowsFromQuery()) {
            return;
        }
        testContext.assertAxisReturns("[Gender2].members", BasicQueryTest.fold("[Gender2].[All Gender]\n[Gender2].[All Gender].[F]\n[Gender2].[All Gender].[M]"));
    }

    public void testCatalogHierarchyBasedOnView2() {
        if (this.props.ReadAggregates.get()) {
            return;
        }
        if (this.getTestContext().getDialect().allowsFromQuery()) {
            return;
        }
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"ProductView\" foreignKey=\"product_id\">\n   <Hierarchy hasAll=\"true\" primaryKey=\"product_id\" primaryKeyTable=\"productView\">\n       <View alias=\"productView\">\n           <SQL dialect=\"db2\"><![CDATA[\nSELECT *\nFROM \"product\", \"product_class\"\nWHERE \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\n]]>\n           </SQL>\n           <SQL dialect=\"mssql\"><![CDATA[\nSELECT \"product\".\"product_id\",\n\"product\".\"brand_name\",\n\"product\".\"product_name\",\n\"product\".\"SKU\",\n\"product\".\"SRP\",\n\"product\".\"gross_weight\",\n\"product\".\"net_weight\",\n\"product\".\"recyclable_package\",\n\"product\".\"low_fat\",\n\"product\".\"units_per_case\",\n\"product\".\"cases_per_pallet\",\n\"product\".\"shelf_width\",\n\"product\".\"shelf_height\",\n\"product\".\"shelf_depth\",\n\"product_class\".\"product_class_id\",\n\"product_class\".\"product_subcategory\",\n\"product_class\".\"product_category\",\n\"product_class\".\"product_department\",\n\"product_class\".\"product_family\"\nFROM \"product\" inner join \"product_class\"\nON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\n]]>\n           </SQL>\n           <SQL dialect=\"mysql\"><![CDATA[\nSELECT `product`.`product_id`,\n`product`.`brand_name`,\n`product`.`product_name`,\n`product`.`SKU`,\n`product`.`SRP`,\n`product`.`gross_weight`,\n`product`.`net_weight`,\n`product`.`recyclable_package`,\n`product`.`low_fat`,\n`product`.`units_per_case`,\n`product`.`cases_per_pallet`,\n`product`.`shelf_width`,\n`product`.`shelf_height`,\n`product`.`shelf_depth`,\n`product_class`.`product_class_id`,\n`product_class`.`product_family`,\n`product_class`.`product_department`,\n`product_class`.`product_category`,\n`product_class`.`product_subcategory` \nFROM `product`, `product_class`\nWHERE `product`.`product_class_id` = `product_class`.`product_class_id`\n]]>\n           </SQL>\n           <SQL dialect=\"generic\"><![CDATA[\nSELECT *\nFROM \"product\", \"product_class\"\nWHERE \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\n]]>\n           </SQL>\n       </View>\n       <Level name=\"Product Family\" column=\"product_family\" uniqueMembers=\"true\"/>\n       <Level name=\"Product Department\" column=\"product_department\" uniqueMembers=\"false\"/>\n       <Level name=\"Product Category\" column=\"product_category\" uniqueMembers=\"false\"/>\n       <Level name=\"Product Subcategory\" column=\"product_subcategory\" uniqueMembers=\"false\"/>\n       <Level name=\"Brand Name\" column=\"brand_name\" uniqueMembers=\"false\"/>\n       <Level name=\"Product Name\" column=\"product_name\" uniqueMembers=\"true\"/>\n   </Hierarchy>\n</Dimension>");
        testContext.assertQueryReturns("select {[Measures].[Unit Sales]} on columns,\n {[ProductView].[Drink].[Beverages].children} on rows\nfrom Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[ProductView].[All ProductViews].[Drink].[Beverages].[Carbonated Beverages]}\n{[ProductView].[All ProductViews].[Drink].[Beverages].[Drinks]}\n{[ProductView].[All ProductViews].[Drink].[Beverages].[Hot Beverages]}\n{[ProductView].[All ProductViews].[Drink].[Beverages].[Pure Juice Beverages]}\nRow #0: 3,407\nRow #1: 2,469\nRow #2: 4,301\nRow #3: 3,396\n"));
    }

    public void testCountDistinct() {
        this.assertQueryReturns("select {[Measures].[Unit Sales], [Measures].[Customer Count]} on columns,\n {[Gender].members} on rows\nfrom Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Customer Count]}\nAxis #2:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 266,773\nRow #0: 5,581\nRow #1: 131,558\nRow #1: 2,755\nRow #2: 135,215\nRow #2: 2,826\n"));
    }

    public void testCountDistinctAgg() {
        boolean use_agg_orig = this.props.UseAggregates.get();
        boolean do_caching_orig = this.props.DisableCaching.get();
        this.props.DisableCaching.setString("true");
        this.assertQueryReturns("select {[Measures].[Unit Sales], [Measures].[Customer Count]} on rows,\nNON EMPTY {[Time].[1997].[Q1].[1]} ON COLUMNS\nfrom Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997].[Q1].[1]}\nAxis #2:\n{[Measures].[Unit Sales]}\n{[Measures].[Customer Count]}\nRow #0: 21,628\nRow #1: 1,396\n"));
        if (use_agg_orig) {
            this.props.UseAggregates.setString("false");
        } else {
            this.props.UseAggregates.setString("true");
        }
        this.assertQueryReturns("select {[Measures].[Unit Sales], [Measures].[Customer Count]} on rows,\nNON EMPTY {[Time].[1997].[Q1].[1]} ON COLUMNS\nfrom Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997].[Q1].[1]}\nAxis #2:\n{[Measures].[Unit Sales]}\n{[Measures].[Customer Count]}\nRow #0: 21,628\nRow #1: 1,396\n"));
        if (use_agg_orig) {
            this.props.UseAggregates.setString("true");
        } else {
            this.props.UseAggregates.setString("false");
        }
        if (do_caching_orig) {
            this.props.DisableCaching.setString("true");
        } else {
            this.props.DisableCaching.setString("false");
        }
    }

    public void testMemberWithNullKey() {
        if (!this.isDefaultNullMemberRepresentation()) {
            return;
        }
        Result result = this.executeQuery("select {[Measures].[Unit Sales]} on columns,\n{[Store Size in SQFT].members} on rows\nfrom Sales");
        String resultString = TestContext.toString(result);
        resultString = Pattern.compile("\\.0\\]").matcher(resultString).replaceAll("]");
        boolean nullsSortHigh = false;
        int row = 0;
        String expected = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store Size in SQFT].[All Store Size in SQFTs]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[#null]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[20319]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[21215]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[22478]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[23112]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[23593]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[23598]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[23688]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[23759]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[24597]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[27694]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[28206]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[30268]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[30584]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[30797]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[33858]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[34452]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[34791]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[36509]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[38382]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[39696]}\nRow #" + row++ + ": 266,773\n" + ("Row #" + row++ + ": 39,329\n") + "Row #" + row++ + ": 26,079\n" + "Row #" + row++ + ": 25,011\n" + "Row #" + row++ + ": 2,117\n" + "Row #" + row++ + ": \n" + "Row #" + row++ + ": \n" + "Row #" + row++ + ": 25,663\n" + "Row #" + row++ + ": 21,333\n" + "Row #" + row++ + ": \n" + "Row #" + row++ + ": \n" + "Row #" + row++ + ": 41,580\n" + "Row #" + row++ + ": 2,237\n" + "Row #" + row++ + ": 23,591\n" + "Row #" + row++ + ": \n" + "Row #" + row++ + ": \n" + "Row #" + row++ + ": 35,257\n" + "Row #" + row++ + ": \n" + "Row #" + row++ + ": \n" + "Row #" + row++ + ": \n" + "Row #" + row++ + ": \n" + "Row #" + row++ + ": 24,576\n" + "");
        BasicQueryTest.assertEquals((String)expected, (String)resultString);
    }

    public void testSlicerOverride() {
        this.assertQueryReturns("with member [Measures].[Radio Unit Sales] as \n '([Measures].[Unit Sales], [Promotion Media].[Radio])'\nselect {[Measures].[Unit Sales], [Measures].[Radio Unit Sales]} on columns,\n filter([Product].[Product Department].members, [Promotion Media].[Radio] > 50) on rows\nfrom Sales\nwhere ([Promotion Media].[Daily Paper], [Time].[1997].[Q1])", BasicQueryTest.fold("Axis #0:\n{[Promotion Media].[All Media].[Daily Paper], [Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Radio Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Snack Foods]}\nRow #0: 692\nRow #0: 87\nRow #1: 447\nRow #1: 63\n"));
    }

    public void testMembersOfLargeDimensionTheHardWay() {
        if (Bug.avoidMemoryOverflow(TestContext.instance().getDialect())) {
            return;
        }
        Connection connection = TestContext.instance().getFoodMartConnection();
        String queryString = "select {[Measures].[Unit Sales]} on columns,\n{[Customers].members} on rows\nfrom Sales";
        Query query = connection.parseQuery(queryString);
        Result result = connection.execute(query);
        BasicQueryTest.assertEquals((int)10407, (int)result.getAxes()[1].getPositions().size());
    }

    public void testUnparse() {
        Connection connection = this.getConnection();
        Query query = connection.parseQuery("with member [Measures].[Rendite] as \n '(([Measures].[Store Sales] - [Measures].[Store Cost])) / [Measures].[Store Cost]',\n format_string = iif(([Measures].[Store Sales] - [Measures].[Store Cost]) / [Measures].[Store Cost] * 100 > \n     Parameter (\"UpperLimit\", NUMERIC, 151, \"Obere Grenze\"), \n   \"|#.00%|arrow='up'\",\n   iif(([Measures].[Store Sales] - [Measures].[Store Cost]) / [Measures].[Store Cost] * 100 < \n       Parameter(\"LowerLimit\", NUMERIC, 150, \"Untere Grenze\"),\n     \"|#.00%|arrow='down'\",\n     \"|#.00%|arrow='right'\"))\nselect {[Measures].members} on columns\nfrom Sales");
        String s = Util.unparse(query);
        BasicQueryTest.assertEquals((String)BasicQueryTest.fold("with member [Measures].[Rendite] as '(([Measures].[Store Sales] - [Measures].[Store Cost]) / [Measures].[Store Cost])', format_string = IIf((((([Measures].[Store Sales] - [Measures].[Store Cost]) / [Measures].[Store Cost]) * 100.0) > Parameter(\"UpperLimit\", NUMERIC, 151.0, \"Obere Grenze\")), \"|#.00%|arrow='up'\", IIf((((([Measures].[Store Sales] - [Measures].[Store Cost]) / [Measures].[Store Cost]) * 100.0) < Parameter(\"LowerLimit\", NUMERIC, 150.0, \"Untere Grenze\")), \"|#.00%|arrow='down'\", \"|#.00%|arrow='right'\"))\nselect {[Measures].Members} ON COLUMNS\nfrom [Sales]\n"), (String)s);
    }

    public void testUnparse2() {
        Connection connection = this.getConnection();
        Query query = connection.parseQuery("with member [Measures].[Foo] as '1', format_string='##0.00', funny=IIf(1=1,\"x\"\"y\",\"foo\") select {[Measures].[Foo]} on columns from Sales");
        String s = query.toString();
        BasicQueryTest.assertEquals((String)BasicQueryTest.fold("with member [Measures].[Foo] as '1.0', format_string = \"##0.00\", funny = IIf((1.0 = 1.0), \"x\"\"y\", \"foo\")\nselect {[Measures].[Foo]} ON COLUMNS\nfrom [Sales]\n"), (String)s);
    }

    public void _testLookupCube() {
        this.assertQueryReturns("WITH MEMBER Measures.[Store Unit Sales] AS \n 'LookupCube(\"Sales\", \"(\" + MemberToStr(Store.CurrentMember) + \", Measures.[Unit Sales])\")'\nSELECT\n {Measures.Amount, Measures.[Store Unit Sales]} ON COLUMNS,\n Store.CA.CHILDREN ON ROWS\nFROM Budget", "");
    }

    public void testBasketAnalysis() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Qualified Count] AS\n 'COUNT(FILTER(DESCENDANTS(Customers.CURRENTMEMBER, [Customers].[Name]),\n               ([Measures].[Store Sales]) > 10000 OR ([Measures].[Unit Sales]) > 10))'\nMEMBER [Measures].[Qualified Sales] AS\n 'SUM(FILTER(DESCENDANTS(Customers.CURRENTMEMBER, [Customers].[Name]),\n             ([Measures].[Store Sales]) > 10000 OR ([Measures].[Unit Sales]) > 10),\n      ([Measures].[Store Sales]))'\nSELECT {[Measures].[Qualified Count], [Measures].[Qualified Sales]} ON COLUMNS,\n  DESCENDANTS([Customers].[All Customers], [State Province], SELF_AND_BEFORE) ON ROWS\nFROM Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Qualified Count]}\n{[Measures].[Qualified Sales]}\nAxis #2:\n{[Customers].[All Customers]}\n{[Customers].[All Customers].[Canada]}\n{[Customers].[All Customers].[Canada].[BC]}\n{[Customers].[All Customers].[Mexico]}\n{[Customers].[All Customers].[Mexico].[DF]}\n{[Customers].[All Customers].[Mexico].[Guerrero]}\n{[Customers].[All Customers].[Mexico].[Jalisco]}\n{[Customers].[All Customers].[Mexico].[Mexico]}\n{[Customers].[All Customers].[Mexico].[Oaxaca]}\n{[Customers].[All Customers].[Mexico].[Sinaloa]}\n{[Customers].[All Customers].[Mexico].[Veracruz]}\n{[Customers].[All Customers].[Mexico].[Yucatan]}\n{[Customers].[All Customers].[Mexico].[Zacatecas]}\n{[Customers].[All Customers].[USA]}\n{[Customers].[All Customers].[USA].[CA]}\n{[Customers].[All Customers].[USA].[OR]}\n{[Customers].[All Customers].[USA].[WA]}\nRow #0: 4,719.00\nRow #0: 553,587.77\nRow #1: .00\nRow #1: \nRow #2: .00\nRow #2: \nRow #3: .00\nRow #3: \nRow #4: .00\nRow #4: \nRow #5: .00\nRow #5: \nRow #6: .00\nRow #6: \nRow #7: .00\nRow #7: \nRow #8: .00\nRow #8: \nRow #9: .00\nRow #9: \nRow #10: .00\nRow #10: \nRow #11: .00\nRow #11: \nRow #12: .00\nRow #12: \nRow #13: 4,719.00\nRow #13: 553,587.77\nRow #14: 2,149.00\nRow #14: 151,509.69\nRow #15: 1,008.00\nRow #15: 141,899.84\nRow #16: 1,562.00\nRow #16: 260,178.24\n"));
    }

    public void testBasketAnalysisAfterFlush() {
        this.getConnection().getCacheControl(null).flushSchemaCache();
        this.testBasketAnalysis();
    }

    public void _testStringComparisons() {
        this.assertQueryReturns("SELECT {Measures.[Unit Sales]} ON COLUMNS,\n  FILTER([Product].[Product Name].MEMBERS,\n         INSTR(LCASE([Product].CURRENTMEMBER.NAME), \"fruit\") <> 0) ON ROWS \nFROM Sales", "");
    }

    public void testPercentagesAsMeasures() {
        this.assertQueryReturns("WITH MEMBER Measures.[Unit Sales Percent] AS\n  '((Store.CURRENTMEMBER, Measures.[Unit Sales]) /\n    (Store.CURRENTMEMBER.PARENT, Measures.[Unit Sales])) ',\n  FORMAT_STRING = 'Percent'\nSELECT {Measures.[Unit Sales], Measures.[Unit Sales Percent]} ON COLUMNS,\n  ORDER(DESCENDANTS(Store.[USA].[CA], Store.[Store City], SELF), \n        [Measures].[Unit Sales], ASC) ON ROWS\nFROM Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Unit Sales Percent]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Alameda]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\nRow #0: \nRow #0: \nRow #1: 2,117\nRow #1: 2.83%\nRow #2: 21,333\nRow #2: 28.54%\nRow #3: 25,635\nRow #3: 34.30%\nRow #4: 25,663\nRow #4: 34.33%\n"));
    }

    public void _testCumlativeSums() {
        this.assertQueryReturns("WITH MEMBER Measures.[Cumulative No of Employees] AS\n  'SUM(HEAD(ORDER({[Store].Siblings}, [Measures].[Number of Employees], BDESC) AS OrderedSiblings,\n            RANK([Store], OrderedSiblings)),\n       [Measures].[Number of Employees])'\nSELECT {[Measures].[Number of Employees], [Measures].[Cumulative No of Employees]} ON COLUMNS,\n  ORDER(DESCENDANTS([Store].[USA].[CA], [Store State], AFTER), \n        [Measures].[Number of Employees], BDESC) ON ROWS\nFROM HR", "");
    }

    public void testLogicalOps() {
        this.assertQueryReturns("WITH MEMBER [Product].[Food OR Drink] AS\n  '([Product].[Food], Measures.[Unit Sales]) + ([Product].[Drink], Measures.[Unit Sales])'\nSELECT {Measures.[Unit Sales]} ON COLUMNS,\n  DESCENDANTS(Time.[1997], [Quarter], SELF_AND_BEFORE) ON ROWS\nFROM Sales\nWHERE [Product].[Food OR Drink]", BasicQueryTest.fold("Axis #0:\n{[Product].[Food OR Drink]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Time].[1997]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q4]}\nRow #0: 216,537\nRow #1: 53,785\nRow #2: 50,720\nRow #3: 53,505\nRow #4: 58,527\n"));
    }

    public void testLogicalAnd() {
        this.assertQueryReturns("SELECT {Measures.[Unit Sales]} ON COLUMNS,\n  DESCENDANTS([Time].[1997], [Quarter], SELF_AND_BEFORE) ON ROWS\nFROM Sales\nWHERE ([Product].[Drink], [Store].[USA])", BasicQueryTest.fold("Axis #0:\n{[Product].[All Products].[Drink], [Store].[All Stores].[USA]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Time].[1997]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q4]}\nRow #0: 24,597\nRow #1: 5,976\nRow #2: 5,895\nRow #3: 6,065\nRow #4: 6,661\n"));
    }

    public void _testSet() {
        this.assertQueryReturns("WITH SET [Good AND Pearl Stores] AS\n  'FILTER(Store.Members,\n          ([Product].[Good], Measures.[Unit Sales]) > 0 AND \n          ([Product].[Pearl], Measures.[Unit Sales]) > 0)'\nSELECT DESCENDANTS([Time].[1997], [Quarter], SELF_AND_BEFORE) ON COLUMNS,\n  [Good AND Pearl Stores] ON ROWS\nFROM Sales", "");
    }

    public void testCustomMemberProperties() {
        this.assertQueryReturns("SELECT {[Measures].[Units Shipped], [Measures].[Units Ordered]} ON COLUMNS,\n  NON EMPTY [Store].[Store Name].MEMBERS\n    DIMENSION PROPERTIES [Store].[Store Name].[Store Sqft] ON ROWS\nFROM Warehouse", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Units Shipped]}\n{[Measures].[Units Ordered]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nRow #0: 10759.0\nRow #0: 11699.0\nRow #1: 24587.0\nRow #1: 26463.0\nRow #2: 23835.0\nRow #2: 26270.0\nRow #3: 1696.0\nRow #3: 1875.0\nRow #4: 8515.0\nRow #4: 9109.0\nRow #5: 32393.0\nRow #5: 35797.0\nRow #6: 2348.0\nRow #6: 2454.0\nRow #7: 22734.0\nRow #7: 24610.0\nRow #8: 24110.0\nRow #8: 26703.0\nRow #9: 11889.0\nRow #9: 12828.0\nRow #10: 32411.0\nRow #10: 35930.0\nRow #11: 1860.0\nRow #11: 2074.0\nRow #12: 10589.0\nRow #12: 11426.0\n"));
    }

    public void _testMemberPropertyAsCalcMember() {
        this.assertQueryReturns("WITH MEMBER Measures.[Store SqFt] AS '[Store].CURRENTMEMBER.PROPERTIES(\"Store SQFT\")'\nSELECT { [Measures].[Store SQFT], [Measures].[Units Shipped], [Measures].[Units Ordered] }  ON COLUMNS,\n  [Store].[Store Name].MEMBERS ON ROWS\nFROM Warehouse", "");
    }

    public void _testDrillingDownMoreThanOneLevel() {
        this.assertQueryReturns("SELECT  {[Measures].[Unit Sales]} ON COLUMNS,\n  EXCEPT(GENERATE([Customers].[Country].MEMBERS,\n                  {DESCENDANTS([Customers].CURRENTMEMBER, [Customers].[City], SELF_AND_BEFORE)}),\n         {[Customers].[State Province].MEMBERS}) ON ROWS\nFROM Sales", "");
    }

    public void _testTopmost() {
        this.assertQueryReturns("WITH MEMBER Measures.[Country Name] AS \n  'Ancestor(Store.CurrentMember, [Store Country]).Name'\nSELECT {Measures.[Country Name], Measures.[Unit Sales]} ON COLUMNS,\n  GENERATE([Store Country].MEMBERS, \n    TOPCOUNT(DESCENDANTS([Store].CURRENTMEMBER, [Store].[Store Name]),\n      1, [Measures].[Unit Sales])) ON ROWS\nFROM Sales", "");
    }

    public void testTopmost2() {
        this.assertQueryReturns("SELECT {Measures.[Unit Sales]} ON COLUMNS,\n  CROSSJOIN(Customers.CHILDREN,\n    TOPCOUNT(DESCENDANTS([Store].CURRENTMEMBER, [Store].[Store Name]),\n             1, [Measures].[Unit Sales])) ON ROWS\nFROM Sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Customers].[All Customers].[Canada], [Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Customers].[All Customers].[Mexico], [Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Customers].[All Customers].[USA], [Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\nRow #0: \nRow #1: \nRow #2: 41,580\n"));
    }

    public void testRank() {
        this.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS, \n  ORDER([Store].[Store Name].MEMBERS, (Measures.[Unit Sales]), BDESC) ON ROWS\nFROM Sales\nWHERE [Product].[Non-Consumable]", BasicQueryTest.fold("Axis #0:\n{[Product].[All Products].[Non-Consumable]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[Canada].[BC].[Vancouver].[Store 19]}\n{[Store].[All Stores].[Canada].[BC].[Victoria].[Store 20]}\n{[Store].[All Stores].[Mexico].[DF].[Mexico City].[Store 9]}\n{[Store].[All Stores].[Mexico].[DF].[San Andres].[Store 21]}\n{[Store].[All Stores].[Mexico].[Guerrero].[Acapulco].[Store 1]}\n{[Store].[All Stores].[Mexico].[Jalisco].[Guadalajara].[Store 5]}\n{[Store].[All Stores].[Mexico].[Veracruz].[Orizaba].[Store 10]}\n{[Store].[All Stores].[Mexico].[Yucatan].[Merida].[Store 8]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Camacho].[Store 4]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo].[Store 12]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo].[Store 18]}\n{[Store].[All Stores].[USA].[CA].[Alameda].[HQ]}\nRow #0: 7,940\nRow #1: 6,712\nRow #2: 5,076\nRow #3: 4,947\nRow #4: 4,706\nRow #5: 4,639\nRow #6: 4,479\nRow #7: 4,428\nRow #8: 3,950\nRow #9: 2,140\nRow #10: 442\nRow #11: 390\nRow #12: 387\nRow #13: \nRow #14: \nRow #15: \nRow #16: \nRow #17: \nRow #18: \nRow #19: \nRow #20: \nRow #21: \nRow #22: \nRow #23: \nRow #24: \n"));
    }

    public void testDifferentCalculationsForDifferentLevels() {
        this.assertQueryReturns("WITH MEMBER Measures.[Average Units Ordered] AS\n  'AVG(DESCENDANTS([Store].CURRENTMEMBER, [Store].[Store Name]), [Measures].[Units Ordered])',\n  FORMAT_STRING='#.00'\nSELECT {[Measures].[Units ordered], Measures.[Average Units Ordered]} ON COLUMNS,\n  [Store].[Store State].MEMBERS ON ROWS\nFROM Warehouse", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Units Ordered]}\n{[Measures].[Average Units Ordered]}\nAxis #2:\n{[Store].[All Stores].[Canada].[BC]}\n{[Store].[All Stores].[Mexico].[DF]}\n{[Store].[All Stores].[Mexico].[Guerrero]}\n{[Store].[All Stores].[Mexico].[Jalisco]}\n{[Store].[All Stores].[Mexico].[Veracruz]}\n{[Store].[All Stores].[Mexico].[Yucatan]}\n{[Store].[All Stores].[Mexico].[Zacatecas]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: \nRow #0: \nRow #1: \nRow #1: \nRow #2: \nRow #2: \nRow #3: \nRow #3: \nRow #4: \nRow #4: \nRow #5: \nRow #5: \nRow #6: \nRow #6: \nRow #7: 66307.0\nRow #7: 16576.75\nRow #8: 44906.0\nRow #8: 22453.00\nRow #9: 116025.0\nRow #9: 16575.00\n"));
    }

    public void testDifferentCalculations2() {
        this.assertQueryReturns("WITH MEMBER Measures.[Average Units Ordered] AS\n  'AVG(DESCENDANTS([Store].CURRENTMEMBER, [Store].[Store Name]), [Measures].[Units Ordered])'\nSELECT {[Measures].[Units ordered], Measures.[Average Units Ordered]} ON COLUMNS,\n  [Product].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].CHILDREN ON ROWS\nFROM Warehouse\nWHERE [Store].[USA].[CA]", BasicQueryTest.fold("Axis #0:\n{[Store].[All Stores].[USA].[CA]}\nAxis #1:\n{[Measures].[Units Ordered]}\n{[Measures].[Average Units Ordered]}\nAxis #2:\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Pearl]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus]}\nRow #0: \nRow #0: \nRow #1: 151.0\nRow #1: 75.5\nRow #2: 95.0\nRow #2: 95.0\nRow #3: \nRow #3: \nRow #4: 211.0\nRow #4: 105.5\n"));
    }

    public void _testDifferentCalculationsForDifferentDimensions() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Avg Units Shipped] AS\n  '[Measures].[Units Shipped] / \n    COUNT(DESCENDANTS([Time].CURRENTMEMBER, [Time].[Month], SELF))'\nSELECT {Measures.[Units Shipped], Measures.[Avg Units Shipped]} ON COLUMNS,\nNONEMPTYCROSSJOIN(Store.CA.Children, Product.MEMBERS) ON ROWS\nFROM Warehouse", "");
    }

    public void _testDifferentCalculationsForDifferentDimensions2() {
        this.assertQueryReturns("WITH MEMBER Measures.[Closing Balance] AS\n  '([Measures].[Units Ordered], \n    CLOSINGPERIOD([Time].[Month], [Time].CURRENTMEMBER)) -\n   ([Measures].[Units Shipped], \n    CLOSINGPERIOD([Time].[Month], [Time].CURRENTMEMBER))'\nSELECT {[Measures].[Closing Balance]} ON COLUMNS,\n  Product.MEMBERS ON ROWS\nFROM Warehouse", "");
    }

    public void _testDateRange() {
        this.assertQueryReturns("WITH MEMBER [Time].[1997].[Six Month] AS\n  'SUM([Time].[1]:[Time].[6])'\nMEMBER [Time].[1997].[Nine Month] AS\n  'SUM([Time].[1]:[Time].[9])'\nSELECT AddCalculatedMembers([Time].[1997].Children) ON COLUMNS,\n  [Product].Children ON ROWS\nFROM Sales", "");
    }

    public void _testRolling() {
        this.assertQueryReturns(BasicQueryTest.fold("WITH SET Rolling12 AS\n  'LASTPERIODS(12, TAIL(FILTER([Time].[Month].MEMBERS, \n    ([Customers].[All Customers], \n    [Education Level].[All Education Level],\n    [Gender].[All Gender],\n    [Marital Status].[All Marital Status],\n    [Product].[All Products], \n    [Promotion Media].[All Media],\n    [Promotions].[All Promotions],\n    [Store].[All Stores],\n    [Store Size in SQFT].[All Store Size in SQFT],\n    [Store Type].[All Store Type],\n    [Yearly Income].[All Yearly Income],\n    Measures.[Unit Sales]) >0),\n  1).ITEM(0).ITEM(0))'\nSELECT {[Measures].[Unit Sales]} ON COLUMNS, \n  Rolling12 ON ROWS\nFROM Sales"), "");
    }

    public void testDifferentCalcsForDifferentTimePeriods() {
        this.assertQueryReturns("WITH MEMBER [Product].[Drink Forecast - Standard] AS\n  '[Product].[All Products].[Drink] * 2'\nMEMBER [Product].[Drink Forecast - Dynamic] AS \n  '[Product].[All Products].[Drink] * \n   IIF([Time].CurrentMember.Name = \"1\", 1.2,\n     IIF([Time].CurrentMember.Name = \"2\", 1.3,\n       IIF([Time].CurrentMember.Name = \"3\", 1.4,\n         IIF([Time].CurrentMember.Name = \"4\", 1.6,\n           IIF([Time].CurrentMember.Name = \"5\", 2.1,\n             IIF([Time].CurrentMember.Name = \"6\", 2.4,\n               IIF([Time].CurrentMember.Name = \"7\", 2.6,\n                 IIF([Time].CurrentMember.Name = \"8\", 2.3,\n                   IIF([Time].CurrentMember.Name = \"9\", 1.9,\n                     IIF([Time].CurrentMember.Name = \"10\", 1.5,\n                       IIF([Time].CurrentMember.Name = \"11\", 1.4,\n                         IIF([Time].CurrentMember.Name = \"12\", 1.2, 1.0))))))))))))'\nSELECT DESCENDANTS(Time.[1997], [Month], SELF) ON COLUMNS, \n  {[Product].CHILDREN, [Product].[Drink Forecast - Standard], [Product].[Drink Forecast - Dynamic]} ON ROWS\nFROM Warehouse", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[5]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3].[8]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4].[11]}\n{[Time].[1997].[Q4].[12]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\n{[Product].[Drink Forecast - Standard]}\n{[Product].[Drink Forecast - Dynamic]}\nRow #0: 881.847\nRow #0: 579.051\nRow #0: 476.292\nRow #0: 618.722\nRow #0: 778.886\nRow #0: 636.935\nRow #0: 937.842\nRow #0: 767.332\nRow #0: 920.707\nRow #0: 1,007.764\nRow #0: 820.808\nRow #0: 792.167\nRow #1: 8,383.446\nRow #1: 4,851.406\nRow #1: 5,353.188\nRow #1: 6,061.829\nRow #1: 6,039.282\nRow #1: 5,259.242\nRow #1: 6,902.01\nRow #1: 5,790.772\nRow #1: 8,167.053\nRow #1: 6,188.732\nRow #1: 5,344.845\nRow #1: 5,025.744\nRow #2: 2,040.396\nRow #2: 1,269.816\nRow #2: 1,460.686\nRow #2: 1,696.757\nRow #2: 1,397.035\nRow #2: 1,578.136\nRow #2: 1,671.046\nRow #2: 1,609.447\nRow #2: 2,059.617\nRow #2: 1,617.493\nRow #2: 1,909.713\nRow #2: 1,382.364\nRow #3: 1,763.693\nRow #3: 1,158.102\nRow #3: 952.584\nRow #3: 1,237.444\nRow #3: 1,557.773\nRow #3: 1,273.87\nRow #3: 1,875.685\nRow #3: 1,534.665\nRow #3: 1,841.414\nRow #3: 2,015.528\nRow #3: 1,641.615\nRow #3: 1,584.334\nRow #4: 1,058.216\nRow #4: 752.766\nRow #4: 666.809\nRow #4: 989.955\nRow #4: 1,635.661\nRow #4: 1,528.644\nRow #4: 2,438.39\nRow #4: 1,764.865\nRow #4: 1,749.343\nRow #4: 1,511.646\nRow #4: 1,149.13\nRow #4: 950.601\n"));
    }

    public void _testDc4dtp2() {
        this.assertQueryReturns("WITH MEMBER [Product].[Drink Forecast - Standard] AS\n  '[Product].[All Products].[Drink] * 2'\nMEMBER [Product].[Drink Forecast - Dynamic] AS \n  '[Product].[All Products].[Drink] * \n   [Time].CURRENTMEMBER.PROPERTIES(\"Dynamic Forecast Multiplier\")'\nSELECT DESCENDANTS(Time.[1997], [Month], SELF) ON COLUMNS, \n  {[Product].CHILDREN, [Drink Forecast - Standard], [Drink Forecast - Dynamic]} ON ROWS\nFROM Warehouse", "");
    }

    public void _testWarehouseProfit() {
        this.assertQueryReturns("select \n{[Measures].[Warehouse Cost], [Measures].[Warehouse Sales], [Measures].[Warehouse Profit]}\n ON COLUMNS from [Warehouse]", "");
    }

    public void _testYtdGrowth() {
        this.assertQueryReturns("WITH MEMBER [Measures].[YTD Unit Sales] AS\n  'COALESCEEMPTY(SUM(YTD(), [Measures].[Unit Sales]), 0)'\nMEMBER [Measures].[Previous YTD Unit Sales] AS\n  '(Measures.[YTD Unit Sales], PARALLELPERIOD([Time].[Year]))'\nMEMBER [Measures].[YTD Growth] AS\n  '[Measures].[YTD Unit Sales] - ([Measures].[Previous YTD Unit Sales])'\nSELECT {[Time].[1998]} ON COLUMNS,\n  {[Measures].[YTD Unit Sales], [Measures].[Previous YTD Unit Sales], [Measures].[YTD Growth]} ON ROWS\nFROM Sales ", "");
    }

    public void dont_testParallelMutliple() {
        for (int i = 0; i < 5; ++i) {
            this.runParallelQueries(1, 1, false);
            this.runParallelQueries(3, 2, false);
            this.runParallelQueries(4, 6, true);
            this.runParallelQueries(6, 10, false);
        }
    }

    public void dont_testParallelNot() {
        this.runParallelQueries(1, 1, false);
    }

    public void dont_testParallelSomewhat() {
        this.runParallelQueries(3, 2, false);
    }

    public void dont_testParallelFlushCache() {
        this.runParallelQueries(4, 6, true);
    }

    public void dont_testParallelVery() {
        this.runParallelQueries(6, 10, false);
    }

    private void runParallelQueries(int threadCount, final int iterationCount, final boolean flush) {
        long timeoutMs = (long)threadCount * (long)iterationCount * 600L * 1000L;
        final int[] executeCount = new int[]{0};
        final ArrayList<FoodMartTestCase.QueryAndResult> queries = new ArrayList<FoodMartTestCase.QueryAndResult>();
        queries.addAll(Arrays.asList(sampleQueries));
        queries.addAll(taglibQueries);
        TestCaseForker threaded = new TestCaseForker(this, timeoutMs, threadCount, new ChooseRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run(int i) {
                int j = 0;
                while (j < iterationCount) {
                    int queryIndex = (i * 2 + j) % queries.size();
                    try {
                        FoodMartTestCase.QueryAndResult query = (FoodMartTestCase.QueryAndResult)queries.get(queryIndex);
                        BasicQueryTest.this.assertQueryReturns(query.query, query.result);
                        if (flush && i == 0) {
                            BasicQueryTest.this.getConnection().getCacheControl(null).flushSchemaCache();
                        }
                        int[] nArray = executeCount;
                        // MONITORENTER : executeCount
                        executeCount[0] = executeCount[0] + 1;
                        // MONITOREXIT : nArray
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        throw Util.newInternal(e, "Thread #" + i + " failed while executing query #" + queryIndex);
                    }
                    ++j;
                }
            }
        });
        threaded.run();
        BasicQueryTest.assertEquals((String)"number of executions", (int)(threadCount * iterationCount), (int)executeCount[0]);
    }

    public void testDependsOn() {
        this.assertQueryReturns("with member [Customers].[my] as \n  'Aggregate(Filter([Customers].[City].Members, (([Measures].[Unit Sales] / ([Measures].[Unit Sales], [Product].[All Products])) > 0.1)))' \nselect  \n  {[Measures].[Unit Sales]} ON columns, \n  {[Product].[All Products].[Food].[Deli], [Product].[All Products].[Food].[Frozen Foods]} ON rows \nfrom [Sales] \nwhere ([Customers].[my], [Time].[1997])\n", BasicQueryTest.fold("Axis #0:\n{[Customers].[my], [Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Deli]}\n{[Product].[All Products].[Food].[Frozen Foods]}\nRow #0: 13\nRow #1: 15,111\n"));
    }

    public void testFilterWithCrossJoin() throws Exception {
        String queryWithFilter = "WITH SET [#DataSet#] AS 'Filter(Crossjoin({[Store].[All Stores]}, {[Customers].[All Customers]}), [Measures].[Unit Sales] > 5)' MEMBER [Customers].[#GT#] as 'Aggregate({[#DataSet#]})' MEMBER [Store].[#GT#] as 'Aggregate({[#DataSet#]})' SET [#GrandTotalSet#] as 'Crossjoin({[Store].[#GT#]}, {[Customers].[#GT#]})' SELECT {[Measures].[Unit Sales]} on columns, Union([#GrandTotalSet#], Hierarchize({[#DataSet#]})) on rows FROM [Sales]";
        String queryWithoutFilter = "WITH SET [#DataSet#] AS 'Crossjoin({[Store].[All Stores]}, {[Customers].[All Customers]})' SET [#GrandTotalSet#] as 'Crossjoin({[Store].[All Stores]}, {[Customers].[All Customers]})' SELECT {[Measures].[Unit Sales]} on columns, Union([#GrandTotalSet#], Hierarchize({[#DataSet#]})) on rows FROM [Sales]";
        String wrongResultWithFilter = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[#GT#], [Customers].[#GT#]}\nRow #0: \n";
        String expectedResultWithFilter = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[#GT#], [Customers].[#GT#]}\n{[Store].[All Stores], [Customers].[All Customers]}\nRow #0: 266,773\nRow #1: 266,773\n";
        String expectedResultWithoutFilter = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores], [Customers].[All Customers]}\nRow #0: 266,773\n";
        this.assertQueryReturns(queryWithFilter, BasicQueryTest.fold(expectedResultWithFilter));
        this.assertQueryReturns(queryWithoutFilter, BasicQueryTest.fold(expectedResultWithoutFilter));
        this.assertQueryReturns(queryWithFilter, BasicQueryTest.fold(expectedResultWithFilter));
    }

    public void testFilteredCrossJoin() {
        this.getConnection().getCacheControl(null).flushSchemaCache();
        Result result = this.executeQuery("select {[Measures].[Store Sales]} on columns,\n  NON EMPTY Crossjoin(\n    Filter([Customers].[Name].Members,\n      (([Measures].[Store Sales],\n        [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],\n        [Time].[1997].[Q1].[1]) > 5.0)),\n    Filter([Product].[Product Name].Members,\n      (([Measures].[Store Sales],\n        [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],\n        [Time].[1997].[Q1].[1]) > 5.0))\n ) ON rows\nfrom [Sales]\nwhere (\n  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],\n  [Time].[1997].[Q1].[1]\n)\n");
        Axis a = result.getAxes()[1];
        BasicQueryTest.assertEquals((int)12, (int)a.getPositions().size());
    }

    public void testNonEmptyCrossJoin() {
        if (!this.props.EnableNativeCrossJoin.get()) {
            return;
        }
        this.getConnection().getCacheControl(null).flushSchemaCache();
        Result result = this.executeQuery("select {[Measures].[Store Sales]} on columns,\n  NON EMPTY Crossjoin(\n    [Customers].[Name].Members,\n    [Product].[Product Name].Members\n ) ON rows\nfrom [Sales]\nwhere (\n  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],\n  [Time].[1997].[Q1].[1]\n)\n");
        Axis a = result.getAxes()[1];
        BasicQueryTest.assertEquals((int)67, (int)a.getPositions().size());
    }

    public void testNonEmptyNonEmptyCrossJoin1() {
        this.getConnection().getCacheControl(null).flushSchemaCache();
        Result result = this.executeQuery("select {[Education Level].[All Education Levels].[Graduate Degree]} on columns,\n   CrossJoin(\n      {[Store Type].[Store Type].members},\n      {[Promotions].[Promotion Name].members})\n   on rows\nfrom Sales\nwhere ([Customers].[All Customers].[USA].[WA].[Anacortes])\n");
        Axis a = result.getAxes()[1];
        BasicQueryTest.assertEquals((int)306, (int)a.getPositions().size());
    }

    public void testNonEmptyNonEmptyCrossJoin2() {
        this.getConnection().getCacheControl(null).flushSchemaCache();
        Result result = this.executeQuery("select {[Education Level].[All Education Levels].[Graduate Degree]} on columns,\n   NonEmptyCrossJoin(\n      {[Store Type].[Store Type].members},\n      {[Promotions].[Promotion Name].members})\n   on rows\nfrom Sales\nwhere ([Customers].[All Customers].[USA].[WA].[Anacortes])\n");
        Axis a = result.getAxes()[1];
        BasicQueryTest.assertEquals((int)10, (int)a.getPositions().size());
    }

    public void testNonEmptyNonEmptyCrossJoin3() {
        this.getConnection().getCacheControl(null).flushSchemaCache();
        Result result = this.executeQuery("select {[Education Level].[All Education Levels].[Graduate Degree]} on columns,\n   Non Empty CrossJoin(\n      {[Store Type].[Store Type].members},\n      {[Promotions].[Promotion Name].members})\n   on rows\nfrom Sales\nwhere ([Customers].[All Customers].[USA].[WA].[Anacortes])\n");
        Axis a = result.getAxes()[1];
        BasicQueryTest.assertEquals((int)1, (int)a.getPositions().size());
    }

    public void testNonEmptyNonEmptyCrossJoin4() {
        this.getConnection().getCacheControl(null).flushSchemaCache();
        Result result = this.executeQuery("select {[Education Level].[All Education Levels].[Graduate Degree]} on columns,\n   Non Empty NonEmptyCrossJoin(\n      {[Store Type].[Store Type].members},\n      {[Promotions].[Promotion Name].members})\n   on rows\nfrom Sales\nwhere ([Customers].[All Customers].[USA].[WA].[Anacortes])\n");
        Axis a = result.getAxes()[1];
        BasicQueryTest.assertEquals((int)1, (int)a.getPositions().size());
    }

    public void testHierDifferentKeyClass() {
        Result result = this.executeQuery("with member [Time].[1997].[Q1].[xxx] as\n'Aggregate({[Time].[1997].[Q1].[1], [Time].[1997].[Q1].[2]})'\nselect {[Measures].[Unit Sales], [Measures].[Store Cost],\n[Measures].[Store Sales]} ON columns,\nHierarchize(Union(Union({[Time].[1997], [Time].[1998],\n[Time].[1997].[Q1].[xxx]}, [Time].[1997].Children),\n[Time].[1997].[Q1].Children)) ON rows from [Sales]");
        Axis a = result.getAxes()[1];
        BasicQueryTest.assertEquals((int)10, (int)a.getPositions().size());
    }

    public void testOverlappingCalculatedMembers() {
        String query = "WITH MEMBER [Store].[Total] AS 'SUM([Store].[Store Country].MEMBERS)' MEMBER [Store Type].[Total] AS 'SUM([Store Type].[Store Type].MEMBERS)' MEMBER [Gender].[Total] AS 'SUM([Gender].[Gender].MEMBERS)' MEMBER [Measures].[x] AS '[Measures].[Store Sales]' SELECT {[Measures].[x]} ON COLUMNS , { ([Store].[Total], [Store Type].[Total], [Gender].[Total]) } ON ROWS FROM Sales";
        String desiredResult = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[x]}\nAxis #2:\n{[Store].[Total], [Store Type].[Total], [Gender].[Total]}\nRow #0: 565,238.13\n");
        this.assertQueryReturns(query, desiredResult);
    }

    public void testEmptyProperty() {
        String query = "select     {[Measures].[Unit Sales]} on columns, filter([Store].[Store Name].members,[Store].currentmember.properties(\"Store Manager\")=\"Smith\") on rows from Sales";
        String desiredResult = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\nRow #0: 2,237\n");
        this.assertQueryReturns(query, desiredResult);
    }

    public void _testCubeWhichUsesSameSharedDimTwice() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<DimensionUsage name=\"Other Store\" source=\"Store\" foreignKey=\"unit_sales\" />");
        Axis axis = testContext.executeAxis("[Other Store].members");
        BasicQueryTest.assertEquals((int)63, (int)axis.getPositions().size());
        axis = testContext.executeAxis("[Store].members");
        BasicQueryTest.assertEquals((int)63, (int)axis.getPositions().size());
        String q1 = "select {[Measures].[Unit Sales]} on columns,\n NON EMPTY {[Other Store].members} on rows\nfrom [Sales]";
        testContext.assertQueryReturns("select {[Measures].[Unit Sales]} on columns,\n NON EMPTY {[Other Store].members} on rows\nfrom [Sales]", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Other Store].[All Other Stores]}\n{[Other Store].[All Other Stores].[Mexico]}\n{[Other Store].[All Other Stores].[USA]}\n{[Other Store].[All Other Stores].[Mexico].[Guerrero]}\n{[Other Store].[All Other Stores].[Mexico].[Jalisco]}\n{[Other Store].[All Other Stores].[Mexico].[Zacatecas]}\n{[Other Store].[All Other Stores].[USA].[CA]}\n{[Other Store].[All Other Stores].[USA].[WA]}\n{[Other Store].[All Other Stores].[Mexico].[Guerrero].[Acapulco]}\n{[Other Store].[All Other Stores].[Mexico].[Jalisco].[Guadalajara]}\n{[Other Store].[All Other Stores].[Mexico].[Zacatecas].[Camacho]}\n{[Other Store].[All Other Stores].[USA].[CA].[Beverly Hills]}\n{[Other Store].[All Other Stores].[USA].[WA].[Bellingham]}\n{[Other Store].[All Other Stores].[USA].[WA].[Bremerton]}\n{[Other Store].[All Other Stores].[Mexico].[Guerrero].[Acapulco].[Store 1]}\n{[Other Store].[All Other Stores].[Mexico].[Jalisco].[Guadalajara].[Store 5]}\n{[Other Store].[All Other Stores].[Mexico].[Zacatecas].[Camacho].[Store 4]}\n{[Other Store].[All Other Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Other Store].[All Other Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Other Store].[All Other Stores].[USA].[WA].[Bremerton].[Store 3]}\nRow #0: 266,773\nRow #1: 110,822\nRow #2: 155,951\nRow #3: 1,827\nRow #4: 14,915\nRow #5: 94,080\nRow #6: 222\nRow #7: 155,729\nRow #8: 1,827\nRow #9: 14,915\nRow #10: 94,080\nRow #11: 222\nRow #12: 39,362\nRow #13: 116,367\nRow #14: 1,827\nRow #15: 14,915\nRow #16: 94,080\nRow #17: 222\nRow #18: 39,362\nRow #19: 116,367\n"));
        String q2 = BasicQueryTest.fold("select {[Measures].[Unit Sales]} on columns,\n CrossJoin(\n  {[Store].[USA], [Store].[USA].[CA], [Store].[USA].[OR].[Portland]}, \n  {[Other Store].[USA], [Other Store].[USA].[CA], [Other Store].[USA].[OR].[Portland]}) on rows\nfrom [Sales]");
        testContext.assertQueryReturns(q2, BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA], [Other Store].[All Other Stores].[USA]}\n{[Store].[All Stores].[USA], [Other Store].[All Other Stores].[USA].[CA]}\n{[Store].[All Stores].[USA], [Other Store].[All Other Stores].[USA].[OR].[Portland]}\n{[Store].[All Stores].[USA].[CA], [Other Store].[All Other Stores].[USA]}\n{[Store].[All Stores].[USA].[CA], [Other Store].[All Other Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[CA], [Other Store].[All Other Stores].[USA].[OR].[Portland]}\n{[Store].[All Stores].[USA].[OR].[Portland], [Other Store].[All Other Stores].[USA]}\n{[Store].[All Stores].[USA].[OR].[Portland], [Other Store].[All Other Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR].[Portland], [Other Store].[All Other Stores].[USA].[OR].[Portland]}\nRow #0: 155,951\nRow #1: 222\nRow #2: \nRow #3: 43,730\nRow #4: 66\nRow #5: \nRow #6: 15,134\nRow #7: 24\nRow #8: \n"));
        Result result = this.executeQuery(q2);
        Cell cell = result.getCell(new int[]{0, 0});
        String sql = cell.getDrillThroughSQL(false);
        sql = sql.replace('\"', '`');
        String tableQualifier = "as ";
        Dialect dialect = this.getTestContext().getDialect();
        if (dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ORACLE) {
            tableQualifier = "";
        }
        BasicQueryTest.assertEquals((String)("select `store`.`store_country` as `Store Country`, `time_by_day`.`the_year` as `Year`, `store_1`.`store_country` as `x0`, `sales_fact_1997`.`unit_sales` as `Unit Sales` from `store` " + tableQualifier + "`store`," + " `sales_fact_1997` " + tableQualifier + "`sales_fact_1997`," + " `time_by_day` " + tableQualifier + "`time_by_day`," + " `store` " + tableQualifier + "`store_1` " + "where `sales_fact_1997`.`store_id` = `store`.`store_id`" + " and `store`.`store_country` = 'USA'" + " and `sales_fact_1997`.`time_id` = `time_by_day`.`time_id`" + " and `time_by_day`.`the_year` = 1997" + " and `sales_fact_1997`.`unit_sales` = `store_1`.`store_id`" + " and `store_1`.`store_country` = 'USA'"), (String)sql);
    }

    public void testMemberVisibility() {
        String cubeName = "Sales_MemberVis";
        TestContext testContext = TestContext.create(null, "<Cube name=\"" + cubeName + "\">\n" + "  <Table name=\"sales_fact_1997\"/>\n" + "  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n" + "      formatString=\"Standard\" visible=\"false\"/>\n" + "  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"\n" + "      formatString=\"#,###.00\"/>\n" + "  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n" + "      formatString=\"#,###.00\"/>\n" + "  <Measure name=\"Sales Count\" column=\"product_id\" aggregator=\"count\"\n" + "      formatString=\"#,###\"/>\n" + "  <Measure name=\"Customer Count\" column=\"customer_id\"\n" + "      aggregator=\"distinct-count\" formatString=\"#,###\"/>\n" + "  <CalculatedMember\n" + "      name=\"Profit\"\n" + "      dimension=\"Measures\"\n" + "      visible=\"false\"\n" + "      formula=\"[Measures].[Store Sales]-[Measures].[Store Cost]\">\n" + "    <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"$#,##0.00\"/>\n" + "  </CalculatedMember>\n" + "</Cube>", null, null, null, null);
        SchemaReader scr = testContext.getConnection().getSchema().lookupCube(cubeName, true).getSchemaReader(null);
        Member member = scr.getMemberByUniqueName(Id.Segment.toList("Measures", "Unit Sales"), true);
        Object visible = member.getPropertyValue(Property.VISIBLE.name);
        BasicQueryTest.assertEquals((Object)Boolean.FALSE, (Object)visible);
        member = scr.getMemberByUniqueName(Id.Segment.toList("Measures", "Store Cost"), true);
        visible = member.getPropertyValue(Property.VISIBLE.name);
        BasicQueryTest.assertEquals((Object)Boolean.TRUE, (Object)visible);
        member = scr.getMemberByUniqueName(Id.Segment.toList("Measures", "Profit"), true);
        visible = member.getPropertyValue(Property.VISIBLE.name);
        BasicQueryTest.assertEquals((Object)Boolean.FALSE, (Object)visible);
    }

    public void testAllMemberCaption() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Gender3\" foreignKey=\"customer_id\">\n  <Hierarchy hasAll=\"true\" allMemberName=\"All Gender\"\n allMemberCaption=\"Frauen und Maenner\" primaryKey=\"customer_id\">\n  <Table name=\"customer\"/>\n    <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        String mdx = "select {[Gender3].[All Gender]} on columns from Sales";
        Result result = testContext.executeQuery(mdx);
        Axis axis0 = result.getAxes()[0];
        Position pos0 = axis0.getPositions().get(0);
        Member allGender = (Member)pos0.get(0);
        String caption = allGender.getCaption();
        Assert.assertEquals((String)caption, (String)"Frauen und Maenner");
    }

    public void testAllLevelName() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Gender4\" foreignKey=\"customer_id\">\n  <Hierarchy hasAll=\"true\" allMemberName=\"All Gender\"\n allLevelName=\"GenderLevel\" primaryKey=\"customer_id\">\n  <Table name=\"customer\"/>\n    <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        String mdx = "select {[Gender4].[All Gender]} on columns from Sales";
        Result result = testContext.executeQuery(mdx);
        Axis axis0 = result.getAxes()[0];
        Position pos0 = axis0.getPositions().get(0);
        Member allGender = (Member)pos0.get(0);
        String caption = allGender.getLevel().getName();
        Assert.assertEquals((String)caption, (String)"GenderLevel");
    }

    public void testDimWithoutAll() {
        TestContext testContext = new TestContext(){

            public Util.PropertyList getFoodMartConnectionProperties() {
                String schema = 2.getFoodMartSchema(null, "<Cube name=\"Sales_DimWithoutAll\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"Product\" foreignKey=\"product_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"product_id\" primaryKeyTable=\"product\">\n      <Join leftKey=\"product_class_id\" rightKey=\"product_class_id\">\n        <Table name=\"product\"/>\n        <Table name=\"product_class\"/>\n      </Join>\n      <Level name=\"Product Family\" table=\"product_class\" column=\"product_family\"\n          uniqueMembers=\"true\"/>\n      <Level name=\"Product Department\" table=\"product_class\" column=\"product_department\"\n          uniqueMembers=\"false\"/>\n      <Level name=\"Product Category\" table=\"product_class\" column=\"product_category\"\n          uniqueMembers=\"false\"/>\n      <Level name=\"Product Subcategory\" table=\"product_class\" column=\"product_subcategory\"\n          uniqueMembers=\"false\"/>\n      <Level name=\"Brand Name\" table=\"product\" column=\"brand_name\" uniqueMembers=\"false\"/>\n      <Level name=\"Product Name\" table=\"product\" column=\"product_name\"\n          uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Gender\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"customer_id\">\n    <Table name=\"customer\"/>\n      <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
                Util.PropertyList properties = super.getFoodMartConnectionProperties();
                properties.put(RolapConnectionProperties.CatalogContent.name(), schema);
                return properties;
            }

            public String getDefaultCubeName() {
                return "Sales_DimWithoutAll";
            }
        };
        testContext.assertExprReturns("[Gender].CurrentMember.Name", "F");
        testContext.assertExprReturns("[Product].CurrentMember.Name", "Drink");
        testContext.assertExprThrows("([Gender].[All Gender], [Measures].[Unit Sales])", "MDX object '[Gender].[All Gender]' not found in cube 'Sales_DimWithoutAll'");
        testContext.assertExprThrows("([Gender].[All Genders], [Measures].[Unit Sales])", "MDX object '[Gender].[All Genders]' not found in cube 'Sales_DimWithoutAll'");
        testContext.assertExprReturns("[Measures].[Unit Sales]", "12,202");
        testContext.assertExprReturns("([Gender].[F], [Measures].[Unit Sales])", "12,202");
        testContext.assertExprReturns("([Gender].[M], [Measures].[Unit Sales])", "12,395");
        testContext.assertExprReturns("([Product].[Food].[Canned Foods], [Measures].[Unit Sales])", "9,407");
        testContext.assertExprReturns("([Product].[Food].[Dairy], [Measures].[Unit Sales])", "6,513");
        testContext.assertExprReturns("([Product].[Drink].[Dairy], [Measures].[Unit Sales])", "1,987");
    }

    public void testMemberOnAxis() {
        this.assertQueryReturns("select [Measures].[Sales Count] on 0, non empty [Store].[Store State].members on 1 from [Sales]", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 24,442\nRow #1: 21,611\nRow #2: 40,784\n"));
    }

    public void testScalarOnAxisFails() {
        this.assertThrows("select [Measures].[Sales Count] + 1 on 0, non empty [Store].[Store State].members on 1 from [Sales]", "Axis 'COLUMNS' expression is not a set");
    }

    public void testSameDimOnTwoAxesFails() {
        this.assertThrows(BasicQueryTest.fold("select {[Measures].[Unit Sales]} on columns,\n {[Measures].[Store Sales]} on rows\nfrom [Sales]"), "Dimension '[Measures]' appears in more than one independent axis");
        this.assertThrows("select {[Measures].[Unit Sales]} on columns,\n CrossJoin({[Product].members},           {[Measures].[Store Sales]}) on rows\nfrom [Sales]", "Dimension '[Measures]' appears in more than one independent axis");
        this.assertThrows(BasicQueryTest.fold("select CrossJoin(\n    {[Product].children},\n    {[Measures].[Unit Sales]}) on columns,\n    {([Product],\n      [Store].CurrentMember)} on rows\nfrom [Sales]"), "Dimension '[Product]' appears in more than one independent axis");
        this.assertThrows(BasicQueryTest.fold("select {[Measures].[Unit Sales]} on columns,\n {[Store].Members} on rows\nfrom [Sales]\nwhere ([Time].[1997].[Q1], [Measures].[Store Sales])"), "Dimension '[Measures]' appears in more than one independent axis");
        this.executeQuery("with member [Measures].[West Coast Total] as  ' Aggregate({[Store].[USA].[CA], [Store].[USA].[OR], [Store].[USA].[WA]}) ' \nselect    {[Measures].[Store Sales], \n    [Measures].[Unit Sales]} on Columns,\n CrossJoin(\n   {[Product].children},\n   {[Store].children}) on Rows\nfrom [Sales]");
    }

    public void _testSetArgToTupleFails() {
        this.assertThrows("select CrossJoin(\n    {[Product].children},\n    {[Measures].[Unit Sales]}) on columns,\n    {([Product],\n      [Store].members)} on rows\nfrom [Sales]", "Dimension '[Product]' appears in more than one independent axis");
    }

    public void _badArgsToTupleFails() {
        this.assertThrows("select {[Measures].[Unit Sales]} on columns,\n {[Store].Members} on rows\nfrom [Sales]\nwhere ([Time].[1997].[Q1], [Product], [Time].[1997].[Q2])", "Dimension '[Time]' more than once in same tuple");
        this.assertThrows("select {[Measures].[Unit Sales]} on columns,\n CrossJoin({[Time].[1997].[Q1],\n           {[Product]},\n           {[Time].[1997].[Q2]}) on rows\nfrom [Sales]", "Dimension '[Time]' more than once in same tuple");
    }

    public void testNullMember() {
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertQueryReturns("SELECT \n{[Measures].[Store Cost]} ON columns, \n{[Store Size in SQFT].[All Store Size in SQFTs].[#null]} ON rows \nFROM [Sales] \nWHERE [Time].[1997]", BasicQueryTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Store Cost]}\nAxis #2:\n{[Store Size in SQFT].[All Store Size in SQFTs].[#null]}\nRow #0: 33,307.69\n"));
        }
    }

    public void testNullMemberWithOneNonNull() {
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertQueryReturns("SELECT \n{[Measures].[Store Cost]} ON columns, \n{[Store Size in SQFT].[All Store Size in SQFTs].[#null],[Store Size in SQFT].[ALL Store Size in SQFTs].[39696]} ON rows \nFROM [Sales] \nWHERE [Time].[1997]", BasicQueryTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Store Cost]}\nAxis #2:\n{[Store Size in SQFT].[All Store Size in SQFTs].[#null]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[39696]}\nRow #0: 33,307.69\nRow #1: 21,121.96\n"));
        }
    }

    public void testMultipleConstraintsOnSameColumn() {
        String cubeName = "Sales_withCities";
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales_withCities\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <Dimension name=\"Cities\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Cities\" primaryKey=\"customer_id\">\n      <Table name=\"customer\"/>\n      <Level name=\"City\" column=\"city\" uniqueMembers=\"false\"/> \n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Customers\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Customers\" primaryKey=\"customer_id\">\n      <Table name=\"customer\"/>\n      <Level name=\"Country\" column=\"country\" uniqueMembers=\"true\"/>\n      <Level name=\"State Province\" column=\"state_province\" uniqueMembers=\"true\"/>\n      <Level name=\"City\" column=\"city\" uniqueMembers=\"false\"/>\n      <Level name=\"Name\" column=\"fullname\" uniqueMembers=\"true\">\n        <Property name=\"Gender\" column=\"gender\"/>\n        <Property name=\"Marital Status\" column=\"marital_status\"/>\n        <Property name=\"Education\" column=\"education\"/>\n        <Property name=\"Yearly Income\" column=\"yearly_income\"/>\n      </Level>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Gender\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n    <Table name=\"customer\"/>\n      <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {\n [Customers].[All Customers].[USA],\n [Customers].[All Customers].[USA].[OR],\n [Customers].[All Customers].[USA].[CA],\n [Customers].[All Customers].[USA].[CA].[Altadena],\n [Customers].[All Customers].[USA].[CA].[Burbank],\n [Customers].[All Customers].[USA].[CA].[Burbank].[Alma Son]} ON COLUMNS\nfrom [Sales_withCities] \nwhere ([Cities].[All Cities].[Burbank], [Measures].[Store Sales])", BasicQueryTest.fold("Axis #0:\n{[Cities].[All Cities].[Burbank], [Measures].[Store Sales]}\nAxis #1:\n{[Customers].[All Customers].[USA]}\n{[Customers].[All Customers].[USA].[OR]}\n{[Customers].[All Customers].[USA].[CA]}\n{[Customers].[All Customers].[USA].[CA].[Altadena]}\n{[Customers].[All Customers].[USA].[CA].[Burbank]}\n{[Customers].[All Customers].[USA].[CA].[Burbank].[Alma Son]}\nRow #0: 6,577.33\nRow #0: \nRow #0: 6,577.33\nRow #0: \nRow #0: 6,577.33\nRow #0: 36.50\n"));
    }

    public void testOverrideDimension() {
        this.assertQueryReturns(BasicQueryTest.fold("with member  [Gender].[test] as '\n  aggregate(\n  filter (crossjoin( [Gender].[Gender].members, [Time].members), \n      [time].CurrentMember = [Time].[1997].[Q1]   AND\n[measures].[unit sales] > 50) )\n'\nselect \n  { [time].[year].members } on 0,\n  { [gender].[test] }\n on 1  \nfrom [sales]"), BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997]}\n{[Time].[1998]}\nAxis #2:\n{[Gender].[test]}\nRow #0: 66,291\nRow #0: 66,291\n"));
    }

    public void testBadMeasure1() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"SalesWithBadMeasure\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <Measure name=\"Bad Measure\" aggregator=\"sum\"\n      formatString=\"Standard\"/>\n</Cube>", null, null, null, null);
        Throwable throwable = null;
        try {
            testContext.assertSimpleQuery();
        }
        catch (Throwable e) {
            throwable = e;
        }
        TestContext.checkThrowable(throwable, "must contain either a source column or a source expression, but not both");
    }

    public void testBadMeasure2() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"SalesWithBadMeasure2\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <Measure name=\"Bad Measure\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\">\n    <MeasureExpression>\n       <SQL dialect=\"generic\">\n         unit_sales\n       </SQL>\n    </MeasureExpression>\n  </Measure>\n</Cube>", null, null, null, null);
        Throwable throwable = null;
        try {
            testContext.assertSimpleQuery();
        }
        catch (Throwable e) {
            throwable = e;
        }
        TestContext.checkThrowable(throwable, "must contain either a source column or a source expression, but not both");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidMembersInQuery() {
        String mdx = "select {[Measures].[Unit Sales]} on columns,\n {[Time].[1997].[Q1], [Time].[1997].[QTOO]} on rows\nfrom [Sales]";
        String mdx2 = "select {[Measures].[Unit Sales]} on columns,\nnonemptycrossjoin(\n{[Time].[1997].[Q1], [Time].[1997].[QTOO]},\n[Customers].[All Customers].[USA].children) on rows\nfrom [Sales]";
        this.assertThrows(mdx, "MDX object '[Time].[1997].[QTOO]' not found in cube 'Sales'");
        boolean savedInvalidProp = this.props.IgnoreInvalidMembersDuringQuery.get();
        String savedAlertProp = this.props.AlertNativeEvaluationUnsupported.get();
        try {
            this.props.IgnoreInvalidMembersDuringQuery.set(true);
            this.assertQueryReturns(mdx, BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Time].[1997].[Q1]}\nRow #0: 66,291\n"));
            this.props.AlertNativeEvaluationUnsupported.set("ERROR");
            this.assertQueryReturns(mdx2, BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Time].[1997].[Q1], [Customers].[All Customers].[USA].[CA]}\n{[Time].[1997].[Q1], [Customers].[All Customers].[USA].[OR]}\n{[Time].[1997].[Q1], [Customers].[All Customers].[USA].[WA]}\nRow #0: 16,890\nRow #1: 19,287\nRow #2: 30,114\n"));
        }
        finally {
            this.props.IgnoreInvalidMembersDuringQuery.set(savedInvalidProp);
            this.props.AlertNativeEvaluationUnsupported.set(savedAlertProp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemberOrdinalCaching() {
        boolean saved = this.props.CompareSiblingsByOrderKey.get();
        this.props.CompareSiblingsByOrderKey.set(true);
        Connection conn = null;
        try {
            conn = this.getTestContext().getFoodMartConnection(false);
            TestContext context = this.getTestContext(conn);
            this.tryMemberOrdinalCaching(context);
        }
        finally {
            this.props.CompareSiblingsByOrderKey.set(saved);
            if (conn != null) {
                conn.close();
            }
        }
    }

    private void tryMemberOrdinalCaching(TestContext context) {
        context.assertQueryReturns("with member [Measures].[o] as 0\nset necj as nonemptycrossjoin(\n[Store].[Store State].members, [Customers].[Name].members)\nselect tail(necj,5) on rows,\n{[Measures].[o]} on columns\nfrom [Sales]\n", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[o]}\nAxis #2:\n{[Store].[All Stores].[USA].[WA], [Customers].[All Customers].[USA].[WA].[Yakima].[Tracy Meyer]}\n{[Store].[All Stores].[USA].[WA], [Customers].[All Customers].[USA].[WA].[Yakima].[Vanessa Thompson]}\n{[Store].[All Stores].[USA].[WA], [Customers].[All Customers].[USA].[WA].[Yakima].[Velma Lykes]}\n{[Store].[All Stores].[USA].[WA], [Customers].[All Customers].[USA].[WA].[Yakima].[William Battaglia]}\n{[Store].[All Stores].[USA].[WA], [Customers].[All Customers].[USA].[WA].[Yakima].[Wilma Fink]}\nRow #0: 0\nRow #1: 0\nRow #2: 0\nRow #3: 0\nRow #4: 0\n"));
        context.assertQueryReturns("with member [Measures].[o] as 0\nselect tail([Customers].[Name].members, 5)\non rows,\n{[Measures].[o]} on columns\nfrom [Sales]", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[o]}\nAxis #2:\n{[Customers].[All Customers].[USA].[WA].[Yakima].[Tracy Meyer]}\n{[Customers].[All Customers].[USA].[WA].[Yakima].[Vanessa Thompson]}\n{[Customers].[All Customers].[USA].[WA].[Yakima].[Velma Lykes]}\n{[Customers].[All Customers].[USA].[WA].[Yakima].[William Battaglia]}\n{[Customers].[All Customers].[USA].[WA].[Yakima].[Wilma Fink]}\nRow #0: 0\nRow #1: 0\nRow #2: 0\nRow #3: 0\nRow #4: 0\n"));
    }

    public void testCancel() {
        String query = BasicQueryTest.fold("WITH \n  MEMBER [Measures].[Sleepy] \n    AS 'SleepUdf([Measures].[Unit Sales])' \nSELECT {[Measures].[Sleepy]} ON COLUMNS,\n  {[Product].members} ON ROWS\nFROM [Sales]");
        this.executeAndCancel(query, 2000);
    }

    private void executeAndCancel(String queryString, int waitMillis) {
        TestContext tc = TestContext.create(null, null, null, null, "<UserDefinedFunction name=\"SleepUdf\" className=\"" + SleepUdf.class.getName() + "\"/>", null);
        Connection connection = tc.getConnection();
        final Query query = connection.parseQuery(queryString);
        if (waitMillis == 0) {
            query.cancel();
        } else {
            Timer timer = new Timer(true);
            TimerTask task = new TimerTask(){

                public void run() {
                    Thread thread = Thread.currentThread();
                    thread.setName("CancelThread");
                    try {
                        query.cancel();
                    }
                    catch (Exception ex) {
                        Assert.fail((String)("Cancel request failed:  " + ex.getMessage()));
                    }
                }
            };
            timer.schedule(task, waitMillis);
        }
        Throwable throwable = null;
        try {
            connection.execute(query);
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        TestContext.checkThrowable(throwable, "canceled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeout() {
        TestContext tc = TestContext.create(null, null, null, null, "<UserDefinedFunction name=\"SleepUdf\" className=\"" + SleepUdf.class.getName() + "\"/>", null);
        String query = "WITH\n  MEMBER [Measures].[Sleepy]\n    AS 'SleepUdf([Measures].[Unit Sales])'\nSELECT {[Measures].[Sleepy]} ON COLUMNS,\n  {[Product].members} ON ROWS\nFROM [Sales]";
        Throwable throwable = null;
        int origTimeout = this.props.QueryTimeout.get();
        try {
            this.props.QueryTimeout.set(2);
            tc.executeQuery(query);
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        finally {
            this.props.QueryTimeout.set(origTimeout);
        }
        TestContext.checkThrowable(throwable, "Query timeout of 2 seconds reached");
    }

    public void testFormatInheritance() {
        this.assertQueryReturns("with member measures.foo as 'measures.bar' member measures.bar as 'measures.profit' select {measures.foo} on 0 from sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[foo]}\nRow #0: $339,610.90\n"));
    }

    public void testFormatInheritanceWithIIF() {
        this.assertQueryReturns("with member measures.foo as 'measures.bar' member measures.bar as 'iif(not isempty(measures.profit),measures.profit,null)' select from sales where measures.foo", BasicQueryTest.fold("Axis #0:\n{[Measures].[foo]}\n$339,610.90"));
    }

    public void testFormatInheritanceWorksWithFirstFormatItFinds() {
        this.assertQueryReturns("with member measures.foo as 'measures.bar' member measures.bar as 'iif(measures.profit>3000,measures.[unit sales],measures.[Customer Count])' select {[Store].[All Stores].[USA].[WA].children} on 0 from sales where measures.foo", BasicQueryTest.fold("Axis #0:\n{[Measures].[foo]}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\n{[Store].[All Stores].[USA].[WA].[Bremerton]}\n{[Store].[All Stores].[USA].[WA].[Seattle]}\n{[Store].[All Stores].[USA].[WA].[Spokane]}\n{[Store].[All Stores].[USA].[WA].[Tacoma]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla]}\n{[Store].[All Stores].[USA].[WA].[Yakima]}\nRow #0: $190.00\nRow #0: $24,576.00\nRow #0: $25,011.00\nRow #0: $23,591.00\nRow #0: $35,257.00\nRow #0: $96.00\nRow #0: $11,491.00\n"));
    }

    public void testAvgCastProblem() {
        this.assertQueryReturns("with member measures.bar as 'iif(measures.profit>3000,min([Education Level].[Education Level].Members),min([Education Level].[Education Level].Members))' select {[Store].[All Stores].[USA].[WA].children} on 0 from sales where measures.bar", BasicQueryTest.fold("Axis #0:\n{[Measures].[bar]}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\n{[Store].[All Stores].[USA].[WA].[Bremerton]}\n{[Store].[All Stores].[USA].[WA].[Seattle]}\n{[Store].[All Stores].[USA].[WA].[Spokane]}\n{[Store].[All Stores].[USA].[WA].[Tacoma]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla]}\n{[Store].[All Stores].[USA].[WA].[Yakima]}\nRow #0: $95.00\nRow #0: $1,835.00\nRow #0: $1,277.00\nRow #0: $1,434.00\nRow #0: $1,084.00\nRow #0: $129.00\nRow #0: $958.00\n"));
    }

    public void testFormatInheritanceToPickupFormatFromSecondMeasureWhenTheFirstDoesNotHaveOne() {
        this.assertQueryReturns("with member measures.foo as 'measures.bar+measures.blah' member measures.bar as '10' member measures.blah as '20',format_string='$##.###.00' select from sales where measures.foo", BasicQueryTest.fold("Axis #0:\n{[Measures].[foo]}\n$30.00"));
    }

    public void testFormatInheritanceWithComplexExpressionToAssertThatTheFormatOfTheFisrtMemberThatHasAValidFormatIsUsed() {
        this.assertQueryReturns("with member measures.foo as '13+31*measures.[Unit Sales]/iif(measures.profit>0,measures.profit,measures.[Customer Count])' select {[Store].[All Stores].[USA].[CA].children} on 0 from sales where measures.foo", BasicQueryTest.fold("Axis #0:\n{[Measures].[foo]}\nAxis #1:\n{[Store].[All Stores].[USA].[CA].[Alameda]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\nRow #0: 13\nRow #0: 37\nRow #0: 37\nRow #0: 37\nRow #0: 38\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryIterationLimit() {
        String queryString = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Dates], [*BASE_MEMBERS_Stores])' Set [*BASE_MEMBERS_Dates] as '{[Time].[1997].[Q1], [Time].[1997].[Q2], [Time].[1997].[Q3], [Time].[1997].[Q4]}' Set [*GENERATED_MEMBERS_Dates] as 'Generate([*NATIVE_CJ_SET], {[Time].CurrentMember})' Set [*GENERATED_MEMBERS_Measures] as '{[Measures].[*SUMMARY_METRIC_0]}' Set [*BASE_MEMBERS_Stores] as '{[Store].[USA].[CA], [Store].[USA].[WA], [Store].[USA].[OR]}' Set [*GENERATED_MEMBERS_Stores] as 'Generate([*NATIVE_CJ_SET], {[Store].CurrentMember})' Member [Time].[*SM_CTX_SEL] as 'Aggregate([*GENERATED_MEMBERS_Dates])' Member [Measures].[*SUMMARY_METRIC_0] as '[Measures].[Unit Sales]/([Measures].[Unit Sales],[Time].[*SM_CTX_SEL])' Member [Time].[*SUBTOTAL_MEMBER_SEL~SUM] as 'sum([*GENERATED_MEMBERS_Dates])' Member [Store].[*SUBTOTAL_MEMBER_SEL~SUM] as 'sum([*GENERATED_MEMBERS_Stores])' select crossjoin({[Time].[*SUBTOTAL_MEMBER_SEL~SUM]}, {[Store].[*SUBTOTAL_MEMBER_SEL~SUM]}) on columns from [Sales]";
        Throwable throwable = null;
        int origLimit = this.props.IterationLimit.get();
        try {
            this.props.IterationLimit.set(11);
            Connection connection = this.getConnection();
            Query query = connection.parseQuery(queryString);
            query.setResultStyle(ResultStyle.LIST);
            connection.execute(query);
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        finally {
            this.props.IterationLimit.set(origLimit);
        }
        TestContext.checkThrowable(throwable, "Number of iterations exceeded limit of 11");
        this.executeQuery(queryString);
    }

    public void testGetCaptionUsingMemberDotCaption() {
        this.assertQueryReturns("SELECT Filter(Store.allmembers, [store].currentMember.caption = \"USA\") on 0 FROM SALES", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\nRow #0: 266,773\n"));
    }

    public void testGetCaptionUsingMemberDotPropertiesCaption() {
        this.assertQueryReturns("SELECT Filter(Store.allmembers, [store].currentMember.properties(\"caption\") = \"USA\") on 0 FROM SALES", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\nRow #0: 266,773\n"));
    }

    public void testDefaultMeasureInCube() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"DefaultMeasureTesting\" defaultMeasure=\"Supply Time\">\n  <Table name=\"inventory_fact_1997\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"store_id\"/>\n  <Measure name=\"Store Invoice\" column=\"store_invoice\" aggregator=\"sum\"/>\n  <Measure name=\"Supply Time\" column=\"supply_time\" aggregator=\"sum\"/>\n  <Measure name=\"Warehouse Cost\" column=\"warehouse_cost\" aggregator=\"sum\"/>\n</Cube>", null, null, null, null);
        String queryWithoutFilter = "select store.members on 0 from DefaultMeasureTesting";
        String queryWithDeflaultMeasureFilter = "select store.members on 0 from DefaultMeasureTesting where [measures].[Supply Time]";
        this.assertQueriesReturnSimilarResults(queryWithoutFilter, queryWithDeflaultMeasureFilter, testContext);
    }

    public void testDefaultMeasureInCubeForIncorrectMeasureName() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"DefaultMeasureTesting\" defaultMeasure=\"Supply Time Error\">\n  <Table name=\"inventory_fact_1997\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"store_id\"/>\n  <Measure name=\"Store Invoice\" column=\"store_invoice\" aggregator=\"sum\"/>\n  <Measure name=\"Supply Time\" column=\"supply_time\" aggregator=\"sum\"/>\n  <Measure name=\"Warehouse Cost\" column=\"warehouse_cost\" aggregator=\"sum\"/>\n</Cube>", null, null, null, null);
        String queryWithoutFilter = "select store.members on 0 from DefaultMeasureTesting";
        String queryWithFirstMeasure = "select store.members on 0 from DefaultMeasureTesting where [measures].[Store Invoice]";
        this.assertQueriesReturnSimilarResults(queryWithoutFilter, queryWithFirstMeasure, testContext);
    }

    public void testDefaultMeasureInCubeForCaseSensitivity() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"DefaultMeasureTesting\" defaultMeasure=\"SUPPLY TIME\">\n  <Table name=\"inventory_fact_1997\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"store_id\"/>\n  <Measure name=\"Store Invoice\" column=\"store_invoice\" aggregator=\"sum\"/>\n  <Measure name=\"Supply Time\" column=\"supply_time\" aggregator=\"sum\"/>\n  <Measure name=\"Warehouse Cost\" column=\"warehouse_cost\" aggregator=\"sum\"/>\n</Cube>", null, null, null, null);
        String queryWithoutFilter = "select store.members on 0 from DefaultMeasureTesting";
        String queryWithFirstMeasure = "select store.members on 0 from DefaultMeasureTesting where [measures].[Store Invoice]";
        String queryWithDefaultMeasureFilter = "select store.members on 0 from DefaultMeasureTesting where [measures].[Supply Time]";
        if (this.props.CaseSensitive.get()) {
            this.assertQueriesReturnSimilarResults(queryWithoutFilter, queryWithFirstMeasure, testContext);
        } else {
            this.assertQueriesReturnSimilarResults(queryWithoutFilter, queryWithDefaultMeasureFilter, testContext);
        }
    }

    public void testNumericToLogicalConversion() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns, Filter(Descendants([Product].[Food].[Baked Goods].[Bread]), Count([Product].currentMember.children)) on Rows from [Sales]", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baked Goods].[Bread]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels].[Colony]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels].[Fantastic]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels].[Great]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels].[Modell]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels].[Sphinx]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins].[Colony]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins].[Fantastic]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins].[Great]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins].[Modell]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins].[Sphinx]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Sliced Bread]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Sliced Bread].[Colony]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Sliced Bread].[Fantastic]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Sliced Bread].[Great]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Sliced Bread].[Modell]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Sliced Bread].[Sphinx]}\nRow #0: 7,870\nRow #1: 815\nRow #2: 163\nRow #3: 160\nRow #4: 145\nRow #5: 165\nRow #6: 182\nRow #7: 3,497\nRow #8: 740\nRow #9: 798\nRow #10: 605\nRow #11: 719\nRow #12: 635\nRow #13: 3,558\nRow #14: 737\nRow #15: 815\nRow #16: 638\nRow #17: 653\nRow #18: 715\n"));
    }

    public void testRollupQuery() {
        this.assertQueryReturns("SELECT {[Product].[Product Department].MEMBERS} ON AXIS(0),\n{{[Gender].[Gender].MEMBERS}, {[Gender].[All Gender]}} ON AXIS(1)\nFROM [Sales 2] WHERE {[Measures].[Unit Sales]}", BasicQueryTest.fold("Axis #0:\n{[Measures].[Unit Sales]}\nAxis #1:\n{[Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Product].[All Products].[Drink].[Beverages]}\n{[Product].[All Products].[Drink].[Dairy]}\n{[Product].[All Products].[Food].[Baked Goods]}\n{[Product].[All Products].[Food].[Baking Goods]}\n{[Product].[All Products].[Food].[Breakfast Foods]}\n{[Product].[All Products].[Food].[Canned Foods]}\n{[Product].[All Products].[Food].[Canned Products]}\n{[Product].[All Products].[Food].[Dairy]}\n{[Product].[All Products].[Food].[Deli]}\n{[Product].[All Products].[Food].[Eggs]}\n{[Product].[All Products].[Food].[Frozen Foods]}\n{[Product].[All Products].[Food].[Meat]}\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Seafood]}\n{[Product].[All Products].[Food].[Snack Foods]}\n{[Product].[All Products].[Food].[Snacks]}\n{[Product].[All Products].[Food].[Starchy Foods]}\n{[Product].[All Products].[Non-Consumable].[Carousel]}\n{[Product].[All Products].[Non-Consumable].[Checkout]}\n{[Product].[All Products].[Non-Consumable].[Health and Hygiene]}\n{[Product].[All Products].[Non-Consumable].[Household]}\n{[Product].[All Products].[Non-Consumable].[Periodicals]}\nAxis #2:\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\n{[Gender].[All Gender]}\nRow #0: 3,439\nRow #0: 6,776\nRow #0: 1,987\nRow #0: 3,771\nRow #0: 9,841\nRow #0: 1,821\nRow #0: 9,407\nRow #0: 867\nRow #0: 6,513\nRow #0: 5,990\nRow #0: 2,001\nRow #0: 13,011\nRow #0: 841\nRow #0: 18,713\nRow #0: 947\nRow #0: 14,936\nRow #0: 3,459\nRow #0: 2,696\nRow #0: 368\nRow #0: 887\nRow #0: 7,841\nRow #0: 13,278\nRow #0: 2,168\nRow #1: 3,399\nRow #1: 6,797\nRow #1: 2,199\nRow #1: 4,099\nRow #1: 10,404\nRow #1: 1,496\nRow #1: 9,619\nRow #1: 945\nRow #1: 6,372\nRow #1: 6,047\nRow #1: 2,131\nRow #1: 13,644\nRow #1: 873\nRow #1: 19,079\nRow #1: 817\nRow #1: 15,609\nRow #1: 3,425\nRow #1: 2,566\nRow #1: 473\nRow #1: 892\nRow #1: 8,443\nRow #1: 13,760\nRow #1: 2,126\nRow #2: 6,838\nRow #2: 13,573\nRow #2: 4,186\nRow #2: 7,870\nRow #2: 20,245\nRow #2: 3,317\nRow #2: 19,026\nRow #2: 1,812\nRow #2: 12,885\nRow #2: 12,037\nRow #2: 4,132\nRow #2: 26,655\nRow #2: 1,714\nRow #2: 37,792\nRow #2: 1,764\nRow #2: 30,545\nRow #2: 6,884\nRow #2: 5,262\nRow #2: 841\nRow #2: 1,779\nRow #2: 16,284\nRow #2: 27,038\nRow #2: 4,294\n"));
    }

    public void testBug1630754() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Customer_2\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Customers\" primaryKey=\"customer_id\"  >\n      <Table name=\"customer\"/>\n      <Level name=\"Name1\" column=\"customer_id\" uniqueMembers=\"true\"/>      <Level name=\"Name2\" column=\"customer_id\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>");
        Result result = testContext.executeQuery("WITH SET [#DataSet#] AS    'NonEmptyCrossjoin({Descendants([Customer_2].[All Customers], 2)},    {[Product].[All Products]})' SELECT {[Measures].[Unit Sales], [Measures].[Store Sales]} on columns, Hierarchize({[#DataSet#]}) on rows FROM [Sales]");
        int rowCount = result.getAxes()[1].getPositions().size();
        BasicQueryTest.assertEquals((int)5581, (int)rowCount);
    }

    public void testNonEmptyCrossjoinFilter() {
        String desiredResult = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products], [Time].[1997].[Q2].[5]}\nRow #0: 21,081\n");
        this.assertQueryReturns("select NON EMPTY {[Measures].[Unit Sales]} ON COLUMNS,\nNON EMPTY Crossjoin(  {Product.[All Products]},\n  Filter(    Descendants(Time, [Time].[Month]),     Time.CurrentMember.Name = '5')) ON ROWS\nfrom [Sales] ", desiredResult);
        this.assertQueryReturns("select NON EMPTY {[Measures].[Unit Sales]} ON COLUMNS,\nNON EMPTY Filter(  Crossjoin(    {Product.[All Products]},\n    Descendants(Time, [Time].[Month])),  Time.CurrentMember.Name = '5') ON ROWS\nfrom [Sales] ", desiredResult);
    }

    public void testDuplicateAxisFails() {
        this.assertThrows("select [Gender].Members on columns, [Measures].Members on columns from [Sales]", "Duplicate axis name 'COLUMNS'.");
    }

    public void testInvalidAxisFails() {
        this.assertThrows("select [Gender].Members on 0, [Measures].Members on 10 from [Sales]", "Axis numbers specified in a query must be sequentially specified, and cannot contain gaps. Axis 1 (ROWS) is missing.");
        this.assertThrows("select [Gender].Members on columns, [Measures].Members on foobar\nfrom [Sales]", "Syntax error at line 1, column 59, token 'foobar'");
        this.assertThrows("select [Gender].Members on columns, [Measures].Members on slicer\nfrom [Sales]", "Syntax error at line 1, column 59, token 'slicer'");
        this.assertThrows("select [Gender].Members on columns, [Measures].Members on filter\nfrom [Sales]", "Syntax error at line 1, column 59, token 'filter'");
    }

    public void testSummingProperties() {
        String expected = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\n{[Store].[All Stores].[USA].[CA]}\nAxis #2:\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 131,558\nRow #0: 36,759\nRow #1: 135,215\nRow #1: 37,989\n");
        this.assertQueryReturns("with member [Measures].[Sum Sqft] as 'sum(  Descendants([Store].CurrentMember, [Store].Levels(5)),  [Store].CurrentMember.Properties(\"Store Sqft\")) '\nselect {[Store].[USA], [Store].[USA].[CA]} on 0,\n [Gender].Children on 1\nfrom [Sales]", expected);
        this.assertQueryReturns("with member [Measures].[Sum Sqft] as 'sum(  Descendants([Store].CurrentMember, [Store].Levels(\"Store Name\")),  [Store].CurrentMember.Properties(\"Store Sqft\")) '\nselect {[Store].[USA], [Store].[USA].[CA]} on 0,\n [Gender].Children on 1\nfrom [Sales]", expected);
        this.assertQueryReturns("with member [Measures].[Sum Sqft] as 'sum(  Descendants([Store].CurrentMember, [Store].[Store Name]),  [Store].CurrentMember.Properties(\"Store Sqft\")) '\nselect {[Store].[USA], [Store].[USA].[CA]} on 0,\n [Gender].Children on 1\nfrom [Sales]", expected);
        this.assertQueryReturns("with member [Measures].[Sum Sqft] as 'sum(  Descendants([Store].CurrentMember, , LEAVES),  [Store].CurrentMember.Properties(\"Store Sqft\")) '\nselect {[Store].[USA], [Store].[USA].[CA]} on 0,\n [Gender].Children on 1\nfrom [Sales]", expected);
    }

    public void testIifWithTupleFirstAndMemberNextWithMeasure() {
        this.assertQueryReturns("WITH\nMEMBER [Gender].agg AS 'IIF(1=1, ([Gender].[All Gender],measures.[unit sales]),([Gender].[All Gender]))', SOLVE_ORDER = 4 SELECT {[Measures].[unit sales]} ON 0, {{[Gender].[Gender].MEMBERS},{([Gender].agg)}} on 1 FROM sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\n{[Gender].[agg]}\nRow #0: 131,558\nRow #1: 135,215\nRow #2: 266,773\n"));
    }

    public void testIifWithMemberFirstAndTupleNextWithMeasure() {
        this.assertQueryReturns("WITH\nMEMBER [Gender].agg AS 'IIF(1=1, ([Gender].[All Gender]),([Gender].[All Gender],measures.[unit sales]))', SOLVE_ORDER = 4 SELECT {[Measures].[unit sales]} ON 0, {{[Gender].[Gender].MEMBERS},{([Gender].agg)}} on 1 FROM sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\n{[Gender].[agg]}\nRow #0: 131,558\nRow #1: 135,215\nRow #2: 266,773\n"));
    }

    public void testIifWithMemberFirstAndTupleNextWithoutMeasure() {
        this.assertQueryReturns("WITH\nMEMBER [Gender].agg AS 'IIF(1=1, ([Gender].[All Gender]),([Gender].[All Gender],[Time].[1997]))', SOLVE_ORDER = 4 SELECT {[Measures].[unit sales]} ON 0, {{[Gender].[Gender].MEMBERS},{([Gender].agg)}} on 1 FROM sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\n{[Gender].[agg]}\nRow #0: 131,558\nRow #1: 135,215\nRow #2: 266,773\n"));
    }

    public void testIifWithTupleFirstAndMemberNextWithoutMeasure() {
        this.assertQueryReturns("WITH\nMEMBER [Gender].agg AS 'IIF(1=1, ([Store].[All Stores].[USA], [Gender].[All Gender]), ([Gender].[All Gender]))', SOLVE_ORDER = 4 SELECT {[Measures].[unit sales]} ON 0, {([Gender].agg)} on 1 FROM sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[agg]}\nRow #0: 266,773\n"));
    }

    public void testIifWithTuplesOfUnequalSizes() {
        this.assertQueryReturns("WITH\nMEMBER [Gender].agg AS 'IIF(Measures.currentMember is [Measures].[Unit Sales], ([Store].[All Stores],[Gender].[All Gender],measures.[unit sales]),([Store].[All Stores],[Gender].[All Gender]))', SOLVE_ORDER = 4 SELECT {[Measures].[unit sales]} ON 0, {{[Gender].[Gender].MEMBERS},{([Gender].agg)}} on 1 FROM sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\n{[Gender].[agg]}\nRow #0: 131,558\nRow #1: 135,215\nRow #2: 266,773\n"));
    }

    public void testIifWithTuplesOfUnequalSizesAndOrder() {
        this.assertQueryReturns("WITH\nMEMBER [Gender].agg AS 'IIF(Measures.currentMember is [Measures].[Unit Sales], ([Store].[All Stores],[Gender].[M],measures.[unit sales]),([Gender].[M],[Store].[All Stores]))', SOLVE_ORDER = 4 SELECT {[Measures].[unit sales]} ON 0, {{[Gender].[Gender].MEMBERS},{([Gender].agg)}} on 1 FROM sales", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\n{[Gender].[agg]}\nRow #0: 131,558\nRow #1: 135,215\nRow #2: 135,215\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyAggregationListDueToFilterDoesNotThrowException() {
        boolean ignoreMeasureForNonJoiningDimension = this.props.IgnoreMeasureForNonJoiningDimension.get();
        this.props.IgnoreMeasureForNonJoiningDimension.set(true);
        try {
            this.assertQueryReturns("WITH \nMEMBER [GENDER].[AGG] AS 'AGGREGATE(FILTER([S1], (NOT ISEMPTY([MEASURES].[STORE SALES]))))' SET [S1] AS 'CROSSJOIN({[GENDER].[GENDER].MEMBERS},{[STORE].[CANADA].CHILDREN})' SELECT\n{[MEASURES].[STORE SALES]} ON COLUMNS,\n{[GENDER].[AGG]} ON ROWS\nFROM [WAREHOUSE AND SALES]", BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n{[Gender].[AGG]}\nRow #0: \n"));
        }
        finally {
            this.props.IgnoreMeasureForNonJoiningDimension.set(ignoreMeasureForNonJoiningDimension);
        }
    }

    public void testEmptySqlBug() {
        String expectedResult = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores], [Product].[All Products], [Customers].[All Customers]}\nRow #0: 266,773\n");
        this.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin({[Store].[All Stores]}, Crossjoin({[Product].[All Products]}, {[Customers].[All Customers]})) ON ROWS from [Sales]", expectedResult);
        this.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS,   Crossjoin({[Store].[All Stores]}, Crossjoin({[Product].[All Products]}, {[Customers].[All Customers]})) ON ROWS from [Sales]", expectedResult);
        this.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY [Store].[All Stores]  * [Product].[All Products] * [Customers].[All Customers] ON ROWS from [Sales]", expectedResult);
        this.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY [Store].[All Stores]  * {([Product].[All Products],     [Customers].[All Customers])} ON ROWS from [Sales]", expectedResult);
        String expectedResult4 = BasicQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores], [Product].[All Products], [Customers].[All Customers], [Gender].[All Gender]}\nRow #0: 266,773\n");
        this.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY [Store].[All Stores]  * [Product].[All Products] * {([Customers].[All Customers], [Gender].[All Gender])} ON ROWS from [Sales]", expectedResult4);
        this.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY [Store].[All Stores]  * {([Product].[All Products], [Customers].[All Customers])} * [Gender].[All Gender] ON ROWS from [Sales]", expectedResult4);
        this.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY {([Store].[All Stores], [Product].[All Products])} * [Customers].[All Customers] * [Gender].[All Gender] ON ROWS from [Sales]", expectedResult4);
    }

    public static class SleepUdf
    implements UserDefinedFunction {
        public String getName() {
            return "SleepUdf";
        }

        public String getDescription() {
            return "Returns its argument plus one but sleeps 1 ms first";
        }

        public Syntax getSyntax() {
            return Syntax.Function;
        }

        public Type getReturnType(Type[] parameterTypes) {
            return new NumericType();
        }

        public Type[] getParameterTypes() {
            return new Type[]{new NumericType()};
        }

        public Object execute(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
            Object argValue = arguments[0].evaluateScalar(evaluator);
            if (argValue instanceof Number) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception ex) {
                    return null;
                }
                return ((Number)argValue).doubleValue() + 1.0;
            }
            return null;
        }

        public String[] getReservedWords() {
            return null;
        }
    }
}

