/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.MultiDataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiFileLoader
extends DataLoader {
    private static final long serialVersionUID = 1521919955690157343L;

    @Deprecated
    protected MultiFileLoader(Class<? extends DataObject> clazz) {
        super(clazz);
    }

    protected MultiFileLoader(String string) {
        super(string);
    }

    @Override
    protected final DataObject handleFindDataObject(FileObject fileObject, DataLoader.RecognizedFiles recognizedFiles) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        FileObject fileObject2;
        block27: {
            fileObject2 = this.findPrimaryFileImpl(fileObject);
            if (fileObject2 == null) {
                return null;
            }
            bl = ERR.isLoggable(Level.FINE);
            if (bl) {
                ERR.fine(((Object)((Object)this)).getClass().getName() + " is accepting: " + fileObject);
            }
            if (fileObject2 != fileObject) {
                if (bl) {
                    ERR.fine("checking correctness: primary is different than provided file: " + fileObject2 + " fo: " + fileObject);
                }
                object4 = DataLoaderPool.getDefault().allLoaders();
                while (true) {
                    if ((object3 = (DataLoader)((Object)object4.nextElement())) == this) {
                        ERR.fine("ok, consistent");
                        break block27;
                    }
                    if (!(object3 instanceof MultiFileLoader) || ((MultiFileLoader)((Object)(object2 = (MultiFileLoader)((Object)object3)))).findPrimaryFile(fileObject2) != fileObject2) continue;
                    if (bl) {
                        ERR.fine("loader seems to also take care of the file: " + object2);
                    }
                    try {
                        object = ((DataLoader)((Object)object2)).findDataObject(fileObject2, recognizedFiles);
                    }
                    catch (DataObjectExistsException dataObjectExistsException) {
                        object = dataObjectExistsException.getDataObject();
                    }
                    if (object != null) break;
                }
                return null;
            }
        }
        try {
            object4 = this.createMultiObject(fileObject2);
            if (bl) {
                ERR.fine(((Object)((Object)this)).getClass().getName() + " created object for: " + fileObject + " obj: " + object4);
            }
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            object2 = dataObjectExistsException.getDataObject();
            if (bl) {
                ERR.fine(((Object)((Object)this)).getClass().getName() + " object already exists for: " + fileObject + " obj: " + object2);
            }
            if (((DataObject)object2).getLoader() != this) {
                if (bl) {
                    ERR.fine(((Object)((Object)this)).getClass().getName() + " loader is wrong: " + ((Object)((Object)((DataObject)object2).getLoader())).getClass().getName());
                }
                if (((DataObject)object2).getLoader() instanceof MultiFileLoader) {
                    object = (MultiFileLoader)((DataObject)object2).getLoader();
                    FileObject fileObject3 = object.findPrimaryFileImpl(fileObject);
                    ERR.log(Level.FINE, "Its primary file is {0}", fileObject3);
                    if (fileObject3 != null && ((DataObject)object2).getPrimaryFile() != fileObject3) {
                        ERR.log(Level.FINE, "Which is different than primary of found: {0}", object2);
                        Enumeration<DataLoader> enumeration = DataLoaderPool.getDefault().allLoaders();
                        while (enumeration.hasMoreElements()) {
                            DataLoader dataLoader = enumeration.nextElement();
                            if (dataLoader == object) {
                                ERR.log(Level.FINE, "Returning null");
                                return null;
                            }
                            if (dataLoader != this) continue;
                            ERR.log(Level.FINE, "The loader" + (Object)object + " is after " + (Object)((Object)this) + ". So do break.");
                            break;
                        }
                    }
                }
                object2 = this.checkCollision((DataObject)object2, fileObject);
            }
            if (!(object2 instanceof MultiDataObject)) {
                if (bl) {
                    ERR.fine(((Object)((Object)this)).getClass().getName() + " object is not MultiDataObject: " + object2);
                }
                throw dataObjectExistsException;
            }
            object4 = (MultiDataObject)object2;
        }
        catch (IOException iOException) {
            ERR.log(Level.FINE, null, iOException);
            throw iOException;
        }
        if (((DataObject)object4).getLoader() != this) {
            if (bl) {
                ERR.fine(((Object)((Object)this)).getClass().getName() + " wrong loader: " + ((Object)((Object)((DataObject)object4).getLoader())).getClass().getName());
            }
            return object4;
        }
        if (bl) {
            ERR.fine(((Object)((Object)this)).getClass().getName() + " marking secondary entries");
        }
        ((MultiDataObject)object4).markSecondaryEntriesRecognized(recognizedFiles);
        if (bl) {
            ERR.fine(((Object)((Object)this)).getClass().getName() + " register entry: " + fileObject);
        }
        object3 = ((MultiDataObject)object4).registerEntry(fileObject);
        if (bl) {
            ERR.fine(((Object)((Object)this)).getClass().getName() + " success: " + (Object)object3);
        }
        return object4;
    }

    protected abstract FileObject findPrimaryFile(FileObject var1);

    protected abstract MultiDataObject createMultiObject(FileObject var1) throws DataObjectExistsException, IOException;

    protected abstract MultiDataObject.Entry createPrimaryEntry(MultiDataObject var1, FileObject var2);

    protected abstract MultiDataObject.Entry createSecondaryEntry(MultiDataObject var1, FileObject var2);

    DataObject checkCollision(DataObject dataObject, FileObject fileObject) {
        FileObject fileObject2 = dataObject.getPrimaryFile();
        DataObjectPool.getPOOL().revalidate(new HashSet<FileObject>(Collections.singleton(fileObject2)));
        DataObject dataObject2 = DataObjectPool.getPOOL().find(fileObject2);
        return dataObject2;
    }

    void checkConsistency(MultiDataObject multiDataObject) {
        FileObject fileObject = multiDataObject.getPrimaryFile();
        if (fileObject.equals(this.findPrimaryFileImpl(fileObject))) {
            return;
        }
        try {
            multiDataObject.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    void checkFiles(MultiDataObject multiDataObject) {
        FileObject fileObject = multiDataObject.getPrimaryFile();
        assert (fileObject != null) : "Object " + multiDataObject + " cannot have null primary file";
        FileObject fileObject2 = fileObject.getParent();
        assert (fileObject2 != null) : "Object " + multiDataObject + " cannot have null parent file";
        FileObject[] fileObjectArray = fileObject2.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject3 = this.findPrimaryFileImpl(fileObjectArray[i]);
            if (fileObject3 != fileObject) continue;
            try {
                DataObject.find(fileObjectArray[i]);
                continue;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    MultiDataObject.Entry createSecondaryEntryImpl(MultiDataObject multiDataObject, FileObject fileObject) {
        return this.createSecondaryEntry(multiDataObject, fileObject);
    }

    FileObject findPrimaryFileImpl(FileObject fileObject) {
        return this.findPrimaryFile(fileObject);
    }
}

