/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.lang.reflect.InvocationTargetException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;
import org.springframework.remoting.rmi.RmiInvocationHandler;
import org.springframework.remoting.support.RemoteInvocationBasedAccessor;

public class RmiClientInterceptor
extends RemoteInvocationBasedAccessor
implements MethodInterceptor,
InitializingBean {
    private boolean lookupStubOnStartup = true;
    private boolean cacheStub = true;
    private boolean refreshStubOnConnectFailure = false;
    private Remote cachedStub;

    public void setLookupStubOnStartup(boolean lookupStubOnStartup) {
        this.lookupStubOnStartup = lookupStubOnStartup;
    }

    public void setCacheStub(boolean cacheStub) {
        this.cacheStub = cacheStub;
    }

    public void setRefreshStubOnConnectFailure(boolean refreshStubOnConnectFailure) {
        this.refreshStubOnConnectFailure = refreshStubOnConnectFailure;
    }

    public void afterPropertiesSet() throws Exception {
        this.prepare();
    }

    public void prepare() throws Exception {
        if (this.getServiceUrl() == null) {
            throw new IllegalArgumentException("serviceUrl is required");
        }
        if (this.lookupStubOnStartup) {
            Remote remoteObj = this.lookupStub();
            if (this.logger.isInfoEnabled()) {
                if (remoteObj instanceof RmiInvocationHandler) {
                    this.logger.info((Object)("RMI stub [" + this.getServiceUrl() + "] is an RMI invoker"));
                } else if (this.getServiceInterface() != null) {
                    boolean isImpl = this.getServiceInterface().isInstance(remoteObj);
                    this.logger.info((Object)("Using service interface [" + this.getServiceInterface().getName() + "] for RMI stub [" + this.getServiceUrl() + "] - " + (!isImpl ? "not " : "") + "directly implemented"));
                }
            }
            if (this.cacheStub) {
                this.cachedStub = remoteObj;
            }
        }
    }

    protected Remote lookupStub() throws Exception {
        Remote stub = Naming.lookup(this.getServiceUrl());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Located RMI stub with URL [" + this.getServiceUrl() + "]"));
        }
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Remote getStub() throws Exception {
        if (!this.cacheStub || this.lookupStubOnStartup && !this.refreshStubOnConnectFailure) {
            return this.cachedStub != null ? this.cachedStub : this.lookupStub();
        }
        RmiClientInterceptor rmiClientInterceptor = this;
        synchronized (rmiClientInterceptor) {
            if (this.cachedStub == null) {
                this.cachedStub = this.lookupStub();
            }
            return this.cachedStub;
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Remote stub = null;
        try {
            stub = this.getStub();
        }
        catch (Throwable ex) {
            throw new RemoteLookupFailureException("RMI lookup for service [" + this.getServiceUrl() + "] failed", ex);
        }
        try {
            return this.doInvoke(invocation, stub);
        }
        catch (RemoteConnectFailureException ex) {
            return this.handleRemoteConnectFailure(invocation, ex);
        }
        catch (RemoteException ex) {
            if (this.isConnectFailure(ex)) {
                return this.handleRemoteConnectFailure(invocation, ex);
            }
            throw ex;
        }
    }

    protected boolean isConnectFailure(RemoteException ex) {
        return RmiClientInterceptorUtils.isConnectFailure(ex);
    }

    private Object handleRemoteConnectFailure(MethodInvocation invocation, Exception ex) throws Throwable {
        if (this.refreshStubOnConnectFailure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not connect to RMI service [" + this.getServiceUrl() + "] - retrying"), (Throwable)ex);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Could not connect to RMI service [" + this.getServiceUrl() + "] - retrying"));
            }
            return this.refreshAndRetry(invocation);
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object refreshAndRetry(MethodInvocation invocation) throws Throwable {
        Remote freshStub = null;
        RmiClientInterceptor rmiClientInterceptor = this;
        synchronized (rmiClientInterceptor) {
            try {
                freshStub = this.lookupStub();
                if (this.cacheStub) {
                    this.cachedStub = freshStub;
                }
            }
            catch (Throwable ex) {
                throw new RemoteLookupFailureException("RMI lookup for service [" + this.getServiceUrl() + "] failed", ex);
            }
        }
        return this.doInvoke(invocation, freshStub);
    }

    protected Object doInvoke(MethodInvocation invocation, Remote stub) throws Throwable {
        if (stub instanceof RmiInvocationHandler) {
            try {
                return this.doInvoke(invocation, (RmiInvocationHandler)stub);
            }
            catch (RemoteException ex) {
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), ex, this.isConnectFailure(ex), this.getServiceUrl());
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            catch (Throwable ex) {
                throw new AspectException("Failed to invoke remote service [" + this.getServiceUrl() + "]", ex);
            }
        }
        try {
            return RmiClientInterceptorUtils.doInvoke(invocation, stub);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof RemoteException) {
                RemoteException rex = (RemoteException)targetEx;
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), rex, this.isConnectFailure(rex), this.getServiceUrl());
            }
            throw targetEx;
        }
    }

    protected Object doInvoke(MethodInvocation methodInvocation, RmiInvocationHandler invocationHandler) throws RemoteException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (AopUtils.isToStringMethod(methodInvocation.getMethod())) {
            return "RMI invoker proxy for service URL [" + this.getServiceUrl() + "]";
        }
        return invocationHandler.invoke(this.createRemoteInvocation(methodInvocation));
    }
}

