/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.locale;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.plugin.locale.JasperBabylonRunner;
import it.businesslogic.ireport.plugin.locale.JasperBabylonRunnerListener;
import it.businesslogic.ireport.plugin.locale.MissingResourceCellRenderer;
import it.businesslogic.ireport.plugin.locale.ResourceKey;
import it.businesslogic.ireport.plugin.locale.TranslationStatusDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TranslationStatusDetailDialog
extends JDialog
implements JasperBabylonRunnerListener {
    private Properties properties = null;
    private String fileName = "";
    private JButton jButtonDetails;
    private JButton jButtonExportToJB;
    private JButton jButtonImportFromJB;
    private JButton jButtonOk;
    private JButton jButtonSave;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTable jTableLanguages;
    static /* synthetic */ Class class$java$lang$String;

    public TranslationStatusDetailDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public TranslationStatusDetailDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    private void initAll() {
        this.initComponents();
        TableColumnModel tcm = this.jTableLanguages.getColumnModel();
        TableColumn tc = tcm.getColumn(0);
        tc.setCellRenderer(new MissingResourceCellRenderer());
        DefaultListSelectionModel dsm = new DefaultListSelectionModel();
        dsm.setSelectionMode(0);
        dsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TranslationStatusDetailDialog.this.jButtonDetails.setEnabled(TranslationStatusDetailDialog.this.jTableLanguages.getSelectedRow() >= 0);
            }
        });
        this.jTableLanguages.setSelectionModel(dsm);
        this.applyI18n();
        this.pack();
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TranslationStatusDetailDialog.this.jButtonOkActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOk);
    }

    public void setLanguage(String language, Properties defaultTranslations) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableLanguages.getModel();
        dtm.setRowCount(0);
        this.properties = new Properties();
        this.fileName = language;
        try {
            this.properties.load(MainFrame.getMainInstance().getReportClassLoader().getResourceAsStream("it/businesslogic/ireport/locale/" + language));
        }
        catch (Exception ex) {
            // empty catch block
        }
        Iterator<Object> namesIterator = defaultTranslations.keySet().iterator();
        Object[] names = new String[defaultTranslations.keySet().size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)namesIterator.next();
        }
        Arrays.sort(names);
        double translated = 0.0;
        for (int i = 0; i < names.length; ++i) {
            String name = "" + (String)names[i];
            ResourceKey rk = new ResourceKey(name);
            if (this.properties.getProperty(name) == null) {
                rk.setMissing(true);
            }
            dtm.addRow(new Object[]{rk, !rk.isMissing() ? this.properties.getProperty(name) : "", defaultTranslations.getProperty(name)});
        }
        this.jTableLanguages.updateUI();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jButtonImportFromJB = new JButton();
        this.jButtonExportToJB = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableLanguages = new JTable();
        this.jPanel1 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonDetails = new JButton();
        this.jButtonOk = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButtonImportFromJB.setText("Import from JasperBabylon");
        this.jButtonImportFromJB.setActionCommand("Import from JasperBabylon");
        this.jButtonImportFromJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDetailDialog.this.jButtonExportToJBjButtonDetailsActionPerformed2(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel2.add((Component)this.jButtonImportFromJB, gridBagConstraints);
        this.jButtonExportToJB.setText("Export to JasperBabylon");
        this.jButtonExportToJB.setActionCommand("Export to JasperBabylon");
        this.jButtonExportToJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDetailDialog.this.jButtonDetailsActionPerformed2(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel2.add((Component)this.jButtonExportToJB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jTableLanguages.setModel(new DefaultTableModel(new Object[0][], new String[]{"Key", "Translation", "Default"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TranslationStatusDetailDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TranslationStatusDetailDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TranslationStatusDetailDialog.class$("java.lang.String")) : class$java$lang$String};
                this.canEdit = new boolean[]{false, true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableLanguages.setGridColor(new Color(204, 204, 204));
        this.jTableLanguages.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TranslationStatusDetailDialog.this.jTableLanguagesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableLanguages);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDetailDialog.this.jButtonDetailsActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonDetails.setLabel("Export to file");
        this.jButtonDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDetailDialog.this.jButtonDetailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButtonDetails, gridBagConstraints);
        this.jButtonOk.setText("Close");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDetailDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButtonExportToJBjButtonDetailsActionPerformed2(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        JasperBabylonRunner jbr = new JasperBabylonRunner();
        jbr.setRunnerListener(this);
        String code = this.getFileName();
        if (code.startsWith("Ireport_")) {
            code = code.substring(8);
        }
        if (code.endsWith(".properties")) {
            code = code.substring(0, code.length() - 11);
        }
        jbr.getLocale(code);
    }

    private void jButtonDetailsActionPerformed2(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want send your translation on JasperBabylon?") == 0) {
            Properties p = new Properties();
            for (int i = 0; i < this.jTableLanguages.getRowCount(); ++i) {
                ResourceKey rk = (ResourceKey)this.jTableLanguages.getValueAt(i, 0);
                String value = (String)this.jTableLanguages.getValueAt(i, 1);
                if (value == null || value.length() == 0) continue;
                p.setProperty(rk.getKey(), value);
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            JasperBabylonRunner jbr = new JasperBabylonRunner();
            jbr.setRunnerListener(this);
            String code = this.getFileName();
            if (code.startsWith("Ireport_")) {
                code = code.substring(8);
            }
            if (code.endsWith(".properties")) {
                code = code.substring(0, code.length() - 11);
            }
            jbr.putLocale(code, p);
        }
    }

    private void jButtonDetailsActionPerformed1(ActionEvent evt) {
        Properties p = new Properties();
        for (int i = 0; i < this.jTableLanguages.getRowCount(); ++i) {
            ResourceKey rk = (ResourceKey)this.jTableLanguages.getValueAt(i, 0);
            String value = (String)this.jTableLanguages.getValueAt(i, 1);
            if (value == null || value.length() == 0) continue;
            p.setProperty(rk.getKey(), value);
        }
        Misc.saveTemporaryLocale(p, this.getFileName());
        if (this.getParent() != null && this.getParent() instanceof TranslationStatusDialog) {
            ((TranslationStatusDialog)this.getParent()).updateStatus();
        }
        this.jButtonOkActionPerformed(null);
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonDetailsActionPerformed(ActionEvent evt) {
        try {
            JFileChooser jfc = new JFileChooser();
            jfc.setSelectedFile(new File(this.getFileName()));
            if (jfc.showSaveDialog(this) == 0) {
                FileOutputStream fos = new FileOutputStream(jfc.getSelectedFile());
                this.getProperties().store(fos, "");
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(fos));
                pw.println("\n\n# ---------- Missing translations -------------");
                for (int i = 0; i < this.jTableLanguages.getRowCount(); ++i) {
                    ResourceKey rk = (ResourceKey)this.jTableLanguages.getValueAt(i, 0);
                    if (!rk.isMissing()) continue;
                    pw.println("#" + rk + "=" + this.jTableLanguages.getValueAt(i, 2));
                }
                pw.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jTableLanguagesMouseClicked(MouseEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TranslationStatusDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void applyI18n() {
        this.jButtonDetails.setText(I18n.getString("translationStatusDetailDialog.buttonDetails", "Export"));
        this.jButtonOk.setText(I18n.getString("translationStatusDetailDialog.buttonOk", "Close"));
        this.jTableLanguages.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("translationStatusDetailDialog.tablecolumn.key", "Key"));
        this.jTableLanguages.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("translationStatusDetailDialog.tablecolumn.translation", "Translation"));
        this.jTableLanguages.getColumnModel().getColumn(2).setHeaderValue(I18n.getString("translationStatusDetailDialog.tablecolumn.default", "Default"));
        this.jButtonExportToJB.setText(I18n.getString("translationStatusDetailDialog.buttonExportToJB", "Export to JasperBabylon"));
        this.jButtonImportFromJB.setText(I18n.getString("translationStatusDetailDialog.buttonImportFromJB", "Import from JasperBabylon"));
        this.jButtonSave.setText(I18n.getString("translationStatusDetailDialog.buttonSave", "Save"));
    }

    public void listLocalesComplete(List list) {
    }

    public void getLocaleComplete(Properties props) {
        for (int i = 0; i < this.jTableLanguages.getRowCount(); ++i) {
            ResourceKey rk = (ResourceKey)this.jTableLanguages.getValueAt(i, 0);
            if (props.getProperty(rk.getKey()) == null) continue;
            rk.setMissing(false);
            this.jTableLanguages.setValueAt(props.getProperty(rk.getKey()), i, 1);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TranslationStatusDetailDialog.this.setCursor(Cursor.getDefaultCursor());
                    TranslationStatusDetailDialog.this.jTableLanguages.updateUI();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void putLocaleComplete(String returnMessage) {
        try {
            final String msg = returnMessage;
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TranslationStatusDetailDialog.this.setCursor(Cursor.getDefaultCursor());
                    JOptionPane.showMessageDialog(TranslationStatusDetailDialog.this, msg);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void operationError(int operation, String message) {
        try {
            final String msg = message;
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TranslationStatusDetailDialog.this.setCursor(Cursor.getDefaultCursor());
                    JOptionPane.showMessageDialog(TranslationStatusDetailDialog.this, msg);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

