/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConnectionDialog
extends JDialog {
    protected IReportConnection iReportConnection = null;
    protected IReportConnectionEditor iReportConnectionEditor = null;
    private int dialogResult = 2;
    private int step = 0;
    private JButton jButtonCancel;
    private JButton jButtonSave;
    private JButton jButtonTest;
    private JLabel jLabel2;
    private JLabel jLabelName;
    private JLabel jLabelTitle;
    private JList jList1;
    private JPanel jPanelButtons;
    private JPanel jPanelCustomComponent;
    private JPanel jPanelModifyDatasource;
    private JPanel jPanelNewDatasource;
    private JPanel jPanelRoot;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTextField jTextFieldName;

    public ConnectionDialog(Frame parent, boolean isNewDatasource) {
        super(parent, true);
        this.initAll(isNewDatasource);
    }

    public ConnectionDialog(Dialog parent, boolean isNewDatasource) {
        super(parent, true);
        this.initAll(isNewDatasource);
    }

    public void initAll(boolean isNewDatasource) {
        this.initComponents();
        if (isNewDatasource) {
            this.setStep(0);
            DefaultListModel<Tag> dlm = new DefaultListModel<Tag>();
            List types = MainFrame.getMainInstance().getConnectionImplementations();
            for (int i = 0; i < types.size(); ++i) {
                String cName = "" + types.get(i);
                try {
                    IReportConnection c = (IReportConnection)Class.forName(cName, true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
                    String sName = c.getDescription();
                    dlm.addElement(new Tag(c, sName));
                    continue;
                }
                catch (Throwable tw) {
                    tw.printStackTrace();
                }
            }
            this.jList1.setModel(dlm);
            this.jButtonSave.setEnabled(false);
            if (this.jList1.getModel().getSize() > 0) {
                this.jList1.setSelectedIndex(0);
            }
        }
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.applyI18n();
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonSave);
        this.pack();
        Misc.centerFrame(this);
    }

    public void setIReportConnection(IReportConnection conn) {
        this.setIReportConnection(conn, false);
    }

    private void setIReportConnection(IReportConnection conn, boolean isNew) {
        if (conn == null) {
            return;
        }
        this.iReportConnection = this.cloneConnection(conn);
        this.jTextFieldName.setText(this.iReportConnection.getName());
        this.jLabelTitle.setText(conn.getDescription());
        this.jButtonSave.setText(I18n.getString("connectionDialog.buttonOK", "Save"));
        this.jButtonTest.setEnabled(true);
        this.setStep(1);
        this.jPanelRoot.removeAll();
        this.iReportConnectionEditor = this.iReportConnection.getIReportConnectionEditor();
        if (!isNew) {
            this.iReportConnectionEditor.setIReportConnection(this.iReportConnection);
        }
        this.jPanelCustomComponent.add((Component)((Object)this.iReportConnectionEditor));
        this.jPanelRoot.add(this.jPanelModifyDatasource);
        this.jPanelRoot.updateUI();
        this.jTextFieldName.requestFocusInWindow();
    }

    public IReportConnection getIReportConnection() {
        return this.iReportConnection;
    }

    private void initComponents() {
        this.jPanelModifyDatasource = new JPanel();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator3 = new JSeparator();
        this.jPanelCustomComponent = new JPanel();
        this.jLabelTitle = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanelRoot = new JPanel();
        this.jPanelNewDatasource = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jSeparator2 = new JSeparator();
        this.jPanelButtons = new JPanel();
        this.jButtonTest = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanelModifyDatasource.setLayout(new GridBagLayout());
        this.jLabelName.setText("Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelModifyDatasource.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelModifyDatasource.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator3.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelModifyDatasource.add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanelCustomComponent.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelModifyDatasource.add((Component)this.jPanelCustomComponent, gridBagConstraints);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jLabelTitle.setBackground(new Color(255, 255, 255));
        this.jLabelTitle.setFont(new Font("Dialog", 1, 12));
        this.jLabelTitle.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/datasource/datasource.png")));
        this.jLabelTitle.setText("<html>Datasource");
        this.jLabelTitle.setVerticalAlignment(3);
        this.jLabelTitle.setOpaque(true);
        this.jLabelTitle.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jLabelTitle, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanelRoot.setLayout(new BorderLayout());
        this.jPanelRoot.setPreferredSize(new Dimension(440, 400));
        this.jPanelNewDatasource.setLayout(new GridBagLayout());
        this.jLabel2.setText("Select the datasource type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelNewDatasource.add((Component)this.jLabel2, gridBagConstraints);
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ConnectionDialog.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ConnectionDialog.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelNewDatasource.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanelRoot.add((Component)this.jPanelNewDatasource, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanelRoot, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jPanelButtons.setMinimumSize(new Dimension(50, 30));
        this.jPanelButtons.setPreferredSize(new Dimension(50, 30));
        this.jButtonTest.setText("Test");
        this.jButtonTest.setEnabled(false);
        this.jButtonTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.jButtonTestActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelButtons.add((Component)this.jButtonTest, gridBagConstraints);
        this.jButtonSave.setText("Next >");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelButtons.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelButtons.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanelButtons, gridBagConstraints);
        this.pack();
    }

    private void jButtonTestActionPerformed(ActionEvent evt) {
        IReportConnection tmpIReportConnection = this.iReportConnectionEditor.getIReportConnection();
        if (tmpIReportConnection != null) {
            try {
                tmpIReportConnection.test();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
            this.jButtonSaveActionPerformed(null);
        }
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.getStep() == 0) {
            if (this.jList1.getSelectedValue() == null) {
                return;
            }
            IReportConnection ic = (IReportConnection)((Tag)this.jList1.getSelectedValue()).getValue();
            this.setIReportConnection(ic, true);
            return;
        }
        if (this.jTextFieldName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.connectionDialog.invalidName", "Please insert a valid connection name!"), I18n.getString("messages.connectionDialog.invalidNameCaption", "Invalid connection name!"), 2);
            return;
        }
        IReportConnection tmpIReportConnection = this.iReportConnectionEditor.getIReportConnection();
        if (tmpIReportConnection == null) {
            return;
        }
        tmpIReportConnection.setName(this.jTextFieldName.getText());
        this.iReportConnection = tmpIReportConnection;
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.jButtonSave.setEnabled(this.jList1.getSelectedIndex() >= 0);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ConnectionDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public void applyI18n() {
        this.jButtonSave.setText(I18n.getString("next", "Next >"));
        this.jButtonCancel.setText(I18n.getString("connectionDialog.buttonCancel", "Cancel"));
        this.jButtonTest.setText(I18n.getString("connectionDialog.buttonOK1", "Test"));
        this.jLabelTitle.setText(I18n.getString("connectionDialog.newDatasourceTitle", "New datasource"));
        this.jLabelName.setText(I18n.getString("connectionDialog.label1", "Name"));
        this.setTitle(I18n.getString("connectionDialog.title", "Connections properties"));
        this.jButtonCancel.setMnemonic(I18n.getString("connectionDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonSave.setMnemonic(I18n.getString("connectionDialog.buttonOKMnemonic", "o").charAt(0));
        this.jButtonTest.setMnemonic(I18n.getString("connectionDialog.buttonOK1Mnemonic", "t").charAt(0));
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public IReportConnection cloneConnection(IReportConnection conn) {
        if (conn == null) {
            return null;
        }
        Class<?> clazz = conn.getClass();
        try {
            IReportConnection newConn = (IReportConnection)clazz.newInstance();
            newConn.loadProperties(conn.getProperties());
            newConn.setName(conn.getName());
            return newConn;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

