/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import mondrian.olap.Evaluator;
import mondrian.olap.MondrianProperties;
import mondrian.rolap.ChildByNameConstraint;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.DefaultTupleConstraint;
import mondrian.rolap.DescendantsConstraint;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

public class SqlConstraintFactory {
    boolean enabled;
    private static final SqlConstraintFactory instance = new SqlConstraintFactory();

    private SqlConstraintFactory() {
        this.enabled = MondrianProperties.instance().EnableNativeNonEmpty.get();
    }

    public static final SqlConstraintFactory instance() {
        return instance;
    }

    public MemberChildrenConstraint getMemberChildrenConstraint(Evaluator context) {
        if (!this.enabled || context == null) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new SqlContextConstraint((RolapEvaluator)context, false);
    }

    public TupleConstraint getLevelMembersConstraint(Evaluator context) {
        if (!this.enabled || context == null) {
            return DefaultTupleConstraint.instance();
        }
        return new SqlContextConstraint((RolapEvaluator)context, false);
    }

    public MemberChildrenConstraint getChildByNameConstraint(RolapMember parent, String childName) {
        if (!this.enabled || parent.getRolapHierarchy().isRagged()) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new ChildByNameConstraint(childName);
    }

    public TupleConstraint getDescendantsConstraint(List parentMembers, MemberChildrenConstraint mcc) {
        return new DescendantsConstraint(parentMembers, mcc);
    }
}

