/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.NativeEvaluator;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.RolapNativeFilter;
import mondrian.rolap.RolapNativeTopCount;

public class RolapNativeRegistry
extends RolapNative {
    private List natives = new ArrayList();

    public RolapNativeRegistry() {
        super.setEnabled(true);
        this.register(new RolapNativeCrossJoin());
        this.register(new RolapNativeTopCount());
        this.register(new RolapNativeFilter());
    }

    public NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        RolapEvaluator revaluator = evaluator;
        Iterator it = this.natives.iterator();
        while (it.hasNext()) {
            RolapNative rn = (RolapNative)it.next();
            NativeEvaluator ne = rn.createEvaluator(revaluator, fun, args);
            if (ne == null) continue;
            if (this.listener != null) {
                RolapNative.NativeEvent e = new RolapNative.NativeEvent(this, ne);
                this.listener.foundEvaluator(e);
            }
            return ne;
        }
        return null;
    }

    public void register(RolapNative rn) {
        this.natives.add(rn);
    }

    void setListener(RolapNative.Listener listener) {
        super.setListener(listener);
        Iterator it = this.natives.iterator();
        while (it.hasNext()) {
            RolapNative rn = (RolapNative)it.next();
            rn.setListener(listener);
        }
    }

    void useHardCache(boolean hard) {
        Iterator it = this.natives.iterator();
        while (it.hasNext()) {
            RolapNative rn = (RolapNative)it.next();
            rn.useHardCache(hard);
        }
    }
}

