/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.Category;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

public class Parameter
extends ExpBase {
    private final String name;
    private final int category;
    private final String description;
    private Exp exp;
    private int defineCount;
    private final Type type;

    Parameter(String name, int category, Exp exp, String description, Type type) {
        this.name = name;
        this.category = category;
        this.exp = exp;
        this.defineCount = 1;
        this.description = description;
        this.type = type;
    }

    static Parameter[] cloneArray(Parameter[] a) {
        if (a == null) {
            return null;
        }
        Parameter[] a2 = new Parameter[a.length];
        for (int i = 0; i < a.length; ++i) {
            a2[i] = (Parameter)a[i].clone();
        }
        return a2;
    }

    public int getCategory() {
        return this.category;
    }

    public Type getTypeX() {
        return this.type;
    }

    public Exp getExp() {
        return this.exp;
    }

    void incrementDefineCount() {
        ++this.defineCount;
    }

    int getDefineCount() {
        return this.defineCount;
    }

    void resetDefineCount() {
        this.defineCount = 0;
    }

    public Exp accept(Validator validator) {
        Parameter p = validator.getQuery().lookupParam(this.name);
        if (p == null) {
            throw Util.newInternal("parameter '" + this.name + "' not registered");
        }
        return p;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value, Query query) {
        this.exp = this.quickParse(value, query);
    }

    Exp quickParse(String value, Query query) {
        switch (this.category) {
            case 7: {
                return Literal.create(new Double(value));
            }
            case 9: {
                return Literal.createString(value);
            }
            case 6: {
                return Util.lookup(query, Util.explode(value));
            }
        }
        throw Category.instance.badValue(this.category);
    }

    public Object getValue() {
        switch (this.category) {
            case 7: {
                if (this.exp instanceof FunCall) {
                    FunCall f = (FunCall)this.exp;
                    if (f.getFunName().equals("-")) {
                        Literal lit = (Literal)f.getArg(0);
                        Object o = lit.getValue();
                        if (o instanceof Double) {
                            return new Double(-((Double)o).doubleValue());
                        }
                        if (o instanceof Integer) {
                            return new Integer(-((Integer)o).intValue());
                        }
                        if (o instanceof Integer) {
                            return o;
                        }
                    } else {
                        throw Util.newInternal("bad FunCall " + f);
                    }
                }
                return ((Literal)this.exp).getValue();
            }
            case 9: {
                return ((Literal)this.exp).getValue();
            }
        }
        return (Member)this.exp;
    }

    public void setValue(Object value) {
        switch (this.category) {
            case 7: {
                this.exp = Literal.create((Double)value);
                break;
            }
            case 9: {
                this.exp = Literal.createString((String)value);
                break;
            }
            default: {
                this.exp = (Member)value;
            }
        }
    }

    public String getParameterType() {
        return Category.instance.getName(this.category).toUpperCase();
    }

    public String getDescription() {
        return this.description;
    }

    public void validate(Query q) {
        switch (this.defineCount) {
            case 0: {
                throw MondrianResource.instance().MdxParamNeverDef.ex(this.name);
            }
            case 1: {
                break;
            }
            default: {
                throw MondrianResource.instance().MdxParamMultipleDef.ex(this.name, new Integer(this.defineCount));
            }
        }
        if (this.exp == null) {
            throw MondrianResource.instance().MdxParamValueNotFound.ex(this.name);
        }
    }

    public Object clone() {
        return new Parameter(this.name, this.category, this.exp, this.description, this.type);
    }

    public void unparse(PrintWriter pw) {
        boolean firstPrinting = true;
        if (pw instanceof Query.QueryPrintWriter) {
            firstPrinting = ((Query.QueryPrintWriter)pw).parameters.add(this);
        }
        if (firstPrinting) {
            pw.print("Parameter(" + Util.quoteForMdx(this.name) + ", ");
            switch (this.category) {
                case 7: 
                case 9: {
                    pw.print(this.getParameterType());
                    break;
                }
                case 6: {
                    this.type.getHierarchy().unparse(pw);
                    break;
                }
                default: {
                    throw Category.instance.badValue(this.category);
                }
            }
            pw.print(", ");
            this.exp.unparse(pw);
            if (this.description != null) {
                pw.print(", " + Util.quoteForMdx(this.description));
            }
            pw.print(")");
        } else {
            pw.print("ParamRef(" + Util.quoteForMdx(this.name) + ")");
        }
    }

    public Object[] getChildren() {
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Parameter)) {
            return false;
        }
        Parameter that = (Parameter)other;
        return that.getName().equals(this.getName()) && that.getCategory() == this.getCategory() && that.exp.equals(this.exp);
    }

    public Object evaluate(Evaluator evaluator) {
        return evaluator.visit(this);
    }
}

