/*
 * Decompiled with CFR 0.152.
 */
package rex.olap.mdxparse;

import java.util.ArrayList;
import java.util.Iterator;
import rex.olap.mdxparse.Exp;
import rex.olap.mdxparse.ExpVisitor;

public class CompoundId
implements Exp {
    private ArrayList names = new ArrayList();

    public CompoundId(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public CompoundId(String name) {
        this(name, false);
    }

    public void append(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public void append(String name) {
        this.names.add(new NamePart(name, false));
    }

    public String[] toStringArray() {
        String[] ret = new String[this.names.size()];
        int i = 0;
        Iterator iter = this.names.iterator();
        while (iter.hasNext()) {
            NamePart np = (NamePart)iter.next();
            ret[i++] = np.name;
        }
        return ret;
    }

    public String toMdx() {
        String str = "";
        boolean isFollow = false;
        Iterator iter = this.names.iterator();
        while (iter.hasNext()) {
            NamePart np = (NamePart)iter.next();
            if (isFollow) {
                str = str + ".";
            }
            isFollow = true;
            str = str + np.name;
        }
        return str;
    }

    private CompoundId() {
    }

    public Object clone() {
        CompoundId cloned = new CompoundId();
        Iterator iter = this.names.iterator();
        while (iter.hasNext()) {
            NamePart np = (NamePart)iter.next();
            cloned.append(np.name, np.isKey);
        }
        return cloned;
    }

    public void accept(ExpVisitor visitor) {
        visitor.visitCompoundId(this);
    }

    private class NamePart {
        private String name;
        private boolean isKey;

        protected NamePart(String name, boolean isKey) {
            this.name = name;
            this.isKey = isKey;
        }
    }
}

