/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eigenbase.xom.MetaGenerator;
import org.eigenbase.xom.XOMException;

public class XOMGenTask
extends Task {
    String modelFileName;
    String destDir;
    String dtdFileName;
    String className;

    public void execute() throws BuildException {
        if (this.modelFileName == null) {
            throw new BuildException("You must specify model.");
        }
        if (this.destDir == null) {
            this.destDir = this.project.getBaseDir().toString();
        }
        if (this.className == null) {
            throw new BuildException("You must specify className.");
        }
        String string = XOMGenTask.classToFileName(this.destDir, this.className);
        try {
            File file = new File(this.modelFileName);
            File file2 = new File(string);
            File file3 = file2.getParentFile();
            File file4 = new File(file3, this.dtdFileName);
            if (file.exists() && file2.exists() && file4.exists()) {
                long l = file.lastModified();
                long l2 = file2.lastModified();
                long l3 = file4.lastModified();
                if (l2 > l && l3 > l) {
                    return;
                }
            }
            MetaGenerator metaGenerator = new MetaGenerator(this.modelFileName, false, this.className);
            metaGenerator.writeFiles(this.destDir, this.dtdFileName);
            metaGenerator.writeOutputs();
        }
        catch (XOMException xOMException) {
            throw new BuildException("Generation of model failed: " + xOMException);
        }
        catch (IOException iOException) {
            throw new BuildException("Generation of model failed: " + iOException);
        }
    }

    public void setModel(String string) {
        this.modelFileName = string;
    }

    public void setDestdir(String string) {
        this.destDir = string;
    }

    public void setClassname(String string) {
        this.className = string;
    }

    public void setDtdname(String string) {
        this.dtdFileName = string;
    }

    static String classToFileName(String string, String string2) {
        char c = System.getProperty("file.separator").charAt(0);
        if (string == null) {
            string = "";
        } else if (!string.equals("")) {
            string = string + c;
        }
        return string + string2.replace('.', c) + ".java";
    }
}

