/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRBshGenerator {
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;
    protected final JRSourceCompileTask sourceTask;
    protected Map parametersMap;
    protected Map fieldsMap;
    protected Map variablesMap;
    protected JRVariable[] variables;

    protected JRBshGenerator(JRSourceCompileTask sourceTask) {
        this.sourceTask = sourceTask;
        this.parametersMap = sourceTask.getParametersMap();
        this.fieldsMap = sourceTask.getFieldsMap();
        this.variablesMap = sourceTask.getVariablesMap();
        this.variables = sourceTask.getVariables();
    }

    public static String generateScript(JRSourceCompileTask sourceTask) {
        JRBshGenerator generator = new JRBshGenerator(sourceTask);
        return generator.generateScript();
    }

    protected String generateScript() {
        StringBuffer sb = new StringBuffer();
        this.generateScriptStart(sb);
        this.generateDeclarations(sb);
        this.generateInitMethod(sb);
        sb.append("\n");
        sb.append("\n");
        List expressions = this.sourceTask.getExpressions();
        sb.append(this.generateMethod((byte)3, expressions));
        if (this.sourceTask.isOnlyDefaultEvaluation()) {
            ArrayList empty = new ArrayList();
            sb.append(this.generateMethod((byte)1, empty));
            sb.append(this.generateMethod((byte)2, empty));
        } else {
            sb.append(this.generateMethod((byte)1, expressions));
            sb.append(this.generateMethod((byte)2, expressions));
        }
        this.generateScriptEnd(sb);
        return sb.toString();
    }

    protected final void generateScriptStart(StringBuffer sb) {
        sb.append("//\n");
        sb.append("// Generated by JasperReports - ");
        sb.append(new SimpleDateFormat().format(new Date()));
        sb.append("\n");
        sb.append("//\n");
        sb.append("import net.sf.jasperreports.engine.*;\n");
        sb.append("import net.sf.jasperreports.engine.fill.*;\n");
        sb.append("\n");
        sb.append("import java.util.*;\n");
        sb.append("import java.math.*;\n");
        sb.append("import java.text.*;\n");
        sb.append("import java.io.*;\n");
        sb.append("import java.net.*;\n");
        sb.append("\n");
        String[] imports = this.sourceTask.getImports();
        if (imports != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                sb.append("import ");
                sb.append(imports[i]);
                sb.append(";\n");
            }
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("createBshEvaluator()\n");
        sb.append("{\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("    JREvaluator evaluator = null;\n");
        sb.append("\n");
    }

    protected final void generateDeclarations(StringBuffer sb) {
        Iterator it;
        if (this.parametersMap != null && this.parametersMap.size() > 0) {
            Set parameterNames = this.parametersMap.keySet();
            it = parameterNames.iterator();
            while (it.hasNext()) {
                sb.append("    JRFillParameter parameter_");
                sb.append(JRStringUtil.getLiteral((String)((String)it.next())));
                sb.append(" = null;\n");
            }
        }
        sb.append("\n");
        if (this.fieldsMap != null && this.fieldsMap.size() > 0) {
            Set fieldNames = this.fieldsMap.keySet();
            it = fieldNames.iterator();
            while (it.hasNext()) {
                sb.append("    JRFillField field_");
                sb.append(JRStringUtil.getLiteral((String)((String)it.next())));
                sb.append(" = null;\n");
            }
        }
        sb.append("\n");
        if (this.variables != null && this.variables.length > 0) {
            for (int i = 0; i < this.variables.length; ++i) {
                sb.append("    JRFillVariable variable_");
                sb.append(JRStringUtil.getLiteral((String)this.variables[i].getName()));
                sb.append(" = null;\n");
            }
        }
    }

    protected final void generateInitMethod(StringBuffer sb) {
        sb.append("\n");
        sb.append("\n");
        sb.append("    init(\n");
        sb.append("        JREvaluator evaluator,\n");
        sb.append("        Map parsm,\n");
        sb.append("        Map fldsm,\n");
        sb.append("        Map varsm\n");
        sb.append("        )\n");
        sb.append("    {\n");
        sb.append("        super.evaluator = evaluator;\n");
        sb.append("\n");
        if (this.parametersMap != null && this.parametersMap.size() > 0) {
            Set parameterNames = this.parametersMap.keySet();
            String parameterName2 = null;
            for (String parameterName2 : parameterNames) {
                sb.append("        super.parameter_");
                sb.append(JRStringUtil.getLiteral((String)parameterName2));
                sb.append(" = (JRFillParameter)parsm.get(\"");
                sb.append(parameterName2);
                sb.append("\");\n");
            }
        }
        sb.append("\n");
        if (this.fieldsMap != null && this.fieldsMap.size() > 0) {
            Set fieldNames = this.fieldsMap.keySet();
            String fieldName2 = null;
            for (String fieldName2 : fieldNames) {
                sb.append("        super.field_");
                sb.append(JRStringUtil.getLiteral((String)fieldName2));
                sb.append(" = (JRFillField)fldsm.get(\"");
                sb.append(fieldName2);
                sb.append("\");\n");
            }
        }
        sb.append("\n");
        if (this.variables != null && this.variables.length > 0) {
            String variableName = null;
            for (int i = 0; i < this.variables.length; ++i) {
                variableName = this.variables[i].getName();
                sb.append("        super.variable_");
                sb.append(JRStringUtil.getLiteral((String)variableName));
                sb.append(" = (JRFillVariable)varsm.get(\"");
                sb.append(variableName);
                sb.append("\");\n");
            }
        }
        sb.append("    }\n");
    }

    protected void generateScriptEnd(StringBuffer sb) {
        sb.append("\n");
        sb.append("    str(String key)\n");
        sb.append("    {\n");
        sb.append("        return super.evaluator.str(key);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    msg(String pattern, Object arg0)\n");
        sb.append("    {\n");
        sb.append("        return super.evaluator.msg(pattern, arg0);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    msg(String pattern, Object arg0, Object arg1)\n");
        sb.append("    {\n");
        sb.append("        return super.evaluator.msg(pattern, arg0, arg1);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    msg(String pattern, Object arg0, Object arg1, Object arg2)\n");
        sb.append("    {\n");
        sb.append("        return super.evaluator.msg(pattern, arg0, arg1, arg2);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    return this;\n");
        sb.append("}\n");
    }

    protected final String generateMethod(byte evaluationType, List expressionsList) {
        StringBuffer sb = new StringBuffer();
        sb.append("    Object evaluate");
        sb.append((String)methodSuffixMap.get(new Byte(evaluationType)));
        sb.append("(int id)\n");
        sb.append("    {\n");
        sb.append("        Object value = null;\n");
        sb.append("\n");
        sb.append("        switch (id)\n");
        sb.append("        {\n");
        if (expressionsList != null && !expressionsList.isEmpty()) {
            JRExpression expression2 = null;
            for (JRExpression expression2 : expressionsList) {
                sb.append("            case ");
                sb.append(this.sourceTask.getExpressionId(expression2));
                sb.append(" :\n");
                sb.append("            {\n");
                sb.append("                value = (");
                sb.append(expression2.getValueClassName());
                sb.append(")(");
                sb.append(this.generateExpression(expression2, evaluationType));
                sb.append(");\n");
                sb.append("                break;\n");
                sb.append("            }\n");
            }
        }
        sb.append("           default :\n");
        sb.append("           {\n");
        sb.append("           }\n");
        sb.append("        }\n");
        sb.append("        \n");
        sb.append("        return value;\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    private String generateExpression(JRExpression expression, byte evaluationType) {
        JRParameter jrParameter = null;
        JRField jrField = null;
        JRVariable jrVariable = null;
        StringBuffer sbuffer = new StringBuffer();
        JRExpressionChunk[] chunks = expression.getChunks();
        JRExpressionChunk chunk = null;
        String chunkText = null;
        if (chunks != null && chunks.length > 0) {
            block7: for (int i = 0; i < chunks.length; ++i) {
                chunk = chunks[i];
                chunkText = chunk.getText();
                if (chunkText == null) {
                    chunkText = "";
                }
                switch (chunk.getType()) {
                    case 1: {
                        sbuffer.append(chunkText);
                        continue block7;
                    }
                    case 2: {
                        jrParameter = (JRParameter)this.parametersMap.get(chunkText);
                        sbuffer.append("((");
                        sbuffer.append(jrParameter.getValueClassName());
                        sbuffer.append(")super.parameter_");
                        sbuffer.append(JRStringUtil.getLiteral((String)chunkText));
                        sbuffer.append(".getValue())");
                        continue block7;
                    }
                    case 3: {
                        jrField = (JRField)this.fieldsMap.get(chunkText);
                        sbuffer.append("((");
                        sbuffer.append(jrField.getValueClassName());
                        sbuffer.append(")super.field_");
                        sbuffer.append(JRStringUtil.getLiteral((String)chunkText));
                        sbuffer.append(".get");
                        sbuffer.append((String)fieldPrefixMap.get(new Byte(evaluationType)));
                        sbuffer.append("Value())");
                        continue block7;
                    }
                    case 4: {
                        jrVariable = (JRVariable)this.variablesMap.get(chunkText);
                        sbuffer.append("((");
                        sbuffer.append(jrVariable.getValueClassName());
                        sbuffer.append(")super.variable_");
                        sbuffer.append(JRStringUtil.getLiteral((String)chunkText));
                        sbuffer.append(".get");
                        sbuffer.append((String)variablePrefixMap.get(new Byte(evaluationType)));
                        sbuffer.append("Value())");
                        continue block7;
                    }
                    case 5: {
                        jrParameter = (JRParameter)this.parametersMap.get(chunkText);
                        sbuffer.append("super.evaluator.str(\"");
                        sbuffer.append(chunkText);
                        sbuffer.append("\")");
                    }
                }
            }
        }
        if (sbuffer.length() == 0) {
            sbuffer.append("null");
        }
        return sbuffer.toString();
    }

    static {
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }
}

