/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.connection.JRHibernateConnection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.hibernate.SessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JRSpringLoadedHibernateConnection
extends JRHibernateConnection {
    private static final String PROP_KEY_SPRING_CONFIG = "spring.loaded.hibernate.spring.config";
    private static final String PROP_KEY_SESSION_FACTORY_ID = "spring.loaded.hibernate.session.factory.id";
    private String springConfig = null;
    private String sessionFactoryBeanId = null;

    public String getDescription() {
        return "Spring Loaded Hibernate connection";
    }

    public ApplicationContext getApplicationContext() {
        StringTokenizer parser = new StringTokenizer(this.getSpringConfig(), ",");
        String[] configs = new String[parser.countTokens()];
        int iCount = 0;
        while (parser.hasMoreTokens()) {
            configs[iCount++] = parser.nextToken();
        }
        return new ClassPathXmlApplicationContext(configs);
    }

    public String getSessionFactoryBeanId() {
        return this.sessionFactoryBeanId;
    }

    public void setSessionFactoryBeanId(String sessionFactoryBeanId) {
        this.sessionFactoryBeanId = sessionFactoryBeanId;
    }

    public String getSpringConfig() {
        return this.springConfig;
    }

    public void setSpringConfig(String springConfig) {
        this.springConfig = springConfig;
    }

    public SessionFactory getSessionFactory() {
        return (SessionFactory)this.getApplicationContext().getBean(this.getSessionFactoryBeanId());
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_KEY_SESSION_FACTORY_ID, this.getSessionFactoryBeanId());
        map.put(PROP_KEY_SPRING_CONFIG, this.getSpringConfig());
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setSessionFactoryBeanId((String)map.get(PROP_KEY_SESSION_FACTORY_ID));
        this.setSpringConfig((String)map.get(PROP_KEY_SPRING_CONFIG));
    }
}

