/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SBChooser
extends JDialog {
    private static SBChooser myInstance;
    private static int sat;
    private static int bri;
    private Color reference;
    private Color outColor;
    private JSlider satSlider;
    private JSlider briSlider;
    private JTextField satField;
    private JTextField briField;
    private JTextField redField;
    private JTextField greenField;
    private JTextField blueField;
    private TwoColorField twoColorField;
    private ColorField referenceField;
    private boolean keyInput = false;
    private boolean valueIsAdjusting = false;

    public SBChooser(Frame frame) {
        super(frame, "Saturation/Lightness", true);
        this.setDefaultCloseOperation(1);
        this.setupUI(frame);
    }

    private void setupUI(Frame frame) {
        SliderAction sliderAction = new SliderAction();
        JPanel p1 = new JPanel(new BorderLayout(12, 0));
        JPanel p2 = new JPanel(new GridLayout(2, 1, 0, 8));
        JPanel p3 = new JPanel(new FlowLayout(0, 2, 4));
        JPanel p4 = new JPanel(new BorderLayout(4, 0));
        JPanel p5 = new JPanel(new FlowLayout(0, 0, 0));
        p4.add((Component)new JLabel("Saturation"), "North");
        this.satSlider = new JSlider(-100, 100, sat);
        this.satSlider.addChangeListener(sliderAction);
        this.satSlider.setMajorTickSpacing(100);
        this.satSlider.setPaintTicks(true);
        p4.add((Component)this.satSlider, "Center");
        this.satField = new JTextField("" + this.satSlider.getValue(), 4);
        this.satField.getDocument().addDocumentListener(new SatInputListener());
        this.satField.addKeyListener(new ArrowKeyAction(this.satField, -100, 100));
        this.satField.setHorizontalAlignment(0);
        p5.add(this.satField);
        p4.add((Component)p5, "East");
        p2.add(p4);
        p5 = new JPanel(new FlowLayout(0, 0, 0));
        p4 = new JPanel(new BorderLayout(4, 0));
        p4.add((Component)new JLabel("Lightness"), "North");
        this.briSlider = new JSlider(-100, 100, bri);
        this.briSlider.addChangeListener(sliderAction);
        this.briSlider.setMajorTickSpacing(100);
        this.briSlider.setPaintTicks(true);
        p4.add((Component)this.briSlider, "Center");
        this.briField = new JTextField("" + this.briSlider.getValue(), 4);
        this.briField.getDocument().addDocumentListener(new BriInputListener());
        this.briField.addKeyListener(new ArrowKeyAction(this.briField, -100, 100));
        this.briField.setHorizontalAlignment(0);
        p5.add(this.briField);
        p4.add((Component)p5, "East");
        p2.add(p4);
        p3.add(p2);
        p1.add((Component)p3, "Center");
        p2 = new JPanel(new BorderLayout(0, 6));
        p3 = new JPanel(new FlowLayout(0, 4, 4));
        this.twoColorField = new TwoColorField(this.reference);
        p2.add((Component)this.twoColorField, "North");
        this.referenceField = new ColorField(this.reference);
        p2.add((Component)this.referenceField, "Center");
        p3.add(p2);
        p1.add((Component)p3, "East");
        p3 = new JPanel(new FlowLayout(0, 3, 8));
        p3.add(new JLabel("R:"));
        this.redField = new JTextField(4);
        this.redField.setHorizontalAlignment(0);
        this.redField.setEditable(false);
        p3.add(this.redField);
        p3.add(new JLabel("  G:"));
        this.greenField = new JTextField(4);
        this.greenField.setHorizontalAlignment(0);
        this.greenField.setEditable(false);
        p3.add(this.greenField);
        p3.add(new JLabel("  B:"));
        this.blueField = new JTextField(4);
        this.blueField.setHorizontalAlignment(0);
        this.blueField.setEditable(false);
        p3.add(this.blueField);
        p1.add((Component)p3, "South");
        this.getContentPane().add((Component)p1, "Center");
        p3 = new JPanel(new FlowLayout(2, 12, 4));
        p3.setBorder(new EtchedBorder());
        JButton b = new JButton("Cancel");
        b.addActionListener(new CancelAction());
        p3.add(b);
        b = new JButton("OK");
        this.getRootPane().setDefaultButton(b);
        b.addActionListener(new OKAction());
        p3.add(b);
        this.getContentPane().add((Component)p3, "South");
        this.pack();
        this.getSize();
        ((Component)this).setLocation(frame.getLocationOnScreen().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocationOnScreen().y + (frame.getHeight() - this.getSize().height) / 2);
    }

    public static Color showSBChooser(Frame frame, Color ref, Color inColor, int s, int b) {
        if (myInstance == null) {
            myInstance = new SBChooser(frame);
        }
        myInstance.setColor(ref, inColor, s, b);
        ((Component)myInstance).setVisible(true);
        return SBChooser.myInstance.outColor;
    }

    public static Color showSBChooser(Frame frame, ControlPanel.SBField hsb) {
        if (myInstance == null) {
            myInstance = new SBChooser(frame);
        }
        myInstance.setColor(hsb);
        ((Component)myInstance).setVisible(true);
        return SBChooser.myInstance.outColor;
    }

    public static void deleteInstance() {
        myInstance = null;
    }

    public void setColor(ControlPanel.SBField hsb) {
        this.reference = hsb.getColorReference().getReferenceColor();
        this.outColor = hsb.getBackground();
        sat = hsb.getColorReference().getSaturation();
        bri = hsb.getColorReference().getBrightness();
        this.valueIsAdjusting = true;
        this.satSlider.setValue(sat);
        this.briSlider.setValue(bri);
        this.valueIsAdjusting = false;
        this.referenceField.setBackground(this.reference);
        this.twoColorField.setLowerColor(this.outColor);
        this.adjustColor();
    }

    public void setColor(Color ref, Color inColor, int s, int b) {
        this.reference = ref;
        this.outColor = inColor;
        sat = s;
        bri = b;
        this.valueIsAdjusting = true;
        this.satSlider.setValue(sat);
        this.briSlider.setValue(bri);
        this.valueIsAdjusting = false;
        this.referenceField.setBackground(this.reference);
        this.twoColorField.setLowerColor(inColor);
        this.adjustColor();
    }

    private void showColor(int s, int b) {
        sat = s;
        bri = b;
        this.adjustColor();
    }

    private void adjustColor() {
        this.outColor = SBChooser.getAdjustedColor(this.reference, sat, bri);
        this.twoColorField.setUpperColor(this.outColor);
    }

    public static Color getAdjustedColor(Color inColor, int sat, int bri) {
        int b;
        int g;
        int r;
        Color briColor = inColor;
        if (bri < 0) {
            briColor = ColorRoutines.darken(inColor, -bri);
        } else if (bri > 0) {
            briColor = ColorRoutines.lighten(inColor, bri);
        }
        Color satColor = ColorRoutines.getMaxSaturation(briColor, ColorRoutines.getHue(inColor));
        if (sat >= 0) {
            int dr = briColor.getRed() - satColor.getRed();
            int dg = briColor.getGreen() - satColor.getGreen();
            int db = briColor.getBlue() - satColor.getBlue();
            r = briColor.getRed() - (int)Math.round((double)(dr * sat) / 100.0);
            g = briColor.getGreen() - (int)Math.round((double)(dg * sat) / 100.0);
            b = briColor.getBlue() - (int)Math.round((double)(db * sat) / 100.0);
        } else {
            float d = ColorRoutines.getGreyValue(briColor);
            float dr = (float)briColor.getRed() - d;
            float dg = (float)briColor.getGreen() - d;
            float db = (float)briColor.getBlue() - d;
            r = (int)Math.round((double)briColor.getRed() + (double)(dr * (float)sat) / 100.0);
            g = (int)Math.round((double)briColor.getGreen() + (double)(dg * (float)sat) / 100.0);
            b = (int)Math.round((double)briColor.getBlue() + (double)(db * (float)sat) / 100.0);
        }
        return new Color(r, g, b);
    }

    public static int getSat() {
        return sat;
    }

    public static int getBri() {
        return bri;
    }

    class TwoColorField
    extends JPanel {
        private Dimension size = new Dimension(60, 68);
        private Color upperColor;
        private Color lowerColor;

        TwoColorField(Color c) {
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.upperColor = SBChooser.this.outColor;
            this.lowerColor = c;
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        void setUpperColor(Color c) {
            this.upperColor = c;
            SBChooser.this.redField.setText("" + c.getRed());
            SBChooser.this.greenField.setText("" + c.getGreen());
            SBChooser.this.blueField.setText("" + c.getBlue());
            this.repaint(0L);
        }

        void setLowerColor(Color c) {
            this.lowerColor = c;
            this.repaint(0L);
        }

        public void paint(Graphics g) {
            super.paintBorder(g);
            g.setColor(this.upperColor);
            g.fillRect(1, 1, 58, 33);
            g.setColor(this.lowerColor);
            g.fillRect(1, 34, 58, 33);
        }
    }

    class ColorField
    extends JPanel {
        private Dimension size = new Dimension(60, 38);

        ColorField(Color c) {
            this.setBorder(new LineBorder(Color.GRAY, 1));
            this.setBackground(c);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }
    }

    class SliderAction
    implements ChangeListener {
        SliderAction() {
        }

        public void stateChanged(ChangeEvent e) {
            if (!SBChooser.this.keyInput) {
                if (e.getSource().equals(SBChooser.this.satSlider)) {
                    SBChooser.this.satField.setText("" + SBChooser.this.satSlider.getValue());
                } else {
                    SBChooser.this.briField.setText("" + SBChooser.this.briSlider.getValue());
                }
            }
            if (SBChooser.this.valueIsAdjusting) {
                return;
            }
            SBChooser.this.showColor(SBChooser.this.satSlider.getValue(), SBChooser.this.briSlider.getValue());
        }
    }

    class SatInputListener
    implements DocumentListener {
        SatInputListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                try {
                    int val = Integer.parseInt(text);
                    SBChooser.this.keyInput = true;
                    SBChooser.this.satSlider.setValue(val);
                    SBChooser.this.keyInput = false;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    class BriInputListener
    implements DocumentListener {
        BriInputListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                try {
                    int val = Integer.parseInt(text);
                    SBChooser.this.keyInput = true;
                    SBChooser.this.briSlider.setValue(val);
                    SBChooser.this.keyInput = false;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    class ArrowKeyAction
    extends KeyAdapter
    implements ActionListener {
        private JTextField theField;
        private Timer keyTimer;
        private int step;
        private int min;
        private int max;

        ArrowKeyAction(JTextField field, int min, int max) {
            this.theField = field;
            this.min = min;
            this.max = max;
            this.keyTimer = new Timer(20, this);
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38) {
                this.step = 1;
                if (e.getModifiers() == 1) {
                    this.step = 10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            } else if (e.getKeyCode() == 40) {
                this.step = -1;
                if (e.getModifiers() == 1) {
                    this.step = -10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            }
        }

        public void keyReleased(KeyEvent e) {
            this.keyTimer.stop();
        }

        public void actionPerformed(ActionEvent e) {
            this.changeVal();
        }

        private void changeVal() {
            int val = Integer.parseInt(this.theField.getText()) + this.step;
            if (val > this.max) {
                val = this.max;
            } else if (val < this.min) {
                val = this.min;
            }
            this.theField.setText("" + val);
        }
    }

    class OKAction
    implements ActionListener {
        OKAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SBChooser.this.hide();
        }
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SBChooser.this.outColor = null;
            SBChooser.this.hide();
        }
    }
}

