/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class TinyToolBarSeparatorUI
extends BasicToolBarSeparatorUI {
    private static final int W99_SIZE = 6;
    private static final int YQ_SIZE = 7;
    private int defaultSize = 7;

    public static ComponentUI createUI(JComponent c) {
        return new TinyToolBarSeparatorUI();
    }

    protected void installDefaults(JSeparator s) {
        if (Theme.derivedStyle[Theme.style] == 1) {
            this.defaultSize = 6;
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        if (sep.getOrientation() == 0) {
            return new Dimension(0, 1);
        }
        return new Dimension(1, 0);
    }

    public Dimension getMaximumSize(JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        Dimension size = sep.getSeparatorSize();
        if (sep.getOrientation() == 0) {
            if (size != null) {
                return new Dimension(Short.MAX_VALUE, size.height);
            }
            return new Dimension(Short.MAX_VALUE, this.defaultSize);
        }
        if (size != null) {
            return new Dimension(Short.MAX_VALUE, size.width);
        }
        return new Dimension(this.defaultSize, Short.MAX_VALUE);
    }

    public Dimension getPreferredSize(JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        Dimension size = sep.getSeparatorSize();
        if (size != null) {
            return size.getSize();
        }
        if (sep.getOrientation() == 0) {
            return new Dimension(0, this.defaultSize);
        }
        return new Dimension(this.defaultSize, 0);
    }

    public void paint(Graphics g, JComponent c) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyToolBarSeparator(g, c);
                break;
            }
            case 1: {
                this.drawWinToolBarSeparator(g, c);
                break;
            }
            case 2: {
                this.drawXpToolBarSeparator(g, c);
            }
        }
    }

    protected void drawTinyToolBarSeparator(Graphics g, JComponent c) {
    }

    protected void drawWinToolBarSeparator(Graphics g, JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        if (sep.getOrientation() == 0) {
            Container cont = c.getParent();
            int y = sep.getPreferredSize().height / 2 - 1;
            g.setColor(Theme.toolSepDarkColor[Theme.style].getColor());
            g.drawLine(1, y, cont.getWidth() - 6, y);
            g.setColor(Theme.toolSepLightColor[Theme.style].getColor());
            g.drawLine(1, y + 1, cont.getWidth() - 6, y + 1);
        } else {
            int x = sep.getPreferredSize().width / 2 - 1;
            g.setColor(Theme.toolSepDarkColor[Theme.style].getColor());
            g.drawLine(x, 0, x, sep.getHeight());
            g.setColor(Theme.toolSepLightColor[Theme.style].getColor());
            g.drawLine(x + 1, 0, x + 1, sep.getHeight());
        }
    }

    protected void drawXpToolBarSeparator(Graphics g, JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        if (sep.getOrientation() == 0) {
            int y = sep.getHeight() / 2;
            g.setColor(Theme.toolSepDarkColor[Theme.style].getColor());
            g.drawLine(0, y, sep.getWidth(), y);
        } else {
            int x = sep.getWidth() / 2;
            g.setColor(Theme.toolSepDarkColor[Theme.style].getColor());
            g.drawLine(x, 0, x, sep.getHeight());
        }
    }
}

