/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.lexer;

import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.lexer.Lexer;
import org.codehaus.groovy.syntax.lexer.LexerException;
import org.codehaus.groovy.syntax.lexer.UnexpectedCharacterException;

public class LexerBase
implements Lexer {
    protected int startLine;
    protected int startColumn;
    protected Lexer delegate = null;
    protected Lexer source = null;

    public Lexer getDelegate() {
        return this.delegate;
    }

    public Lexer getSource() {
        return this.source;
    }

    public Token nextToken() throws ReadException, LexerException {
        if (this.delegate != null) {
            Token next = this.delegate.nextToken();
            if (next == null) {
                this.undelegate();
            } else {
                return next;
            }
        }
        this.mark();
        return this.undelegatedNextToken();
    }

    protected Token undelegatedNextToken() throws ReadException, LexerException {
        return null;
    }

    protected Token tokenizeEOL() throws LexerException, ReadException {
        Token token = null;
        char c = this.la();
        switch (c) {
            case '\n': 
            case '\r': {
                token = this.symbol(5);
                this.consume();
                if (c != '\r' || this.la() != '\n') break;
                this.consume();
            }
        }
        return token;
    }

    protected boolean readEOL(StringBuffer destination) throws LexerException, ReadException {
        boolean read = false;
        char c = this.la();
        switch (c) {
            case '\n': 
            case '\r': {
                if (destination == null) {
                    this.consume();
                    if (c == '\r' && this.la() == '\n') {
                        this.consume();
                    }
                } else {
                    destination.append(this.consume());
                    if (c == '\r' && this.la() == '\n') {
                        destination.append(this.consume());
                    }
                }
                read = true;
            }
        }
        return read;
    }

    protected void readEOL() throws LexerException, ReadException {
        this.readEOL(null);
    }

    public void reset() {
        this.delegate = null;
        this.source = null;
    }

    public void delegate(Lexer to) {
        this.delegate = to;
        to.setSource(this);
    }

    public void undelegate() {
        if (this.delegate != null) {
            this.delegate.unsetSource();
            this.delegate = null;
        }
    }

    public void setSource(Lexer source) {
        if (source == null) {
            throw new GroovyBugError("use unsetSource() to remove a source from a lexer");
        }
        this.source = source;
    }

    public void unsetSource() {
        this.source = null;
    }

    public boolean isDelegated() {
        return this.delegate != null;
    }

    public boolean isExternallySourced() {
        return this.source != null;
    }

    protected void unexpected(char c, int offset, String message) throws UnexpectedCharacterException {
        throw new UnexpectedCharacterException(this.getStartLine(), this.getStartColumn() + offset, c, message);
    }

    protected void unexpected(char c, char[] expected, int offset) throws UnexpectedCharacterException {
        throw new UnexpectedCharacterException(this.getStartLine(), this.getStartColumn() + offset, c, expected);
    }

    protected void unexpected(char c, int offset) throws UnexpectedCharacterException {
        this.unexpected(c, null, offset);
    }

    protected Token symbol(int type, int columnOffset) {
        return Token.newSymbol(type, this.getStartLine(), this.getStartColumn() - columnOffset);
    }

    protected Token symbol(int type) {
        return Token.newSymbol(type, this.getStartLine(), this.getStartColumn());
    }

    public int getLine() {
        if (this.source != null) {
            return this.source.getLine();
        }
        return -1;
    }

    public int getColumn() {
        if (this.source != null) {
            return this.source.getColumn();
        }
        return -1;
    }

    protected void mark() {
        this.startLine = this.getLine();
        this.startColumn = this.getColumn();
    }

    protected int getStartLine() {
        return this.startLine;
    }

    protected int getStartColumn() {
        return this.startColumn;
    }

    public char la() throws LexerException, ReadException {
        return this.la(1);
    }

    public char la(int k) throws LexerException, ReadException {
        if (this.source != null) {
            return this.source.la(k);
        }
        return '\uffff';
    }

    public char consume() throws LexerException, ReadException {
        if (this.source != null) {
            return this.source.consume();
        }
        return '\uffff';
    }
}

