/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.servlet.ServletBinding;
import groovy.servlet.ServletCategory;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.runtime.GroovyCategorySupport;

public class GroovyServlet
extends HttpServlet
implements ResourceConnector {
    public static final String GROOVY_EXTENSION = ".groovy";
    private ServletContext sc;
    private static ClassLoader parent;
    private static GroovyScriptEngine gse;

    public ServletContext getServletContext() {
        return this.sc;
    }

    public void init(ServletConfig config) {
        MetaClass.setUseReflection(true);
        this.sc = config.getServletContext();
        this.sc.log("Groovy servlet initialized");
        parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = GroovyServlet.class.getClassLoader();
        }
        gse = new GroovyScriptEngine(this);
    }

    public URLConnection getResourceConnection(String name) throws ResourceException {
        try {
            URL url = this.sc.getResource("/" + name);
            if (url == null && (url = this.sc.getResource("/WEB-INF/groovy/" + name)) == null) {
                throw new ResourceException("Resource " + name + " not found");
            }
            return url.openConnection();
        }
        catch (IOException ioe) {
            throw new ResourceException("Problem reading resource " + name);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        final String scriptFilename = this.getGroovyScriptPath(httpRequest);
        response.setContentType("text/html");
        final ServletBinding binding = new ServletBinding((HttpServletRequest)request, response, this.sc);
        try {
            Closure closure = new Closure(gse){

                public Object call() {
                    try {
                        return ((GroovyScriptEngine)this.getDelegate()).run(scriptFilename, binding);
                    }
                    catch (ResourceException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ScriptException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            GroovyCategorySupport.use(ServletCategory.class, closure);
        }
        catch (RuntimeException re) {
            StringBuffer error = new StringBuffer("GroovyServlet Error: ");
            error.append(" script: '");
            error.append(scriptFilename);
            error.append("': ");
            Throwable e = re.getCause();
            if (e instanceof ResourceException) {
                error.append(" Script not found, sending 404.");
                this.sc.log(error.toString());
                System.out.println(error.toString());
                httpResponse.sendError(404);
            }
            if (re.getMessage() != null) {
                error.append(re.getMessage());
            }
            if (e != null) {
                this.sc.log("An error occurred processing the request", e);
            } else {
                this.sc.log("An error occurred processing the request", (Throwable)re);
            }
            this.sc.log(error.toString());
            System.out.println(error.toString());
            httpResponse.sendError(500);
        }
    }

    private String getGroovyScriptPath(HttpServletRequest request) {
        int contextLength = request.getContextPath().length();
        String scriptFilename = request.getRequestURI().substring(contextLength).substring(1);
        if (scriptFilename.endsWith(GROOVY_EXTENSION)) {
            return scriptFilename;
        }
        int lastDot = scriptFilename.lastIndexOf(".");
        scriptFilename = scriptFilename.substring(0, lastDot) + GROOVY_EXTENSION;
        return scriptFilename;
    }
}

