/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import jcmdline.AbstractHandlerDecorator;
import jcmdline.CmdLineHandler;
import jcmdline.CmdLineParser;
import jcmdline.DefaultCmdLineHandler;
import jcmdline.Parameter;
import jcmdline.StringParam;
import jcmdline.Strings;

public class LoggerCmdLineHandler
extends AbstractHandlerDecorator {
    private Parameter logOpt;
    private OutputStream stream;
    private Formatter logFormatter;

    public LoggerCmdLineHandler(OutputStream stream, CmdLineHandler handler) {
        super(handler);
        if (stream == null) {
            throw new IllegalArgumentException(Strings.get("LoggerCmdLineHandler.streamNullError"));
        }
        this.stream = stream;
        Object[] validVals = new String[]{Level.ALL.getLocalizedName(), Level.OFF.getLocalizedName(), Level.FINEST.getLocalizedName(), Level.FINER.getLocalizedName(), Level.FINE.getLocalizedName(), Level.CONFIG.getLocalizedName(), Level.INFO.getLocalizedName(), Level.WARNING.getLocalizedName(), Level.SEVERE.getLocalizedName()};
        this.logFormatter = new SimpleFormatter();
        this.logOpt = new StringParam(Strings.get("LoggerCmdLineHandler.logOpt.tag"), Strings.get("LoggerCmdLineHandler.logOpt.desc", validVals), (String[])validVals, true);
        this.setCustomOptions(new Parameter[]{this.logOpt});
    }

    public LoggerCmdLineHandler(OutputStream stream, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args, CmdLineParser parser) {
        this(stream, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args, parser));
    }

    public LoggerCmdLineHandler(OutputStream stream, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args) {
        this(stream, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    public LoggerCmdLineHandler(OutputStream stream, String cmdName, String cmdDesc, Collection options, Collection args) {
        this(stream, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    protected boolean processParsedOptions(boolean parseOk) {
        if (parseOk && this.logOpt.isSet()) {
            Level level = Level.parse(this.logOpt.getValue());
            StreamHandler h = new StreamHandler(this.stream, this.logFormatter);
            h.setLevel(level);
            Logger rootLogger = Logger.getLogger("");
            rootLogger.addHandler(h);
            rootLogger.setLevel(level);
        }
        return parseOk;
    }

    public void setLogFormatter(Formatter logFormatter) {
        if (logFormatter == null) {
            throw new IllegalArgumentException(Strings.get("LoggerCmdLineHandler.logFormatterNullError"));
        }
        this.logFormatter = logFormatter;
    }

    public Formatter getLogFormatter() {
        return this.logFormatter;
    }
}

