/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mondrian.olap.Axis;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Cell;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.ResultBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CellKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.FastBatchingCellReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapPosition;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import org.apache.log4j.Logger;

class RolapResult
extends ResultBase {
    private static final Logger LOGGER = Logger.getLogger((Class)ResultBase.class);
    private static final int MAX_AGGREGATION_PASS_COUNT = 5;
    private final RolapEvaluator evaluator;
    private RolapEvaluator slicerEvaluator;
    private final CellKey point;
    private final Map cellValues;
    private final FastBatchingCellReader batchingReader;
    AggregatingCellReader aggregatingReader = new AggregatingCellReader();
    private final int[] modulos;
    private final Random random;
    private final Map expIndDims;
    private final Map namedSetValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RolapResult(Query query) {
        super(query, new RolapAxis[query.axes.length]);
        this.random = Util.createRandom(MondrianProperties.instance().TestSeed.get());
        this.expIndDims = new HashMap();
        this.namedSetValues = new HashMap();
        this.point = new CellKey(new int[query.axes.length]);
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        if (expDeps > 0) {
            this.evaluator = new DependencyTestingEvaluator(this, expDeps);
        } else {
            RolapEvaluator.RolapEvaluatorRoot root = new RolapEvaluator.RolapEvaluatorRoot(this);
            this.evaluator = new RolapEvaluator(root);
        }
        RolapCube rcube = (RolapCube)query.getCube();
        this.batchingReader = new FastBatchingCellReader(rcube);
        this.cellValues = new HashMap();
        try {
            for (int i = -1; i < this.axes.length; ++i) {
                RolapAxis axisResult;
                QueryAxis axis;
                block22: {
                    if (i == -1) {
                        if (query.slicer != null) {
                            FunCall call = new FunCall("{}", Syntax.Braces, new Exp[]{new FunCall("()", Syntax.Parentheses, new Exp[]{query.slicer})});
                            Exp call2 = call.accept(query.createValidator());
                            axis = new QueryAxis(false, call2, AxisOrdinal.Slicer, -1);
                        } else {
                            axis = null;
                        }
                    } else {
                        axis = query.axes[i];
                    }
                    int attempt = 0;
                    do {
                        this.evaluator.setCellReader(this.batchingReader);
                        axisResult = this.executeAxis(this.evaluator.push(), axis);
                        Util.discard((Object)axisResult);
                        this.evaluator.clearExpResultCache();
                        if (!this.batchingReader.loadAggregations()) break block22;
                    } while (attempt++ <= 5);
                    throw Util.newInternal("Failed to load all aggregations after 5passes; there's probably a cycle");
                }
                this.evaluator.setCellReader(this.aggregatingReader);
                axisResult = this.executeAxis(this.evaluator.push(), axis);
                this.evaluator.clearExpResultCache();
                if (i == -1) {
                    this.slicerAxis = axisResult;
                    switch (this.slicerAxis.positions.length) {
                        case 0: {
                            throw MondrianResource.instance().EmptySlicer.ex();
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            throw MondrianResource.instance().CompoundSlicer.ex();
                        }
                    }
                    Position position = this.slicerAxis.positions[0];
                    for (int j = 0; j < position.members.length; ++j) {
                        Member member = position.members[j];
                        if (member == null) {
                            throw MondrianResource.instance().EmptySlicer.ex();
                        }
                        this.evaluator.setContext(member);
                    }
                    this.slicerEvaluator = (RolapEvaluator)this.evaluator.push();
                    continue;
                }
                this.axes[i] = axisResult;
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            if (limit > 0) {
                long n = 1L;
                for (int i = 0; i < this.axes.length; ++i) {
                    n *= (long)this.axes[i].positions.length;
                }
                if (n > (long)limit) {
                    throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(new Long(n), new Long(limit));
                }
            }
            this.modulos = new int[this.axes.length + 1];
            this.modulos[0] = 1;
            int modulo = 1;
            for (int i = 0; i < this.axes.length; ++i) {
                this.modulos[i + 1] = modulo *= this.axes[i].positions.length;
            }
            this.executeBody(query);
        }
        finally {
            this.evaluator.clearExpResultCache();
        }
        query.getCube().getDimensions();
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public Axis[] getAxes() {
        return this.axes;
    }

    public Cell getCell(int[] pos) {
        if (pos.length != this.point.ordinals.length) {
            throw Util.newError("coordinates should have dimension " + this.point.ordinals.length);
        }
        Object value = this.cellValues.get(new CellKey(pos));
        if (value == null) {
            value = Util.nullValue;
        }
        return new RolapCell(this, this.getCellOrdinal(pos), value);
    }

    private RolapAxis executeAxis(Evaluator evaluator, QueryAxis axis) {
        Position[] positions;
        if (axis == null) {
            Member[] members = new Member[]{};
            RolapPosition position = new RolapPosition(members);
            positions = new Position[]{position};
        } else {
            Exp exp = axis.set;
            evaluator.setNonEmpty(axis.nonEmpty);
            Object value = exp.evaluate(evaluator);
            evaluator.setNonEmpty(false);
            if (value == null) {
                value = Collections.EMPTY_LIST;
            }
            Util.assertTrue(value instanceof List);
            List list = (List)value;
            positions = new Position[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Member[] members = null;
                Object o = list.get(i);
                if (o instanceof Object[]) {
                    Object[] a = (Object[])o;
                    members = new Member[a.length];
                    for (int j = 0; j < a.length; ++j) {
                        members[j] = (Member)a[j];
                    }
                } else {
                    members = new Member[]{(Member)o};
                }
                RolapPosition position = new RolapPosition(members);
                positions[i] = position;
            }
        }
        return new RolapAxis(positions);
    }

    private void executeBody(Query query) {
        try {
            int count;
            block6: {
                count = 0;
                while (true) {
                    this.cellValues.clear();
                    this.evaluator.setCellReader(this.batchingReader);
                    this.executeStripe(query.axes.length - 1, (RolapEvaluator)this.evaluator.push());
                    this.evaluator.clearExpResultCache();
                    if (!this.batchingReader.loadAggregations()) {
                        return;
                    }
                    if (count++ <= 5) continue;
                    if (!(this.evaluator instanceof DependencyTestingEvaluator)) break block6;
                    ((DependencyTestingEvalutorRoot)this.evaluator.root).disabled = true;
                    if (count > 10) break;
                }
                throw Util.newInternal("Query required more than " + count + " iterations");
            }
            throw Util.newInternal("Query required more than " + count + " iterations");
        }
        finally {
            RolapCube cube = (RolapCube)query.getCube();
            cube.clearCache();
        }
    }

    Object evaluateNamedSet(String name, Exp exp) {
        Object value = this.namedSetValues.get(name);
        if (value == null) {
            value = this.evaluateExp(exp, (RolapEvaluator)this.slicerEvaluator.push());
            this.namedSetValues.put(name, value);
        }
        return value;
    }

    private Object evaluateExp(Exp exp, RolapEvaluator evaluator) {
        RolapEvaluator ev;
        boolean dirty;
        block2: {
            int attempt = 0;
            dirty = this.batchingReader.isDirty();
            do {
                ev = (RolapEvaluator)evaluator.push();
                ev.setCellReader(this.batchingReader);
                Object preliminaryValue = exp.evaluate(ev);
                Util.discard((Object)preliminaryValue);
                if (!this.batchingReader.loadAggregations()) break block2;
            } while (attempt++ <= 5);
            throw Util.newInternal("Failed to load all aggregations after 5passes; there's probably a cycle");
        }
        if (dirty) {
            this.batchingReader.setDirty(true);
        }
        ev = (RolapEvaluator)evaluator.push();
        ev.setCellReader(this.aggregatingReader);
        Object value = exp.evaluate(ev);
        return value;
    }

    private void executeStripe(int axisOrdinal, RolapEvaluator evaluator) {
        if (axisOrdinal < 0) {
            RolapAxis axis = (RolapAxis)this.slicerAxis;
            int count = axis.positions.length;
            for (int i = 0; i < count; ++i) {
                Object o;
                RolapPosition position = (RolapPosition)axis.positions[i];
                for (int j = 0; j < position.members.length; ++j) {
                    evaluator.setContext(position.members[j]);
                }
                try {
                    o = evaluator.evaluateCurrent();
                }
                catch (MondrianEvaluationException e) {
                    o = e;
                }
                if (o == null || o == RolapUtil.valueNotReadyException) continue;
                CellKey key = this.point.copy();
                this.cellValues.put(key, o);
                try {
                    Cell cell = this.getCell(this.point.ordinals);
                    Util.discard((Object)cell.getFormattedValue());
                    continue;
                }
                catch (MondrianEvaluationException e) {
                    continue;
                }
                catch (Throwable e) {
                    Util.discard((Object)e);
                }
            }
        } else {
            RolapAxis axis = (RolapAxis)this.axes[axisOrdinal];
            int count = axis.positions.length;
            for (int i = 0; i < count; ++i) {
                this.point.ordinals[axisOrdinal] = i;
                RolapPosition position = (RolapPosition)axis.positions[i];
                for (int j = 0; j < position.members.length; ++j) {
                    evaluator.setContext(position.members[j]);
                }
                this.executeStripe(axisOrdinal - 1, evaluator);
            }
        }
    }

    public int[] getCellPos(int cellOrdinal) {
        int[] pos = new int[this.axes.length];
        for (int j = 0; j < this.axes.length; ++j) {
            pos[j] = cellOrdinal % this.modulos[j + 1] / this.modulos[j];
        }
        return pos;
    }

    int getCellOrdinal(int[] pos) {
        int ordinal = 0;
        for (int j = 0; j < this.axes.length; ++j) {
            ordinal += pos[j] * this.modulos[j];
        }
        return ordinal;
    }

    RolapEvaluator getCellEvaluator(int[] pos) {
        RolapEvaluator cellEvaluator = (RolapEvaluator)this.evaluator.push();
        for (int i = 0; i < pos.length; ++i) {
            Position position = this.axes[i].positions[pos[i]];
            for (int j = 0; j < position.members.length; ++j) {
                cellEvaluator.setContext(position.members[j]);
            }
        }
        return cellEvaluator;
    }

    Evaluator getEvaluator(int[] pos) {
        Evaluator cellEvaluator = this.evaluator.push();
        for (int i = -1; i < this.axes.length; ++i) {
            int index;
            Axis axis;
            if (i < 0) {
                axis = this.slicerAxis;
                index = 0;
            } else {
                axis = this.axes[i];
                index = pos[i];
            }
            Position position = axis.positions[index];
            for (int j = 0; j < position.members.length; ++j) {
                Member member = position.members[j];
                cellEvaluator.setContext(member);
            }
        }
        return cellEvaluator;
    }

    private static class DependencyTestingEvalutorRoot
    extends RolapEvaluator.RolapEvaluatorRoot {
        final int expDeps;
        int callCount;
        int fakeCallCount;
        int fakeCount;
        boolean faking;
        boolean disabled;

        DependencyTestingEvalutorRoot(RolapResult result, int expDeps) {
            super(result);
            this.expDeps = expDeps;
        }
    }

    private class DependencyTestingEvaluator
    extends RolapEvaluator {
        DependencyTestingEvaluator(RolapResult result, int expDeps) {
            super(new DependencyTestingEvalutorRoot(result, expDeps));
        }

        private DependencyTestingEvaluator(RolapEvaluator.RolapEvaluatorRoot root, DependencyTestingEvaluator evaluator, CellReader cellReader, Member[] cloneCurrentMembers) {
            super(root, evaluator, cellReader, cloneCurrentMembers);
        }

        private Dimension[] getIndependentDimensions(Exp exp) {
            Dimension[] indDims = (Dimension[])RolapResult.this.expIndDims.get(exp);
            if (indDims == null) {
                ArrayList<Dimension> indDimList = new ArrayList<Dimension>();
                Dimension[] dims = this.root.cube.getDimensions();
                for (int i = 0; i < dims.length; ++i) {
                    Dimension dim = dims[i];
                    if (exp.dependsOn(dim)) continue;
                    indDimList.add(dim);
                }
                indDims = indDimList.toArray(new Dimension[indDimList.size()]);
                RolapResult.this.expIndDims.put(exp, indDims);
            }
            return indDims;
        }

        public RolapEvaluator _push() {
            Member[] cloneCurrentMembers = (Member[])this.getCurrentMembers().clone();
            return new DependencyTestingEvaluator(this.root, this, this.cellReader, cloneCurrentMembers);
        }

        public Object visit(FunCall funCall) {
            DependencyTestingEvalutorRoot dteRoot = (DependencyTestingEvalutorRoot)this.root;
            if (dteRoot.faking) {
                ++dteRoot.fakeCallCount;
            } else {
                ++dteRoot.callCount;
            }
            Object result = super.visit(funCall);
            if (RolapResult.this.batchingReader.isDirty()) {
                return result;
            }
            if (dteRoot.disabled || dteRoot.faking || this.isNonEmpty() || (double)dteRoot.fakeCallCount > (double)dteRoot.callCount * RolapResult.this.random.nextDouble() * 2.0 * (double)dteRoot.expDeps) {
                return result;
            }
            Dimension[] independentDimensions = this.getIndependentDimensions(funCall);
            if (independentDimensions.length == 0) {
                return result;
            }
            dteRoot.faking = true;
            ++dteRoot.fakeCount;
            ++dteRoot.fakeCallCount;
            int i = RolapResult.this.random.nextInt(independentDimensions.length);
            Member saveMember = this.getContext(independentDimensions[i]);
            Member otherMember = this.chooseOtherMember(saveMember, RolapResult.this.query.getSchemaReader(false));
            this.setContext(otherMember);
            Object otherResult = super.visit(funCall);
            if (!this.equals(otherResult, result)) {
                Member[] members = this.getCurrentMembers();
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < members.length; ++j) {
                    if (j > 0) {
                        buf.append(", ");
                    }
                    buf.append(members[j].getUniqueName());
                }
                throw Util.newInternal("Expression '" + funCall.toMdx() + "' claims to be independent of dimension " + saveMember.getDimension() + " but is not; context is {" + buf.toString() + "}; First result: " + this.toString(result) + ", Second result: " + this.toString(otherResult));
            }
            this.setContext(saveMember);
            dteRoot.faking = false;
            return result;
        }

        private Member chooseOtherMember(Member save, SchemaReader schemaReader) {
            Member member;
            Hierarchy hierarchy = save.getHierarchy();
            do {
                Member[] members;
                Level[] levels = hierarchy.getLevels();
                int levelDepth = RolapResult.this.random.nextInt(levels.length) + 1;
                member = null;
                for (int i = 0; i < levelDepth && (members = i == 0 ? schemaReader.getLevelMembers(levels[i]) : schemaReader.getMemberChildren(member)).length != 0; ++i) {
                    member = members[RolapResult.this.random.nextInt(members.length)];
                }
            } while (member == save);
            return member;
        }

        private boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (o2 == null) {
                return false;
            }
            if (o1 instanceof Object[]) {
                Object[] a2;
                Object[] a1;
                if (o2 instanceof Object[] && (a1 = (Object[])o1).length == (a2 = (Object[])o2).length) {
                    for (int i = 0; i < a1.length; ++i) {
                        if (this.equals(a1[i], a2[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (o1 instanceof List) {
                if (o2 instanceof List) {
                    return this.equals(((List)o1).toArray(), ((List)o2).toArray());
                }
                return false;
            }
            return o1.equals(o2);
        }

        private String toString(Object o) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.toString(o, pw);
            return sw.toString();
        }

        private void toString(Object o, PrintWriter pw) {
            if (o instanceof Object[]) {
                Object[] a = (Object[])o;
                pw.print("{");
                for (int i = 0; i < a.length; ++i) {
                    Object o1 = a[i];
                    if (i > 0) {
                        pw.print(", ");
                    }
                    this.toString(o1, pw);
                }
                pw.print("}");
            } else if (o instanceof List) {
                List list = (List)o;
                this.toString(list.toArray(), pw);
            } else if (o instanceof Member) {
                Member member = (Member)o;
                pw.print(member.getUniqueName());
            } else {
                pw.print(o);
            }
        }
    }

    private static class AggregatingCellReader
    implements CellReader {
        private final RolapAggregationManager aggMan = AggregationManager.instance();

        private AggregatingCellReader() {
        }

        public Object get(Evaluator evaluator) {
            RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
            return this.aggMan.getCellFromCache(rolapEvaluator.getCurrentMembers());
        }
    }
}

