/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;

class OrderFunDef
extends FunDefBase {
    private final boolean desc;
    private final boolean brk;

    public OrderFunDef(FunDef dummyFunDef, boolean desc, boolean brk) {
        super(dummyFunDef);
        this.desc = desc;
        this.brk = brk;
    }

    public boolean callDependsOn(FunCall call, Dimension dimension) {
        return OrderFunDef.callDependsOnSet(call, dimension);
    }

    public Object evaluate(Evaluator evaluator, Exp[] args) {
        List members = (List)OrderFunDef.getArg(evaluator, args, 0);
        ExpBase exp = (ExpBase)OrderFunDef.getArgNoEval(args, 1);
        OrderFunDef.sort(evaluator.push(), members, exp, this.desc, this.brk);
        return members;
    }

    static class Flags
    extends EnumeratedValues {
        static final Flags instance = new Flags();
        public static final int ASC = 0;
        public static final int DESC = 1;
        public static final int BASC = 2;
        public static final int BDESC = 3;

        private Flags() {
            super(new String[]{"ASC", "DESC", "BASC", "BDESC"});
        }

        public static final boolean isDescending(int value) {
            return (value & 1) == 1;
        }

        public static final boolean isBreak(int value) {
            return (value & 2) == 2;
        }
    }

    static class OrderResolver
    extends MultiResolver {
        public OrderResolver() {
            super("Order", "Order(<Set>, <Value Expression>[, ASC | DESC | BASC | BDESC])", "Arranges members of a set, optionally preserving or breaking the hierarchy.", new String[]{"fxxvy", "fxxv"});
        }

        public String[] getReservedWords() {
            return Flags.instance.getNames();
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            int order = OrderResolver.getLiteralArg(args, 2, 0, Flags.instance, dummyFunDef);
            boolean desc = Flags.isDescending(order);
            boolean brk = Flags.isBreak(order);
            return new OrderFunDef(dummyFunDef, desc, brk);
        }
    }
}

