/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

class OpeningClosingPeriodFunDef
extends FunDefBase {
    private final boolean opening;

    public OpeningClosingPeriodFunDef(FunDef dummyFunDef, boolean opening) {
        super(dummyFunDef);
        this.opening = opening;
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 0) {
            Hierarchy hierarchy = validator.getQuery().getCube().getTimeDimension().getHierarchy();
            return new MemberType(hierarchy, null, null);
        }
        return super.getResultType(validator, args);
    }

    public boolean callDependsOn(FunCall call, Dimension dimension) {
        switch (call.getArgCount()) {
            case 0: {
                return dimension.getDimensionType() == DimensionType.TimeDimension;
            }
            case 1: {
                if (super.callDependsOn(call, dimension)) {
                    return true;
                }
                return call.getArg(0).getTypeX().usesDimension(dimension);
            }
            case 2: {
                return super.callDependsOn(call, dimension);
            }
        }
        throw Util.newInternal("bad arg count " + call.getArgCount());
    }

    public Object evaluate(Evaluator evaluator, Exp[] args) {
        Level level;
        Member member = args.length == 2 ? OpeningClosingPeriodFunDef.getMemberArg(evaluator, args, 1, false) : evaluator.getContext(evaluator.getCube().getTimeDimension());
        if (args.length >= 1) {
            level = OpeningClosingPeriodFunDef.getLevelArg(evaluator, args, 0, false);
        } else {
            int targetDepth = member.getLevel().getDepth() + 1;
            Level[] levels = member.getHierarchy().getLevels();
            if (levels.length <= targetDepth) {
                return member.getHierarchy().getNullMember();
            }
            level = levels[targetDepth];
        }
        if (!member.getHierarchy().equals(level.getHierarchy())) {
            throw MondrianResource.instance().FunctionMbrAndLevelHierarchyMismatch.ex(this.opening ? "OpeningPeriod" : "ClosingPeriod", level.getHierarchy().getUniqueName(), member.getHierarchy().getUniqueName());
        }
        if (level.getDepth() < member.getLevel().getDepth()) {
            return member.getHierarchy().getNullMember();
        }
        if (level == member.getLevel()) {
            return member;
        }
        return OpeningClosingPeriodFunDef.getDescendant(evaluator.getSchemaReader(), member, level, this.opening);
    }

    static Member getDescendant(SchemaReader schemaReader, Member member, Level targetLevel, boolean returnFirstDescendant) {
        Member[] children;
        int targetLevelDepth = targetLevel.getDepth();
        OpeningClosingPeriodFunDef.assertPrecondition(member.getLevel().getDepth() < targetLevelDepth, "member.getLevel().getDepth() < targetLevel.getDepth()");
        do {
            if ((children = schemaReader.getMemberChildren(member)).length != 0) continue;
            return targetLevel.getHierarchy().getNullMember();
        } while ((member = children[returnFirstDescendant ? 0 : children.length - 1]).getLevel().getDepth() != targetLevelDepth);
        if (member.isHidden()) {
            return member.getHierarchy().getNullMember();
        }
        return member;
    }

    public static Resolver createResolver(final boolean opening) {
        return opening ? new MultiResolver("OpeningPeriod", "OpeningPeriod([<Level>[, <Member>]])", "Returns the first descendant of a member at a level.", new String[]{"fm", "fml", "fmlm"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new OpeningClosingPeriodFunDef(dummyFunDef, opening);
            }
        } : new MultiResolver("ClosingPeriod", "ClosingPeriod([<Level>[, <Member>]])", "Returns the last descendant of a member at a level.", new String[]{"fm", "fml", "fmlm", "fmm"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new OpeningClosingPeriodFunDef(dummyFunDef, opening);
            }
        };
    }
}

