/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.jdbc.object.SqlOperation;
import org.springframework.jdbc.support.KeyHolder;

public class SqlUpdate
extends SqlOperation {
    private int maxRowsAffected = 0;
    private int requiredRowsAffected = 0;

    public SqlUpdate() {
    }

    public SqlUpdate(DataSource ds, String sql) {
        this.setDataSource(ds);
        this.setSql(sql);
    }

    public SqlUpdate(DataSource ds, String sql, int[] types) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
    }

    public SqlUpdate(DataSource ds, String sql, int[] types, int maxRowsAffected) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
        this.maxRowsAffected = maxRowsAffected;
    }

    public void setMaxRowsAffected(int maxRowsAffected) {
        this.maxRowsAffected = maxRowsAffected;
    }

    public void setRequiredRowsAffected(int requiredRowsAffected) {
        this.requiredRowsAffected = requiredRowsAffected;
    }

    protected void checkRowsAffected(int rowsAffected) throws JdbcUpdateAffectedIncorrectNumberOfRowsException {
        if (this.maxRowsAffected > 0 && rowsAffected > this.maxRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(this.getSql(), this.maxRowsAffected, rowsAffected);
        }
        if (this.requiredRowsAffected > 0 && rowsAffected != this.requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(this.getSql(), this.requiredRowsAffected, rowsAffected);
        }
    }

    public int update(Object[] args) throws DataAccessException {
        this.validateParameters(args);
        int rowsAffected = this.getJdbcTemplate().update(this.newPreparedStatementCreator(args));
        this.checkRowsAffected(rowsAffected);
        return rowsAffected;
    }

    public int update(Object[] args, KeyHolder generatedKeyHolder) throws DataAccessException {
        this.validateParameters(args);
        int rowsAffected = this.getJdbcTemplate().update(this.newPreparedStatementCreator(args), generatedKeyHolder);
        this.checkRowsAffected(rowsAffected);
        return rowsAffected;
    }

    public int update() throws DataAccessException {
        return this.update((Object[])null);
    }

    public int update(int p1) throws DataAccessException {
        return this.update(new Object[]{new Integer(p1)});
    }

    public int update(int p1, int p2) throws DataAccessException {
        return this.update(new Object[]{new Integer(p1), new Integer(p2)});
    }

    public int update(long p1) throws DataAccessException {
        return this.update(new Object[]{new Long(p1)});
    }

    public int update(long p1, long p2) throws DataAccessException {
        return this.update(new Object[]{new Long(p1), new Long(p2)});
    }

    public int update(String p) throws DataAccessException {
        return this.update(new Object[]{p});
    }

    public int update(String p1, String p2) throws DataAccessException {
        return this.update(new Object[]{p1, p2});
    }
}

