/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

abstract class Util {
    private static final Throwable[] emptyThrowableArray = new Throwable[0];
    static final char fileSep = System.getProperty("file.separator").charAt(0);
    private static final Class[] emptyClassArray = new Class[0];

    Util() {
    }

    static ResourceDef.ResourceBundle load(URL uRL) throws IOException {
        return Util.load(uRL.openStream());
    }

    static ResourceDef.ResourceBundle load(InputStream inputStream) throws IOException {
        try {
            Parser parser = XOMUtil.createDefaultParser();
            DOMWrapper dOMWrapper = parser.parse(inputStream);
            ResourceDef.ResourceBundle resourceBundle = new ResourceDef.ResourceBundle(dOMWrapper);
            return resourceBundle;
        }
        catch (XOMException xOMException) {
            throw new IOException(xOMException.toString());
        }
    }

    static void fillText(PrintWriter printWriter, String string, String string2, String string3, int n) {
        int n2;
        int n3 = 0;
        while ((n2 = string.length()) > n3) {
            int n4;
            int n5;
            if (n3 > 0) {
                printWriter.println(string3);
                printWriter.print(string2);
            }
            if ((n5 = string.indexOf("\r", n3)) >= 0 && n5 < n2) {
                n2 = n5;
            }
            if ((n4 = string.indexOf("\n", n3)) >= 0 && n4 < n2) {
                n2 = n4;
            }
            if (n > 0 && n3 + n <= n2 && (n2 = string.lastIndexOf(" ", n3 + n)) < n3 && (n2 = string.indexOf(" ", n3)) < 0) {
                n2 = string.length();
            }
            printWriter.print(string.substring(n3, n2));
            for (n3 = n2; n3 < string.length() && (string.charAt(n3) == ' ' || string.charAt(n3) == '\r' || string.charAt(n3) == '\n'); ++n3) {
            }
        }
    }

    static URL stringToUrl(String string) throws IOException {
        try {
            File file = new File(string);
            return Util.convertPathToURL(file);
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.toString());
        }
    }

    static URL convertPathToURL(File file) {
        try {
            String string = file.getAbsolutePath();
            String string2 = System.getProperty("file.separator");
            if (string2.length() == 1) {
                char c = string2.charAt(0);
                if (c != '/') {
                    string = string.replace(c, '/');
                }
                if (string.charAt(0) != '/') {
                    string = '/' + string;
                }
            }
            string = "file://" + string;
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error(malformedURLException.getMessage());
        }
    }

    static String formatError(String string, Object[] objectArray) {
        String string2 = string;
        for (int i = 0; i < objectArray.length; ++i) {
            String string3 = objectArray[i].toString();
            string2 = Util.replace(string2, "%" + (i + 1), string3);
            string2 = Util.replace(string2, "%i" + (i + 1), string3);
        }
        return string2;
    }

    static String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while (true) {
            if (n2 < n) {
                stringBuffer.append(string.charAt(n2));
                ++n2;
                continue;
            }
            if (n == string.length()) break;
            stringBuffer.append(string3);
            n = string.indexOf(string2, n2 += string2.length());
            if (n != -1) continue;
            n = string.length();
        }
        return stringBuffer.toString();
    }

    static String quoteForJava(String string, boolean bl) {
        if (string == null) {
            return bl ? "null" : "";
        }
        String string2 = Util.replace(string, "\\", "\\\\");
        string2 = Util.replace(string, "\"", "\\\"");
        string2 = Util.replace(string2, "\n\r", "\\n");
        string2 = Util.replace(string2, "\n", "\\n");
        string2 = Util.replace(string2, "\r", "\\r");
        return "\"" + string2 + "\"";
    }

    static String quoteForJava(String string) {
        return Util.quoteForJava(string, true);
    }

    static String quoteForProperties(String string) {
        String string2 = Util.replace(string, "\\", "\\\\");
        string2 = Util.replace(string2, "\n\r", "\\n");
        string2 = Util.replace(string2, "\n", "\\n");
        string2 = Util.replace(string2, "\r", "\\r");
        string2 = Util.replace(string2, "\t", "\\t");
        return string2;
    }

    static String fileNameToClassName(String string, String string2) {
        String string3 = string;
        string3 = Util.removeSuffix(string3, string2);
        string3 = string3.replace(fileSep, '.');
        int n = (string3 = string3.replace('/', '.')).indexOf(95);
        if (n >= 0) {
            string3 = string3.substring(0, n);
        }
        return string3;
    }

    static String fileNameToCppClassName(String string, String string2) {
        int n;
        String string3 = string;
        int n2 = (string3 = Util.removeSuffix(string3, string2)).lastIndexOf(fileSep);
        if (n2 >= 0) {
            string3 = string3.substring(n2 + 1);
        }
        if ((n = string3.indexOf(95)) >= 0) {
            string3 = string3.substring(0, n);
        }
        return string3;
    }

    static String removeSuffix(String string, String string2) {
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    static Locale fileNameToLocale(String string, String string2) {
        String string3 = Util.removeSuffix(string, string2);
        int n = string3.indexOf(95);
        if (n <= 0) {
            return null;
        }
        String string4 = string3.substring(n + 1);
        return Util.parseLocale(string4);
    }

    static Locale parseLocale(String string) {
        String string2;
        int n = string.indexOf(95);
        String string3 = "";
        String string4 = "";
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            if (string2.length() != 2) {
                return null;
            }
            int n2 = string.indexOf(95, n + 1);
            if (n2 < 0) {
                string3 = string.substring(n + 1);
                if (string3.length() != 2) {
                    return null;
                }
            } else {
                string3 = string.substring(n + 1, n2);
                if (string3.length() != 2) {
                    return null;
                }
                string4 = string.substring(n2 + 1);
            }
        }
        return new Locale(string2, string3, string4);
    }

    static String fileNameSansLocale(String string, String string2) {
        String string3 = Util.removeSuffix(string, string2);
        int n = string3.lastIndexOf(fileSep);
        if (n < 0) {
            n = 0;
        }
        while (n < string3.length()) {
            int n2 = string3.indexOf(95, n);
            Locale locale = Util.parseLocale(string3.substring(n2 + 1));
            if (locale != null) {
                return string3.substring(0, n2);
            }
            n = n2 + 1;
        }
        return string3;
    }

    static Throwable[] toArray(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        while (throwable != null) {
            arrayList.add(throwable);
            throwable = Util.getCause(throwable);
        }
        return arrayList.toArray(emptyThrowableArray);
    }

    private static Throwable getCause(Throwable throwable) {
        Method method;
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        try {
            method = throwable.getClass().getMethod("getCause", emptyClassArray);
            if (Throwable.class.isAssignableFrom(method.getReturnType())) {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        try {
            method = throwable.getClass().getMethod("getNestedThrowable", emptyClassArray);
            if (Throwable.class.isAssignableFrom(method.getReturnType())) {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    static String toString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Throwable[] throwableArray = Util.toArray(throwable);
        for (int i = 0; i < throwableArray.length; ++i) {
            Throwable throwable2 = throwableArray[i];
            if (i > 0) {
                printWriter.println();
                printWriter.print("Caused by: ");
            }
            printWriter.print(throwable2.toString());
        }
        return stringWriter.toString();
    }

    static void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        Throwable[] throwableArray = Util.toArray(throwable);
        DummyPrintWriter dummyPrintWriter = new DummyPrintWriter(printWriter);
        for (int i = 0; i < throwableArray.length; ++i) {
            if (i > 0) {
                dummyPrintWriter.println("caused by");
            }
            throwableArray[i].printStackTrace(dummyPrintWriter);
        }
        dummyPrintWriter.flush();
    }

    static void printStackTrace(Throwable throwable, PrintStream printStream) {
        Throwable[] throwableArray = Util.toArray(throwable);
        DummyPrintStream dummyPrintStream = new DummyPrintStream(printStream);
        for (int i = 0; i < throwableArray.length; ++i) {
            if (i > 0) {
                dummyPrintStream.println("caused by");
            }
            throwableArray[i].printStackTrace(dummyPrintStream);
        }
        dummyPrintStream.flush();
    }

    static void generateCommentBlock(PrintWriter printWriter, String string, String string2, String string3) {
        printWriter.println("    /**");
        if (string3 != null) {
            Util.fillText(printWriter, string3, "     * ", "", 70);
            printWriter.println();
            printWriter.println("     *");
        }
        printWriter.print("     * ");
        Util.fillText(printWriter, "<code>" + string + "</code> is '" + string2 + "'", "     * ", "", -1);
        printWriter.println();
        printWriter.println("     */");
    }

    static String getClassNameSansPackage(String string, Locale locale) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        if (locale != null) {
            string2 = string2 + '_' + locale.toString();
        }
        return string2;
    }

    protected static String removePackage(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    static class DummyPrintStream
    extends PrintStream {
        public DummyPrintStream(OutputStream outputStream) {
            super(outputStream);
        }
    }

    static class DummyPrintWriter
    extends PrintWriter {
        public DummyPrintWriter(Writer writer) {
            super(writer);
        }
    }
}

