/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.xml;

import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.xml.sax.Attributes;

public class JRThermometerPlotFactory
extends JRBaseFactory {
    public static final String ATTRIBUTE_showValueLines = "isShowValueLines";
    public static final String ATTRIBUTE_valueLocation = "valueLocation";
    public static final String ATTRIBUTE_mercuryColor = "mercuryColor";

    public Object createObject(Attributes atts) throws JRException {
        JRChart chart = (JRChart)this.digester.peek();
        JRDesignThermometerPlot thermometerPlot = (JRDesignThermometerPlot)chart.getPlot();
        String showValueLines = atts.getValue(ATTRIBUTE_showValueLines);
        if (showValueLines != null && showValueLines.length() > 0) {
            thermometerPlot.setShowValueLines(Boolean.valueOf(showValueLines));
        }
        String location = atts.getValue(ATTRIBUTE_valueLocation);
        Byte loc = (Byte)JRXmlConstants.getThermometerValueLocationMap().get(location);
        if (loc == null) {
            throw new JRException("Invalid thermometer value location: " + location);
        }
        thermometerPlot.setValueLocation(loc);
        String mercuryColor = atts.getValue(ATTRIBUTE_mercuryColor);
        if (mercuryColor != null && mercuryColor.length() > 0) {
            thermometerPlot.setMercuryColor(JRXmlConstants.getColor(mercuryColor, null));
        }
        return thermometerPlot;
    }
}

